/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.acl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.test.TestHelper;
import org.jahia.test.services.content.ContentTest;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclTest {
    private static final transient Logger logger = LoggerFactory.getLogger(ContentTest.class);
    private static final String TESTSITE_NAME = "aclTestSite";
    private static JCRUserNode user1;
    private static JCRUserNode user2;
    private static JCRUserNode user3;
    private static JCRUserNode user4;
    private static JCRGroupNode group1;
    private static JCRGroupNode group2;
    public static final String HOMEPATH = "/sites/aclTestSite/home";
    public static JCRPublicationService jcrService;
    private static JCRNodeWrapper home;
    private static JCRNodeWrapper content1;
    private static JCRNodeWrapper content11;
    private static JCRNodeWrapper content12;
    private static JCRNodeWrapper content2;
    private static JCRNodeWrapper content21;
    private static JCRNodeWrapper content22;
    private static String homeIdentifier;
    private JCRSessionWrapper session;
    static String content1Identifier;
    private static String content11Identifier;
    private static String content12Identifier;
    private static String content2Identifier;
    private static String content21Identifier;
    private static String content22Identifier;

    private static void assertRole(JCRNodeWrapper node, String principal, String grantType, String role) {
        Map aclEntries = node.getAclEntries();
        String path = node.getPath();
        ((MapAssert)Assertions.assertThat((Map)aclEntries).as("ACL entries for node %s should contain %s for role for principal %s", new Object[]{path, grantType, role, principal})).containsKey((Object)principal);
        Assertions.assertThat((Object[])((Object[])((List)aclEntries.get(principal)).get(0))).as("ACL entries for node %s should contain %s for role for principal %s", new Object[]{path, grantType, role, principal}).containsExactly((Object[])new String[]{path, grantType, role});
    }

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        JahiaSite site = TestHelper.createSite(TESTSITE_NAME);
        jcrService = ServicesRegistry.getInstance().getJCRPublicationService();
        JCRSessionWrapper session = jcrService.getSessionFactory().getCurrentUserSession();
        Object languages = null;
        home = session.getNode(HOMEPATH);
        homeIdentifier = home.getIdentifier();
        content1 = home.addNode("content1", "jnt:contentList");
        content1Identifier = content1.getIdentifier();
        content11 = content1.addNode("content1.1", "jnt:contentList");
        content11Identifier = content11.getIdentifier();
        content12 = content1.addNode("content1.2", "jnt:contentList");
        content12Identifier = content12.getIdentifier();
        content2 = home.addNode("content2", "jnt:contentList");
        content2Identifier = content2.getIdentifier();
        content21 = content2.addNode("content2.1", "jnt:contentList");
        content21Identifier = content21.getIdentifier();
        content22 = content2.addNode("content2.2", "jnt:contentList");
        content22Identifier = content22.getIdentifier();
        session.save();
        JahiaUserManagerService userMgr = ServicesRegistry.getInstance().getJahiaUserManagerService();
        JahiaUserManagerService userManager = ServicesRegistry.getInstance().getJahiaUserManagerService();
        Assert.assertNotNull("JahiaUserManagerService cannot be retrieved", userManager);
        user1 = userManager.createUser("user1", "password", new Properties(), session);
        user2 = userManager.createUser("user2", "password", new Properties(), session);
        user3 = userManager.createUser("user3", "password", new Properties(), session);
        user4 = userManager.createUser("user4", "password", new Properties(), session);
        JahiaGroupManagerService groupManager = ServicesRegistry.getInstance().getJahiaGroupManagerService();
        Assert.assertNotNull("JahiaGroupManagerService cannot be retrieved", groupManager);
        group1 = groupManager.createGroup(site.getSiteKey(), "group1", new Properties(), false, session);
        group2 = groupManager.createGroup(site.getSiteKey(), "group2", new Properties(), false, session);
        group1.addMember((JCRNodeWrapper)user1);
        group1.addMember((JCRNodeWrapper)user2);
        group2.addMember((JCRNodeWrapper)user3);
        group2.addMember((JCRNodeWrapper)user4);
        session.save();
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
            if (session.nodeExists("/sites/aclTestSite")) {
                TestHelper.deleteSite(TESTSITE_NAME);
            }
            JahiaUserManagerService userManager = ServicesRegistry.getInstance().getJahiaUserManagerService();
            userManager.deleteUser(user1.getPath(), session);
            userManager.deleteUser(user2.getPath(), session);
            userManager.deleteUser(user3.getPath(), session);
            userManager.deleteUser(user4.getPath(), session);
            session.save();
        }
        catch (Exception ex) {
            logger.warn("Exception during test tearDown", (Throwable)ex);
        }
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @Before
    public void setUp() throws RepositoryException {
        this.session = JCRSessionFactory.getInstance().getCurrentUserSession();
        home = this.session.getNodeByIdentifier(homeIdentifier);
        home.getAclEntries();
        content1 = this.session.getNodeByIdentifier(content1Identifier);
        content1.getAclEntries();
        content11 = this.session.getNodeByIdentifier(content11Identifier);
        content11.getAclEntries();
        content12 = this.session.getNodeByIdentifier(content12Identifier);
        content12.getAclEntries();
        content2 = this.session.getNodeByIdentifier(content2Identifier);
        content2.getAclEntries();
        content21 = this.session.getNodeByIdentifier(content21Identifier);
        content21.getAclEntries();
        content22 = this.session.getNodeByIdentifier(content22Identifier);
        content22.getAclEntries();
        this.session.save();
    }

    @After
    public void tearDown() throws Exception {
        home.revokeAllRoles();
        content1.revokeAllRoles();
        content11.revokeAllRoles();
        content12.revokeAllRoles();
        content2.revokeAllRoles();
        content21.revokeAllRoles();
        content21.revokeAllRoles();
        this.session.save();
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @Test
    public void testDefaultReadRight() throws Exception {
        Assert.assertFalse((Boolean)JCRTemplate.getInstance().doExecuteWithUserSession("user1", null, (JCRCallback)new CheckPermission(HOMEPATH, "jcr:read")));
    }

    @Test
    public void testGrantUser() throws Exception {
        content11.grantRoles("u:user1", Collections.singleton("owner"));
        AclTest.assertRole(content11, "u:user1", "GRANT", "owner");
        this.session.save();
        Assert.assertTrue((Boolean)JCRTemplate.getInstance().doExecuteWithUserSession("user1", null, (JCRCallback)new CheckPermission(content11.getPath(), "jcr:write")));
        Assert.assertFalse((Boolean)JCRTemplate.getInstance().doExecuteWithUserSession("user2", null, (JCRCallback)new CheckPermission(content11.getPath(), "jcr:write")));
    }

    @Test
    public void testGrantGroup() throws Exception {
        content11.grantRoles("g:group1", Collections.singleton("owner"));
        AclTest.assertRole(content11, "g:group1", "GRANT", "owner");
        this.session.save();
        Assert.assertTrue((Boolean)JCRTemplate.getInstance().doExecuteWithUserSession("user1", null, (JCRCallback)new CheckPermission(content11.getPath(), "jcr:write")));
        Assert.assertTrue((Boolean)JCRTemplate.getInstance().doExecuteWithUserSession("user2", null, (JCRCallback)new CheckPermission(content11.getPath(), "jcr:write")));
        Assert.assertFalse((Boolean)JCRTemplate.getInstance().doExecuteWithUserSession("user3", null, (JCRCallback)new CheckPermission(content11.getPath(), "jcr:write")));
        Assert.assertFalse((Boolean)JCRTemplate.getInstance().doExecuteWithUserSession("user4", null, (JCRCallback)new CheckPermission(content11.getPath(), "jcr:write")));
    }

    @Test
    public void testDenyUser() throws Exception {
        content1.grantRoles("u:user1", Collections.singleton("owner"));
        content11.denyRoles("u:user1", Collections.singleton("owner"));
        AclTest.assertRole(content1, "u:user1", "GRANT", "owner");
        AclTest.assertRole(content11, "u:user1", "DENY", "owner");
        this.session.save();
        Assert.assertTrue((Boolean)JCRTemplate.getInstance().doExecuteWithUserSession("user1", null, (JCRCallback)new CheckPermission(content1.getPath(), "jcr:write")));
        Assert.assertFalse((Boolean)JCRTemplate.getInstance().doExecuteWithUserSession("user1", null, (JCRCallback)new CheckPermission(content11.getPath(), "jcr:write")));
    }

    @Test
    public void testAclBreak() throws Exception {
        ((MapAssert)Assertions.assertThat((Map)content1.getAclEntries()).as("ACL entries for node %s should NOT be empty", new Object[]{content1.getPath()})).isNotEmpty();
        content1.setAclInheritanceBreak(true);
        ((MapAssert)Assertions.assertThat((Map)content1.getAclEntries()).as("ACL entries for node %s should be empty", new Object[]{content1.getPath()})).isEmpty();
        content11.grantRoles("u:user1", Collections.singleton("owner"));
        AclTest.assertRole(content11, "u:user1", "GRANT", "owner");
        ((MapAssert)Assertions.assertThat((Map)content11.getAclEntries()).as("ACL entries for node %s should contains %s role for user %s", new Object[]{content11.getPath(), "owner", "user1"})).containsOnlyKeys((Object[])new String[]{"u:user1"});
        this.session.save();
        Assert.assertFalse((Boolean)JCRTemplate.getInstance().doExecuteWithUserSession("user1", null, (JCRCallback)new CheckPermission(home.getPath(), "jcr:read")));
        Assert.assertFalse((Boolean)JCRTemplate.getInstance().doExecuteWithUserSession("user1", null, (JCRCallback)new CheckPermission(content1.getPath(), "jcr:read")));
        Assert.assertTrue((Boolean)JCRTemplate.getInstance().doExecuteWithUserSession("user1", null, (JCRCallback)new CheckPermission(content11.getPath(), "jcr:read")));
        Assert.assertFalse((Boolean)JCRTemplate.getInstance().doExecuteWithUserSession("user1", null, (JCRCallback)new CheckPermission(content12.getPath(), "jcr:read")));
    }

    @Test
    public void testRevokeRoles() throws Exception {
        content11.grantRoles("u:user1", Collections.singleton("owner"));
        content11.grantRoles("u:user2", Collections.singleton("owner"));
        AclTest.assertRole(content11, "u:user1", "GRANT", "owner");
        AclTest.assertRole(content11, "u:user2", "GRANT", "owner");
        this.session.save();
        content11.revokeRolesForPrincipal("u:user2");
        AclTest.assertRole(content11, "u:user1", "GRANT", "owner");
        ((MapAssert)Assertions.assertThat((Map)content11.getAclEntries()).as("ACL entries for node %s should NOT contain roles for principal %s", new Object[]{content11.getPath(), "u:user2"})).doesNotContainKey((Object)"u:user2");
        this.session.save();
        content11.revokeAllRoles();
        ((MapAssert)Assertions.assertThat((Map)content11.getAclEntries()).as("ACL entries for node %s should NOT contain roles for principal %s", new Object[]{content11.getPath(), "u:user1"})).doesNotContainKey((Object)"u:user1");
        ((MapAssert)Assertions.assertThat((Map)content11.getAclEntries()).as("ACL entries for node %s should NOT contain roles for principal %s", new Object[]{content11.getPath(), "u:user2"})).doesNotContainKey((Object)"u:user2");
        this.session.save();
    }

    class CheckPermission
    implements JCRCallback<Boolean> {
        private String path;
        private String permission;

        CheckPermission(String path, String permission) {
            this.path = path;
            this.permission = permission;
        }

        public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
            try {
                return session.getNode(this.path).hasPermission(this.permission);
            }
            catch (PathNotFoundException e) {
                return false;
            }
        }
    }
}

