/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.atmosphere;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Response;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.jahia.bin.Jahia;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRValueFactoryImpl;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.sites.JahiaSite;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereTest
extends JahiaTestCase {
    private static transient Logger logger = LoggerFactory.getLogger(AtmosphereTest.class);
    private String urlTarget = this.getBaseServerURL() + Jahia.getContextPath() + "/atmosphere/alert/testChannel";
    private static JahiaSite site;
    private static JCRPublicationService jcrService;
    private static final String TESTSITE_NAME = "jcrAtmosphereTest";
    private static final String SITECONTENT_ROOT_NODE = "/sites/jcrAtmosphereTest";
    private static final String INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE = "English text";
    private JCRSessionWrapper englishEditSession;
    private JCRSessionWrapper englishLiveSession;
    private JCRNodeWrapper testHomeEdit;

    private void getCleanSession() throws RepositoryException {
        JCRSessionFactory sessionFactory = JCRSessionFactory.getInstance();
        sessionFactory.closeAllSessions();
        this.englishEditSession = sessionFactory.getCurrentUserSession("default", Locale.ENGLISH);
        this.englishLiveSession = sessionFactory.getCurrentUserSession("live", Locale.ENGLISH);
    }

    @BeforeClass
    public static void setUpClass() {
        try {
            site = TestHelper.createSite(TESTSITE_NAME, new HashSet<String>(Arrays.asList("en", "fr")), Collections.singleton("en"), false);
            Assert.assertNotNull(site);
            jcrService = ServicesRegistry.getInstance().getJCRPublicationService();
        }
        catch (Exception ex) {
            logger.warn("Exception during test setUp", (Throwable)ex);
            Assert.fail();
        }
    }

    @AfterClass
    public static void tearDownClass() {
        try {
            TestHelper.deleteSite(TESTSITE_NAME);
        }
        catch (Exception ex) {
            logger.warn("Exception during test tearDown", (Throwable)ex);
        }
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @Before
    public void setUp() {
        try {
            this.getCleanSession();
            JCRNodeWrapper englishEditSiteHomeNode = this.englishEditSession.getNode("/sites/jcrAtmosphereTest/home");
            this.testHomeEdit = englishEditSiteHomeNode.addNode("test" + System.currentTimeMillis(), "jnt:page");
            this.testHomeEdit.setProperty("jcr:title", "Test page");
            this.testHomeEdit.setProperty("j:templateName", "simple");
            this.englishEditSession.save();
            jcrService.publishByMainId(this.testHomeEdit.getIdentifier());
        }
        catch (RepositoryException e) {
            Assert.fail("Cannot setup test" + e.getMessage());
            Assert.fail();
        }
    }

    @After
    public void tearDown() {
        try {
            this.getCleanSession();
            this.englishEditSession.getNodeByIdentifier(this.testHomeEdit.getIdentifier()).remove();
            this.englishEditSession.save();
            this.englishLiveSession.getNodeByIdentifier(this.testHomeEdit.getIdentifier()).remove();
            this.englishLiveSession.save();
        }
        catch (RepositoryException e) {
            Assert.fail("Cannot remove nodes");
        }
    }

    @Test
    public void testNodePublish() throws RepositoryException {
        TestHelper.createList(this.testHomeEdit, "contentList1", 4, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
        JCRValueWrapper[] values = this.testHomeEdit.getResolveSite().getProperty("j:installedModules").getValues();
        Value[] values1 = new Value[values.length + 1];
        System.arraycopy(values, 0, values1, 0, values.length);
        values1[values.length] = JCRValueFactoryImpl.getInstance().createValue("atmosphere:7.0.0.0-SNAPSHOT");
        this.testHomeEdit.getResolveSite().setProperty("j:installedModules", values1);
        this.englishEditSession.save();
        final CountDownLatch latch = new CountDownLatch(1);
        AsyncHttpClient c = new AsyncHttpClient();
        try {
            final AtomicReference response = new AtomicReference();
            c.prepareGet(this.getBaseServerURL() + Jahia.getContextPath() + "/atmosphere/sites/jcrAtmosphereTest-en").execute((AsyncHandler)new AsyncCompletionHandler<Response>(){

                public Response onCompleted(Response r) throws Exception {
                    try {
                        response.set(r);
                        Response response2 = r;
                        return response2;
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
            Thread.sleep(2500L);
            jcrService.publishByMainId(this.testHomeEdit.getIdentifier(), "default", "live", null, false, null);
            try {
                latch.await(20L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Assert.fail(e.getMessage());
            }
            Response r = (Response)response.get();
            Assert.assertNotNull(r);
            Assert.assertEquals(200L, r.getStatusCode());
            Assert.assertTrue(r.getResponseBody().contains("\"name\":\"contentList1_text0\""));
        }
        catch (Exception e) {
            logger.error("test failed", (Throwable)e);
            Assert.fail(e.getMessage());
        }
        c.close();
    }
}

