/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.content;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.nutch.crawl.CrawlDatum;

public class CrawlDBTestUtil {
    private static final Log LOG = LogFactory.getLog(CrawlDBTestUtil.class);

    public static void createCrawlDb(Configuration conf, FileSystem fs, Path crawldb, List<URLCrawlDatum> init) throws Exception {
        LOG.trace((Object)("* creating crawldb: " + crawldb));
        Path dir2 = new Path(crawldb, "current");
        MapFile.Writer writer = new MapFile.Writer(conf, fs, new Path(dir2, "part-00000").toString(), Text.class, CrawlDatum.class);
        for (URLCrawlDatum row : init) {
            LOG.info((Object)("adding:" + row.url.toString()));
            writer.append((WritableComparable)new Text(row.url), (Writable)row.datum);
        }
        writer.close();
    }

    public static Configuration create() {
        return CrawlDBTestUtil.createConfiguration();
    }

    public static Configuration createConfiguration() {
        Configuration conf = new Configuration();
        conf.addResource("nutch-default.xml");
        conf.addResource("crawl-tests.xml");
        return conf;
    }

    public static void generateSeedList(FileSystem fs, Path urlPath, List<String> contents) throws IOException {
        Path file = new Path(urlPath, "urls.txt");
        fs.mkdirs(urlPath);
        FSDataOutputStream out = fs.create(file);
        for (String url : contents) {
            out.writeBytes(url);
            out.writeBytes("\n");
        }
        out.flush();
        out.close();
    }

    public static class URLCrawlDatum {
        Text url;
        CrawlDatum datum;

        public URLCrawlDatum(Text url, CrawlDatum datum) {
            this.url = url;
            this.datum = datum;
        }
    }
}

