/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.content;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.apache.nutch.crawl.CrawlDb;
import org.apache.nutch.crawl.Generator;
import org.apache.nutch.crawl.Injector;
import org.apache.nutch.fetcher.Fetcher;
import org.hamcrest.Matchers;
import org.jahia.bin.Jahia;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.osgi.BundleResource;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLGenerator;
import org.jahia.services.sites.JahiaSite;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.jahia.test.services.content.CrawlDBTestUtil;
import org.jahia.utils.LanguageCodeConverters;
import org.jahia.utils.Log4jEventCollectorWrapper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class CrawlingPageVisitorTest
extends JahiaTestCase {
    private static final Logger logger = Logger.getLogger(CrawlingPageVisitorTest.class);
    private static final Path TEST_DIR;
    private static final String ACMESITE_NAME = "CrawlACMETest";
    private static final String ACME_SITECONTENT_ROOT_NODE = "sites/CrawlACMETest";
    private static final String DEFAULT_LANGUAGE = "en";
    private static Configuration conf;
    private static FileSystem fileSystem;
    private static Path crawldbPath;
    private static Path segmentsPath;
    private static Path urlPath;
    private Log4jEventCollectorWrapper logEventCollector;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void extract(JahiaTemplatesPackage p, org.springframework.core.io.Resource r, File f) throws Exception {
        if (r instanceof BundleResource && r.contentLength() == 0L || !(r instanceof BundleResource) && r.getFile().isDirectory()) {
            f.mkdirs();
            String path = r.getURI().getPath();
            org.springframework.core.io.Resource[] resourceArray = p.getResources(path.substring(path.indexOf("/plugins")));
            int n = resourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                org.springframework.core.io.Resource resource = resourceArray[n2];
                CrawlingPageVisitorTest.extract(p, resource, new File(f, resource.getFilename()));
                ++n2;
            }
            return;
        }
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(f);
            IOUtils.copy((InputStream)r.getInputStream(), (OutputStream)output);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(output);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)output);
    }

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        System.setProperty("crawl.jahia.version", Jahia.VERSION);
        conf = CrawlDBTestUtil.createConfiguration();
        conf.setClassLoader(CrawlingPageVisitorTest.class.getClassLoader());
        File f = File.createTempFile("plugins", "");
        f.delete();
        JahiaTemplatesPackage templatePackageById = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById("jahia-test-module");
        CrawlingPageVisitorTest.extract(templatePackageById, templatePackageById.getResource("/plugins"), f);
        conf.setStrings("plugin.folders", new String[]{f.getPath()});
        Thread.currentThread().setContextClassLoader(CrawlingPageVisitorTest.class.getClassLoader());
        fileSystem = FileSystem.get((Configuration)conf);
        fileSystem.delete(TEST_DIR, true);
        urlPath = new Path(TEST_DIR, "urls");
        crawldbPath = new Path(TEST_DIR, "crawldb");
        segmentsPath = new Path(TEST_DIR, "segments");
        JahiaSite defaultSite = ServicesRegistry.getInstance().getJahiaSitesService().getSiteByKey(ACMESITE_NAME);
        if (defaultSite == null) {
            final JCRPublicationService jcrService = ServicesRegistry.getInstance().getJCRPublicationService();
            JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    try {
                        TestHelper.createSite(CrawlingPageVisitorTest.ACMESITE_NAME, "localhost", "bootstrap-acme-space-templates", "prepackagedSites/acmespaceelektra.zip", "ACME-SPACE.zip");
                        jcrService.publishByMainId(session.getRootNode().getNode("sites/CrawlACMETest/home").getIdentifier(), "default", "live", null, true, null);
                        session.save();
                    }
                    catch (Exception ex) {
                        throw new JahiaRuntimeException((Throwable)ex);
                    }
                    return null;
                }
            });
        }
    }

    @Before
    public void setUp() {
        this.logEventCollector = new Log4jEventCollectorWrapper(40000);
    }

    @After
    public void tearDown() {
        this.logEventCollector.close();
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        TestHelper.deleteSite(ACMESITE_NAME);
    }

    private String getPrecompileServletURL() {
        return this.getBaseServerURL() + Jahia.getContextPath() + "/modules/tools/precompileServlet";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPrecompileJsps() throws IOException {
        HttpClient client = new HttpClient();
        client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials("jahia", "password"));
        GetMethod get = new GetMethod(this.getPrecompileServletURL());
        try {
            get.setDoAuthentication(true);
            int statusCode = client.executeMethod((HttpMethod)get);
            Assert.assertEquals("Precompile servlet failed", 200L, statusCode);
            Source source = new Source((CharSequence)get.getResponseBodyAsString());
            Element aElement = source.getFirstElement("a");
            String url = this.getBaseServerURL() + aElement.getAttributeValue("href");
            logger.info((Object)("Starting the precompileServlet with the following url: " + url));
            get = new GetMethod(url);
            statusCode = client.executeMethod((HttpMethod)get);
            Assert.assertEquals("Precompile servlet failed", 200L, statusCode);
            Assert.assertThat("Precompilation found buggy JSPs", get.getResponseBodyAsString(), Matchers.containsString("No problems found!"));
            Assert.assertEquals("There were errors during the precompile process", "", CrawlingPageVisitorTest.toText(this.logEventCollector.getCollectedEvents()));
        }
        finally {
            get.releaseConnection();
        }
    }

    @Test
    public void testFetchDefaultSiteLive() throws RepositoryException, IOException {
        this.crawlUrls(this.getBaseUrls("live", ACME_SITECONTENT_ROOT_NODE));
        Assert.assertEquals("There were errors during the crawling", "", CrawlingPageVisitorTest.toText(this.logEventCollector.getCollectedEvents()));
    }

    private List<String> getBaseUrls(String workspace, String sitePath) throws RepositoryException {
        JCRNodeWrapper homeNode;
        RenderContext renderCtx;
        ArrayList<String> urls;
        block2: {
            urls = new ArrayList<String>();
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession(workspace, LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE));
            renderCtx = new RenderContext(CrawlingPageVisitorTest.getRequest(), CrawlingPageVisitorTest.getResponse(), CrawlingPageVisitorTest.getUser());
            homeNode = null;
            try {
                homeNode = session.getRootNode().getNode(sitePath + "/home");
            }
            catch (PathNotFoundException e) {
                if (!ACME_SITECONTENT_ROOT_NODE.equals(sitePath)) break block2;
                JahiaSite defaultSite = ServicesRegistry.getInstance().getJahiaSitesService().getDefaultSite();
                sitePath = defaultSite != null ? "sites/" + defaultSite.getSiteKey() : null;
                homeNode = session.getRootNode().getNode(sitePath + "/home");
            }
        }
        Resource resource = new Resource(homeNode, "html", null, "page");
        renderCtx.setMainResource(resource);
        renderCtx.setSite(homeNode.getResolveSite());
        URLGenerator urlgenerator = new URLGenerator(renderCtx, resource);
        urls.add(urlgenerator.getServer() + urlgenerator.getContext() + ("live".equals(workspace) ? urlgenerator.getLive() : urlgenerator.getEdit()));
        return urls;
    }

    private void crawlUrls(List<String> urls) throws IOException {
        CrawlDBTestUtil.generateSeedList(fileSystem, urlPath, urls);
        Injector injector = new Injector(conf);
        injector.inject(crawldbPath, urlPath);
        Generator g = new Generator(conf);
        conf.setBoolean("fetcher.parse", true);
        Fetcher fetcher = new Fetcher(conf);
        CrawlDb crawlDbTool = new CrawlDb(conf);
        int depth = 5;
        int threads = 4;
        for (int i = 0; i < depth; ++i) {
            Path[] generatedSegments = g.generate(crawldbPath, segmentsPath, 1, Long.MAX_VALUE, Long.MAX_VALUE, false, false);
            if (generatedSegments == null) {
                logger.info((Object)("Stopping at depth=" + i + " - no more URLs to fetch."));
                break;
            }
            for (Path generatedSegment : generatedSegments) {
                fetcher.fetch(generatedSegment, threads);
                crawlDbTool.update(crawldbPath, new Path[]{generatedSegment}, true, true);
            }
        }
    }

    private static String toText(List<Log4jEventCollectorWrapper.LoggingEventWrapper> logEvents) {
        DateFormat timestampFormat = SimpleDateFormat.getDateTimeInstance();
        StringBuilder errors = new StringBuilder();
        for (Log4jEventCollectorWrapper.LoggingEventWrapper logEvent : logEvents) {
            errors.append(timestampFormat.format(new Date(logEvent.getTimestamp()))).append(" ").append(logEvent.getMessage()).append("\n");
            String[] throwableInfo = logEvent.getThrowableInfo();
            if (throwableInfo == null) continue;
            for (String throwableInfoItem : throwableInfo) {
                errors.append(throwableInfoItem).append("\n");
            }
            errors.append("\n");
        }
        return errors.toString();
    }

    static {
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (!tmpDir.endsWith("/") && !tmpDir.endsWith("\\")) {
            tmpDir = tmpDir + System.getProperty("file.separator");
        }
        TEST_DIR = new Path(tmpDir + "test/fetch-test");
    }
}

