/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.content;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.jcr.PathNotFoundException;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.sites.JahiaSite;
import org.jahia.test.TestHelper;
import org.jahia.utils.LanguageCodeConverters;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class MarkForDeletionTest {
    private static String DEFAULT_LANGUAGE = "en";
    private static final String TESTSITE_NAME = "markedForDeletionTest";
    private static final String SITECONTENT_ROOT_NODE = "/sites/markedForDeletionTest";
    private static final String MEETING = "meeting";
    private static final String PARIS = "paris";
    private static final String GENEVA = "geneva";
    private static final String KLAGENFURT = "klagenfurt";
    private static final String DUESSELDORF = "duesseldorf";
    private static final String DELETION_MESSAGE = "Deleted in unit test";
    private static final String QUERY = "select * from [jmix:markedForDeletionRoot]";
    JCRSessionWrapper editSession;
    JCRSessionWrapper liveSession;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        JahiaSite site = TestHelper.createSite(TESTSITE_NAME);
        Assert.assertNotNull(site);
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE));
        MarkForDeletionTest.initContent(session);
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        TestHelper.deleteSite(TESTSITE_NAME);
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testMarkForDeletionOnUnpublished() throws Exception {
        this.reopenSession();
        JCRNodeWrapper node = this.editSession.getNode("/sites/markedForDeletionTest/contents/meeting0");
        node.markForDeletion(DELETION_MESSAGE);
        this.editSession.save();
        Assert.assertTrue("jmix:markedForDeletionRoot not set", node.isNodeType("jmix:markedForDeletionRoot"));
        Assert.assertTrue("jmix:markedForDeletion not set", node.isNodeType("jmix:markedForDeletion"));
        Assert.assertTrue("marked for deletion comment not set", node.getPropertyAsString("j:deletionMessage").equals(DELETION_MESSAGE));
        Assert.assertTrue("j:deletionUser not set", node.hasProperty("j:deletionUser"));
        Assert.assertTrue("j:deletionDate not set", node.hasProperty("j:deletionDate"));
        try {
            this.liveSession.getNode("/sites/markedForDeletionTest/contents/meeting0");
            junit.framework.Assert.fail("Did not throw PathNotFoundException");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        JCRPublicationService jcrService = ServicesRegistry.getInstance().getJCRPublicationService();
        this.reopenSession();
        jcrService.publishByMainId(node.getIdentifier(), "default", "live", null, true, null);
        this.reopenSession();
        try {
            this.editSession.getNode("/sites/markedForDeletionTest/contents/meeting0");
            junit.framework.Assert.fail("Did not throw PathNotFoundException");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        try {
            this.liveSession.getNode("/sites/markedForDeletionTest/contents/meeting0");
            junit.framework.Assert.fail("Did not throw PathNotFoundException");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testMarkForDeletionOnPublished() throws Exception {
        this.reopenSession();
        JCRNodeWrapper node = this.editSession.getNode("/sites/markedForDeletionTest/contents/meeting1");
        JCRPublicationService jcrService = ServicesRegistry.getInstance().getJCRPublicationService();
        jcrService.publishByMainId(node.getIdentifier(), "default", "live", null, true, null);
        this.reopenSession();
        node = this.editSession.getNode("/sites/markedForDeletionTest/contents/meeting1");
        node.markForDeletion(DELETION_MESSAGE);
        this.editSession.save();
        Assert.assertTrue("jmix:markedForDeletionRoot not set", node.isNodeType("jmix:markedForDeletionRoot"));
        Assert.assertTrue("jmix:markedForDeletion not set", node.isNodeType("jmix:markedForDeletion"));
        Assert.assertTrue("marked for deletion comment not set", node.getPropertyAsString("j:deletionMessage").equals(DELETION_MESSAGE));
        Assert.assertTrue("j:deletionUser not set", node.hasProperty("j:deletionUser"));
        Assert.assertTrue("j:deletionDate not set", node.hasProperty("j:deletionDate"));
        JCRNodeWrapper liveNode = this.liveSession.getNode("/sites/markedForDeletionTest/contents/meeting1");
        Assert.assertNotNull("Node is no longer existing in live workspace", liveNode);
        this.reopenSession();
        jcrService.publishByMainId(node.getIdentifier(), "default", "live", null, true, null);
        this.reopenSession();
        try {
            this.editSession.getNode("/sites/markedForDeletionTest/contents/meeting1");
            junit.framework.Assert.fail("Did not throw PathNotFoundException");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        try {
            this.liveSession.getNode("/sites/markedForDeletionTest/contents/meeting1");
            junit.framework.Assert.fail("Did not throw PathNotFoundException");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testMarkForDeletionWithChildren() throws Exception {
        this.reopenSession();
        JCRNodeWrapper node = this.editSession.getNode("/sites/markedForDeletionTest/pages/page3");
        JCRPublicationService jcrService = ServicesRegistry.getInstance().getJCRPublicationService();
        jcrService.publishByMainId(node.getIdentifier(), "default", "live", null, true, null);
        this.reopenSession();
        node = this.editSession.getNode("/sites/markedForDeletionTest/pages/page3");
        JCRNodeWrapper childNode = this.editSession.getNode("/sites/markedForDeletionTest/pages/page3/page31");
        node.markForDeletion(DELETION_MESSAGE);
        this.editSession.save();
        Assert.assertTrue("jmix:markedForDeletionRoot not set", node.isNodeType("jmix:markedForDeletionRoot"));
        Assert.assertTrue("jmix:markedForDeletion not set", node.isNodeType("jmix:markedForDeletion"));
        Assert.assertTrue("marked for deletion comment not set", node.getPropertyAsString("j:deletionMessage").equals(DELETION_MESSAGE));
        Assert.assertTrue("j:deletionUser not set", node.hasProperty("j:deletionUser"));
        Assert.assertTrue("j:deletionDate not set", node.hasProperty("j:deletionDate"));
        Assert.assertFalse("jmix:markedForDeletionRoot should not be set", childNode.isNodeType("jmix:markedForDeletionRoot"));
        Assert.assertTrue("jmix:markedForDeletion not set", childNode.isNodeType("jmix:markedForDeletion"));
        Assert.assertFalse("marked for deletion comment should not be set on child", childNode.hasProperty("j:deletionMessage"));
        Assert.assertFalse("j:deletionUser should not be set on child", childNode.hasProperty("j:deletionUser"));
        Assert.assertFalse("j:deletionDate should not be set on child", childNode.hasProperty("j:deletionDate"));
        this.reopenSession();
        jcrService.publishByMainId(node.getIdentifier(), "default", "live", null, true, null);
        this.reopenSession();
        try {
            this.editSession.getNode("/sites/markedForDeletionTest/pages/page3/page31");
            junit.framework.Assert.fail("Did not throw PathNotFoundException");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        try {
            this.liveSession.getNode("/sites/markedForDeletionTest/pages/page3/page31");
            junit.framework.Assert.fail("Did not throw PathNotFoundException");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        try {
            this.editSession.getNode("/sites/markedForDeletionTest/pages/page3");
            junit.framework.Assert.fail("Did not throw PathNotFoundException");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        try {
            this.liveSession.getNode("/sites/markedForDeletionTest/pages/page3");
            junit.framework.Assert.fail("Did not throw PathNotFoundException");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testMarkForDeletionWithChildrenAlreadyMarked() throws Exception {
        this.reopenSession();
        JCRNodeWrapper node = this.editSession.getNode("/sites/markedForDeletionTest/pages/page2");
        JCRPublicationService jcrService = ServicesRegistry.getInstance().getJCRPublicationService();
        jcrService.publishByMainId(node.getIdentifier(), "default", "live", null, true, null);
        this.reopenSession();
        node = this.editSession.getNode("/sites/markedForDeletionTest/pages/page2/page21");
        JCRNodeWrapper parentNode = this.editSession.getNode("/sites/markedForDeletionTest/pages/page2");
        node.markForDeletion(DELETION_MESSAGE);
        this.editSession.save();
        Assert.assertTrue("jmix:markedForDeletionRoot not set", node.isNodeType("jmix:markedForDeletionRoot"));
        Assert.assertTrue("jmix:markedForDeletion not set", node.isNodeType("jmix:markedForDeletion"));
        Assert.assertTrue("marked for deletion comment not set", node.getPropertyAsString("j:deletionMessage").equals(DELETION_MESSAGE));
        Assert.assertTrue("j:deletionUser not set", node.hasProperty("j:deletionUser"));
        Assert.assertTrue("j:deletionDate not set", node.hasProperty("j:deletionDate"));
        parentNode.markForDeletion("2nd Deleted in unit test");
        this.editSession.save();
        Assert.assertTrue("jmix:markedForDeletionRoot not set", parentNode.isNodeType("jmix:markedForDeletionRoot"));
        Assert.assertTrue("jmix:markedForDeletion not set", parentNode.isNodeType("jmix:markedForDeletion"));
        Assert.assertTrue("marked for deletion comment not set", parentNode.getPropertyAsString("j:deletionMessage").equals("2nd Deleted in unit test"));
        Assert.assertTrue("j:deletionUser not set", parentNode.hasProperty("j:deletionUser"));
        Assert.assertTrue("j:deletionDate not set", parentNode.hasProperty("j:deletionDate"));
        Assert.assertFalse("jmix:markedForDeletionRoot should not be set", node.isNodeType("jmix:markedForDeletionRoot"));
        Assert.assertTrue("jmix:markedForDeletion not set", node.isNodeType("jmix:markedForDeletion"));
        Assert.assertFalse("marked for deletion comment should not be set", node.hasProperty("j:deletionMessage"));
        Assert.assertFalse("j:deletionUser should not be set", node.hasProperty("j:deletionUser"));
        Assert.assertFalse("j:deletionDate should not be set", node.hasProperty("j:deletionDate"));
        Assert.assertNotNull("Node is already deleted", this.liveSession.getNode("/sites/markedForDeletionTest/pages/page2"));
        Assert.assertNotNull("Node is already deleted", this.liveSession.getNode("/sites/markedForDeletionTest/pages/page2/page21"));
        this.reopenSession();
        jcrService.publishByMainId(parentNode.getIdentifier(), "default", "live", null, true, null);
        this.reopenSession();
        try {
            this.editSession.getNode("/sites/markedForDeletionTest/pages/page2/page21");
            junit.framework.Assert.fail("Did not throw PathNotFoundException");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        try {
            this.liveSession.getNode("/sites/markedForDeletionTest/pages/page2/page21");
            junit.framework.Assert.fail("Did not throw PathNotFoundException");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        try {
            this.editSession.getNode("/sites/markedForDeletionTest/pages/page2");
            junit.framework.Assert.fail("Did not throw PathNotFoundException");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        try {
            this.liveSession.getNode("/sites/markedForDeletionTest/pages/page2");
            junit.framework.Assert.fail("Did not throw PathNotFoundException");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testUnmarkForDeletionWithChildren() throws Exception {
        this.reopenSession();
        JCRNodeWrapper node = this.editSession.getNode("/sites/markedForDeletionTest/pages/page1");
        JCRPublicationService jcrService = ServicesRegistry.getInstance().getJCRPublicationService();
        jcrService.publishByMainId(node.getIdentifier(), "default", "live", null, true, null);
        this.reopenSession();
        node = this.editSession.getNode("/sites/markedForDeletionTest/pages/page1");
        JCRNodeWrapper childNode = this.editSession.getNode("/sites/markedForDeletionTest/pages/page1/page11");
        node.markForDeletion(DELETION_MESSAGE);
        this.editSession.save();
        Assert.assertTrue("jmix:markedForDeletionRoot not set", node.isNodeType("jmix:markedForDeletionRoot"));
        Assert.assertTrue("jmix:markedForDeletion not set", node.isNodeType("jmix:markedForDeletion"));
        Assert.assertTrue("marked for deletion comment not set", node.getPropertyAsString("j:deletionMessage").equals(DELETION_MESSAGE));
        Assert.assertTrue("j:deletionUser not set", node.hasProperty("j:deletionUser"));
        Assert.assertTrue("j:deletionDate not set", node.hasProperty("j:deletionDate"));
        Assert.assertFalse("jmix:markedForDeletionRoot should not be set", childNode.isNodeType("jmix:markedForDeletionRoot"));
        Assert.assertTrue("jmix:markedForDeletion not set", childNode.isNodeType("jmix:markedForDeletion"));
        Assert.assertFalse("marked for deletion comment should not be set on child", childNode.hasProperty("j:deletionMessage"));
        Assert.assertFalse("j:deletionUser should not be set on child", childNode.hasProperty("j:deletionUser"));
        Assert.assertFalse("j:deletionDate should not be set on child", childNode.hasProperty("j:deletionDate"));
        Assert.assertNotNull("Node is already deleted", this.liveSession.getNode("/sites/markedForDeletionTest/pages/page1"));
        Assert.assertNotNull("Node is already deleted", this.liveSession.getNode("/sites/markedForDeletionTest/pages/page1/page11"));
        node.unmarkForDeletion();
        this.editSession.save();
        Assert.assertNotNull("Node is already deleted", this.liveSession.getNode("/sites/markedForDeletionTest/pages/page1"));
        Assert.assertNotNull("Node is already deleted", this.liveSession.getNode("/sites/markedForDeletionTest/pages/page1/page11"));
        Assert.assertFalse("jmix:markedForDeletionRoot should not be set", node.isNodeType("jmix:markedForDeletionRoot"));
        Assert.assertFalse("jmix:markedForDeletion should not be set", node.isNodeType("jmix:markedForDeletion"));
        Assert.assertFalse("marked for deletion comment should not be set", node.hasProperty("j:deletionMessage"));
        Assert.assertFalse("j:deletionDate should not be set", node.hasProperty("j:deletionDate"));
        Assert.assertFalse("j:deletionUser should not be set", node.hasProperty("j:deletionUser"));
        Assert.assertFalse("jmix:markedForDeletionRoot should not be set", childNode.isNodeType("jmix:markedForDeletionRoot"));
        Assert.assertFalse("jmix:markedForDeletion should not be set", childNode.isNodeType("jmix:markedForDeletion"));
        Assert.assertFalse("marked for deletion comment should not be set on child", childNode.hasProperty("j:deletionMessage"));
        Assert.assertFalse("j:deletionUser should not be set on child", childNode.hasProperty("j:deletionUser"));
        Assert.assertFalse("j:deletionDate should not be set on child", childNode.hasProperty("j:deletionDate"));
        this.reopenSession();
        jcrService.publishByMainId(node.getIdentifier(), "default", "live", null, true, null);
        this.reopenSession();
        node = this.editSession.getNode("/sites/markedForDeletionTest/pages/page1");
        childNode = this.editSession.getNode("/sites/markedForDeletionTest/pages/page1/page11");
        Assert.assertNotNull("Node is already deleted", this.editSession.getNode("/sites/markedForDeletionTest/pages/page1"));
        Assert.assertNotNull("Node is already deleted", this.editSession.getNode("/sites/markedForDeletionTest/pages/page1/page11"));
        Assert.assertNotNull("Node is already deleted", this.liveSession.getNode("/sites/markedForDeletionTest/pages/page1"));
        Assert.assertNotNull("Node is already deleted", this.liveSession.getNode("/sites/markedForDeletionTest/pages/page1/page11"));
        Assert.assertFalse("jmix:markedForDeletionRoot should not be set", node.isNodeType("jmix:markedForDeletionRoot"));
        Assert.assertFalse("jmix:markedForDeletion should not be set", node.isNodeType("jmix:markedForDeletion"));
        Assert.assertFalse("marked for deletion comment should not be set", node.hasProperty("j:deletionMessage"));
        Assert.assertFalse("j:deletionUser should not be set", node.hasProperty("j:deletionUser"));
        Assert.assertFalse("j:deletionDate should not be set", node.hasProperty("j:deletionDate"));
        Assert.assertFalse("jmix:markedForDeletionRoot should not be set", childNode.isNodeType("jmix:markedForDeletionRoot"));
        Assert.assertFalse("jmix:markedForDeletion should not be set", childNode.isNodeType("jmix:markedForDeletion"));
        Assert.assertFalse("marked for deletion comment should not be set on child", childNode.hasProperty("j:deletionMessage"));
        Assert.assertFalse("j:deletionUser should not be set on child", childNode.hasProperty("j:deletionUser"));
        Assert.assertFalse("j:deletionDate should not be set on child", childNode.hasProperty("j:deletionDate"));
    }

    private static void initContent(JCRSessionWrapper session) throws RepositoryException {
        int i = 0;
        GregorianCalendar calendar = new GregorianCalendar(2000, 0, 1, 12, 0);
        JCRNodeWrapper node = session.getNode("/sites/markedForDeletionTest/contents");
        session.getWorkspace().getVersionManager().checkout(node.getPath());
        MarkForDeletionTest.createEvent(node, MEETING, PARIS, calendar, i++);
        MarkForDeletionTest.createEvent(node, MEETING, GENEVA, calendar, i++);
        MarkForDeletionTest.createEvent(node, MEETING, GENEVA, calendar, i++);
        MarkForDeletionTest.createEvent(node, MEETING, PARIS, calendar, i++);
        JCRNodeWrapper home = session.getNode(SITECONTENT_ROOT_NODE);
        JCRNodeWrapper pages = home.addNode("pages", "jnt:page");
        pages.setProperty("jcr:title", "Source");
        pages.setProperty("j:templateName", "simple");
        JCRNodeWrapper page1 = pages.addNode("page1", "jnt:page");
        page1.setProperty("jcr:title", "Page1");
        page1.setProperty("j:templateName", "simple");
        JCRNodeWrapper page2 = pages.addNode("page2", "jnt:page");
        page2.setProperty("jcr:title", "Page2");
        page2.setProperty("j:templateName", "simple");
        JCRNodeWrapper page3 = pages.addNode("page3", "jnt:page");
        page3.setProperty("jcr:title", "Page3");
        page3.setProperty("j:templateName", "simple");
        JCRNodeWrapper page11 = page1.addNode("page11", "jnt:page");
        page11.setProperty("jcr:title", "Page1-1");
        page11.setProperty("j:templateName", "simple");
        JCRNodeWrapper page12 = page1.addNode("page12", "jnt:page");
        page12.setProperty("jcr:title", "Page1-2");
        page12.setProperty("j:templateName", "simple");
        JCRNodeWrapper page13 = page1.addNode("page13", "jnt:page");
        page13.setProperty("jcr:title", "Page1-3");
        page13.setProperty("j:templateName", "simple");
        JCRNodeWrapper page21 = page2.addNode("page21", "jnt:page");
        page21.setProperty("jcr:title", "Page2-1");
        page21.setProperty("j:templateName", "simple");
        JCRNodeWrapper page22 = page2.addNode("page22", "jnt:page");
        page22.setProperty("jcr:title", "Page2-2");
        page22.setProperty("j:templateName", "simple");
        JCRNodeWrapper page23 = page2.addNode("page23", "jnt:page");
        page23.setProperty("jcr:title", "Page2-3");
        page23.setProperty("j:templateName", "simple");
        JCRNodeWrapper page31 = page3.addNode("page31", "jnt:page");
        page31.setProperty("jcr:title", "Page3-1");
        page31.setProperty("j:templateName", "simple");
        JCRNodeWrapper page32 = page3.addNode("page32", "jnt:page");
        page32.setProperty("jcr:title", "Page3-2");
        page32.setProperty("j:templateName", "simple");
        JCRNodeWrapper page33 = page3.addNode("page33", "jnt:page");
        page33.setProperty("jcr:title", "Page3-3");
        page33.setProperty("j:templateName", "simple");
        session.save();
    }

    @Test
    public void testMixinsAndQuery() throws Exception {
        this.reopenSession();
        long initialNoOfMarkedNodes = JCRContentUtils.size((RangeIterator)this.editSession.getWorkspace().getQueryManager().createQuery(QUERY, "JCR-SQL2").execute().getNodes());
        JCRNodeWrapper parent = this.editSession.getNode("/sites/markedForDeletionTest/contents");
        this.editSession.getWorkspace().getVersionManager().checkout(parent.getPath());
        JCRNodeWrapper node = parent.addNode("mixinsAndQueryTest", "jnt:contentFolder");
        GregorianCalendar calendar = new GregorianCalendar(2000, 0, 1, 12, 0);
        MarkForDeletionTest.createEvent(node, MEETING, PARIS, calendar, 1);
        MarkForDeletionTest.createEvent(node, MEETING, GENEVA, calendar, 2);
        MarkForDeletionTest.createEvent(node, MEETING, KLAGENFURT, calendar, 3);
        MarkForDeletionTest.createEvent(node, MEETING, DUESSELDORF, calendar, 4);
        this.editSession.save();
        Assert.assertEquals("Failed to create 4 event sub-nodes", 4L, JCRContentUtils.size((RangeIterator)node.getNodes()));
        this.reopenSession();
        Assert.assertEquals("Query for marked for deletion nodes delivered wrong number of results", 0L + initialNoOfMarkedNodes, JCRContentUtils.size((RangeIterator)this.editSession.getWorkspace().getQueryManager().createQuery(QUERY, "JCR-SQL2").execute().getNodes()));
        this.editSession.getNode("/sites/markedForDeletionTest/contents/mixinsAndQueryTest/meeting2").markForDeletion(DELETION_MESSAGE);
        this.editSession.getNode("/sites/markedForDeletionTest/contents/mixinsAndQueryTest/meeting4").markForDeletion(DELETION_MESSAGE);
        this.editSession.save();
        this.reopenSession();
        Assert.assertEquals("Query for marked for deletion nodes delivered wrong number of results", 2L + initialNoOfMarkedNodes, JCRContentUtils.size((RangeIterator)this.editSession.getWorkspace().getQueryManager().createQuery(QUERY, "JCR-SQL2").execute().getNodes()));
        this.editSession.getNode("/sites/markedForDeletionTest/contents/mixinsAndQueryTest/meeting2").unmarkForDeletion();
        this.editSession.save();
        this.reopenSession();
        Assert.assertEquals("Query for marked for deletion nodes delivered wrong number of results", 1L + initialNoOfMarkedNodes, JCRContentUtils.size((RangeIterator)this.editSession.getWorkspace().getQueryManager().createQuery(QUERY, "JCR-SQL2").execute().getNodes()));
        this.editSession.getNode("/sites/markedForDeletionTest/contents/mixinsAndQueryTest/meeting4").unmarkForDeletion();
        this.editSession.save();
        this.reopenSession();
        Assert.assertEquals("Query for marked for deletion nodes delivered wrong number of results", 0L + initialNoOfMarkedNodes, JCRContentUtils.size((RangeIterator)this.editSession.getWorkspace().getQueryManager().createQuery(QUERY, "JCR-SQL2").execute().getNodes()));
    }

    private static void createEvent(JCRNodeWrapper node, String eventType, String location, Calendar calendar, int i) throws RepositoryException {
        String name = eventType + i;
        JCRNodeWrapper event = node.addNode(name, "jnt:event");
        event.setProperty("jcr:title", name);
        event.setProperty("eventsType", eventType);
        event.setProperty("location", location);
        event.setProperty("startDate", calendar);
    }

    private void reopenSession() throws RepositoryException {
        JCRSessionFactory.getInstance().closeAllSessions();
        this.editSession = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
        this.liveSession = JCRSessionFactory.getInstance().getCurrentUserSession("live", Locale.ENGLISH);
    }
}

