/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.content.decorator;

import java.util.Locale;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.junit.Assert;
import org.junit.Test;

public class PasswordHistoryEntryDecoratorTest {
    private static final String PROP = "j:password";

    @Test
    public void testSystemSession() throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Boolean>(){

            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRNodeIteratorWrapper iterator = session.getNode("/users/root/passwordHistory").getNodes();
                while (iterator.hasNext()) {
                    JCRNodeWrapper child = (JCRNodeWrapper)iterator.nextNode();
                    if (!child.isNodeType("jnt:passwordHistoryEntry")) continue;
                    Assert.assertTrue("Cannot find j:password property", child.hasProperty(PasswordHistoryEntryDecoratorTest.PROP));
                    Assert.assertNotNull("Cannot find j:password property", child.getProperty(PasswordHistoryEntryDecoratorTest.PROP));
                    Assert.assertNotNull("Cannot find j:password property", child.getPropertyAsString(PasswordHistoryEntryDecoratorTest.PROP));
                    Assert.assertTrue("Cannot find j:password property", child.getPropertiesAsString().containsKey(PasswordHistoryEntryDecoratorTest.PROP));
                    boolean found = false;
                    PropertyIterator propIterator = child.getProperties();
                    while (propIterator.hasNext()) {
                        if (!propIterator.nextProperty().getName().equals(PasswordHistoryEntryDecoratorTest.PROP)) continue;
                        found = true;
                        break;
                    }
                    Assert.assertTrue("Cannot find j:password property", found);
                    break;
                }
                return Boolean.TRUE;
            }
        });
    }

    @Test
    public void testUserSession() throws RepositoryException {
        JCRTemplate.getInstance().doExecute("root", null, "default", Locale.ENGLISH, (JCRCallback)new JCRCallback<Boolean>(){

            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRNodeIteratorWrapper iterator = session.getNode("/users/root/passwordHistory").getNodes();
                while (iterator.hasNext()) {
                    JCRNodeWrapper child = (JCRNodeWrapper)iterator.nextNode();
                    if (!child.isNodeType("jnt:passwordHistoryEntry")) continue;
                    Assert.assertFalse("Found j:password property", child.hasProperty(PasswordHistoryEntryDecoratorTest.PROP));
                    PathNotFoundException pnfe = null;
                    try {
                        child.getProperty(PasswordHistoryEntryDecoratorTest.PROP);
                    }
                    catch (PathNotFoundException e) {
                        pnfe = e;
                    }
                    Assert.assertNotNull("Found j:password property", (Object)pnfe);
                    Assert.assertNull("Found j:password property", child.getPropertyAsString(PasswordHistoryEntryDecoratorTest.PROP));
                    Assert.assertFalse("Found j:password property", child.getPropertiesAsString().containsKey(PasswordHistoryEntryDecoratorTest.PROP));
                    boolean found = false;
                    PropertyIterator propIterator = child.getProperties();
                    while (propIterator.hasNext()) {
                        if (!propIterator.nextProperty().getName().equals(PasswordHistoryEntryDecoratorTest.PROP)) continue;
                        found = true;
                        break;
                    }
                    Assert.assertFalse("Found j:password property", found);
                    break;
                }
                return Boolean.TRUE;
            }
        });
    }
}

