/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.content.interceptor;

import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import junit.framework.Assert;
import org.jahia.bin.Jahia;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.sites.JahiaSite;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class URLInterceptorTest
extends JahiaTestCase {
    private static JahiaSite site;
    private static JCRSessionWrapper session;
    private static JCRSessionWrapper localizedSession;
    private static JCRNodeWrapper node;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        site = TestHelper.createSite("test");
    }

    @Before
    public void setUp() throws RepositoryException {
        session = JCRSessionFactory.getInstance().getCurrentUserSession();
        site = (JahiaSite)session.getNode("/sites/test");
        URLInterceptorTest.setSessionSite(site);
        JCRNodeWrapper shared = session.getNode("/sites/" + site.getSiteKey() + "/contents");
        if (!shared.isCheckedOut()) {
            session.checkout((Node)shared);
        }
        if (shared.hasNode("testContent")) {
            shared.getNode("testContent").remove();
        }
        if (shared.hasNode("refContent")) {
            shared.getNode("refContent").remove();
        }
        session.save();
        node = shared.addNode("testContent", "jnt:mainContent");
        node = shared.addNode("refContent", "jnt:mainContent");
        session.save();
        localizedSession = JCRSessionFactory.getInstance().getCurrentUserSession(null, Locale.ENGLISH);
    }

    @After
    public void tearDown() throws Exception {
        session.save();
        localizedSession.save();
        JCRSessionFactory.getInstance().closeAllSessions();
        site = null;
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        TestHelper.deleteSite("test");
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @Test
    public void testBadReferenceEncoding() throws Exception {
        String value2;
        JCRNodeWrapper n = localizedSession.getNode("/sites/" + site.getSiteKey() + "/contents/testContent");
        try {
            value2 = "<img src=\"" + Jahia.getContextPath() + "/files/sites/" + site.getSiteKey() + "/contents/noNode\">";
            n.setProperty("body", value2);
            Assert.fail("Did not throw exception " + value2);
        }
        catch (ConstraintViolationException value2) {
            // empty catch block
        }
        try {
            value2 = "<a href=\"" + Jahia.getContextPath() + "/cms/render/live/{lang}/sites/" + site.getSiteKey() + "/contents/noNode.html\">test</a>";
            n.setProperty("body", value2);
            Assert.fail("Did not throw exception " + value2);
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testEncodeAndDecode() throws Exception {
        this.validateEncodeAndDecode("<a href=\"" + Jahia.getContextPath() + "/cms/render/default/en/sites/" + site.getSiteKey() + "/contents/refContent.html\">test</a>");
        this.validateEncodeAndDecode("<a href=\"" + Jahia.getContextPath() + "/cms/edit/default/en/sites/" + site.getSiteKey() + "/contents/refContent.html\">test</a>");
        this.validateEncodeAndDecode("<a href=\"" + Jahia.getContextPath() + "/cms/render/live/fr/sites/" + site.getSiteKey() + "/contents/refContent.html\">test</a>");
        this.validateEncodeAndDecode("<a href=\"" + Jahia.getContextPath() + "/cms/render/live/{lang}/sites/" + site.getSiteKey() + "/contents/refContent.html\">test</a>");
        this.validateEncodeAndDecode("<a href=\"" + Jahia.getContextPath() + "/cms/{mode}/en/sites/" + site.getSiteKey() + "/contents/refContent.html\">test</a>");
        this.validateEncodeAndDecode("<a href=\"" + Jahia.getContextPath() + "/cms/{mode}/{lang}/sites/" + site.getSiteKey() + "/contents/refContent.html\">test</a>");
        this.validateEncodeAndDecode("<a href=\"" + Jahia.getContextPath() + "/cms/{mode}/{lang}/sites/" + site.getSiteKey() + "/contents/refContent.html\">test</a><a href=\"" + Jahia.getContextPath() + "/cms/{mode}/{lang}/sites/" + site.getSiteKey() + "/contents/refContent.html\">test</a>");
        this.validateEncodeAndDecode("<a href=\"" + Jahia.getContextPath() + "/cms/{mode}/{lang}/sites/" + site.getSiteKey() + "/contents/refContent.html\">test</a><a href=\"" + Jahia.getContextPath() + "/cms/{mode}/{lang}/sites/" + site.getSiteKey() + "/contents/testContent.html\">test</a>");
        this.validateEncodeAndDecode("<img src=\"" + Jahia.getContextPath() + "/files/default/sites/" + site.getSiteKey() + "/contents/refContent\">");
    }

    private void validateEncodeAndDecode(String value) throws RepositoryException {
        JCRNodeWrapper n = localizedSession.getNode("/sites/" + site.getSiteKey() + "/contents/testContent");
        n.setProperty("body", value);
        Assert.assertEquals("Not the same value after get", value, n.getProperty("body").getString());
    }
}

