/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.content.nodetypes;

import java.util.Calendar;
import java.util.Locale;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.test.JahiaTestCase;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class NodePropertyDefaultValueTest
extends JahiaTestCase {
    private static final String SITE_KEY = "systemsite";
    private static final String FOLDER_PATH = "/sites/systemsite/contents";
    private static final String NODE_NAME = "defaultValuesTest";
    private static final String NODE_PATH = "/sites/systemsite/contents/defaultValuesTest";
    private JCRSessionWrapper englishSession;
    private JCRSessionWrapper frenchSession;
    private JCRSessionWrapper germanSession;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
    }

    @Before
    public void setUp() throws RepositoryException {
        this.englishSession = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
        this.frenchSession = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.FRENCH);
        this.germanSession = JCRSessionFactory.getInstance().getCurrentUserSession("default", new Locale("de", "AT"));
        if (this.englishSession.nodeExists(NODE_PATH)) {
            this.englishSession.getNode(NODE_PATH).remove();
            this.englishSession.save();
        }
    }

    @After
    public void tearDown() throws RepositoryException {
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @Test
    public void testDefaultValues() throws Exception {
        Calendar now = Calendar.getInstance();
        Calendar tomorrow = Calendar.getInstance();
        tomorrow.add(5, 1);
        this.englishSession.getNode(FOLDER_PATH).addNode(NODE_NAME, "test:dynamicValuesTest");
        this.englishSession.save();
        this.englishSession.logout();
        this.englishSession = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
        this.checkPropertyValues(now, tomorrow, "");
    }

    @Test
    public void testMixinDefaultValues() throws Exception {
        Calendar now = Calendar.getInstance();
        Calendar tomorrow = Calendar.getInstance();
        tomorrow.add(5, 1);
        JCRNodeWrapper node = this.englishSession.getNode(FOLDER_PATH).addNode(NODE_NAME, "test:emptyContent");
        node.addMixin("test:dynamicValuesTestMixin");
        this.englishSession.save();
        this.englishSession.logout();
        this.englishSession = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
        this.checkPropertyValues(now, tomorrow, "Mixin");
    }

    private void checkPropertyValues(Calendar now, Calendar tomorrow, String propNameSuffix) throws RepositoryException {
        JCRNodeWrapper node = this.englishSession.getNode(NODE_PATH);
        Assert.assertTrue(node.hasProperty("propertyText" + propNameSuffix));
        Assert.assertTrue(node.hasProperty("propertyTextI18n" + propNameSuffix));
        Assert.assertTrue(node.hasProperty("propertyLong" + propNameSuffix));
        Assert.assertTrue(node.hasProperty("propertyDouble" + propNameSuffix));
        Assert.assertTrue(node.hasProperty("propertyDate" + propNameSuffix));
        Assert.assertTrue(node.hasProperty("propertyNow" + propNameSuffix));
        Assert.assertTrue(node.hasProperty("propertyTomorrow" + propNameSuffix));
        Assert.assertTrue(node.hasProperty("propertyCurrentUser" + propNameSuffix));
        Assert.assertTrue(node.hasProperty("propertyResourceBundleShared" + propNameSuffix));
        Assert.assertTrue(node.hasProperty("propertyResourceBundleI18n" + propNameSuffix));
        Assert.assertEquals("Text plain", node.getProperty("propertyText" + propNameSuffix).getString());
        Assert.assertEquals("Text i18n", node.getProperty("propertyTextI18n" + propNameSuffix).getString());
        Assert.assertEquals(12L, node.getProperty("propertyLong" + propNameSuffix).getLong());
        Assert.assertEquals(12.28, node.getProperty("propertyDouble" + propNameSuffix).getDouble(), 0.01);
        Calendar date = node.getProperty("propertyDate" + propNameSuffix).getDate();
        Assert.assertNotNull(date);
        Assert.assertEquals(1979L, date.get(1));
        Assert.assertEquals(4L, date.get(2));
        Assert.assertEquals(9L, date.get(5));
        Calendar dateNow = node.getProperty("propertyNow" + propNameSuffix).getDate();
        Assert.assertNotNull(dateNow);
        Assert.assertEquals(now.get(1), dateNow.get(1));
        Assert.assertEquals(now.get(2), dateNow.get(2));
        Assert.assertEquals(now.get(5), dateNow.get(5));
        Calendar dateTomorrow = node.getProperty("propertyTomorrow" + propNameSuffix).getDate();
        Assert.assertNotNull(dateTomorrow);
        Assert.assertEquals(tomorrow.get(1), dateTomorrow.get(1));
        Assert.assertEquals(tomorrow.get(2), dateTomorrow.get(2));
        Assert.assertEquals(tomorrow.get(5), dateTomorrow.get(5));
        Assert.assertEquals(this.englishSession.getUserID(), node.getProperty("propertyCurrentUser" + propNameSuffix).getString());
        Assert.assertEquals("Test value 1", node.getProperty("propertyResourceBundleShared" + propNameSuffix).getString());
        Assert.assertEquals("Test value 2", node.getProperty("propertyResourceBundleI18n" + propNameSuffix).getString());
    }

    @Test
    public void testEnglishDefaultValues() throws Exception {
        this.createNode(this.englishSession);
        JCRNodeWrapper node = this.englishSession.getNode(NODE_PATH);
        Assert.assertEquals("Test value 2", node.getProperty("propertyResourceBundleI18n").getString());
    }

    @Test
    public void testFrenchDefaultValues() throws Exception {
        this.createNode(this.frenchSession);
        JCRNodeWrapper node = this.frenchSession.getNode(NODE_PATH);
        Assert.assertEquals("Valeur de test 2", node.getProperty("propertyResourceBundleI18n").getString());
    }

    @Test
    public void testGermanDefaultValues() throws Exception {
        this.createNode(this.germanSession);
        JCRNodeWrapper node = this.germanSession.getNode(NODE_PATH);
        Assert.assertEquals("Testwert 2", node.getProperty("propertyResourceBundleI18n").getString());
    }

    private void createNode(JCRSessionWrapper session) throws Exception {
        session.getNode(FOLDER_PATH).addNode(NODE_NAME, "test:dynamicValuesTest");
        session.save();
    }
}

