/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.content.protection;

import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.Properties;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRMountPointNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.pwdpolicy.JahiaPasswordPolicyService;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.test.JahiaTestCase;
import org.json.JSONObject;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JcrSettingsAccessTest
extends JahiaTestCase {
    private static final String[] JCR_PATHS_TO_TEST = new String[]{"/settings/mail-server", "/settings/mail-server/j:activated", "/settings/search-settings", "/settings/search-settings/j:provider", "/settings/forgesSettings", "/passwordPolicy", "/passwordPolicy/j:policy"};
    private static final String PRIVILEGED_USER_NAME = "jcr-settings-test-privileged-user";
    private static final String SERVER_ADMIN_USER_NAME = "jcr-mount-point-test-serveradmin-user";
    private static final String USER_PASSWORD = "password";
    private static JahiaGroupManagerService groupManager;
    private static String mountPointPath;
    private static JahiaUserManagerService userManager;

    private static void checkExistence(JCRSessionWrapper session, boolean expectExists, String ... paths) throws RepositoryException {
        String user = session.getUserID();
        String workspace = session.getWorkspace().getName();
        for (String path : paths) {
            if (expectExists) {
                Assert.assertTrue(path + " should be accessible with " + user + " session in " + workspace, session.itemExists(path));
                Assert.assertNotNull(path + " should be accessible with " + user + " session in " + workspace, session.getItem(path));
                continue;
            }
            Assert.assertFalse(path + " should not be accessible with " + user + " session in " + workspace, session.itemExists(path));
            try {
                session.getItem(path);
                Assert.fail(path + " should not be accessible with " + user + " session in " + workspace);
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
        }
    }

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        groupManager = JahiaGroupManagerService.getInstance();
        userManager = JahiaUserManagerService.getInstance();
        JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Boolean>(){

            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRUserNode privilegedUser = userManager.createUser(JcrSettingsAccessTest.PRIVILEGED_USER_NAME, JcrSettingsAccessTest.USER_PASSWORD, new Properties(), session);
                session.save();
                groupManager.lookupGroup(null, "privileged", session).addMember((JCRNodeWrapper)privilegedUser);
                session.save();
                JahiaPasswordPolicyService.getInstance().getDefaultPolicy();
                userManager.createUser(JcrSettingsAccessTest.SERVER_ADMIN_USER_NAME, JcrSettingsAccessTest.USER_PASSWORD, new Properties(), session);
                session.save();
                session.getRootNode().grantRoles("u:jcr-mount-point-test-serveradmin-user", Collections.singleton("server-administrator"));
                session.save();
                JCRMountPointNode jcrMountPointNode = (JCRMountPointNode)session.getNode("/mounts").addNode("jcr-mount-point-test-" + System.currentTimeMillis() + "-mount", "jnt:vfsMountPoint");
                jcrMountPointNode.setProperty("j:rootPath", FileUtils.getTempDirectoryPath());
                jcrMountPointNode.setMountStatus(JCRMountPointNode.MountStatus.mounted);
                session.save();
                JCRStoreProvider mountProvider = jcrMountPointNode.getMountProvider();
                Assert.assertTrue("Unable to create VFS mount point", mountProvider != null && mountProvider.isAvailable());
                mountPointPath = jcrMountPointNode.getPath();
                return null;
            }
        });
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Boolean>(){

            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRUserNode serverAdminUser;
                JCRUserNode privilegedUser = userManager.lookupUser(JcrSettingsAccessTest.PRIVILEGED_USER_NAME, session);
                if (privilegedUser != null) {
                    groupManager.lookupGroup(null, "privileged", session).removeMember((JCRNodeWrapper)privilegedUser);
                    session.save();
                    userManager.deleteUser(privilegedUser.getPath(), session);
                    session.save();
                }
                if ((serverAdminUser = userManager.lookupUser(JcrSettingsAccessTest.SERVER_ADMIN_USER_NAME, session)) != null) {
                    session.getRootNode().revokeRolesForPrincipal("u:jcr-mount-point-test-serveradmin-user");
                    userManager.deleteUser(serverAdminUser.getPath(), session);
                    session.save();
                }
                if (mountPointPath != null && session.nodeExists(mountPointPath)) {
                    session.getNode(mountPointPath).remove();
                    session.save();
                }
                return null;
            }
        });
        groupManager = null;
        userManager = null;
    }

    private void checkNoAccessViaRest() throws IOException {
        this.checkNoAccessViaRest("/modules/api/jcr/v1/live/en/paths/settings/mail-server");
        this.checkNoAccessViaRest("/modules/api/jcr/v1/default/en/paths/settings/mail-server");
        this.checkNoAccessViaRest("/modules/api/jcr/v1/default/en/paths/settings/search-settings");
        this.checkNoAccessViaRest("/modules/api/jcr/v1/default/en/paths/settings/forgesSettings");
        this.checkNoAccessViaRest("/modules/api/jcr/v1/default/en/paths/passwordPolicy");
        this.checkNoAccessViaRest("/modules/api/jcr/v1/default/en/paths" + mountPointPath);
    }

    private void checkNoAccessViaRest(String url) throws IOException {
        String out = this.getAsText(url, 404);
        Assert.assertTrue(StringUtils.contains((String)out, (String)"\"exception\":\"javax.jcr.PathNotFoundException\""));
    }

    @Test
    public void shouldHaveAccessToMountPointNodeWithServerAdminUserViaJcr() throws RepositoryException {
        JCRTemplate.getInstance().doExecute(SERVER_ADMIN_USER_NAME, null, "default", Locale.ENGLISH, (JCRCallback)new JCRCallback<Boolean>(){

            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JcrSettingsAccessTest.checkExistence(session, true, new String[]{mountPointPath, mountPointPath + "/j:rootPath"});
                return null;
            }
        });
    }

    @Test
    public void shouldHaveAccessToMountPointNodeWithServerAdminUserViaRest() throws RepositoryException, IOException {
        this.login(SERVER_ADMIN_USER_NAME, USER_PASSWORD);
        try {
            String out = this.getAsText("/modules/api/jcr/v1/default/en/paths" + mountPointPath);
            Assert.assertTrue(StringUtils.contains((String)out, (String)"\"type\":\"jnt:vfsMountPoint\""));
            Assert.assertTrue(StringUtils.contains((String)out, (String)"\"name\":\"j:rootPath\""));
            Assert.assertTrue(StringUtils.contains((String)out, (String)("\"value\":" + JSONObject.quote((String)FileUtils.getTempDirectoryPath()))));
        }
        finally {
            this.logout();
        }
    }

    @Test
    public void shouldHaveAccessToSettingsWithSystemUserViaJcr() throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Boolean>(){

            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JcrSettingsAccessTest.checkExistence(session, true, JCR_PATHS_TO_TEST);
                JcrSettingsAccessTest.checkExistence(session, true, new String[]{mountPointPath, mountPointPath + "/j:rootPath"});
                return null;
            }
        });
    }

    @Test
    public void shouldHaveAccessToSettingsWithSystemUserViaRest() throws RepositoryException, IOException {
        this.loginRoot();
        try {
            String out = this.getAsText("/modules/api/jcr/v1/default/en/paths/settings/mail-server");
            Assert.assertTrue(StringUtils.contains((String)out, (String)"\"type\":\"jnt:mailServerSettings\""));
            Assert.assertTrue(StringUtils.contains((String)out, (String)"\"path\":\"/settings/mail-server/j:activated\""));
            out = this.getAsText("/modules/api/jcr/v1/default/en/paths/settings/search-settings");
            Assert.assertTrue(StringUtils.contains((String)out, (String)"\"type\":\"jnt:searchServerSettings\""));
            Assert.assertTrue(StringUtils.contains((String)out, (String)"\"path\":\"/settings/search-settings/j:provider\""));
            out = this.getAsText("/modules/api/jcr/v1/default/en/paths/settings/forgesSettings");
            Assert.assertTrue(StringUtils.contains((String)out, (String)"\"type\":\"jnt:forgesServerSettings\""));
            out = this.getAsText("/modules/api/jcr/v1/default/en/paths/passwordPolicy");
            Assert.assertTrue(StringUtils.contains((String)out, (String)"\"type\":\"jnt:passwordPolicy\""));
            out = this.getAsText("/modules/api/jcr/v1/default/en/paths" + mountPointPath);
            Assert.assertTrue(StringUtils.contains((String)out, (String)"\"type\":\"jnt:vfsMountPoint\""));
            Assert.assertTrue(StringUtils.contains((String)out, (String)"\"name\":\"j:rootPath\""));
            Assert.assertTrue(StringUtils.contains((String)out, (String)("\"value\":" + JSONObject.quote((String)FileUtils.getTempDirectoryPath()))));
        }
        finally {
            this.logout();
        }
    }

    @Test
    public void shouldNotHaveAccessToSettingsWithGuestUserViaJcr() throws RepositoryException {
        JCRCallback<Boolean> callback = new JCRCallback<Boolean>(){

            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JcrSettingsAccessTest.checkExistence(session, false, JCR_PATHS_TO_TEST);
                JcrSettingsAccessTest.checkExistence(session, false, new String[]{mountPointPath + "/j:rootPath"});
                return null;
            }
        };
        JCRTemplate.getInstance().doExecute("guest", null, "default", Locale.ENGLISH, (JCRCallback)callback);
        JCRTemplate.getInstance().doExecute("guest", null, "live", Locale.ENGLISH, (JCRCallback)callback);
    }

    @Test
    public void shouldNotHaveAccessToSettingsWithGuestUserViaRest() throws RepositoryException, IOException {
        this.checkNoAccessViaRest();
    }

    @Test
    public void shouldNotHaveAccessToSettingsWithPrivilegedUserViaJcr() throws RepositoryException {
        JCRTemplate.getInstance().doExecute(PRIVILEGED_USER_NAME, null, "default", Locale.ENGLISH, (JCRCallback)new JCRCallback<Boolean>(){

            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JcrSettingsAccessTest.checkExistence(session, false, JCR_PATHS_TO_TEST);
                JcrSettingsAccessTest.checkExistence(session, false, new String[]{mountPointPath + "/j:rootPath"});
                return null;
            }
        });
    }

    @Test
    public void shouldNotHaveAccessToSettingsWithPrivilegedUserViaRest() throws RepositoryException, IOException {
        this.login("privileged", USER_PASSWORD);
        try {
            this.checkNoAccessViaRest();
        }
        finally {
            this.logout();
        }
    }
}

