/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.content.protection;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class RestApiAccessTest
extends JahiaTestCase {
    private static final String EDITOR_USER_NAME = "rest-api-access-test-editor";
    private static final String EDITOR_USER_PASSWORD = "password";
    private static String editorNodePath;
    private static JahiaSite site;
    private static final String TESTSITE_NAME = "restApiAccessTest";

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        site = TestHelper.createSite(TESTSITE_NAME, "localhost" + System.currentTimeMillis(), "templates-intranet");
        Assert.assertNotNull(site);
        JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Boolean>(){

            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRUserNode editorUser = JahiaUserManagerService.getInstance().createUser(RestApiAccessTest.EDITOR_USER_NAME, null, RestApiAccessTest.EDITOR_USER_PASSWORD, new Properties(), session);
                editorNodePath = editorUser.getPath();
                session.save();
                JCRNodeWrapper siteNode = session.getNode(site.getJCRLocalPath());
                siteNode.grantRoles("u:rest-api-access-test-editor", Collections.singleton("editor"));
                session.save();
                JCRNodeWrapper userFiles = editorUser.addNode("files", "jnt:folder");
                session.save();
                JCRPublicationService.getInstance().publishByMainId(userFiles.getIdentifier(), "default", "live", null, true, null);
                JCRPublicationService.getInstance().publishByMainId(siteNode.getIdentifier(), "default", "live", null, true, null);
                return null;
            }
        });
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Boolean>(){

            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JahiaUserManagerService userManager = JahiaUserManagerService.getInstance();
                JCRUserNode editorUser = userManager.lookupUser(RestApiAccessTest.EDITOR_USER_NAME, session);
                if (editorUser != null) {
                    userManager.deleteUser(editorUser.getPath(), session);
                    session.save();
                }
                return null;
            }
        });
        TestHelper.deleteSite(TESTSITE_NAME);
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @Test
    public void accessWithEditorUser() throws RepositoryException, IOException {
        this.login(EDITOR_USER_NAME, EDITOR_USER_PASSWORD);
        try {
            this.checkLiveAccess(editorNodePath);
            this.checkLiveAccess(editorNodePath + "/files");
            this.checkLiveAccess("/sites/restApiAccessTest/contents");
        }
        finally {
            this.logout();
        }
    }

    @Test
    public void accessWithGuestToFoldersAndPages() throws RepositoryException, IOException {
        this.checkLiveAccess("/sites/restApiAccessTest/files");
        this.checkLiveAccess("/sites/restApiAccessTest/home");
    }

    private void checkLiveAccess(String path) throws IOException {
        this.checkAccess("/modules/api/jcr/v1/live/en/paths" + path, true);
    }

    private void checkAccess(String url, boolean shouldHaveAccess) throws IOException {
        String out = this.getAsText(url, shouldHaveAccess ? 200 : 404);
        if (shouldHaveAccess) {
            Assert.assertFalse("Should have access to the URL: " + url, StringUtils.contains((String)out, (String)"\"exception\":\"javax.jcr.PathNotFoundException\""));
        } else {
            Assert.assertTrue("Should NOT have access to the URL: " + url, StringUtils.contains((String)out, (String)"\"exception\":\"javax.jcr.PathNotFoundException\""));
        }
    }

    private void checkNoAccess(String path) throws IOException {
        this.checkNoAccess(path, "live");
        this.checkNoAccess(path, "default");
    }

    private void checkNoAccess(String path, String workspace) throws IOException {
        this.checkAccess("/modules/api/jcr/v1/" + workspace + "/en/paths" + path, false);
    }

    @Test
    public void noAccessToConfiguredNodeTypesToSkip() throws RepositoryException, IOException {
        String pwdEntryPath = (String)JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<String>(){

            public String doInJCR(JCRSessionWrapper session) throws RepositoryException {
                List pwdHistoryEntries = JCRContentUtils.getChildrenOfType((JCRNodeWrapper)session.getNode("/users/root/passwordHistory"), (String)"jnt:passwordHistoryEntry", (int)1);
                return pwdHistoryEntries.size() > 0 ? ((JCRNodeWrapper)pwdHistoryEntries.iterator().next()).getPath() : null;
            }
        });
        Assert.assertNotNull("Unable to find password history entry for root user", pwdEntryPath);
        this.checkNoAccess("/users/root/passwordHistory");
        this.checkNoAccess(pwdEntryPath);
        this.loginRoot();
        try {
            this.checkNoAccess("/users/root/passwordHistory");
            this.checkNoAccess(pwdEntryPath);
        }
        finally {
            this.logout();
        }
    }

    @Test
    public void noAccessWithGuestToOtherContent() throws RepositoryException, IOException {
        String[] paths;
        for (String path : paths = new String[]{"/groups", "/imports", "/j:acl", "/jcr:system", "/modules", "/passwordPolicy", "/referencesKeeper", "/settings", "/sites", "/users", "/users/root", "/users/root/files", editorNodePath + "/files"}) {
            this.checkNoAccess(path);
        }
    }
}

