/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.feedimporter;

import java.io.IOException;
import java.net.URL;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jahia.bin.Jahia;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.jahia.utils.LanguageCodeConverters;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class GetFeedActionTest
extends JahiaTestCase {
    private static final String TESTSITE_NAME = "jcrFeedImportTest";
    private static final String SITECONTENT_ROOT_NODE = "/sites/jcrFeedImportTest";

    @BeforeClass
    public static void oneTimeSetup() throws Exception {
        TestHelper.createSite(TESTSITE_NAME);
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        TestHelper.deleteSite(TESTSITE_NAME);
    }

    @Test
    public void testGetFeedAction() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFeed(String nodeName, String feedURL, String testNodeName) throws RepositoryException, IOException, JSONException {
        JCRSessionWrapper baseSession = JCRSessionFactory.getInstance().getCurrentUserSession();
        JCRSiteNode site = (JCRSiteNode)baseSession.getNode(SITECONTENT_ROOT_NODE);
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", LanguageCodeConverters.languageCodeToLocale((String)site.getDefaultLanguage()));
        JCRNodeWrapper node = session.getNode("/sites/jcrFeedImportTest/contents/feeds");
        session.checkout((Node)node);
        JCRNodeWrapper sdaFeedNode = node.addNode(nodeName, "jnt:feed");
        sdaFeedNode.setProperty("url", feedURL);
        session.save();
        JCRPublicationService.getInstance().publishByMainId(sdaFeedNode.getIdentifier(), "default", "live", null, true, null);
        HttpClient client = new HttpClient();
        client.getParams().setAuthenticationPreemptive(true);
        String baseurl = this.getBaseServerURL() + Jahia.getContextPath() + "/cms";
        URL url = new URL(baseurl + "/render/default/en" + sdaFeedNode.getPath() + ".getfeed.do");
        UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials("root", "root1234");
        client.getState().setCredentials(new AuthScope(url.getHost(), url.getPort(), AuthScope.ANY_REALM), (Credentials)defaultcreds);
        client.getHostConfiguration().setHost(url.getHost(), url.getPort(), url.getProtocol());
        PostMethod getFeedAction = new PostMethod(url.toExternalForm());
        try {
            getFeedAction.addRequestHeader(new Header("accept", "application/json"));
            client.executeMethod((HttpMethod)getFeedAction);
            Assert.assertEquals("Bad result code", 200L, getFeedAction.getStatusCode());
            JSONObject jSONObject = new JSONObject(getFeedAction.getResponseBodyAsString());
        }
        finally {
            getFeedAction.releaseConnection();
        }
        JCRSessionWrapper liveSession = JCRSessionFactory.getInstance().getCurrentUserSession("live", LanguageCodeConverters.languageCodeToLocale((String)site.getDefaultLanguage()));
        JCRNodeWrapper target = liveSession.getNode("/sites/jcrFeedImportTest/contents/feeds/" + nodeName + "/" + testNodeName);
    }
}

