/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.i18n;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.utils.i18n.JahiaResourceBundle;
import org.jahia.utils.i18n.Messages;
import org.jahia.utils.i18n.ResourceBundles;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBundleTest {
    private static Logger logger = LoggerFactory.getLogger(ResourceBundleTest.class);

    @Test
    public void lookupBundleTest() {
        JahiaTemplatesPackage pkg = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById("templates-web-space");
        String primary = pkg.getResourceBundleName();
        this.testResource(primary, pkg, "jmix_skinnable.j_skin.skins.acmebox3", Locale.ENGLISH, "ACME Box 3 Plain ");
        this.testResource(primary, pkg, "jmix_skinnable.j_skin.skins.box2", Locale.ENGLISH, "Border, light title, light content");
        this.testResource(primary, pkg, "jnt_displayMetadata.categories", Locale.ENGLISH, "Display the categories");
        this.testResource(primary, pkg, "jmix_contentmetadata.j_lastPublishingDate", Locale.ENGLISH, "Last publication");
        this.testResource(primary, pkg, "column.modifiedBy.label", Locale.ENGLISH, "Modified by");
        this.testResource(primary, pkg, "dummy.column.modifiedBy.label", Locale.ENGLISH, "notFound");
        this.testResource(primary, pkg, "jmix_skinnable.j_skin.skins.box2", Locale.FRENCH, "Avec cadre, fond de titre clair, fond du corps clair");
    }

    @Test
    public void lookupBundleTestLegacy() {
        String lookupModuleName = "Jahia Web Templates Space";
        String siteTemplatesPackageName = "Jahia Web Templates Space";
        this.testResourceLegacy("jmix_skinnable.j_skin.skins.acmebox3", "ACME Box 3 Plain ", lookupModuleName, Locale.ENGLISH, siteTemplatesPackageName);
        this.testResourceLegacy("jmix_skinnable.j_skin.skins.box2", "Border, light title, light content", lookupModuleName, Locale.ENGLISH, siteTemplatesPackageName);
        this.testResourceLegacy("jnt_displayMetadata.categories", "Display the categories", lookupModuleName, Locale.ENGLISH, siteTemplatesPackageName);
        this.testResourceLegacy("jmix_contentmetadata.j_lastPublishingDate", "Last publication", lookupModuleName, Locale.ENGLISH, siteTemplatesPackageName);
        this.testResourceLegacy("column.modifiedBy.label", "Modified by", lookupModuleName, Locale.ENGLISH, siteTemplatesPackageName);
        this.testResourceLegacy("dummy.column.modifiedBy.label", "notFound", lookupModuleName, Locale.ENGLISH, siteTemplatesPackageName);
        this.testResourceLegacy("jmix_skinnable.j_skin.skins.box2", "Avec cadre, fond de titre clair, fond du corps clair", lookupModuleName, Locale.FRENCH, siteTemplatesPackageName);
    }

    private void testResource(String primaryBundleName, JahiaTemplatesPackage pkg, String searchedKey, Locale locale, String expectedResult) {
        String result = Messages.get((String)primaryBundleName, (JahiaTemplatesPackage)pkg, (String)searchedKey, (Locale)locale, (String)"notFound");
        Assert.assertEquals("looking for \"" + searchedKey + "\" in Jahia Web Templates but found \"" + result + "\" instead of \"" + expectedResult + "\"", expectedResult, result);
    }

    private void testResourceLegacy(String searchedKey, String expectedResult, String modulePackageName, Locale locale, String siteTemplatesPackageName) {
        String notFound = "notFound";
        JahiaResourceBundle moduleResource = new JahiaResourceBundle(locale, modulePackageName, siteTemplatesPackageName);
        String result = moduleResource.get(searchedKey, notFound);
        Assert.assertEquals("looking for \"" + searchedKey + "\" in Jahia Web Templates (" + modulePackageName + ") but found \"" + result + "\" instead of \"" + expectedResult + "\"", expectedResult, result);
    }

    @Test
    public void testUniqueValue() throws Exception {
        ResourceBundle resourceBundle = ResourceBundles.getInternal((Locale)Locale.ENGLISH);
        Assert.assertNotNull(resourceBundle);
        if (resourceBundle != null) {
            boolean duplicatedValue = false;
            HashMap<String, String> valueKeyMap = new HashMap<String, String>();
            Enumeration<String> enume = resourceBundle.getKeys();
            while (enume.hasMoreElements()) {
                String key = enume.nextElement();
                String value = resourceBundle.getString(key);
                boolean valueExist = valueKeyMap.containsKey(value);
                if (valueExist) {
                    logger.error("Duplicated value found in JahiaInternalResources_en.properties: " + key + " = " + value + " and " + (String)valueKeyMap.get(value) + " = " + value);
                } else {
                    valueKeyMap.put(value, key);
                }
                duplicatedValue = duplicatedValue || valueExist;
            }
            Assert.assertFalse(duplicatedValue);
        }
    }
}

