/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.logging;

import java.io.IOException;
import javax.jcr.RepositoryException;
import org.apache.log4j.Level;
import org.jahia.bin.listeners.LoggingConfigListener;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleLoggingTest
extends JahiaTestCase {
    private static final Logger loggerA = LoggerFactory.getLogger((String)(ModuleLoggingTest.class.getName() + ".loggerA"));
    private static final Logger loggerB = LoggerFactory.getLogger((String)(ModuleLoggingTest.class.getName() + ".loggerB"));
    private static final Logger loggerC = LoggerFactory.getLogger((String)(ModuleLoggingTest.class.getName() + ".loggerC"));

    private static void assertLevel(Logger logger, int level) {
        logger.trace("Trace logging of logger {}", (Object)logger.getName());
        logger.debug("Debug logging of logger {}", (Object)logger.getName());
        logger.info("Info logging of logger {}", (Object)logger.getName());
        logger.warn("Warn logging of logger {}", (Object)logger.getName());
        logger.error("Error logging of logger {}", (Object)logger.getName());
        logger.error("Debug enabled for logger {}: {}", (Object)logger.getName(), (Object)logger.isDebugEnabled());
        if (level <= 5000) {
            Assert.assertTrue(logger.isTraceEnabled());
        }
        if (level <= 10000) {
            Assert.assertTrue(logger.isDebugEnabled());
        }
        if (level <= 20000) {
            Assert.assertTrue(logger.isInfoEnabled());
        }
        if (level <= 40000) {
            Assert.assertTrue(logger.isErrorEnabled());
        }
        if (level > 40000) {
            Assert.assertFalse(logger.isErrorEnabled());
        }
        if (level > 30000) {
            Assert.assertFalse(logger.isWarnEnabled());
        }
        if (level > 20000) {
            Assert.assertFalse(logger.isInfoEnabled());
        }
        if (level > 10000) {
            Assert.assertFalse(logger.isDebugEnabled());
        }
        if (level > 5000) {
            Assert.assertFalse(logger.isTraceEnabled());
        }
    }

    @Before
    public void defaultLoggingLevelIsInfo() throws RepositoryException, IOException {
        ModuleLoggingTest.assertLevel(loggerA, 20000);
        ModuleLoggingTest.assertLevel(loggerB, 20000);
        ModuleLoggingTest.assertLevel(loggerC, 20000);
    }

    @Test
    public void loggerLevelIsError() throws RepositoryException, IOException {
        LoggingConfigListener.setLoggerLevel((String)loggerB.getName(), (String)Level.ERROR.toString());
        TestHelper.sleep(2000L);
        try {
            ModuleLoggingTest.assertLevel(loggerA, 20000);
            ModuleLoggingTest.assertLevel(loggerB, 40000);
            ModuleLoggingTest.assertLevel(loggerC, 20000);
        }
        finally {
            LoggingConfigListener.setLoggerLevel((String)loggerB.getName(), (String)Level.INFO.toString());
            TestHelper.sleep(2000L);
        }
    }
}

