/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.logging;

import java.util.Arrays;
import java.util.Comparator;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.hamcrest.Matchers;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.tags.TaggingService;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.util.StopWatch;

public class ServiceLoggingTest {
    private static transient Logger logger = Logger.getLogger(ServiceLoggingTest.class);
    private static final int TAGS_TO_CREATE = 30;
    private static final float ACCEPTABLE_DEVIATION = 10.0f;
    private int counter = 0;
    private TaggingService service;
    private static final String TESTSITE_NAME = "serviceLoggingTest";
    private String tagPrefix;

    private String generateTagName() {
        return this.tagPrefix + this.counter++;
    }

    @Before
    public void setUp() {
        try {
            TestHelper.createSite(TESTSITE_NAME);
            this.tagPrefix = "test-" + System.currentTimeMillis() + "-";
            this.service = (TaggingService)SpringContextSingleton.getBean((String)"org.jahia.services.tags.TaggingService");
        }
        catch (Exception e) {
            logger.error((Object)"Error setting up ServiceLoggingTest environment", (Throwable)e);
            Assert.fail();
        }
    }

    @After
    public void tearDown() {
        try {
            this.deleteAllTags();
        }
        catch (Exception e) {
            logger.error((Object)"Error tearing down ServiceLoggingTest environment", (Throwable)e);
        }
        try {
            TestHelper.deleteSite(TESTSITE_NAME);
        }
        catch (Exception e) {
            logger.error((Object)"Error tearing down ServiceLoggingTest environment", (Throwable)e);
        }
        this.tagPrefix = null;
        this.counter = 0;
        this.service = null;
    }

    private void deleteAllTags() throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRNodeIteratorWrapper nodeIterator = session.getWorkspace().getQueryManager().createQuery("select * from [jnt:tag] where ischildnode([/sites/serviceLoggingTest/tags]) and localname() like '" + ServiceLoggingTest.this.tagPrefix + "%'", "JCR-SQL2").execute().getNodes();
                while (nodeIterator.hasNext()) {
                    Node node = nodeIterator.nextNode();
                    try {
                        session.checkout(node);
                        node.remove();
                    }
                    catch (PathNotFoundException pathNotFoundException) {}
                }
                try {
                    session.getNode("/sites/serviceLoggingTest/tags-content").remove();
                }
                catch (PathNotFoundException pathNotFoundException) {
                    // empty catch block
                }
                session.save();
                return null;
            }
        });
    }

    @Test
    public void testCreateMultipleTags() throws RepositoryException {
        for (int i = 0; i < 3; ++i) {
            this.service.createTag(this.generateTagName(), TESTSITE_NAME);
        }
        Logger metricsLogger = Logger.getLogger((String)"loggingService");
        Logger profilerMetricsLogger = Logger.getLogger((String)"profilerLoggingService");
        profilerMetricsLogger.setLevel(Level.OFF);
        metricsLogger.setLevel(Level.OFF);
        StopWatch stopWatch = new StopWatch();
        System.gc();
        for (int i = 0; i < 30; ++i) {
            stopWatch.start("Create task " + i + " without logs");
            this.service.createTag(this.generateTagName(), TESTSITE_NAME);
            stopWatch.stop();
        }
        long withoutLogs = this.calculateTime(stopWatch.getTaskInfo());
        this.deleteAllTags();
        for (int i = 0; i < 3; ++i) {
            this.service.createTag(this.generateTagName(), TESTSITE_NAME);
        }
        metricsLogger.setLevel(Level.TRACE);
        StopWatch logStopWatch = new StopWatch();
        System.gc();
        for (int i = 0; i < 30; ++i) {
            logStopWatch.start("Create task " + i + " with logs");
            this.service.createTag(this.generateTagName(), TESTSITE_NAME);
            logStopWatch.stop();
        }
        long withLogs = this.calculateTime(logStopWatch.getTaskInfo());
        if (withLogs > withoutLogs) {
            float percentage = (float)Math.abs(logStopWatch.getTotalTimeMillis() - stopWatch.getTotalTimeMillis()) / (float)stopWatch.getTotalTimeMillis() * 100.0f;
            if (percentage >= 10.0f) {
                percentage = (float)Math.abs(withLogs - withoutLogs) / (float)withoutLogs * 100.0f;
            }
            if (percentage >= 10.0f) {
                logger.warn((Object)("Without logging 80% iterations (" + withoutLogs + "ms): " + stopWatch.prettyPrint()));
                logger.warn((Object)("With logging 80% iterations (" + withLogs + "ms): " + logStopWatch.prettyPrint()));
            }
            Assert.assertThat("Logs has more than 10.0% impact on peformance", Float.valueOf(percentage), Matchers.lessThan(Float.valueOf(10.0f)));
        }
    }

    private long calculateTime(StopWatch.TaskInfo[] tasks) {
        Arrays.sort(tasks, new Comparator<StopWatch.TaskInfo>(){

            @Override
            public int compare(StopWatch.TaskInfo o1, StopWatch.TaskInfo o2) {
                return o1.getTimeMillis() < o2.getTimeMillis() ? -1 : (o1.getTimeMillis() == o2.getTimeMillis() ? 0 : 1);
            }
        });
        int i = 0;
        long time = 0L;
        int reducedLoop = 24;
        for (StopWatch.TaskInfo taskInfo : tasks) {
            time += taskInfo.getTimeMillis();
            if (++i == reducedLoop) break;
        }
        return time;
    }
}

