/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.logout;

import java.util.HashSet;
import java.util.Locale;
import javax.jcr.PathNotFoundException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.Jahia;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.seo.urlrewrite.UrlRewriteService;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.jahia.utils.LanguageCodeConverters;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class LogoutTest
extends JahiaTestCase {
    private static final String SITE_KEY = "logoutSite";
    private static UrlRewriteService engine;
    private static JahiaSite defaultSite;
    private static boolean seoRulesEnabled;
    private static boolean seoRemoveCmsPrefix;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        JCRNodeWrapper n;
        engine = (UrlRewriteService)SpringContextSingleton.getBean((String)"UrlRewriteService");
        if (!engine.isSeoRulesEnabled()) {
            engine.setSeoRulesEnabled(true);
            seoRulesEnabled = true;
        }
        if (!engine.isSeoRemoveCmsPrefix()) {
            engine.setSeoRemoveCmsPrefix(true);
            seoRemoveCmsPrefix = true;
        }
        if (seoRulesEnabled || seoRemoveCmsPrefix) {
            engine.afterPropertiesSet();
        }
        JahiaSitesService service = ServicesRegistry.getInstance().getJahiaSitesService();
        defaultSite = service.getDefaultSite();
        JahiaSite site = service.getSiteByKey(SITE_KEY);
        if (site == null) {
            site = TestHelper.createSite(SITE_KEY, "localhost", "templates-web");
            site = (JahiaSite)JCRSessionFactory.getInstance().getCurrentUserSession().getNode(site.getJCRLocalPath());
        }
        HashSet<String> languages = new HashSet<String>();
        languages.add("en");
        site.setLanguages(languages);
        site.setDefaultLanguage("en");
        service.updateSystemSitePermissions(site);
        service.setDefaultSite(site);
        LogoutTest.setSessionSite(site);
        JahiaSite siteForServerName = service.getSiteByServerName(LogoutTest.getRequest().getServerName());
        JCRPublicationService jcrService = ServicesRegistry.getInstance().getJCRPublicationService();
        String defaultLanguage = site.getDefaultLanguage();
        JCRSessionFactory sessionFactory = JCRSessionFactory.getInstance();
        JCRSessionWrapper session = sessionFactory.getCurrentUserSession("default", Locale.ENGLISH, LanguageCodeConverters.languageCodeToLocale((String)defaultLanguage));
        try {
            session.getNode("/sites/logoutSite/home/pubPage");
        }
        catch (PathNotFoundException e) {
            n = session.getNode("/sites/logoutSite/home").addNode("pubPage", "jnt:page");
            n.setProperty("j:templateName", "simple");
            n.setProperty("jcr:title", "title0");
            session.save();
        }
        try {
            session.getNode("/sites/logoutSite/home/privPage");
        }
        catch (PathNotFoundException e) {
            n = session.getNode("/sites/logoutSite/home").addNode("privPage", "jnt:page");
            n.setProperty("j:templateName", "simple");
            n.setProperty("jcr:title", "title1");
            session.save();
        }
        jcrService.publishByMainId(session.getNode("/sites/logoutSite/files").getIdentifier(), "default", "live", languages, false, null);
        jcrService.publishByMainId(session.getNode("/sites/logoutSite/search-results").getIdentifier(), "default", "live", languages, false, null);
        jcrService.publishByMainId(session.getNode("/sites/logoutSite/home").getIdentifier(), "default", "live", languages, false, null);
        jcrService.publishByMainId(session.getNode("/sites/logoutSite/home/pubPage").getIdentifier(), "default", "live", languages, false, null);
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        if (defaultSite != null) {
            ServicesRegistry.getInstance().getJahiaSitesService().setDefaultSite(defaultSite);
            defaultSite = null;
        }
        TestHelper.deleteSite(SITE_KEY);
        JCRSessionFactory.getInstance().closeAllSessions();
        if (seoRulesEnabled || seoRemoveCmsPrefix) {
            engine.setSeoRulesEnabled(!seoRulesEnabled);
            engine.setSeoRemoveCmsPrefix(!seoRemoveCmsPrefix);
            engine.afterPropertiesSet();
            seoRulesEnabled = false;
            seoRemoveCmsPrefix = false;
        }
        engine = null;
    }

    @After
    public void tearDown() {
    }

    @Test
    public void logoutLivePub() throws Exception {
        String returnUrl = this.perform("/en/sites/logoutSite/home/pubPage.html");
        Assert.assertEquals("Logout from live published page failed ", "/sites/logoutSite/home/pubPage.html", returnUrl);
    }

    @Test
    public void logoutEditPub() throws Exception {
        String returnUrl = this.perform("/cms/render/default/en/sites/logoutSite/home/pubPage.html");
        Assert.assertEquals("Logout from default published page failed ", "/sites/logoutSite/home/pubPage.html", returnUrl);
    }

    @Test
    public void logoutEditPrivate() throws Exception {
        String returnUrl = this.perform("/cms/render/default/en/sites/logoutSite/home/privPage.html");
        Assert.assertEquals("Logout from default unPublished page failed ", "/sites/logoutSite/home.html", returnUrl);
    }

    @Test
    public void logoutUserDashboard() throws Exception {
        String returnUrl = this.perform("/en/users/root.user-home.html");
        Assert.assertEquals("Logout from user dashboard page failed ", "/sites/logoutSite/home.html", returnUrl);
    }

    @Test
    public void logoutAdministration() throws Exception {
        String returnUrl = this.perform("/administration");
        Assert.assertEquals("Logout from administration failed ", "/cms/admin/en/settings.aboutJahia.html", returnUrl);
    }

    @Test
    public void logoutFilesLive() throws Exception {
        String returnUrl = this.perform("/sites/logoutSite/files");
        Assert.assertEquals("Logout from live files failed ", "/sites/logoutSite/files.html", returnUrl);
    }

    @Test
    public void logoutFilesEdit() throws Exception {
        String returnUrl = this.perform("/cms/render/default/en/sites/logoutSite/files.html");
        Assert.assertEquals("Logout from default files failed ", "/sites/logoutSite/files.html", returnUrl);
    }

    protected String perform(String url) throws Exception {
        this.loginRoot();
        return this.logout(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String logout(String url) throws Exception {
        String returnUrl = null;
        String baseurl = this.getBaseServerURL() + Jahia.getContextPath();
        GetMethod method = new GetMethod(baseurl + "/cms/logout");
        try {
            method.setRequestHeader("Referer", baseurl + url);
            this.getHttpClient().executeMethod((HttpMethod)method);
            returnUrl = StringUtils.isEmpty((String)Jahia.getContextPath()) || !method.getPath().startsWith(Jahia.getContextPath()) ? method.getPath() : StringUtils.substringAfter((String)method.getPath(), (String)Jahia.getContextPath());
        }
        finally {
            method.releaseConnection();
        }
        return returnUrl;
    }

    static {
        defaultSite = null;
        seoRulesEnabled = false;
        seoRemoveCmsPrefix = false;
    }
}

