/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.providers;

import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ModulesProviderTest {
    private Node root;
    private JahiaTemplatesPackage dummyPackage;
    private JahiaTemplateManagerService templateManagerService;

    @Before
    public void setUp() throws Exception {
        JCRSessionFactory.getInstance().closeAllSessions();
        JCRSessionWrapper s = JCRSessionFactory.getInstance().getCurrentUserSession();
        this.templateManagerService = ServicesRegistry.getInstance().getJahiaTemplateManagerService();
        JCRNodeWrapper dummy1 = this.templateManagerService.checkoutModule(null, "scm:svn:https://devtools.jahia.com/svn/jahia/trunk/test/dummy-modules/dummy1/", null, "dummy1", null, s);
        this.root = dummy1.getNode("sources/src/main/resources");
    }

    @After
    public void tearDown() throws Exception {
        JahiaTemplatesPackage pack = this.templateManagerService.getTemplatePackageById("dummy1");
        if (pack != null) {
            this.templateManagerService.undeployModule(pack);
        }
    }

    @Test
    public void readTypes() throws Exception {
        this.readType("jnt:cssFolder", "css");
        this.readType("jnt:cssFile", "css/dummy.css");
        this.readType("jnt:nodeTypeFolder", "jnt_testComponent1");
        this.readType("jnt:templateTypeFolder", "jnt_testComponent1/html");
        this.readType("jnt:viewFile", "jnt_testComponent1/html/testComponent1.jsp");
        this.readType("jnt:resourceBundleFolder", "resources");
        this.readType("jnt:definitionFile", "META-INF/definitions.cnd");
    }

    private void readType(String nodeType, String path) throws RepositoryException {
        String resolvedNodeType = this.root.getNode(path).getPrimaryNodeType().getName();
        Assert.assertEquals(nodeType + " is expected on path " + path + " but " + resolvedNodeType + " has been found", resolvedNodeType, nodeType);
    }

    @Test
    public void writeAndReadProperties() throws Exception {
        JCRSessionWrapper s = JCRSessionFactory.getInstance().getCurrentUserSession();
        Node viewNode = this.root.getNode("jnt_testComponent1/html/testComponent1.jsp");
        String sourceCode = viewNode.getProperty("sourceCode").getString();
        Assert.assertTrue("testComponent1 source not match", sourceCode.equals("--------------\ntest component\n--------------\n"));
        String testString = System.currentTimeMillis() + "\n";
        viewNode.setProperty("sourceCode", sourceCode + testString);
        viewNode.setProperty("cache.perUser", true);
        viewNode.setProperty("cache.requestParameters", "dummyParam");
        s.save();
        s.logout();
        s = JCRSessionFactory.getInstance().getCurrentUserSession();
        this.dummyPackage = this.templateManagerService.getTemplatePackageById("dummy1");
        this.root = s.getNode("/modules/" + this.dummyPackage.getIdWithVersion() + "/sources/src/main/resources");
        viewNode = this.root.getNode("jnt_testComponent1/html/testComponent1.jsp");
        Assert.assertTrue("testComponent1 source not match", viewNode.getProperty("sourceCode").getString().endsWith(testString));
        Assert.assertTrue("cache.perUser not set to true", viewNode.getProperty("cache.perUser").getBoolean());
        Assert.assertTrue("cache.requestParameters not set to dummyParam", viewNode.getProperty("cache.requestParameters").getString().equals("dummyParam"));
        viewNode.setProperty("sourceCode", sourceCode);
        s.save();
    }

    @Test
    public void readNodeTypeDefinition() throws Exception {
        Node nodeType = this.root.getNode("META-INF/definitions.cnd/jnt:testComponent2");
        Assert.assertEquals("jnt:primaryNodeType", nodeType.getPrimaryNodeType().getName());
        Assert.assertEquals("jnt:content", nodeType.getProperty("j:supertype").getString());
        HashSet<String> testValues = new HashSet<String>();
        for (Value value : nodeType.getProperty("j:mixins").getValues()) {
            testValues.add(value.getString());
        }
        Assert.assertTrue(Sets.newHashSet((Object[])new String[]{"jmix:editorialContent", "mix:title", "jmix:tagged", "jmix:structuredContent"}).equals(testValues));
        Assert.assertTrue(nodeType.getProperty("j:hasOrderableChildNodes").getBoolean());
        Assert.assertTrue(nodeType.getProperty("j:isQueryable").getBoolean());
        Assert.assertFalse(nodeType.getProperty("j:isAbstract").getBoolean());
        Node propertyDefinition = nodeType.getNode("property1");
        Assert.assertEquals("jnt:propertyDefinition", propertyDefinition.getPrimaryNodeType().getName());
        Assert.assertEquals("String", propertyDefinition.getProperty("j:requiredType").getString());
        Assert.assertEquals("RichText", propertyDefinition.getProperty("j:selectorType").getString());
        Assert.assertTrue(propertyDefinition.getProperty("j:isInternationalized").getBoolean());
        Assert.assertTrue(propertyDefinition.getProperty("j:mandatory").getBoolean());
        Assert.assertFalse(propertyDefinition.getProperty("j:isFullTextSearchable").getBoolean());
        propertyDefinition = nodeType.getNode("property2");
        Assert.assertEquals("WeakReference", propertyDefinition.getProperty("j:requiredType").getString());
        Assert.assertEquals("Picker", propertyDefinition.getProperty("j:selectorType").getString());
        Assert.assertEquals("type='image'", propertyDefinition.getProperty("j:selectorOptions").getValues()[0].getString());
        Assert.assertTrue(propertyDefinition.getProperty("j:protected").getBoolean());
        propertyDefinition = nodeType.getNode("property3");
        Assert.assertEquals("String", propertyDefinition.getProperty("j:requiredType").getString());
        Assert.assertEquals("Choicelist", propertyDefinition.getProperty("j:selectorType").getString());
        Assert.assertEquals("resourceBundle", propertyDefinition.getProperty("j:selectorOptions").getValues()[0].getString());
        Assert.assertTrue(propertyDefinition.getProperty("j:multiple").getBoolean());
        Assert.assertEquals("no", propertyDefinition.getProperty("j:index").getString());
        testValues = new HashSet();
        for (Value value : propertyDefinition.getProperty("j:defaultValues").getValues()) {
            testValues.add(value.getString());
        }
        Assert.assertTrue(Sets.newHashSet((Object[])new String[]{"one", "three"}).equals(testValues));
        testValues = new HashSet();
        for (Value value : propertyDefinition.getProperty("j:valueConstraints").getValues()) {
            testValues.add(value.getString());
        }
        Assert.assertTrue(Sets.newHashSet((Object[])new String[]{"one", "two", "three"}).equals(testValues));
        propertyDefinition = nodeType.getNode("property4");
        Assert.assertEquals("Long", propertyDefinition.getProperty("j:requiredType").getString());
        Assert.assertEquals("2", propertyDefinition.getProperty("j:defaultValues").getValues()[0].getString());
        Assert.assertTrue(propertyDefinition.getProperty("j:autoCreated").getBoolean());
        Assert.assertTrue(propertyDefinition.getProperty("j:isHidden").getBoolean());
        Assert.assertTrue(propertyDefinition.getProperty("j:isFullTextSearchable").getBoolean());
        Assert.assertEquals("tokenized", propertyDefinition.getProperty("j:index").getString());
        Assert.assertEquals("VERSION", propertyDefinition.getProperty("j:onParentVersion").getString());
        Assert.assertEquals("latest", propertyDefinition.getProperty("j:onConflictAction").getString());
        Assert.assertEquals(1.0, propertyDefinition.getProperty("j:scoreboost").getDouble(), 0.0);
        Assert.assertTrue(propertyDefinition.getProperty("j:isQueryOrderable").getBoolean());
        Assert.assertEquals("=", propertyDefinition.getProperty("j:availableQueryOperators").getValues()[0].getString());
        propertyDefinition = nodeType.getNode("property5");
        Assert.assertFalse(propertyDefinition.getProperty("j:autoCreated").getBoolean());
        Assert.assertFalse(propertyDefinition.getProperty("j:isHidden").getBoolean());
        Assert.assertTrue(propertyDefinition.getProperty("j:isFacetable").getBoolean());
        Assert.assertTrue(propertyDefinition.getProperty("j:isHierarchical").getBoolean());
        Assert.assertEquals("COPY", propertyDefinition.getProperty("j:onParentVersion").getString());
        Assert.assertEquals("oldest", propertyDefinition.getProperty("j:onConflictAction").getString());
        Assert.assertEquals(2.0, propertyDefinition.getProperty("j:scoreboost").getDouble(), 0.0);
        Assert.assertFalse(propertyDefinition.getProperty("j:isQueryOrderable").getBoolean());
        testValues = new HashSet();
        for (Value value : propertyDefinition.getProperty("j:availableQueryOperators").getValues()) {
            testValues.add(value.getString());
        }
        Assert.assertTrue(Sets.newHashSet((Object[])new String[]{"=", "<>", "<", "<=", ">", ">=", "LIKE"}).equals(testValues));
        Assert.assertEquals("keyword", propertyDefinition.getProperty("j:analyzer").getString());
        Node childNodeDefinition = nodeType.getNode("child1");
        Assert.assertEquals("jnt:childNodeDefinition", childNodeDefinition.getPrimaryNodeType().getName());
        Assert.assertEquals("jnt:testComponent1", childNodeDefinition.getProperty("j:requiredPrimaryTypes").getValues()[0].getString());
        Assert.assertEquals("jnt:testComponent1", childNodeDefinition.getProperty("j:defaultPrimaryType").getString());
        Assert.assertTrue(childNodeDefinition.getProperty("j:autoCreated").getBoolean());
        Assert.assertFalse(childNodeDefinition.getProperty("j:mandatory").getBoolean());
        Assert.assertFalse(childNodeDefinition.getProperty("j:protected").getBoolean());
        Assert.assertEquals("VERSION", childNodeDefinition.getProperty("j:onParentVersion").getString());
        childNodeDefinition = nodeType.getNode("child2");
        Assert.assertFalse(childNodeDefinition.getProperty("j:autoCreated").getBoolean());
        Assert.assertTrue(childNodeDefinition.getProperty("j:mandatory").getBoolean());
        Assert.assertTrue(childNodeDefinition.getProperty("j:protected").getBoolean());
        Assert.assertEquals("COPY", childNodeDefinition.getProperty("j:onParentVersion").getString());
        childNodeDefinition = nodeType.getNode("__node__jnt@@testComponent2");
        Assert.assertEquals("jnt:unstructuredChildNodeDefinition", childNodeDefinition.getPrimaryNodeType().getName());
        Assert.assertEquals("jnt:testComponent2", childNodeDefinition.getProperty("j:requiredPrimaryTypes").getValues()[0].getString());
        nodeType = this.root.getNode("META-INF/definitions.cnd/jnt:testComponent3");
        Assert.assertEquals("jnt:primaryNodeType", nodeType.getPrimaryNodeType().getName());
        Assert.assertEquals("jnt:content", nodeType.getProperty("j:supertype").getString());
        Assert.assertEquals("mix:title", nodeType.getProperty("j:mixins").getValues()[0].getString());
        Assert.assertFalse(nodeType.getProperty("j:hasOrderableChildNodes").getBoolean());
        Assert.assertFalse(nodeType.getProperty("j:isQueryable").getBoolean());
        Assert.assertTrue(nodeType.getProperty("j:isAbstract").getBoolean());
        Assert.assertEquals("metadata", nodeType.getProperty("j:itemsType").getString());
        nodeType = this.root.getNode("META-INF/definitions.cnd/jmix:testMixin1");
        Assert.assertEquals("jnt:mixinNodeType", nodeType.getPrimaryNodeType().getName());
        Assert.assertEquals("jmix:templateMixin", nodeType.getProperty("j:mixins").getValues()[0].getString());
        testValues = new HashSet();
        for (Value value : nodeType.getProperty("j:mixinExtends").getValues()) {
            testValues.add(value.getString());
        }
        Assert.assertTrue(Sets.newHashSet((Object[])new String[]{"jmix:list", "jnt:area"}).equals(testValues));
        Assert.assertEquals("layout", nodeType.getProperty("j:itemsType").getString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void writeNodeTypeDefinition() throws Exception {
        int n;
        String line;
        JCRSessionWrapper s = JCRSessionFactory.getInstance().getCurrentUserSession();
        String definitionsPath = "META-INF/definitions.cnd";
        Node definitions = this.root.getNode(definitionsPath);
        Node nodeType = definitions.addNode("jnt:testComponent4", "jnt:primaryNodeType");
        nodeType.setProperty("j:supertype", "jnt:content");
        String[] values = new String[]{"jmix:tagged", "jmix:structuredContent"};
        nodeType.setProperty("j:mixins", values);
        nodeType.setProperty("j:hasOrderableChildNodes", true);
        nodeType.setProperty("j:isAbstract", false);
        nodeType.setProperty("j:isQueryable", false);
        Node propertyDefinition = nodeType.addNode("property1", "jnt:propertyDefinition");
        propertyDefinition.setProperty("j:requiredType", "String");
        propertyDefinition.setProperty("j:mandatory", true);
        propertyDefinition = nodeType.addNode("property2", "jnt:propertyDefinition");
        propertyDefinition.setProperty("j:requiredType", "Long");
        propertyDefinition.setProperty("j:protected", true);
        s.save();
        s.logout();
        s = JCRSessionFactory.getInstance().getCurrentUserSession();
        this.dummyPackage = this.templateManagerService.getTemplatePackageById("dummy1");
        String cndPath = this.dummyPackage.getSourcesFolder().getAbsolutePath() + "/src/main/resources/META-INF/definitions.cnd";
        try (BufferedReader input = new BufferedReader(new FileReader(cndPath));){
            String line2 = null;
            int n2 = 1;
            while ((line2 = input.readLine()) != null) {
                if (n2 == 31) {
                    Assert.assertEquals("[jnt:testComponent4] > jnt:content, jmix:tagged, jmix:structuredContent orderable noquery", line2);
                } else if (n2 == 32) {
                    Assert.assertEquals(" - property1 (string) mandatory", line2);
                } else if (n2 == 33) {
                    Assert.assertEquals(" - property2 (long) protected", line2);
                }
                ++n2;
            }
        }
        this.root = s.getNode("/modules/" + this.dummyPackage.getIdWithVersion() + "/sources/src/main/resources");
        nodeType = this.root.getNode("META-INF/definitions.cnd/jnt:testComponent4");
        Assert.assertEquals("jnt:primaryNodeType", nodeType.getPrimaryNodeType().getName());
        Assert.assertEquals("jnt:content", nodeType.getProperty("j:supertype").getString());
        HashSet<String> testValues = new HashSet<String>();
        for (Value value : nodeType.getProperty("j:mixins").getValues()) {
            testValues.add(value.getString());
        }
        Assert.assertTrue(Sets.newHashSet((Object[])new String[]{"jmix:tagged", "jmix:structuredContent"}).equals(testValues));
        Assert.assertTrue(nodeType.getProperty("j:hasOrderableChildNodes").getBoolean());
        Assert.assertFalse(nodeType.getProperty("j:isAbstract").getBoolean());
        Assert.assertFalse(nodeType.getProperty("j:isQueryable").getBoolean());
        propertyDefinition = nodeType.getNode("property1");
        Assert.assertEquals("jnt:propertyDefinition", propertyDefinition.getPrimaryNodeType().getName());
        Assert.assertEquals("String", propertyDefinition.getProperty("j:requiredType").getString());
        Assert.assertTrue(propertyDefinition.getProperty("j:mandatory").getBoolean());
        propertyDefinition = nodeType.getNode("property2");
        Assert.assertEquals("Long", propertyDefinition.getProperty("j:requiredType").getString());
        Assert.assertTrue(propertyDefinition.getProperty("j:protected").getBoolean());
        nodeType.orderBefore("property2", "property1");
        s.save();
        s.logout();
        input = new BufferedReader(new FileReader(cndPath));
        try {
            line = null;
            n = 1;
            while ((line = input.readLine()) != null) {
                if (n == 32) {
                    Assert.assertEquals(" - property2 (long) protected", line);
                } else if (n == 33) {
                    Assert.assertEquals(" - property1 (string) mandatory", line);
                }
                ++n;
            }
        }
        finally {
            input.close();
        }
        s = JCRSessionFactory.getInstance().getCurrentUserSession();
        s.move("/modules/" + this.dummyPackage.getIdWithVersion() + "/sources/src/main/resources/META-INF/definitions.cnd/jnt:testComponent4", "/modules/" + this.dummyPackage.getIdWithVersion() + "/sources/src/main/resources/META-INF/definitions.cnd/jnt:testRenamedComponent");
        s.save();
        input = new BufferedReader(new FileReader(cndPath));
        try {
            line = null;
            n = 1;
            while ((line = input.readLine()) != null) {
                if (n == 31) {
                    Assert.assertEquals("[jnt:testRenamedComponent] > jnt:content, jmix:tagged, jmix:structuredContent orderable noquery", line);
                }
                ++n;
            }
        }
        finally {
            input.close();
        }
        this.root = s.getNode("/modules/" + this.dummyPackage.getIdWithVersion() + "/sources/src/main/resources");
        Assert.assertTrue(this.root.hasNode("META-INF/definitions.cnd/jnt:testRenamedComponent"));
        s.save();
        s.logout();
        s = JCRSessionFactory.getInstance().getCurrentUserSession();
        this.root = s.getNode("/modules/" + this.dummyPackage.getIdWithVersion() + "/sources/src/main/resources/META-INF/definitions.cnd/jnt:testRenamedComponent");
        this.root.orderBefore("property2", "property1");
        s.save();
        s.logout();
        input = new BufferedReader(new FileReader(cndPath));
        try {
            line = null;
            n = 1;
            while ((line = input.readLine()) != null) {
                if (n == 32) {
                    Assert.assertEquals(" - property2 (long) protected", line);
                } else if (n == 33) {
                    Assert.assertEquals(" - property1 (string) mandatory", line);
                }
                ++n;
            }
        }
        finally {
            input.close();
        }
        s = JCRSessionFactory.getInstance().getCurrentUserSession();
        this.root = s.getNode("/modules/" + this.dummyPackage.getIdWithVersion() + "/sources/src/main/resources");
        nodeType = this.root.getNode("META-INF/definitions.cnd/jnt:testRenamedComponent");
        nodeType.remove();
        s.save();
        s.logout();
        s = JCRSessionFactory.getInstance().getCurrentUserSession();
        this.dummyPackage = this.templateManagerService.getTemplatePackageById("dummy1");
        this.root = s.getNode("/modules/" + this.dummyPackage.getIdWithVersion() + "/sources/src/main/resources");
        Assert.assertFalse(this.root.hasNode("META-INF/definitions.cnd/jnt:testRenamedComponent"));
    }
}

