/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.publication;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.PublicationInfo;
import org.jahia.services.content.PublicationInfoNode;
import org.jahia.services.sites.JahiaSite;
import org.jahia.test.TestHelper;
import org.jahia.utils.LanguageCodeConverters;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicationTest {
    private static final Logger logger = LoggerFactory.getLogger(PublicationTest.class);
    private static JahiaSite site;
    private static JCRPublicationService jcrService;
    private static final String TESTSITE_NAME = "jcrPublicationTest";
    private static final String SITECONTENT_ROOT_NODE = "/sites/jcrPublicationTest";
    private static final String INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE = "English text";
    private JCRSessionWrapper englishEditSession;
    private JCRSessionWrapper englishLiveSession;
    private JCRNodeWrapper testHomeEdit;

    @BeforeClass
    public static void setUpClass() {
        try {
            site = TestHelper.createSite(TESTSITE_NAME, new HashSet<String>(Arrays.asList("en", "fr")), Collections.singleton("en"), false);
            Assert.assertNotNull(site);
            jcrService = ServicesRegistry.getInstance().getJCRPublicationService();
        }
        catch (Exception ex) {
            logger.warn("Exception during test setUp", (Throwable)ex);
            Assert.fail();
        }
    }

    @AfterClass
    public static void tearDownClass() {
        try {
            TestHelper.deleteSite(TESTSITE_NAME);
        }
        catch (Exception ex) {
            logger.warn("Exception during test tearDown", (Throwable)ex);
        }
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @Before
    public void setUp() {
        try {
            this.getCleanSession();
            JCRNodeWrapper englishEditSiteHomeNode = this.englishEditSession.getNode("/sites/jcrPublicationTest/home");
            this.testHomeEdit = englishEditSiteHomeNode.addNode("test" + System.currentTimeMillis(), "jnt:page");
            this.testHomeEdit.setProperty("jcr:title", "Test page");
            this.testHomeEdit.setProperty("j:templateName", "simple");
            this.englishEditSession.save();
            jcrService.publishByMainId(this.testHomeEdit.getIdentifier());
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            Assert.fail("Cannot setUp test: " + e.getMessage());
        }
    }

    @After
    public void tearDown() {
        try {
            this.getCleanSession();
            this.englishEditSession.getNodeByIdentifier(this.testHomeEdit.getIdentifier()).remove();
            this.englishEditSession.save();
            this.englishLiveSession.getNodeByIdentifier(this.testHomeEdit.getIdentifier()).remove();
            this.englishLiveSession.save();
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            Assert.fail("Cannot remove nodes: " + e.getMessage());
        }
    }

    @Test
    public void testNodePublish() throws RepositoryException {
        TestHelper.createList(this.testHomeEdit, "contentList1", 4, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
        this.englishEditSession.save();
        jcrService.publishByMainId(this.testHomeEdit.getIdentifier(), "default", "live", null, false, null);
        this.testPropertyInWorkspace(this.englishLiveSession, this.testHomeEdit.getPath() + "/contentList1/contentList1_text1", "body", "English text1", "Property value for text node 1 was not found or invalid in english live workspace");
        JCRNodeWrapper liveContentList1Node = this.englishLiveSession.getNode(this.testHomeEdit.getPath() + "/contentList1");
        this.testChildOrdering(liveContentList1Node, "live", "contentList1_text0", "contentList1_text1", "contentList1_text2");
    }

    @Test
    public void testNodeUpdate() throws RepositoryException {
        TestHelper.createList(this.testHomeEdit, "contentList1", 4, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
        this.englishEditSession.save();
        jcrService.publishByMainId(this.testHomeEdit.getIdentifier(), "default", "live", null, false, null);
        JCRNodeWrapper editTextNode1 = this.englishEditSession.getNode(this.testHomeEdit.getPath() + "/contentList1/contentList1_text1");
        editTextNode1.setProperty("body", "English text update 1");
        this.englishEditSession.save();
        jcrService.publishByMainId(this.testHomeEdit.getIdentifier(), "default", "live", null, false, null);
        this.testPropertyInWorkspace(this.englishLiveSession, this.testHomeEdit.getPath() + "/contentList1/contentList1_text1", "body", "English text update 1", "Property value for text node 1 was not found or invalid in english live workspace");
    }

    @Test
    public void testNodeUnpublish() throws RepositoryException {
        TestHelper.createList(this.testHomeEdit, "contentList1", 4, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
        this.englishEditSession.save();
        jcrService.publishByMainId(this.testHomeEdit.getIdentifier(), "default", "live", null, false, null);
        JCRNodeWrapper editTextNode1 = this.englishEditSession.getNode(this.testHomeEdit.getPath() + "/contentList1/contentList1_text1");
        jcrService.unpublish((List)Lists.newArrayList((Object[])new String[]{editTextNode1.getIdentifier()}));
        String testHomeEditPath = this.testHomeEdit.getPath();
        JCRSessionFactory.getInstance().closeAllSessions();
        this.englishEditSession = jcrService.getSessionFactory().getCurrentUserSession("default", Locale.ENGLISH);
        this.englishLiveSession = jcrService.getSessionFactory().getCurrentUserSession("live", Locale.ENGLISH);
        this.testHomeEdit = this.englishEditSession.getNode(testHomeEditPath);
        this.testNodeNotInWorkspace(this.englishLiveSession, this.testHomeEdit.getPath() + "/contentList1/contentList1_text1", "Text node 1 was unpublished, should not be available in the live workspace anymore !");
        jcrService.publishByMainId(editTextNode1.getIdentifier(), "default", "live", null, false, null);
        this.testNodeInWorkspace(this.englishLiveSession, this.testHomeEdit.getPath() + "/contentList1/contentList1_text1", "Text node 1 was re-published, it should have been present in the live workspace");
    }

    @Test
    public void testNodeRename() throws RepositoryException {
        TestHelper.createList(this.testHomeEdit, "contentList1", 4, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
        this.englishEditSession.save();
        jcrService.publishByMainId(this.testHomeEdit.getIdentifier(), "default", "live", null, false, null);
        JCRNodeWrapper editTextNode1 = this.englishEditSession.getNode(this.testHomeEdit.getPath() + "/contentList1/contentList1_text1");
        editTextNode1.rename("contentList1_text1_renamed");
        this.englishEditSession.save();
        this.getCleanSession();
        jcrService.publishByMainId(this.testHomeEdit.getIdentifier(), "default", "live", null, false, null);
        this.testNodeInWorkspace(this.englishLiveSession, this.testHomeEdit.getPath() + "/contentList1/contentList1_text1_renamed", "Text node 1 was renamed, should have been available under the new name in the live workspace !");
        this.testNodeNotInWorkspace(this.englishLiveSession, this.testHomeEdit.getPath() + "/contentList1/contentList1_text1", "Text node 1 was renamed, should not have been available under the old name in the live workspace !");
        JCRNodeWrapper liveContentList1 = this.englishLiveSession.getNode(this.testHomeEdit.getPath() + "/contentList1");
        this.testChildOrdering(liveContentList1, "live", "contentList1_text0", "contentList1_text1_renamed", "contentList1_text2");
        editTextNode1 = this.englishEditSession.getNode(this.testHomeEdit.getPath() + "/contentList1/contentList1_text1_renamed");
        editTextNode1.rename("contentList1_text1");
        this.englishEditSession.save();
        this.getCleanSession();
        jcrService.publishByMainId(this.testHomeEdit.getIdentifier(), "default", "live", null, false, null);
        this.testNodeInWorkspace(this.englishLiveSession, this.testHomeEdit.getPath() + "/contentList1/contentList1_text1", "Text node 1 was renamed, should have been available under the new name in the live workspace !");
        this.testNodeNotInWorkspace(this.englishLiveSession, this.testHomeEdit.getPath() + "/contentList1/contentList1_text1_renamed", "Text node 1 was renamed, should not have been available under the old name in the live workspace !");
        liveContentList1 = this.englishLiveSession.getNode(this.testHomeEdit.getPath() + "/contentList1");
        this.testChildOrdering(liveContentList1, "live", "contentList1_text0", "contentList1_text1", "contentList1_text2");
    }

    @Test
    public void testNodeReorder() throws RepositoryException {
        TestHelper.createList(this.testHomeEdit, "contentList1", 4, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
        this.englishEditSession.save();
        jcrService.publishByMainId(this.testHomeEdit.getIdentifier(), "default", "live", null, false, null);
        JCRNodeWrapper editContentList1 = this.englishEditSession.getNode(this.testHomeEdit.getPath() + "/contentList1");
        editContentList1.orderBefore("contentList1_text1", "contentList1_text0");
        this.englishEditSession.save();
        this.testChildOrdering(editContentList1, "default", "contentList1_text1", "contentList1_text0", "contentList1_text2");
        jcrService.publishByMainId(editContentList1.getIdentifier(), "default", "live", null, false, null);
        JCRNodeWrapper liveContentList1Node = this.englishLiveSession.getNode(this.testHomeEdit.getPath() + "/contentList1");
        this.testChildOrdering(liveContentList1Node, "live", "contentList1_text1", "contentList1_text0", "contentList1_text2");
    }

    @Test
    public void testNodeMove() throws RepositoryException {
        TestHelper.createList(this.testHomeEdit, "contentList1", 4, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
        TestHelper.createList(this.testHomeEdit, "contentList2", 4, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
        this.englishEditSession.save();
        jcrService.publishByMainId(this.testHomeEdit.getIdentifier(), "default", "live", null, false, null);
        JCRNodeWrapper editContentList1 = this.englishEditSession.getNode(this.testHomeEdit.getPath() + "/contentList1");
        JCRNodeWrapper editContentList2 = this.englishEditSession.getNode(this.testHomeEdit.getPath() + "/contentList2");
        JCRNodeWrapper editTextNode1 = editContentList1.getNode("contentList1_text1");
        this.englishEditSession.move(editTextNode1.getPath(), this.testHomeEdit.getPath() + "/contentList2/contentList1_text1");
        editContentList2.orderBefore("contentList1_text1", "contentList2_text0");
        this.englishEditSession.save();
        this.getCleanSession();
        jcrService.publishByMainId(editContentList2.getIdentifier(), "default", "live", null, true, null);
        this.getCleanSession();
        JCRNodeWrapper liveContentList1Node = this.englishLiveSession.getNode(this.testHomeEdit.getPath() + "/contentList1");
        JCRNodeWrapper liveContentList2Node = this.englishLiveSession.getNode(this.testHomeEdit.getPath() + "/contentList2");
        this.testChildOrdering(liveContentList1Node, "live", "contentList1_text0", "contentList1_text2", "contentList1_text3");
        this.testChildOrdering(liveContentList2Node, "live", "contentList1_text1", "contentList2_text0", "contentList2_text1");
    }

    @Test
    public void testNodeMoveAndUpdate() throws RepositoryException {
        TestHelper.createList(this.testHomeEdit, "contentList1", 4, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
        TestHelper.createList(this.testHomeEdit, "contentList2", 4, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
        this.englishEditSession.save();
        jcrService.publishByMainId(this.testHomeEdit.getIdentifier(), "default", "live", null, false, null);
        this.englishEditSession.getNode(this.testHomeEdit.getPath() + "/contentList1");
        JCRNodeWrapper editContentList2 = this.englishEditSession.getNode(this.testHomeEdit.getPath() + "/contentList2");
        this.englishEditSession.move(this.testHomeEdit.getPath() + "/contentList1/contentList1_text1", this.testHomeEdit.getPath() + "/contentList2/contentList1_text1");
        this.englishEditSession.save();
        JCRNodeWrapper editTextNode1 = this.englishEditSession.getNode(this.testHomeEdit.getPath() + "/contentList2/contentList1_text1");
        editTextNode1.setProperty("body", "English text update 2");
        this.englishEditSession.save();
        editContentList2.orderBefore("contentList1_text1", "contentList2_text0");
        this.englishEditSession.save();
        this.getCleanSession();
        jcrService.publishByMainId(editContentList2.getIdentifier(), "default", "live", null, true, null);
        JCRNodeWrapper liveContentList1Node = this.englishLiveSession.getNode(this.testHomeEdit.getPath() + "/contentList1");
        JCRNodeWrapper liveContentList2Node = this.englishLiveSession.getNode(this.testHomeEdit.getPath() + "/contentList2");
        this.testChildOrdering(liveContentList1Node, "live", "contentList1_text0", "contentList1_text2", "contentList1_text3");
        this.testChildOrdering(liveContentList2Node, "live", "contentList1_text1", "contentList2_text0", "contentList2_text1", "contentList2_text2", "contentList2_text3");
    }

    @Test
    public void testNodeMoveTwice() throws RepositoryException {
        TestHelper.createList(this.testHomeEdit, "contentList3", 4, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
        TestHelper.createList(this.testHomeEdit, "contentList4", 4, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
        this.englishEditSession.save();
        jcrService.publishByMainId(this.testHomeEdit.getIdentifier(), "default", "live", null, false, null);
        this.englishEditSession.getNode(this.testHomeEdit.getPath() + "/contentList3");
        JCRNodeWrapper editContentList4 = this.englishEditSession.getNode(this.testHomeEdit.getPath() + "/contentList4");
        this.englishEditSession.move(this.testHomeEdit.getPath() + "/contentList3/contentList3_text1", this.testHomeEdit.getPath() + "/contentList4/contentList3_text1");
        editContentList4.orderBefore("contentList3_text1", "contentList4_text1");
        editContentList4.orderBefore("contentList3_text1", "contentList4_text0");
        this.englishEditSession.save();
        this.englishEditSession.getNode(this.testHomeEdit.getPath() + "/contentList4/contentList3_text1");
        this.getCleanSession();
        jcrService.publishByMainId(editContentList4.getIdentifier(), "default", "live", null, true, null);
        JCRNodeWrapper liveContentList3Node = this.englishLiveSession.getNode(this.testHomeEdit.getPath() + "/contentList3");
        JCRNodeWrapper liveContentList4Node = this.englishLiveSession.getNode(this.testHomeEdit.getPath() + "/contentList4");
        this.testChildOrdering(liveContentList3Node, "live", "contentList3_text0", "contentList3_text2", "contentList3_text3");
        this.testChildOrdering(liveContentList4Node, "live", "contentList3_text1", "contentList4_text0", "contentList4_text1", "contentList4_text2", "contentList4_text3");
    }

    @Test
    public void testNodeDelete() throws RepositoryException {
        TestHelper.createList(this.testHomeEdit, "contentList1", 4, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
        this.englishEditSession.save();
        JCRNodeWrapper editContentList1 = this.englishEditSession.getNode(this.testHomeEdit.getPath() + "/contentList1");
        JCRNodeWrapper editTextNode1 = this.englishEditSession.getNode(this.testHomeEdit.getPath() + "/contentList1/contentList1_text1");
        editTextNode1.remove();
        this.englishEditSession.save();
        jcrService.publishByMainId(editContentList1.getIdentifier(), "default", "live", null, true, null);
        this.testNodeNotInWorkspace(this.englishLiveSession, this.testHomeEdit.getPath() + "/contentList1/contentList1_text1", "Text node 1 was deleted, should not be available in the live workspace anymore !");
    }

    @Test
    public void testNodeMarkForDelete() throws RepositoryException {
        TestHelper.createList(this.testHomeEdit, "contentList1", 4, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
        this.englishEditSession.save();
        JCRNodeWrapper editContentList4 = this.englishEditSession.getNode(this.testHomeEdit.getPath() + "/contentList1");
        JCRNodeWrapper editTextNode1 = this.englishEditSession.getNode(this.testHomeEdit.getPath() + "/contentList1/contentList1_text1");
        editTextNode1.markForDeletion("Deleted by unit test");
        this.englishEditSession.save();
        this.getCleanSession();
        jcrService.publishByMainId(editContentList4.getIdentifier(), "default", "live", null, true, null);
        this.testNodeNotInWorkspace(this.englishLiveSession, this.testHomeEdit.getPath() + "/contentList1/contentList1_text1", "Text node 1 was deleted, should not be available in the live workspace anymore !");
    }

    @Test
    public void testNodeAddAndReorder() throws Exception {
        TestHelper.createList(this.testHomeEdit, "contentList1", 4, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
        this.englishEditSession.save();
        JCRNodeWrapper editContentList1 = this.englishEditSession.getNode(this.testHomeEdit.getPath() + "/contentList1");
        editContentList1.orderBefore("contentList1_text2", "contentList1_text3");
        editContentList1.orderBefore("contentList1_text1", "contentList1_text2");
        editContentList1.orderBefore("contentList1_text0", "contentList1_text1");
        this.englishEditSession.save();
        this.testChildOrdering(editContentList1, "default", "contentList1_text0", "contentList1_text1", "contentList1_text2");
        jcrService.publishByMainId(editContentList1.getIdentifier(), "default", "live", null, false, null);
        JCRNodeWrapper liveContentList1Node = this.englishLiveSession.getNode(this.testHomeEdit.getPath() + "/contentList1");
        this.testChildOrdering(liveContentList1Node, "live", "contentList1_text0", "contentList1_text1", "contentList1_text2");
        for (int i = 4; i < 8; ++i) {
            JCRNodeWrapper textNode = editContentList1.addNode(editContentList1.getName() + "_text" + Integer.toString(i), "jnt:mainContent");
            textNode.setProperty("jcr:title", INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE + Integer.toString(i));
            textNode.setProperty("body", INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE + Integer.toString(i));
        }
        this.englishEditSession.save();
        jcrService.publishByMainId(editContentList1.getIdentifier(), "default", "live", null, false, null);
        this.testChildOrdering(liveContentList1Node, "live", "contentList1_text0", "contentList1_text1", "contentList1_text2", "contentList1_text3", "contentList1_text4", "contentList1_text5", "contentList1_text6", "contentList1_text7");
        JCRNodeWrapper textNode = editContentList1.addNode(editContentList1.getName() + "_text8", "jnt:mainContent");
        textNode.setProperty("jcr:title", "English text8");
        textNode.setProperty("body", "English text8");
        editContentList1.orderBefore("contentList1_text8", "contentList1_text1");
        this.englishEditSession.save();
        this.testChildOrdering(editContentList1, "default", "contentList1_text0", "contentList1_text8", "contentList1_text1");
        jcrService.publishByMainId(editContentList1.getIdentifier(), "default", "live", null, false, null);
        this.testChildOrdering(liveContentList1Node, "default", "contentList1_text0", "contentList1_text8", "contentList1_text1");
    }

    @Test
    public void testNodeRemoveAndAdd() throws Exception {
        JCRNodeWrapper list = TestHelper.createList(this.testHomeEdit, "contentList1", 4, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
        this.englishEditSession.save();
        jcrService.publishByMainId(this.testHomeEdit.getIdentifier());
        String firstId = list.getIdentifier();
        list.remove();
        list = TestHelper.createList(this.testHomeEdit, "contentList1", 5, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
        String secondId = list.getIdentifier();
        this.englishEditSession.save();
        jcrService.publishByMainId(this.testHomeEdit.getIdentifier());
        try {
            this.englishLiveSession.getNodeByUUID(firstId);
            Assert.fail("Node should have been deleted");
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        JCRNodeWrapper liveList = this.englishLiveSession.getNode(list.getPath());
        Assert.assertEquals("Invalid uuid", secondId, liveList.getIdentifier());
    }

    @Test
    public void testAddMixinAndPublish() throws RepositoryException {
        this.testHomeEdit.addMixin("jmix:sitemap");
        this.englishEditSession.save();
        Assert.assertTrue("Page should now have the sitemap mixin type in edit workspace", this.testHomeEdit.isNodeType("jmix:sitemap"));
        this.testPropertyInWorkspace(this.englishEditSession, this.testHomeEdit.getPath(), "changefreq", "monthly", "Propery changefreq should have default value of 'monthly'");
        jcrService.publishByMainId(this.testHomeEdit.getIdentifier(), "default", "live", null, false, null);
        JCRNodeWrapper englishLivePage1 = this.englishLiveSession.getNode(this.testHomeEdit.getPath());
        Assert.assertTrue("Page should now have the sitemap mixin type in live workspace", englishLivePage1.isNodeType("jmix:sitemap"));
        this.testPropertyInWorkspace(this.englishLiveSession, this.testHomeEdit.getPath(), "changefreq", "monthly", "Propery changefreq should have default value of 'monthly'");
        this.testHomeEdit.removeMixin("jmix:sitemap");
        this.englishEditSession.save();
        Assert.assertFalse("pageAddMixin should now no longer have the sitemap mixin in the edit workspace!", this.testHomeEdit.isNodeType("jmix:sitemap"));
        jcrService.publishByMainId(this.testHomeEdit.getIdentifier(), "default", "live", null, false, null);
        englishLivePage1 = this.englishLiveSession.getNode(this.testHomeEdit.getPath());
        Assert.assertFalse("Page should now no longer have the sitemap mixin in the live workspace!", englishLivePage1.isNodeType("jmix:sitemap"));
    }

    @Test
    public void testPublicationMixin() throws RepositoryException {
        TestHelper.createList(this.testHomeEdit, "contentList1", 4, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
        String listPath = this.testHomeEdit.getPath() + "/contentList1/contentList1_text2";
        this.englishEditSession.getNode(listPath).addMixin("jmix:publication");
        this.englishEditSession.save();
        jcrService.publishByMainId(this.testHomeEdit.getIdentifier(), "default", "live", null, false, null);
        this.testPropertyInWorkspace(this.englishLiveSession, this.testHomeEdit.getPath() + "/contentList1/contentList1_text1", "body", "English text1", "Property value for text node 1 was not found or invalid in english live workspace");
        this.testNodeNotInWorkspace(this.englishLiveSession, listPath, "Sub page should have not been published");
        jcrService.publishByMainId(this.testHomeEdit.getIdentifier(), "default", "live", null, true, null);
        this.testNodeInWorkspace(this.englishLiveSession, listPath, "Sub page should have been published");
    }

    @Test
    public void testMultiLanguagePublication() throws RepositoryException {
        JCRSessionWrapper frenchEditSession = JCRSessionFactory.getInstance().getCurrentUserSession("default", LanguageCodeConverters.languageCodeToLocale((String)"fr"));
        JCRNodeWrapper page = frenchEditSession.getNode(this.testHomeEdit.getPath());
        page.setProperty("jcr:title", "French title");
        frenchEditSession.save();
        jcrService.publishByMainId(this.testHomeEdit.getIdentifier(), "default", "live", Collections.singleton("en"), false, null);
        this.testNodeInWorkspace(this.englishLiveSession, this.testHomeEdit.getPath(), "Page should be published in english");
        JCRSessionWrapper frenchLiveSession = JCRSessionFactory.getInstance().getCurrentUserSession("live", LanguageCodeConverters.languageCodeToLocale((String)"fr"));
        this.testNodeNotInWorkspace(frenchLiveSession, this.testHomeEdit.getPath(), "Page should not be published in english");
        jcrService.publishByMainId(this.testHomeEdit.getIdentifier(), "default", "live", Collections.singleton("fr"), false, null);
        this.testNodeInWorkspace(frenchLiveSession, this.testHomeEdit.getPath(), "Page should be published in french");
    }

    @Test
    public void testPublicationStatus() throws RepositoryException {
        JCRNodeWrapper list = TestHelper.createList(this.testHomeEdit, "contentList1", 4, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
        JCRNodeWrapper editTextNode1 = this.englishEditSession.getNode(this.testHomeEdit.getPath() + "/contentList1/contentList1_text1");
        this.englishEditSession.save();
        this.getCleanSession();
        List infos = jcrService.getPublicationInfo(this.testHomeEdit.getIdentifier(), null, false, true, false, "default", "live");
        Assert.assertEquals("Invalid status for page", 1L, this.getStatusFor(infos, this.testHomeEdit.getIdentifier()));
        Assert.assertEquals("Invalid status for list", 4L, this.getStatusFor(infos, list.getIdentifier()));
        Assert.assertEquals("Invalid status for content", 4L, this.getStatusFor(infos, editTextNode1.getIdentifier()));
        jcrService.publishByMainId(this.testHomeEdit.getIdentifier(), "default", "live", null, false, null);
        this.getCleanSession();
        infos = jcrService.getPublicationInfo(this.testHomeEdit.getIdentifier(), null, false, true, false, "default", "live");
        Assert.assertEquals("Invalid status for page", 1L, this.getStatusFor(infos, this.testHomeEdit.getIdentifier()));
        Assert.assertEquals("Invalid status for list", 1L, this.getStatusFor(infos, list.getIdentifier()));
        Assert.assertEquals("Invalid status for content", 1L, this.getStatusFor(infos, editTextNode1.getIdentifier()));
        editTextNode1 = this.englishEditSession.getNode(this.testHomeEdit.getPath() + "/contentList1/contentList1_text1");
        editTextNode1.setProperty("align", "right");
        this.englishEditSession.save();
        this.getCleanSession();
        infos = jcrService.getPublicationInfo(this.testHomeEdit.getIdentifier(), null, false, true, false, "default", "live");
        Assert.assertEquals("Invalid status for page", 1L, this.getStatusFor(infos, this.testHomeEdit.getIdentifier()));
        Assert.assertEquals("Invalid status for list", 1L, this.getStatusFor(infos, list.getIdentifier()));
        Assert.assertEquals("Invalid status for content", 3L, this.getStatusFor(infos, editTextNode1.getIdentifier()));
    }

    private int getStatusFor(List<PublicationInfo> infos, String uuid) {
        for (PublicationInfo info : infos) {
            int i = this.getStatusFor(info.getRoot(), uuid);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    private int getStatusFor(PublicationInfoNode info, String uuid) {
        if (info.getUuid().equals(uuid)) {
            return info.getStatus();
        }
        for (PublicationInfoNode node : info.getChildren()) {
            int i = this.getStatusFor(node, uuid);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    private Boolean getWipFor(List<PublicationInfo> infos, String uuid) {
        for (PublicationInfo info : infos) {
            Boolean wip = this.getWipFor(info.getRoot(), uuid);
            if (wip == null) continue;
            return wip;
        }
        return false;
    }

    private Boolean getWipFor(PublicationInfoNode info, String uuid) {
        if (info.getUuid().equals(uuid)) {
            return info.isWorkInProgress();
        }
        for (PublicationInfoNode node : info.getChildren()) {
            Boolean wip = this.getWipFor(node, uuid);
            if (wip == null) continue;
            return wip;
        }
        return null;
    }

    @Test
    public void testWorkInProgressStatus() throws RepositoryException {
        JCRNodeWrapper list = TestHelper.createList(this.testHomeEdit, "contentList1", 4, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
        JCRNodeWrapper editTextNode1 = this.englishEditSession.getNode(this.testHomeEdit.getPath() + "/contentList1/contentList1_text1");
        editTextNode1.setProperty("j:workInProgressStatus", "LANGUAGES");
        editTextNode1.setProperty("j:workInProgressLanguages", new String[]{"en"});
        this.englishEditSession.save();
        this.getCleanSession();
        Set<String> languages = Collections.singleton("en");
        List infos = jcrService.getPublicationInfo(this.testHomeEdit.getIdentifier(), languages, false, true, false, "default", "live");
        Assert.assertEquals("Invalid status for page", 1L, this.getStatusFor(infos, this.testHomeEdit.getIdentifier()));
        Assert.assertEquals("Invalid status for list", 4L, this.getStatusFor(infos, list.getIdentifier()));
        Assert.assertEquals("Invalid status for content", 4L, this.getStatusFor(infos, editTextNode1.getIdentifier()));
        Assert.assertEquals("Invalid 'work in progress' info for content", true, this.getWipFor(infos, editTextNode1.getIdentifier()));
        jcrService.publishByMainId(this.testHomeEdit.getIdentifier(), "default", "live", languages, false, null);
        this.getCleanSession();
        infos = jcrService.getPublicationInfo(this.testHomeEdit.getIdentifier(), languages, false, true, false, "default", "live");
        Assert.assertEquals("Invalid status forQA-5120 :  page", 1L, this.getStatusFor(infos, this.testHomeEdit.getIdentifier()));
        Assert.assertEquals("Invalid status for list", 1L, this.getStatusFor(infos, list.getIdentifier()));
        Assert.assertEquals("Invalid status for content", 4L, this.getStatusFor(infos, editTextNode1.getIdentifier()));
        Assert.assertEquals("Invalid 'work in progress' info for content", true, this.getWipFor(infos, editTextNode1.getIdentifier()));
        editTextNode1 = this.englishEditSession.getNode(this.testHomeEdit.getPath() + "/contentList1/contentList1_text1");
        editTextNode1.markForDeletion("Test mark for deletion");
        this.englishEditSession.save();
        this.getCleanSession();
        infos = jcrService.getPublicationInfo(this.testHomeEdit.getIdentifier(), languages, false, true, false, "default", "live");
        Assert.assertEquals("Invalid 'work in progress' info for content", false, this.getWipFor(infos, editTextNode1.getIdentifier()));
        editTextNode1 = this.englishEditSession.getNode(this.testHomeEdit.getPath() + "/contentList1/contentList1_text1");
        editTextNode1.unmarkForDeletion();
        this.englishEditSession.save();
        this.getCleanSession();
        infos = jcrService.getPublicationInfo(this.testHomeEdit.getIdentifier(), languages, false, true, false, "default", "live");
        Assert.assertEquals("Invalid 'work in progress' info for content", true, this.getWipFor(infos, editTextNode1.getIdentifier()));
        editTextNode1 = this.englishEditSession.getNode(this.testHomeEdit.getPath() + "/contentList1/contentList1_text1");
        editTextNode1.setProperty("j:workInProgressStatus", "DISABLED");
        this.englishEditSession.save();
        this.getCleanSession();
        infos = jcrService.getPublicationInfo(this.testHomeEdit.getIdentifier(), languages, false, true, false, "default", "live");
        Assert.assertEquals("Invalid status for page", 1L, this.getStatusFor(infos, this.testHomeEdit.getIdentifier()));
        Assert.assertEquals("Invalid status for list", 1L, this.getStatusFor(infos, list.getIdentifier()));
        Assert.assertEquals("Invalid status for content", 4L, this.getStatusFor(infos, editTextNode1.getIdentifier()));
        Assert.assertEquals("Invalid 'work in progress' info for content", false, this.getWipFor(infos, editTextNode1.getIdentifier()));
        editTextNode1 = this.englishEditSession.getNode(this.testHomeEdit.getPath() + "/contentList1/contentList1_text1");
        editTextNode1.setProperty("j:workInProgressStatus", "DISABLED");
        editTextNode1.addMixin("jmix:keywords");
        editTextNode1.setProperty("j:keywords", new String[]{"Hello, Bonjour"});
        this.englishEditSession.save();
        this.getCleanSession();
        jcrService.publishByMainId(this.testHomeEdit.getIdentifier(), "default", "live", languages, true, null);
        infos = jcrService.getPublicationInfo(this.testHomeEdit.getIdentifier(), languages, false, true, false, "default", "live");
        Assert.assertEquals("Invalid status for page", 1L, this.getStatusFor(infos, this.testHomeEdit.getIdentifier()));
        Assert.assertEquals("Invalid status for content", 1L, this.getStatusFor(infos, editTextNode1.getIdentifier()));
        Assert.assertEquals("Invalid 'work in progress' info for content", false, this.getWipFor(infos, editTextNode1.getIdentifier()));
        editTextNode1 = this.englishEditSession.getNode(this.testHomeEdit.getPath() + "/contentList1/contentList1_text1");
        editTextNode1.setProperty("j:workInProgressStatus", "LANGUAGES");
        editTextNode1.setProperty("j:workInProgressLanguages", new String[]{"en"});
        editTextNode1.setProperty("j:keywords", new String[]{"Hello1, Bonjour1"});
        this.englishEditSession.save();
        this.getCleanSession();
        jcrService.publishByMainId(this.testHomeEdit.getIdentifier(), "default", "live", languages, true, null);
        infos = jcrService.getPublicationInfo(this.testHomeEdit.getIdentifier(), languages, false, true, true, "default", "live");
        Assert.assertEquals("Invalid status for page", 1L, this.getStatusFor(infos, this.testHomeEdit.getIdentifier()));
        Assert.assertEquals("Invalid status for content", 3L, this.getStatusFor(infos, editTextNode1.getIdentifier()));
        this.getCleanSession();
        jcrService.publishByMainId(this.testHomeEdit.getIdentifier(), "default", "live", new HashSet<String>(Arrays.asList("en", "fr")), true, null);
        editTextNode1 = this.englishLiveSession.getNode(this.testHomeEdit.getPath() + "/contentList1/contentList1_text1");
        String keywords = (String)editTextNode1.getPropertiesAsString().get("j:keywords");
        Assert.assertEquals(true, keywords.contains("Hello"));
        Assert.assertEquals(true, keywords.contains("Bonjour"));
    }

    private void testNodeInWorkspace(JCRSessionWrapper sessionWrapper, String absoluteNodePath, String failureMessage) throws RepositoryException {
        boolean nodeWasFoundInLive = false;
        try {
            sessionWrapper.getNode(absoluteNodePath);
            nodeWasFoundInLive = true;
        }
        catch (PathNotFoundException pnfe) {
            nodeWasFoundInLive = false;
        }
        String treeString = "";
        if (!nodeWasFoundInLive) {
            StringBuilder stringBuilder = TestHelper.dumpTree(new StringBuilder(), (Node)this.testHomeEdit, 0, true);
            treeString = "\nTree dump:\n" + stringBuilder.toString();
        }
        Assert.assertTrue(failureMessage + treeString, nodeWasFoundInLive);
    }

    private void testNodeNotInWorkspace(JCRSessionWrapper sessionWrapper, String absoluteNodePath, String failureMessage) throws RepositoryException {
        boolean nodeWasFoundInLive = true;
        try {
            sessionWrapper.getNode(absoluteNodePath);
        }
        catch (PathNotFoundException pnfe) {
            nodeWasFoundInLive = false;
        }
        String treeString = "";
        if (nodeWasFoundInLive) {
            StringBuilder stringBuilder = TestHelper.dumpTree(new StringBuilder(), (Node)this.testHomeEdit, 0, true);
            treeString = "\nTree dump:\n" + stringBuilder.toString();
        }
        Assert.assertFalse(failureMessage + treeString, nodeWasFoundInLive);
    }

    private void testPropertyInWorkspace(JCRSessionWrapper sessionWrapper, String absoluteNodePath, String propertyName, String propertyValue, String failureMessage) throws RepositoryException {
        boolean nodeWasFoundInLive = false;
        try {
            JCRNodeWrapper liveTextNode1 = sessionWrapper.getNode(absoluteNodePath);
            nodeWasFoundInLive = true;
            String readPropertyValue = liveTextNode1.getPropertyAsString(propertyName);
            if (propertyValue == null) {
                if (readPropertyValue == null) {
                    return;
                }
                Assert.assertNotNull(failureMessage, readPropertyValue);
            } else {
                Assert.assertEquals(failureMessage, propertyValue, readPropertyValue);
            }
        }
        catch (PathNotFoundException pnfe) {
            nodeWasFoundInLive = false;
        }
        Assert.assertTrue(failureMessage, nodeWasFoundInLive);
    }

    private void testChildOrdering(JCRNodeWrapper contentList1Node, String workspace, String ... child) throws RepositoryException {
        String expectedValueString = StringUtils.join((Object[])child, (String)" ");
        JCRNodeIteratorWrapper childNodeIterator = contentList1Node.getNodes();
        ArrayList<String> foundValues = new ArrayList<String>();
        while (childNodeIterator.hasNext()) {
            Node currentChildNode = childNodeIterator.nextNode();
            if (!Arrays.asList(child).contains(currentChildNode.getName())) continue;
            foundValues.add(currentChildNode.getName());
        }
        String foundValueString = StringUtils.join((Object[])foundValues.toArray(), (String)" ");
        Assert.assertEquals("Order is invalid, " + (workspace.equals("default") ? "done in staging mode" : "propagated to live mode"), expectedValueString, foundValueString);
    }

    private void getCleanSession() throws RepositoryException {
        JCRSessionFactory sessionFactory = JCRSessionFactory.getInstance();
        sessionFactory.closeAllSessions();
        this.englishEditSession = sessionFactory.getCurrentUserSession("default", Locale.ENGLISH);
        this.englishLiveSession = sessionFactory.getCurrentUserSession("live", Locale.ENGLISH);
    }
}

