/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.query;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.RangeFacet;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.query.QOMBuilder;
import org.jahia.services.query.QueryResultWrapper;
import org.jahia.services.sites.JahiaSite;
import org.jahia.test.TestHelper;
import org.jahia.utils.LanguageCodeConverters;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class FacetedQueryTest {
    private static String DEFAULT_LANGUAGE = "fr";
    private static final String TESTSITE_NAME = "jcrFacetTest";
    private static final String MEETING = "meeting";
    private static final String CONSUMER_SHOW = "consumerShow";
    private static final String ROAD_SHOW = "roadShow";
    private static final String CONFERENCE = "conference";
    private static final String SHOW = "show";
    private static final String PRESS_CONFERENCE = "pressConference";
    private static final String PARIS = "paris";
    private static final String GENEVA = "geneva";

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        JahiaSite site = TestHelper.createSite(TESTSITE_NAME);
        Assert.assertNotNull(site);
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE));
        FacetedQueryTest.initContent(session);
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        TestHelper.deleteSite(TESTSITE_NAME);
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSimpleFacets() throws Exception {
        QueryResultWrapper resCheck;
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE));
        QueryResultWrapper res = this.doQuery(session, "eventsType", "rep:facet(facet.mincount=1)");
        this.checkResultSize(res, 0);
        FacetField field = res.getFacetField("eventsType");
        Assert.assertNotNull("Facet field is null", field);
        Assert.assertNotNull("Facet values are null", field.getValues());
        Assert.assertEquals("Query did not return correct number of facets", 6L, field.getValues().size());
        Iterator counts = field.getValues().iterator();
        this.checkFacet((FacetField.Count)counts.next(), SHOW, 7);
        this.checkFacet((FacetField.Count)counts.next(), PRESS_CONFERENCE, 6);
        this.checkFacet((FacetField.Count)counts.next(), CONFERENCE, 5);
        this.checkFacet((FacetField.Count)counts.next(), ROAD_SHOW, 4);
        this.checkFacet((FacetField.Count)counts.next(), CONSUMER_SHOW, 3);
        this.checkFacet((FacetField.Count)counts.next(), MEETING, 2);
        for (FacetField.Count count : field.getValues()) {
            resCheck = this.doFilteredQuery(session, "eventsType", count.getName());
            this.checkResultSize(resCheck, (int)count.getCount());
        }
        for (FacetField.Count count : field.getValues()) {
            resCheck = this.doQuery(session, "rep:filter(eventsType)", count.getAsFilterQuery());
            this.checkResultSize(resCheck, (int)count.getCount());
        }
        res = this.doQuery(session, "eventsType", "rep:facet(facet.mincount=1&prefix=c)");
        field = res.getFacetField("eventsType");
        Assert.assertNotNull("Facet field is null", field);
        Assert.assertNotNull("Facet values are null", field.getValues());
        Assert.assertEquals("Query did not return correct number of facet values", 2L, field.getValues().size());
        counts = field.getValues().iterator();
        this.checkFacet((FacetField.Count)counts.next(), CONFERENCE, 5);
        this.checkFacet((FacetField.Count)counts.next(), CONSUMER_SHOW, 3);
        for (FacetField.Count count : field.getValues()) {
            resCheck = this.doQuery(session, "rep:filter(eventsType)", count.getAsFilterQuery());
            this.checkResultSize(resCheck, (int)count.getCount());
        }
        res = this.doQuery(session, "eventsType", "rep:facet(facet.mincount=1&sort=index)");
        field = res.getFacetField("eventsType");
        Assert.assertNotNull("Facet field is null", field);
        Assert.assertNotNull("Facet values are null", field.getValues());
        Assert.assertEquals("Query did not return correct number of facet value", 6L, field.getValues().size());
        counts = field.getValues().iterator();
        this.checkFacet((FacetField.Count)counts.next(), CONFERENCE, 5);
        this.checkFacet((FacetField.Count)counts.next(), CONSUMER_SHOW, 3);
        this.checkFacet((FacetField.Count)counts.next(), MEETING, 2);
        this.checkFacet((FacetField.Count)counts.next(), PRESS_CONFERENCE, 6);
        this.checkFacet((FacetField.Count)counts.next(), ROAD_SHOW, 4);
        this.checkFacet((FacetField.Count)counts.next(), SHOW, 7);
        for (FacetField.Count count : field.getValues()) {
            resCheck = this.doQuery(session, "rep:filter(eventsType)", count.getAsFilterQuery());
            this.checkResultSize(resCheck, (int)count.getCount());
        }
    }

    @Test
    public void testDateFacets() throws Exception {
        QueryResultWrapper resCheck;
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE));
        QueryResultWrapper res = this.doQuery(session, "startDate", "rep:facet(date.start=2000-01-01T00:00:00Z&date.end=2002-01-01T00:00:00Z&date.gap=+1MONTH)");
        FacetField field = res.getFacetDate("startDate");
        Assert.assertEquals("Query did not return correct number of facets", 24L, field.getValues().size());
        res = this.doQuery(session, "startDate", "rep:facet(facet.mincount=1&date.start=2000-01-01T00:00:00Z&date.end=2002-01-01T00:00:00Z&date.gap=+1MONTH)");
        field = res.getFacetDate("startDate");
        Assert.assertEquals("Query did not return correct number of facets", 2L, field.getValues().size());
        Iterator counts = field.getValues().iterator();
        this.checkFacet((FacetField.Count)counts.next(), "2000-01-01T00:00:00Z", 14);
        this.checkFacet((FacetField.Count)counts.next(), "2000-02-01T00:00:00Z", 13);
        for (FacetField.Count count : field.getValues()) {
            resCheck = this.doQuery(session, "rep:filter(startDate)", count.getAsFilterQuery());
            this.checkResultSize(resCheck, (int)count.getCount());
        }
        res = this.doQuery(session, "startDate", "rep:facet(facet.mincount=1&date.start=2000-01-01T00:00:00Z&date.end=2002-01-01T00:00:00Z&date.gap=+1YEAR)");
        field = res.getFacetDate("startDate");
        Assert.assertEquals("Query did not return correct number of facets", 1L, field.getValues().size());
        counts = field.getValues().iterator();
        this.checkFacet((FacetField.Count)counts.next(), "2000-01-01T00:00:00Z", 27);
        for (FacetField.Count count : field.getValues()) {
            resCheck = this.doQuery(session, "rep:filter(startDate)", count.getAsFilterQuery());
            this.checkResultSize(resCheck, (int)count.getCount());
        }
        res = this.doQuery(session, "startDate", "rep:facet(facet.mincount=1&date.start=2000-01-10T00:00:00Z&date.end=2000-01-31T00:00:00Z&date.gap=+7DAYS&date.include=lower&date.include=upper&date.include=edge&date.other=all)");
        field = res.getFacetDate("startDate");
        Assert.assertEquals("Query did not return correct number of facets", 6L, field.getValues().size());
        counts = field.getValues().iterator();
        this.checkFacet((FacetField.Count)counts.next(), "2000-01-10T00:00:00Z", 4);
        this.checkFacet((FacetField.Count)counts.next(), "2000-01-17T00:00:00Z", 2);
        this.checkFacet((FacetField.Count)counts.next(), "2000-01-24T00:00:00Z", 2);
        this.checkFacet((FacetField.Count)counts.next(), "before", 4);
        this.checkFacet((FacetField.Count)counts.next(), "after", 15);
        this.checkFacet((FacetField.Count)counts.next(), "between", 8);
        for (FacetField.Count count : field.getValues()) {
            resCheck = this.doQuery(session, "rep:filter(startDate)", count.getAsFilterQuery());
            this.checkResultSize(resCheck, (int)count.getCount());
        }
    }

    @Test
    public void testRangeFacets() throws Exception {
        QueryResultWrapper resCheck;
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE));
        QueryResultWrapper res = this.doQuery(session, "startDate", "rep:facet(range.start=2000-01-01T00:00:00Z&range.end=2002-01-01T00:00:00Z&range.gap=+1MONTH&range.include=lower&range.include=upper&range.include=edge)");
        RangeFacet field = res.getRangeFacet("startDate");
        Assert.assertEquals("Query did not return correct number of facets", 24L, field.getCounts().size());
        res = this.doQuery(session, "startDate", "rep:facet(facet.mincount=1&range.start=2000-01-01T00:00:00Z&range.end=2002-01-01T00:00:00Z&range.gap=+1MONTH&range.include=lower&range.include=upper&range.include=edge)");
        field = res.getRangeFacet("startDate");
        Assert.assertEquals("Query did not return correct number of facets", 2L, field.getCounts().size());
        Iterator counts = field.getCounts().iterator();
        this.checkFacet((RangeFacet.Count)counts.next(), "2000-01-01T00:00:00Z", 14);
        this.checkFacet((RangeFacet.Count)counts.next(), "2000-02-01T00:00:00Z", 13);
        for (RangeFacet.Count count : field.getCounts()) {
            resCheck = this.doQuery(session, "rep:filter(startDate)", count.getAsFilterQuery());
            this.checkResultSize(resCheck, count.getCount());
        }
        res = this.doQuery(session, "startDate", "rep:facet(facet.mincount=1&range.start=2000-01-01T00:00:00Z&range.end=2002-01-01T00:00:00Z&range.gap=+1YEAR&range.include=lower&range.include=upper&range.include=edge)");
        field = res.getRangeFacet("startDate");
        Assert.assertEquals("Query did not return correct number of facets", 1L, field.getCounts().size());
        counts = field.getCounts().iterator();
        this.checkFacet((RangeFacet.Count)counts.next(), "2000-01-01T00:00:00Z", 27);
        for (RangeFacet.Count count : field.getCounts()) {
            resCheck = this.doQuery(session, "rep:filter(startDate)", count.getAsFilterQuery());
            this.checkResultSize(resCheck, count.getCount());
        }
        res = this.doQuery(session, "startDate", "rep:facet(facet.mincount=1&range.start=2000-01-10T00:00:00Z&range.end=2000-01-31T00:00:00Z&range.gap=+7DAYS&range.include=lower&range.include=upper&range.include=edge&range.other=all)");
        field = res.getRangeFacet("startDate");
        Assert.assertEquals("Query did not return correct number of facets", 6L, field.getCounts().size());
        counts = field.getCounts().iterator();
        this.checkFacet((RangeFacet.Count)counts.next(), "2000-01-10T00:00:00Z", 4);
        this.checkFacet((RangeFacet.Count)counts.next(), "2000-01-17T00:00:00Z", 2);
        this.checkFacet((RangeFacet.Count)counts.next(), "2000-01-24T00:00:00Z", 2);
        this.checkFacet((RangeFacet.Count)counts.next(), "before", 4);
        this.checkFacet((RangeFacet.Count)counts.next(), "after", 15);
        this.checkFacet((RangeFacet.Count)counts.next(), "between", 8);
        for (RangeFacet.Count count : field.getCounts()) {
            resCheck = this.doQuery(session, "rep:filter(startDate)", count.getAsFilterQuery());
            this.checkResultSize(resCheck, count.getCount());
        }
    }

    @Test
    public void testI18NFacets() throws Exception {
        QueryResultWrapper resCheck;
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE));
        QueryResultWrapper res = this.doQuery(session, "location", "rep:facet(facet.mincount=1)");
        FacetField field = res.getFacetField("location");
        Assert.assertNotNull("Facet field is null", field);
        Assert.assertNotNull("Facet values are null", field.getValues());
        Assert.assertEquals("Query did not return correct number of facets", 2L, field.getValues().size());
        Iterator counts = field.getValues().iterator();
        this.checkFacet((FacetField.Count)counts.next(), PARIS, 15);
        this.checkFacet((FacetField.Count)counts.next(), GENEVA, 12);
        for (FacetField.Count count : field.getValues()) {
            resCheck = this.doFilteredQuery(session, "location", count.getName());
            this.checkResultSize(resCheck, (int)count.getCount());
        }
        for (FacetField.Count count : field.getValues()) {
            resCheck = this.doQuery(session, "rep:filter(location)", count.getAsFilterQuery());
            this.checkResultSize(resCheck, (int)count.getCount());
        }
    }

    @Test
    public void testCategoryFacets() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE));
        QueryResultWrapper res = this.doQuery(session, "j:defaultCategory", "rep:facet(facet.mincount=1&nodetype=jmix:categorized)");
        FacetField field = res.getFacetField("j:defaultCategory");
        Assert.assertNotNull("Facet field is null", field);
        Assert.assertNotNull("Facet values are null", field.getValues());
        Assert.assertEquals("Query did not return correct number of facets", 3L, field.getValues().size());
        Iterator counts = field.getValues().iterator();
        this.checkFacet((FacetField.Count)counts.next(), "1/sites/systemsite/categories/cat3", 16);
        this.checkFacet((FacetField.Count)counts.next(), "1/sites/systemsite/categories/cat2", 6);
        this.checkFacet((FacetField.Count)counts.next(), "1/sites/systemsite/categories/cat1", 5);
        for (FacetField.Count count : field.getValues()) {
            String countName = count.getName();
            QueryResultWrapper resCheck = this.doFilteredQuery(session, "j:defaultCategory", session.getNode(countName.substring(countName.indexOf("/"))).getIdentifier());
            this.checkResultSize(resCheck, (int)count.getCount());
        }
        for (FacetField.Count count : field.getValues()) {
            QueryResultWrapper resCheck = this.doQuery(session, "rep:filter(j:defaultCategory)", count.getAsFilterQuery());
            this.checkResultSize(resCheck, (int)count.getCount());
        }
    }

    @Test
    public void testMultipleFacets() throws Exception {
        QueryResultWrapper resCheck;
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE));
        QueryResultWrapper res = this.doQuery(session, "eventsType", "rep:facet(facet.mincount=1&key=eventsType)", "startDate", "rep:facet(facet.mincount=1&date.start=2000-01-01T00:00:00Z&date.end=2000-03-01T00:00:00Z&date.gap=+1MONTH&key=2)");
        this.checkResultSize(res, 0);
        FacetField field = res.getFacetField("eventsType");
        Assert.assertNotNull("Facet field is null", field);
        Assert.assertNotNull("Facet values are null", field.getValues());
        Assert.assertEquals("Query did not return correct number of facet value", 6L, field.getValues().size());
        Iterator counts = field.getValues().iterator();
        this.checkFacet((FacetField.Count)counts.next(), SHOW, 7);
        this.checkFacet((FacetField.Count)counts.next(), PRESS_CONFERENCE, 6);
        this.checkFacet((FacetField.Count)counts.next(), CONFERENCE, 5);
        this.checkFacet((FacetField.Count)counts.next(), ROAD_SHOW, 4);
        this.checkFacet((FacetField.Count)counts.next(), CONSUMER_SHOW, 3);
        this.checkFacet((FacetField.Count)counts.next(), MEETING, 2);
        for (FacetField.Count count : field.getValues()) {
            resCheck = this.doQuery(session, "rep:filter(eventsType)", count.getAsFilterQuery());
            this.checkResultSize(resCheck, (int)count.getCount());
        }
        field = res.getFacetDate("startDate");
        Assert.assertNotNull("Facet field is null", field);
        Assert.assertNotNull("Facet values are null", field.getValues());
        Assert.assertEquals("Query did not return correct number of facet values", 2L, field.getValues().size());
        counts = field.getValues().iterator();
        this.checkFacet((FacetField.Count)counts.next(), "2000-01-01T00:00:00Z", 14);
        this.checkFacet((FacetField.Count)counts.next(), "2000-02-01T00:00:00Z", 13);
        for (FacetField.Count count : field.getValues()) {
            resCheck = this.doQuery(session, "rep:filter(startDate)", count.getAsFilterQuery(), "eventsType", "rep:facet(facet.mincount=1&key=eventsType)");
            this.checkResultSize(resCheck, 0);
            FacetField nestedField = resCheck.getFacetDate("startDate");
            Assert.assertNull("Facet field is not null", nestedField);
            nestedField = resCheck.getFacetField("eventsType");
            Iterator nestedCounts = nestedField.getValues().iterator();
            if ("2000-01-01T00:00:00Z".equals(count.getName())) {
                this.checkFacet((FacetField.Count)nestedCounts.next(), CONFERENCE, 5);
                this.checkFacet((FacetField.Count)nestedCounts.next(), ROAD_SHOW, 4);
                this.checkFacet((FacetField.Count)nestedCounts.next(), CONSUMER_SHOW, 3);
                this.checkFacet((FacetField.Count)nestedCounts.next(), MEETING, 2);
            } else {
                this.checkFacet((FacetField.Count)nestedCounts.next(), SHOW, 7);
                this.checkFacet((FacetField.Count)nestedCounts.next(), PRESS_CONFERENCE, 6);
            }
            for (FacetField.Count nestedCount : nestedField.getValues()) {
                QueryResultWrapper nestedResCheck = this.doQuery(session, "rep:filter(startDate)", count.getAsFilterQuery(), "rep:filter(eventsType)", nestedCount.getAsFilterQuery());
                this.checkResultSize(nestedResCheck, (int)nestedCount.getCount());
            }
        }
    }

    @Test
    public void testQueryFacets() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE));
        QueryResultWrapper res = this.doQuery(session, "eventsType", "rep:facet(facet.query=0\\:FACET\\:eventsType:[a TO p]&facet.query=0\\:FACET\\:eventsType:[p TO z])");
        Map queryFacet = res.getFacetQuery();
        Assert.assertNotNull("Query facet result is null", queryFacet);
        Assert.assertEquals("Query did not return correct number of facets", 2L, queryFacet.size());
        Assert.assertEquals("Facet count is incorrect", 10L, (Long)queryFacet.get("0\\:FACET\\:eventsType:[a TO p]"));
        Assert.assertEquals("Facet count is incorrect", 17L, (Long)queryFacet.get("0\\:FACET\\:eventsType:[p TO z]"));
        QueryResultWrapper resCheck = this.doQuery(session, "rep:filter()", "0\\:FACET\\:eventsType:[a TO p]");
        this.checkResultSize(resCheck, 10);
        resCheck = this.doQuery(session, "rep:filter()", "0\\:FACET\\:eventsType:[p TO z]");
        this.checkResultSize(resCheck, 17);
        res = this.doQuery(session, "startDate", "rep:facet(facet.query=0\\:FACET\\:startDate:[2000-01-01T00:00:00Z TO 2000-01-01T00:00:00Z+1MONTH]&facet.query=0\\:FACET\\:startDate:[2000-01-01T00:00:00Z+1MONTH TO 2000-01-01T00:00:00Z+2MONTH])");
        queryFacet = res.getFacetQuery();
        Assert.assertNotNull("Query facet result is null", queryFacet);
        Assert.assertEquals("Query did not return correct number of facets", 2L, queryFacet.size());
        Assert.assertEquals("Facet count is incorrect", 14L, (Long)queryFacet.get("0\\:FACET\\:startDate:[2000-01-01T00:00:00Z TO 2000-01-01T00:00:00Z+1MONTH]"));
        Assert.assertEquals("Facet count is incorrect", 13L, (Long)queryFacet.get("0\\:FACET\\:startDate:[2000-01-01T00:00:00Z+1MONTH TO 2000-01-01T00:00:00Z+2MONTH]"));
        resCheck = this.doQuery(session, "rep:filter()", "0\\:FACET\\:startDate:[2000-01-01T00:00:00Z TO 2000-01-01T00:00:00Z+1MONTH]");
        this.checkResultSize(resCheck, 14);
        resCheck = this.doQuery(session, "rep:filter()", "0\\:FACET\\:startDate:[2000-01-01T00:00:00Z+1MONTH TO 2000-01-01T00:00:00Z+2MONTH]");
        this.checkResultSize(resCheck, 13);
    }

    private static void initContent(JCRSessionWrapper session) throws RepositoryException {
        int i = 0;
        GregorianCalendar calendar = new GregorianCalendar(2000, 0, 1, 12, 0);
        JCRNodeWrapper cats = session.getNode("/sites/systemsite/categories");
        if (!cats.hasNode("cat1")) {
            cats.addNode("cat1", "jnt:category");
        }
        if (!cats.hasNode("cat2")) {
            cats.addNode("cat2", "jnt:category");
        }
        if (!cats.hasNode("cat3")) {
            cats.addNode("cat3", "jnt:category");
        }
        JCRNodeWrapper cat1 = cats.getNode("cat1");
        JCRNodeWrapper cat2 = cats.getNode("cat2");
        JCRNodeWrapper cat3 = cats.getNode("cat3");
        JCRNodeWrapper node = session.getNode("/sites/jcrFacetTest/contents");
        session.getWorkspace().getVersionManager().checkout(node.getPath());
        FacetedQueryTest.createEvent(node, MEETING, PARIS, calendar, cat1, i++);
        FacetedQueryTest.createEvent(node, MEETING, GENEVA, calendar, cat1, i++);
        ((Calendar)calendar).add(5, 5);
        FacetedQueryTest.createEvent(node, CONSUMER_SHOW, PARIS, calendar, cat1, i++);
        FacetedQueryTest.createEvent(node, CONSUMER_SHOW, PARIS, calendar, cat1, i++);
        ((Calendar)calendar).add(5, 5);
        FacetedQueryTest.createEvent(node, CONSUMER_SHOW, GENEVA, calendar, cat1, i++);
        FacetedQueryTest.createEvent(node, ROAD_SHOW, PARIS, calendar, cat2, i++);
        ((Calendar)calendar).add(5, 5);
        FacetedQueryTest.createEvent(node, ROAD_SHOW, PARIS, calendar, cat2, i++);
        FacetedQueryTest.createEvent(node, ROAD_SHOW, GENEVA, calendar, cat2, i++);
        ((Calendar)calendar).add(5, 5);
        FacetedQueryTest.createEvent(node, ROAD_SHOW, GENEVA, calendar, cat2, i++);
        FacetedQueryTest.createEvent(node, CONFERENCE, PARIS, calendar, cat2, i++);
        ((Calendar)calendar).add(5, 5);
        FacetedQueryTest.createEvent(node, CONFERENCE, PARIS, calendar, cat2, i++);
        FacetedQueryTest.createEvent(node, CONFERENCE, PARIS, calendar, cat3, i++);
        ((Calendar)calendar).add(5, 5);
        FacetedQueryTest.createEvent(node, CONFERENCE, GENEVA, calendar, cat3, i++);
        FacetedQueryTest.createEvent(node, CONFERENCE, GENEVA, calendar, cat3, i++);
        ((Calendar)calendar).add(5, 5);
        FacetedQueryTest.createEvent(node, SHOW, PARIS, calendar, cat3, i++);
        FacetedQueryTest.createEvent(node, SHOW, PARIS, calendar, cat3, i++);
        ((Calendar)calendar).add(5, 5);
        FacetedQueryTest.createEvent(node, SHOW, PARIS, calendar, cat3, i++);
        FacetedQueryTest.createEvent(node, SHOW, GENEVA, calendar, cat3, i++);
        FacetedQueryTest.createEvent(node, SHOW, GENEVA, calendar, cat3, i++);
        FacetedQueryTest.createEvent(node, SHOW, GENEVA, calendar, cat3, i++);
        FacetedQueryTest.createEvent(node, SHOW, GENEVA, calendar, cat3, i++);
        FacetedQueryTest.createEvent(node, PRESS_CONFERENCE, PARIS, calendar, cat3, i++);
        FacetedQueryTest.createEvent(node, PRESS_CONFERENCE, PARIS, calendar, cat3, i++);
        FacetedQueryTest.createEvent(node, PRESS_CONFERENCE, PARIS, calendar, cat3, i++);
        FacetedQueryTest.createEvent(node, PRESS_CONFERENCE, PARIS, calendar, cat3, i++);
        FacetedQueryTest.createEvent(node, PRESS_CONFERENCE, GENEVA, calendar, cat3, i++);
        FacetedQueryTest.createEvent(node, PRESS_CONFERENCE, GENEVA, calendar, cat3, i++);
        session.save();
    }

    private QueryResultWrapper doQuery(JCRSessionWrapper session, String ... facet) throws RepositoryException {
        QueryObjectModelFactory factory = session.getWorkspace().getQueryManager().getQOMFactory();
        QOMBuilder qomBuilder = new QOMBuilder(factory, session.getValueFactory());
        qomBuilder.setSource((Source)factory.selector("jnt:event", "event"));
        qomBuilder.andConstraint((Constraint)factory.descendantNode("event", "/sites/jcrFacetTest"));
        for (int j = 0; j < facet.length; ++j) {
            String prop = facet[j++];
            String val = facet[j];
            if (prop.startsWith("rep:filter(")) {
                qomBuilder.andConstraint((Constraint)factory.fullTextSearch("event", "rep:filter(" + Text.escapeIllegalJcrChars((String)StringUtils.substringAfter((String)prop, (String)"rep:filter(")), (StaticOperand)factory.literal(session.getValueFactory().createValue(val))));
                continue;
            }
            qomBuilder.getColumns().add(factory.column("event", prop, val));
        }
        QueryObjectModel qom = qomBuilder.createQOM();
        QueryResultWrapper res = (QueryResultWrapper)qom.execute();
        return res;
    }

    private QueryResultWrapper doFilteredQuery(JCRSessionWrapper session, String ... constraints) throws RepositoryException {
        QueryObjectModelFactory factory = session.getWorkspace().getQueryManager().getQOMFactory();
        QOMBuilder qomBuilder = new QOMBuilder(factory, session.getValueFactory());
        qomBuilder.setSource((Source)factory.selector("jnt:event", "event"));
        qomBuilder.andConstraint((Constraint)factory.descendantNode("event", "/sites/jcrFacetTest"));
        for (int j = 0; j < constraints.length; ++j) {
            String prop = constraints[j++];
            String val = constraints[j];
            qomBuilder.andConstraint((Constraint)factory.comparison((DynamicOperand)factory.propertyValue("event", prop), "jcr.operator.equal.to", (StaticOperand)factory.literal(session.getValueFactory().createValue(val))));
        }
        QueryObjectModel qom = qomBuilder.createQOM();
        QueryResultWrapper res = (QueryResultWrapper)qom.execute();
        return res;
    }

    private void checkResultSize(QueryResultWrapper res, int expected) throws RepositoryException {
        JCRNodeIteratorWrapper ni = res.getNodes();
        ArrayList<JCRNodeWrapper> results = new ArrayList<JCRNodeWrapper>();
        while (ni.hasNext()) {
            results.add((JCRNodeWrapper)ni.next());
        }
        Assert.assertEquals("", expected, results.size());
    }

    private void checkFacet(FacetField.Count c, String name, int count) {
        Assert.assertEquals("Facet are not correctly ordered or has incorrect name", name, c.getName());
        Assert.assertEquals("Facet count is incorrect", count, c.getCount());
    }

    private void checkFacet(RangeFacet.Count c, String name, int count) {
        Assert.assertEquals("Facet are not correctly ordered or has incorrect name", name, c.getValue());
        Assert.assertEquals("Facet count is incorrect", count, c.getCount());
    }

    private static void createEvent(JCRNodeWrapper node, String eventType, String location, Calendar calendar, JCRNodeWrapper category, int i) throws RepositoryException {
        String name = eventType + i;
        JCRNodeWrapper event = node.addNode(name, "jnt:event");
        event.setProperty("jcr:title", name);
        event.setProperty("eventsType", eventType);
        event.setProperty("location", location);
        event.setProperty("startDate", calendar);
        event.addMixin("jmix:categorized");
        event.setProperty("j:defaultCategory", new Value[]{event.getSession().getValueFactory().createValue((Node)category)});
    }
}

