/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.query;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.core.query.lucene.join.JahiaQueryEngine;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.query.QueryResultWrapper;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.sites.JahiaSite;
import org.jahia.test.TestHelper;
import org.jahia.utils.LanguageCodeConverters;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeSortTest {
    private static Logger logger = LoggerFactory.getLogger(NativeSortTest.class);
    private static String DEFAULT_LANGUAGE = "en";
    private static final String TESTSITE_NAME = "jcrQueryTest";
    private static final String SITECONTENT_ROOT_NODE = "/sites/jcrQueryTest";
    private static final String NEWS_NAME_PREFIX = "news_";
    private static final String MEETING = "meeting";
    private static final String CONSUMER_SHOW = "consumerShow";
    private static final String ROAD_SHOW = "roadShow";
    private static final String CONFERENCE = "conference";
    private static final String SHOW = "show";
    private static final String PRESS_CONFERENCE = "pressConference";
    private static final String PARIS = "paris";
    private static final String GENEVA = "geneva";
    private static final String FIRST_PHONE_SENTENCE = "The horse doesn't eat cucumber salad";
    private static final String FIRST_TELEGRAPH_SENTENCE = "What hath God wrought?";
    private JCRSessionWrapper session;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        JahiaSite site = TestHelper.createSite(TESTSITE_NAME);
        Assert.assertNotNull(site);
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE));
        NativeSortTest.initContent(session);
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        TestHelper.deleteSite(TESTSITE_NAME);
    }

    @Before
    public void setUp() throws RepositoryException {
        this.session = JCRSessionFactory.getInstance().getCurrentUserSession("default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE));
    }

    @After
    public void tearDown() {
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @Test
    public void testChildNodeQueries() throws Exception {
        this.doQuery("SELECT * FROM [jnt:news] as news WHERE ISCHILDNODE(news, [/sites/jcrQueryTest/contents/news]) ORDER BY news.[jcr:title]", 16, false);
        this.doQuery("SELECT * FROM [jmix:editorialContent] as content WHERE ISCHILDNODE(content, [/sites/jcrQueryTest/contents/news]) OR ISCHILDNODE(content, [/sites/jcrQueryTest/contents/events]) ORDER BY content.[jcr:title]", 43, false);
        this.doQuery("SELECT * FROM [jmix:editorialContent] as content WHERE ISDESCENDANTNODE(content, [/sites/jcrQueryTest/contents]) AND NOT ISCHILDNODE(content, [/sites/jcrQueryTest/contents/events]) ORDER BY content.[jcr:title]", 23, false);
        this.doQuery("SELECT * FROM [jmix:editorialContent] as content WHERE ISCHILDNODE(content, [/sites/jcrQueryTest/contents/news]) AND content.[jcr:title] LIKE 'news_1%'", 7, false);
        this.doQuery("SELECT * FROM [jmix:editorialContent] as content WHERE ISCHILDNODE(content, [/sites/jcrQueryTest/contents/news]) AND contains(content.*, 'cucumber')", 10, false);
    }

    @Test
    public void testDescendantNodeQueries() throws Exception {
        this.doQuery("SELECT * FROM [jnt:news] as news WHERE ISDESCENDANTNODE(news, [/sites/jcrQueryTest/contents/news]) ORDER BY news.[jcr:title]", 23, false);
        this.doQuery("SELECT * FROM [jmix:editorialContent] as content WHERE ISDESCENDANTNODE(content, [/sites/jcrQueryTest/contents/news]) OR ISDESCENDANTNODE(content, [/sites/jcrQueryTest/contents/events]) ORDER BY content.[jcr:title]", 50, false);
        this.doQuery("SELECT * FROM [jmix:editorialContent] as content WHERE ISDESCENDANTNODE(content, [/sites/jcrQueryTest/contents]) AND NOT ISDESCENDANTNODE(content, [/sites/jcrQueryTest/contents/news]) ORDER BY content.[jcr:title]", 27, false);
        this.doQuery("SELECT * FROM [jmix:editorialContent] as content WHERE ISDESCENDANTNODE(content, [/sites/jcrQueryTest/contents/news]) AND content.[jcr:title] LIKE 'news_1%'", 11, false);
        this.doQuery("SELECT * FROM [jmix:editorialContent] as content WHERE ISDESCENDANTNODE(content, [/sites/jcrQueryTest/contents/news]) AND contains(content.*, 'cucumber')", 13, false);
        this.doQuery("SELECT * FROM [jmix:editorialContent] as content WHERE (ISCHILDNODE(content, [/sites/jcrQueryTest/contents/news]) AND content.[jcr:title] LIKE 'news_1%') OR (ISDESCENDANTNODE(content, [/sites/jcrQueryTest/contents/events]) AND content.[location] = 'geneva')", 19, false);
    }

    @Test
    public void testSortByTitle() throws Exception {
        JCRNodeWrapper newsList = NativeSortTest.createList(this.session.getNode("/sites/jcrQueryTest/contents"), "news-title-test");
        NativeSortTest.createNews(newsList, "D news", null, null, null);
        NativeSortTest.createNews(newsList, "c news", null, null, null);
        NativeSortTest.createNews(newsList, "Z news", null, null, null);
        NativeSortTest.createNews(newsList, "A news", null, null, null);
        NativeSortTest.createNews(newsList, "z news", null, null, null);
        NativeSortTest.createNews(newsList, "C news", null, null, null);
        NativeSortTest.createNews(newsList, "b news", null, null, null);
        NativeSortTest.createNews(newsList, "B news", null, null, null);
        NativeSortTest.createNews(newsList, "d news", null, null, null);
        NativeSortTest.createNews(newsList, "a news", null, null, null);
        this.session.save();
        try {
            this.doQuery("SELECT * FROM [jnt:news] as news WHERE ISCHILDNODE(news, [/sites/jcrQueryTest/contents/news-title-test]) ORDER BY news.[jcr:title]", 10, false);
        }
        finally {
            newsList.remove();
            this.session.save();
        }
    }

    @Test
    public void testSortByTitleNonLatin() throws Exception {
        JCRNodeWrapper newsList = NativeSortTest.createList(this.session.getNode("/sites/jcrQueryTest/contents"), "news-title-non-latin-test");
        NativeSortTest.createNews(newsList, "z test news", null, null, null);
        NativeSortTest.createNews(newsList, "A test news", null, null, null);
        NativeSortTest.createNews(newsList, "Z test news", null, null, null);
        NativeSortTest.createNews(newsList, "Test news", null, null, null);
        NativeSortTest.createNews(newsList, "a test news", null, null, null);
        NativeSortTest.createNews(newsList, "\u0422\u0435\u0441\u0442 \u043d\u043e\u0432\u043e\u0441\u0442\u044c", null, null, null);
        NativeSortTest.createNews(newsList, "01 test news", null, null, null);
        NativeSortTest.createNews(newsList, "\u00c4 test news", null, null, null);
        NativeSortTest.createNews(newsList, "\u00c5 test news", null, null, null);
        NativeSortTest.createNews(newsList, "test news", null, null, null);
        NativeSortTest.createNews(newsList, "t\u00e4st news", null, null, null);
        NativeSortTest.createNews(newsList, "t\u00e0st news", null, null, null);
        NativeSortTest.createNews(newsList, "tast news", null, null, null);
        NativeSortTest.createNews(newsList, "11 test news", null, null, null);
        NativeSortTest.createNews(newsList, "0 test news", null, null, null);
        NativeSortTest.createNews(newsList, "21 test news", null, null, null);
        NativeSortTest.createNews(newsList, "1 test news", null, null, null);
        this.session.save();
        try {
            this.doQuery("SELECT * FROM [jnt:news] as news WHERE ISCHILDNODE(news, [/sites/jcrQueryTest/contents/news-title-non-latin-test]) ORDER BY news.[jcr:title]", 17, false);
        }
        finally {
            newsList.remove();
            this.session.save();
        }
    }

    private void checkSame(List<JCRNodeWrapper> nodes, List<JCRNodeWrapper> nodesNative, String query) throws RepositoryException {
        Assert.assertEquals("Result number for native and non-native sort are different for query: " + query, nodes.size(), nodesNative.size());
        for (int i = 0; i < nodes.size(); ++i) {
            Assert.assertEquals("Results have a different order for query: " + query, nodes.get(i).getIdentifier(), nodesNative.get(i).getIdentifier());
        }
    }

    private static void initContent(JCRSessionWrapper session) throws RepositoryException {
        int i = 0;
        GregorianCalendar calendar = new GregorianCalendar(2000, 0, 1, 12, 0);
        JCRNodeWrapper cats = session.getNode("/sites/systemsite/categories");
        if (!cats.hasNode("cat1")) {
            cats.addNode("cat1", "jnt:category");
        }
        if (!cats.hasNode("cat2")) {
            cats.addNode("cat2", "jnt:category");
        }
        if (!cats.hasNode("cat3")) {
            cats.addNode("cat3", "jnt:category");
        }
        JCRNodeWrapper cat1 = cats.getNode("cat1");
        JCRNodeWrapper cat2 = cats.getNode("cat2");
        JCRNodeWrapper cat3 = cats.getNode("cat3");
        JCRNodeWrapper contentNode = session.getNode("/sites/jcrQueryTest/contents");
        session.getWorkspace().getVersionManager().checkout(contentNode.getPath());
        JCRNodeWrapper node = NativeSortTest.createList(contentNode, "events");
        NativeSortTest.createEvent(node, MEETING, PARIS, calendar, cat1, i++);
        NativeSortTest.createEvent(node, MEETING, GENEVA, calendar, cat1, i++);
        ((Calendar)calendar).add(5, 5);
        NativeSortTest.createEvent(node, CONSUMER_SHOW, PARIS, calendar, cat1, i++);
        NativeSortTest.createEvent(node, CONSUMER_SHOW, PARIS, calendar, cat1, i++);
        ((Calendar)calendar).add(5, 5);
        NativeSortTest.createEvent(node, CONSUMER_SHOW, GENEVA, calendar, cat1, i++);
        NativeSortTest.createEvent(node, ROAD_SHOW, PARIS, calendar, cat2, i++);
        ((Calendar)calendar).add(5, 5);
        NativeSortTest.createEvent(node, ROAD_SHOW, PARIS, calendar, cat2, i++);
        NativeSortTest.createEvent(node, ROAD_SHOW, GENEVA, calendar, cat2, i++);
        ((Calendar)calendar).add(5, 5);
        NativeSortTest.createEvent(node, ROAD_SHOW, GENEVA, calendar, cat2, i++);
        NativeSortTest.createEvent(node, CONFERENCE, PARIS, calendar, cat2, i++);
        ((Calendar)calendar).add(5, 5);
        NativeSortTest.createEvent(node, CONFERENCE, PARIS, calendar, cat2, i++);
        NativeSortTest.createEvent(node, CONFERENCE, PARIS, calendar, cat3, i++);
        ((Calendar)calendar).add(5, 5);
        NativeSortTest.createEvent(node, CONFERENCE, GENEVA, calendar, cat3, i++);
        NativeSortTest.createEvent(node, CONFERENCE, GENEVA, calendar, cat3, i++);
        ((Calendar)calendar).add(5, 5);
        NativeSortTest.createEvent(node, SHOW, PARIS, calendar, cat3, i++);
        NativeSortTest.createEvent(node, SHOW, PARIS, calendar, cat3, i++);
        ((Calendar)calendar).add(5, 5);
        NativeSortTest.createEvent(node, SHOW, PARIS, calendar, cat3, i++);
        NativeSortTest.createEvent(node, SHOW, GENEVA, calendar, cat3, i++);
        NativeSortTest.createEvent(node, SHOW, GENEVA, calendar, cat3, i++);
        NativeSortTest.createEvent(node, SHOW, GENEVA, calendar, cat3, i++);
        NativeSortTest.createEvent(node, SHOW, GENEVA, calendar, cat3, i++);
        NativeSortTest.createEvent(node, PRESS_CONFERENCE, PARIS, calendar, cat3, i++);
        NativeSortTest.createEvent(node, PRESS_CONFERENCE, PARIS, calendar, cat3, i++);
        NativeSortTest.createEvent(node, PRESS_CONFERENCE, PARIS, calendar, cat3, i++);
        NativeSortTest.createEvent(node, PRESS_CONFERENCE, PARIS, calendar, cat3, i++);
        NativeSortTest.createEvent(node, PRESS_CONFERENCE, GENEVA, calendar, cat3, i++);
        NativeSortTest.createEvent(node, PRESS_CONFERENCE, GENEVA, calendar, cat3, i++);
        JCRNodeWrapper newsListNode = NativeSortTest.createList(contentNode, "news");
        calendar = new GregorianCalendar(2000, 0, 1, 12, 0);
        i = 0;
        NativeSortTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_PHONE_SENTENCE, calendar, cat1);
        NativeSortTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_TELEGRAPH_SENTENCE, calendar, cat1);
        ((Calendar)calendar).add(5, 5);
        NativeSortTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_PHONE_SENTENCE, calendar, cat1);
        NativeSortTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_PHONE_SENTENCE, calendar, cat1);
        ((Calendar)calendar).add(5, 5);
        NativeSortTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_TELEGRAPH_SENTENCE, calendar, cat1);
        NativeSortTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_PHONE_SENTENCE, calendar, cat2);
        ((Calendar)calendar).add(5, 5);
        NativeSortTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_PHONE_SENTENCE, calendar, cat2);
        NativeSortTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_TELEGRAPH_SENTENCE, calendar, cat2);
        ((Calendar)calendar).add(5, 5);
        NativeSortTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_TELEGRAPH_SENTENCE, calendar, cat2);
        NativeSortTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_PHONE_SENTENCE, calendar, cat2);
        ((Calendar)calendar).add(5, 5);
        NativeSortTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_PHONE_SENTENCE, calendar, cat2);
        NativeSortTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_PHONE_SENTENCE, calendar, cat3);
        ((Calendar)calendar).add(5, 5);
        NativeSortTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_TELEGRAPH_SENTENCE, calendar, cat3);
        NativeSortTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_TELEGRAPH_SENTENCE, calendar, cat3);
        ((Calendar)calendar).add(5, 5);
        NativeSortTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_PHONE_SENTENCE, calendar, cat3);
        NativeSortTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_PHONE_SENTENCE, calendar, cat3);
        JCRNodeWrapper newsSubListNode = NativeSortTest.createList(newsListNode, "news");
        ((Calendar)calendar).add(5, 5);
        NativeSortTest.createNews(newsSubListNode, NEWS_NAME_PREFIX + i++, FIRST_PHONE_SENTENCE, calendar, cat3);
        NativeSortTest.createNews(newsSubListNode, NEWS_NAME_PREFIX + i++, FIRST_TELEGRAPH_SENTENCE, calendar, cat3);
        NativeSortTest.createNews(newsSubListNode, NEWS_NAME_PREFIX + i++, FIRST_TELEGRAPH_SENTENCE, calendar, cat3);
        NativeSortTest.createNews(newsSubListNode, NEWS_NAME_PREFIX + i++, FIRST_TELEGRAPH_SENTENCE, calendar, cat3);
        calendar = new GregorianCalendar(2000, 0, 1, 12, 0);
        NativeSortTest.createNews(newsSubListNode, NEWS_NAME_PREFIX + i++, FIRST_TELEGRAPH_SENTENCE, calendar, cat3);
        NativeSortTest.createNews(newsSubListNode, NEWS_NAME_PREFIX + i++, FIRST_PHONE_SENTENCE, calendar, cat3);
        NativeSortTest.createNews(newsSubListNode, NEWS_NAME_PREFIX + i++, FIRST_PHONE_SENTENCE, calendar, cat3);
        session.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQuery(String statement, int expectedResultCount, boolean compareTimes) throws RepositoryException {
        if (logger.isDebugEnabled()) {
            logger.debug("Query: {}", (Object)statement);
        }
        NativeSortTest.setNativeSort(true);
        long timerNative = System.currentTimeMillis();
        List<JCRNodeWrapper> nodesNative = null;
        try {
            QueryWrapper query = this.session.getWorkspace().getQueryManager().createQuery(statement, "JCR-SQL2");
            QueryResultWrapper res = (QueryResultWrapper)query.execute();
            nodesNative = this.checkResultSize(res, expectedResultCount);
        }
        finally {
            timerNative = System.currentTimeMillis() - timerNative;
            if (logger.isDebugEnabled()) {
                logger.debug("Query with native sort took {} ms", (Object)timerNative);
            }
        }
        NativeSortTest.setNativeSort(false);
        long timer = System.currentTimeMillis();
        List<JCRNodeWrapper> nodes = null;
        try {
            QueryWrapper query = this.session.getWorkspace().getQueryManager().createQuery(statement, "JCR-SQL2");
            QueryResultWrapper res = (QueryResultWrapper)query.execute();
            nodes = this.checkResultSize(res, expectedResultCount);
        }
        finally {
            timer = System.currentTimeMillis() - timer;
            if (logger.isDebugEnabled()) {
                logger.debug("Query took {} ms", (Object)timer);
            }
        }
        this.checkSame(nodes, nodesNative, statement);
        if (compareTimes) {
            if (timerNative > timer) {
                logger.warn("Query with native sort is {}% slower ({} ms) than the standard query ({} ms): {}", new Object[]{Math.round((float)timerNative / (float)timer * 100.0f) - 100, timerNative, timer, statement});
            } else {
                logger.info("Query with native sort is {}% faster ({} ms) than the standard query ({} ms)", new Object[]{Math.round((float)timer / (float)timerNative * 100.0f) - 100, timerNative, timer});
            }
        }
    }

    private List<JCRNodeWrapper> checkResultSize(QueryResultWrapper res, int expected) throws RepositoryException {
        JCRNodeIteratorWrapper ni = res.getNodes();
        ArrayList<JCRNodeWrapper> results = new ArrayList<JCRNodeWrapper>();
        while (ni.hasNext()) {
            results.add((JCRNodeWrapper)ni.next());
        }
        if (logger.isDebugEnabled()) {
            String newLine = System.getProperty("line.separator");
            StringBuffer debugMessage = new StringBuffer("Results: ").append(newLine);
            for (JCRNodeWrapper result : results) {
                debugMessage.append(result.getPath()).append(newLine);
            }
            logger.debug(debugMessage.toString());
        }
        Assert.assertEquals("", expected, results.size());
        return results;
    }

    private static JCRNodeWrapper createList(JCRNodeWrapper node, String name) throws RepositoryException {
        JCRNodeWrapper list = node.addNode(name, "jnt:contentList");
        list.setProperty("jcr:title", name);
        return list;
    }

    private static JCRNodeWrapper createEvent(JCRNodeWrapper node, String eventType, String location, Calendar calendar, JCRNodeWrapper category, int i) throws RepositoryException {
        String name = eventType + i;
        JCRNodeWrapper event = node.addNode(JCRContentUtils.generateNodeName((String)name, (int)100), "jnt:event");
        event.setProperty("jcr:title", name);
        event.setProperty("eventsType", eventType);
        event.setProperty("location", location);
        event.setProperty("startDate", calendar);
        event.addMixin("jmix:categorized");
        event.setProperty("j:defaultCategory", new Value[]{event.getSession().getValueFactory().createValue((Node)category)});
        return event;
    }

    private static JCRNodeWrapper createNews(JCRNodeWrapper node, String name, String desc, Calendar calendar, JCRNodeWrapper category) throws RepositoryException {
        JCRNodeWrapper event = node.addNode(JCRContentUtils.findAvailableNodeName((Node)node, (String)JCRContentUtils.generateNodeName((String)name, (int)100)), "jnt:news");
        event.setProperty("jcr:title", name);
        if (desc != null) {
            event.setProperty("desc", desc);
        }
        event.setProperty("date", calendar != null ? calendar : Calendar.getInstance());
        if (category != null) {
            event.addMixin("jmix:categorized");
            event.setProperty("j:defaultCategory", new Value[]{event.getSession().getValueFactory().createValue((Node)category)});
        }
        return event;
    }

    private static void setNativeSort(boolean enabled) {
        JahiaQueryEngine.nativeSort = enabled;
    }
}

