/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.query;

import java.util.Collections;
import java.util.Locale;
import java.util.Properties;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.core.query.lucene.JahiaQueryImpl;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryAclCheckTest {
    private static final String GROUP_NAME = "jcrQueryAclCheckTestGroup";
    private static Logger logger = LoggerFactory.getLogger(QueryAclCheckTest.class);
    private static final String SITE_KEY = "jcrQueryAclCheckTest";
    private static final String SITE_PATH = "/sites/jcrQueryAclCheckTest";
    private static final String TEST_NODE_NAME = "jcrQueryAclCheckTest";
    private static final String TEST_NODE_PATH = "/sites/jcrQueryAclCheckTest/contents/jcrQueryAclCheckTest";
    private static final String USER_NAME = "jcrQueryAclCheckTestUser";

    private static JCRNodeWrapper createList(JCRNodeWrapper node, String name) throws RepositoryException {
        JCRNodeWrapper list = node.addNode(name, "jnt:contentList");
        list.setProperty("jcr:title", name);
        return list;
    }

    private static JCRNodeWrapper createText(JCRNodeWrapper node, String text) throws RepositoryException {
        JCRNodeWrapper textNode = node.addNode(JCRContentUtils.findAvailableNodeName((Node)node, (String)JCRContentUtils.generateNodeName((String)text)), "jnt:text");
        textNode.setProperty("text", text);
        return textNode;
    }

    private static JCRSessionWrapper getSystemSession() throws RepositoryException {
        return JCRSessionFactory.getInstance().getCurrentSystemSession("default", Locale.ENGLISH, Locale.ENGLISH);
    }

    private static void initContent(JCRSessionWrapper session) throws RepositoryException {
        JahiaUserManagerService userManager = JahiaUserManagerService.getInstance();
        JCRUserNode user = userManager.createUser(USER_NAME, "jcrQueryAclCheckTest", "password", new Properties(), session);
        JahiaGroupManagerService groupManager = JahiaGroupManagerService.getInstance();
        JCRGroupNode group = groupManager.createGroup("jcrQueryAclCheckTest", GROUP_NAME, new Properties(), false, session);
        group.addMember((JCRNodeWrapper)user);
        session.getNode(SITE_PATH).grantRoles("g:" + group.getName(), Collections.singleton("editor"));
        JCRNodeWrapper topNode = QueryAclCheckTest.createList(session.getNode("/sites/jcrQueryAclCheckTest/contents"), "jcrQueryAclCheckTest");
        QueryAclCheckTest.createText(topNode, "text-1");
        QueryAclCheckTest.createText(topNode, "text-2");
        QueryAclCheckTest.createText(topNode, "text-3");
        JCRNodeWrapper subNode = QueryAclCheckTest.createList(topNode, "sub-node-1");
        QueryAclCheckTest.createText(subNode, "sub-text-1-1");
        QueryAclCheckTest.createText(subNode, "sub-text-1-2");
        QueryAclCheckTest.createText(subNode, "sub-text-1-3");
        subNode = QueryAclCheckTest.createList(topNode, "sub-node-2");
        subNode.setAclInheritanceBreak(true);
        subNode.grantRoles("u:" + user.getName(), Collections.singleton("editor"));
        QueryAclCheckTest.createText(subNode, "sub-text-2-1");
        QueryAclCheckTest.createText(subNode, "sub-text-2-2");
        QueryAclCheckTest.createText(subNode, "sub-text-2-3");
        subNode = QueryAclCheckTest.createList(topNode, "sub-node-3");
        subNode.setAclInheritanceBreak(true);
        subNode.grantRoles("g:" + group.getName(), Collections.singleton("editor"));
        QueryAclCheckTest.createText(subNode, "sub-text-3-1");
        QueryAclCheckTest.createText(subNode, "sub-text-3-2");
        QueryAclCheckTest.createText(subNode, "sub-text-3-3");
        subNode = QueryAclCheckTest.createList(topNode, "sub-node-4");
        subNode.setAclInheritanceBreak(true);
        subNode.grantRoles("u:root", Collections.singleton("editor"));
        logger.info("UUID: {}", (Object)QueryAclCheckTest.createText(subNode, "sub-text-4-1").getIdentifier());
        QueryAclCheckTest.createText(subNode, "sub-text-4-2");
        QueryAclCheckTest.createText(subNode, "sub-text-4-3");
        session.save();
    }

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        JahiaSite site = TestHelper.createSite("jcrQueryAclCheckTest");
        Assert.assertNotNull(site);
        QueryAclCheckTest.initContent(QueryAclCheckTest.getSystemSession());
    }

    @AfterClass
    public static void oneTimeTearUp() throws Exception {
        TestHelper.deleteSite("jcrQueryAclCheckTest");
    }

    private void checkResultSizeNodes(QueryResult res, int expected) throws RepositoryException {
        NodeIterator ni = res.getNodes();
        int count = 0;
        while (ni.hasNext()) {
            ni.next();
            ++count;
        }
        Assert.assertEquals("The result size is not the expected one", expected, count);
    }

    private void checkResultSizeRows(QueryResult res, int expected) throws RepositoryException {
        RowIterator ri = res.getRows();
        int count = 0;
        while (ri.hasNext()) {
            ri.next();
            ++count;
        }
        Assert.assertEquals("The result size is not the expected one", expected, count);
    }

    private QueryResult doQuery(JCRSessionWrapper session, String statement, String language) throws RepositoryException {
        if (logger.isDebugEnabled()) {
            logger.debug("Query: " + statement);
        }
        return session.getWorkspace().getQueryManager().createQuery(statement, language).execute();
    }

    private void performSql2Test(final boolean countRows) throws Exception {
        JCRTemplate.getInstance().doExecute(USER_NAME, "jcrQueryAclCheckTest", "default", Locale.ENGLISH, (JCRCallback)new JCRCallback<Boolean>(){

            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                QueryResult res = QueryAclCheckTest.this.doQuery(session, "SELECT * FROM [jnt:text] WHERE ISDESCENDANTNODE('/sites/jcrQueryAclCheckTest')", "JCR-SQL2");
                if (countRows) {
                    QueryAclCheckTest.this.checkResultSizeRows(res, 12);
                } else {
                    QueryAclCheckTest.this.checkResultSizeNodes(res, 12);
                }
                return Boolean.TRUE;
            }
        });
    }

    private void performXpathTest(final boolean countRows) throws RepositoryException {
        JCRTemplate.getInstance().doExecute(USER_NAME, "jcrQueryAclCheckTest", "default", Locale.ENGLISH, (JCRCallback)new JCRCallback<Boolean>(){

            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                QueryResult res = QueryAclCheckTest.this.doQuery(session, "/jcr:root/sites/jcrQueryAclCheckTest//element(*,jnt:text)", "xpath");
                if (countRows) {
                    QueryAclCheckTest.this.checkResultSizeRows(res, 24);
                } else {
                    QueryAclCheckTest.this.checkResultSizeNodes(res, 24);
                }
                return Boolean.TRUE;
            }
        });
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @Test
    public void testAclSetup() throws Exception {
        JCRTemplate.getInstance().doExecute(USER_NAME, "jcrQueryAclCheckTest", "default", Locale.ENGLISH, (JCRCallback)new JCRCallback<Boolean>(){

            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                Assert.assertTrue("Test node does not exist", session.nodeExists(QueryAclCheckTest.TEST_NODE_PATH));
                Assert.assertTrue("User should be able to read the node", session.nodeExists("/sites/jcrQueryAclCheckTest/contents/jcrQueryAclCheckTest/text-1"));
                Assert.assertTrue("User should be able to read the node", session.nodeExists("/sites/jcrQueryAclCheckTest/contents/jcrQueryAclCheckTest/sub-node-1"));
                Assert.assertTrue("User should be able to read the node", session.nodeExists("/sites/jcrQueryAclCheckTest/contents/jcrQueryAclCheckTest/sub-node-1/sub-text-1-3"));
                Assert.assertTrue("User should be able to read the node", session.nodeExists("/sites/jcrQueryAclCheckTest/contents/jcrQueryAclCheckTest/sub-node-2"));
                Assert.assertTrue("User should be able to read the node", session.nodeExists("/sites/jcrQueryAclCheckTest/contents/jcrQueryAclCheckTest/sub-node-2/sub-text-2-3"));
                Assert.assertTrue("User should be able to read the node", session.nodeExists("/sites/jcrQueryAclCheckTest/contents/jcrQueryAclCheckTest/sub-node-3"));
                Assert.assertTrue("User should be able to read the node", session.nodeExists("/sites/jcrQueryAclCheckTest/contents/jcrQueryAclCheckTest/sub-node-3/sub-text-3-3"));
                Assert.assertFalse("User should NOT be able to read the node", session.nodeExists("/sites/jcrQueryAclCheckTest/contents/jcrQueryAclCheckTest/sub-node-4"));
                Assert.assertFalse("User should NOT be able to read the node", session.nodeExists("/sites/jcrQueryAclCheckTest/contents/jcrQueryAclCheckTest/sub-node-4/sub-text-4-3"));
                return Boolean.TRUE;
            }
        });
    }

    @Test
    public void testSql2Nodes() throws Exception {
        this.performSql2Test(false);
    }

    @Test
    public void testSql2Rows() throws Exception {
        this.performSql2Test(false);
    }

    @Test
    public void testXpathNodes() throws Exception {
        boolean oldValue = JahiaQueryImpl.checkAclUuidInIndex;
        try {
            JahiaQueryImpl.checkAclUuidInIndex = false;
            this.performXpathTest(false);
        }
        finally {
            JahiaQueryImpl.checkAclUuidInIndex = oldValue;
        }
    }

    @Test
    public void testXpathNodesCheckAclUuidInIndex() throws Exception {
        boolean oldValue = JahiaQueryImpl.checkAclUuidInIndex;
        try {
            JahiaQueryImpl.checkAclUuidInIndex = true;
            this.performXpathTest(false);
        }
        finally {
            JahiaQueryImpl.checkAclUuidInIndex = oldValue;
        }
    }

    @Test
    public void testXpathRows() throws Exception {
        boolean oldValue = JahiaQueryImpl.checkAclUuidInIndex;
        try {
            JahiaQueryImpl.checkAclUuidInIndex = false;
            this.performXpathTest(true);
        }
        finally {
            JahiaQueryImpl.checkAclUuidInIndex = oldValue;
        }
    }

    @Test
    public void testXpathRowsCheckAclUuidInIndex() throws Exception {
        boolean oldValue = JahiaQueryImpl.checkAclUuidInIndex;
        try {
            JahiaQueryImpl.checkAclUuidInIndex = true;
            this.performXpathTest(true);
        }
        finally {
            JahiaQueryImpl.checkAclUuidInIndex = oldValue;
        }
    }
}

