/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.query;

import java.util.Locale;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.query.QueryWrapper;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryModificationTest {
    private static Logger logger = LoggerFactory.getLogger(QueryModificationTest.class);
    private static final String TESTSITE_NAME = "jcrQueryModificationTest";
    private static final String SITECONTENT_ROOT_NODE = "/sites/jcrQueryModificationTest";

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    try {
                        TestHelper.createSite(QueryModificationTest.TESTSITE_NAME, "localhost", "templates-web-blue");
                        session.save();
                    }
                    catch (Exception ex) {
                        logger.warn("Exception during site creation", (Throwable)ex);
                        Assert.fail("Exception during site creation");
                    }
                    return null;
                }
            });
        }
        catch (Exception ex) {
            logger.warn("Exception during test setUp", (Throwable)ex);
            Assert.fail();
        }
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSortingModification() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
        try {
            QueryManagerWrapper queryManager = session.getWorkspace().getQueryManager();
            if (queryManager != null) {
                String query = "SELECT * FROM [jnt:news] as news WHERE ISCHILDNODE(news, ['/sites/jcrQueryModificationTest/home/page8/news']) ORDER BY news.[jcr:title]";
                Query q = queryManager.createQuery(query, "JCR-SQL2");
                Assert.assertEquals("SELECT news.* FROM [jnt:news] AS news WHERE (NOT news.[j:isExternalProviderRoot] IS NOT NULL) AND ISCHILDNODE(news, ['/sites/jcrQueryModificationTest/home/page8/news']) AND news.[jcr:language] = 'en' ORDER BY news.[jcr:title]", ((Query)((QueryWrapper)q).getQueries().values().iterator().next()).getStatement());
                query = "SELECT news.* FROM [jnt:news] AS news WHERE ISCHILDNODE(news, ['/sites/jcrQueryModificationTest/home/page8/news']) AND news.[jcr:language] = 'en' ORDER BY news.[jcr:title]";
                q = queryManager.createQuery(query, "JCR-SQL2");
                Assert.assertEquals("SELECT news.* FROM [jnt:news] AS news WHERE (NOT news.[j:isExternalProviderRoot] IS NOT NULL) AND ISCHILDNODE(news, ['/sites/jcrQueryModificationTest/home/page8/news']) AND news.[jcr:language] = 'en' ORDER BY news.[jcr:title]", ((Query)((QueryWrapper)q).getQueries().values().iterator().next()).getStatement());
                query = "SELECT * FROM [jnt:news] as news WHERE ISCHILDNODE(news, ['/sites/jcrQueryModificationTest/home/page8/news']) ORDER BY news.[jcr:createdBy], news.[jcr:title], news.[jcr:created] desc";
                q = queryManager.createQuery(query, "JCR-SQL2");
                Assert.assertEquals("SELECT news.* FROM [jnt:news] AS news WHERE (NOT news.[j:isExternalProviderRoot] IS NOT NULL) AND ISCHILDNODE(news, ['/sites/jcrQueryModificationTest/home/page8/news']) AND news.[jcr:language] = 'en' ORDER BY news.[jcr:createdBy], news.[jcr:title], news.[jcr:created] DESC", ((Query)((QueryWrapper)q).getQueries().values().iterator().next()).getStatement());
                query = "SELECT news.* FROM [jnt:news] AS news WHERE ISCHILDNODE(news, ['/sites/jcrQueryModificationTest/home/page8/news']) AND news.[jcr:language] = 'en' ORDER BY news.[jcr:createdBy], news.[jcr:title], news.[jcr:created] DESC";
                q = queryManager.createQuery(query, "JCR-SQL2");
                Assert.assertEquals("SELECT news.* FROM [jnt:news] AS news WHERE (NOT news.[j:isExternalProviderRoot] IS NOT NULL) AND ISCHILDNODE(news, ['/sites/jcrQueryModificationTest/home/page8/news']) AND news.[jcr:language] = 'en' ORDER BY news.[jcr:createdBy], news.[jcr:title], news.[jcr:created] DESC", ((Query)((QueryWrapper)q).getQueries().values().iterator().next()).getStatement());
                query = "SELECT * FROM [jnt:news] as news WHERE ISCHILDNODE(news, ['/sites/jcrQueryModificationTest/home/page8/news']) ORDER BY news.[jcr:created] desc";
                q = queryManager.createQuery(query, "JCR-SQL2");
                Assert.assertEquals("SELECT news.* FROM [jnt:news] AS news WHERE (NOT news.[j:isExternalProviderRoot] IS NOT NULL) AND ISCHILDNODE(news, ['/sites/jcrQueryModificationTest/home/page8/news']) AND (NOT news.[jcr:language] IS NOT NULL OR news.[jcr:language] = 'en') ORDER BY news.[jcr:created] DESC", ((Query)((QueryWrapper)q).getQueries().values().iterator().next()).getStatement());
                query = "SELECT news.* FROM [jnt:news] AS news WHERE ISCHILDNODE(news, ['/sites/jcrQueryModificationTest/home/page8/news']) AND (NOT news.[jcr:language] IS NOT NULL OR news.[jcr:language] = 'en') ORDER BY news.[jcr:created] DESC";
                q = queryManager.createQuery(query, "JCR-SQL2");
                Assert.assertEquals("SELECT news.* FROM [jnt:news] AS news WHERE (NOT news.[j:isExternalProviderRoot] IS NOT NULL) AND ISCHILDNODE(news, ['/sites/jcrQueryModificationTest/home/page8/news']) AND (NOT (news.[jcr:language] IS NOT NULL OR news.[jcr:language] = 'en')) ORDER BY news.[jcr:created] DESC", ((Query)((QueryWrapper)q).getQueries().values().iterator().next()).getStatement());
            }
        }
        finally {
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPropertyComparison() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
        try {
            QueryManagerWrapper queryManager = session.getWorkspace().getQueryManager();
            if (queryManager != null) {
                String query = "SELECT * FROM [jnt:news] as news WHERE ISDESCENDANTNODE(news, ['/sites/jcrQueryModificationTest']) AND (length(news.[desc]) > 100 OR news.[date] > '+2001-01-01T01:02:03.000Z') ORDER BY news.[jcr:title]";
                Query q = queryManager.createQuery(query, "JCR-SQL2");
                Assert.assertEquals("SELECT news.* FROM [jnt:news] AS news WHERE (NOT news.[j:isExternalProviderRoot] IS NOT NULL) AND ISDESCENDANTNODE(news, ['/sites/jcrQueryModificationTest']) AND (LENGTH(news.desc) > CAST('100' AS LONG) OR news.date > '+2001-01-01T01:02:03.000Z') AND news.[jcr:language] = 'en' ORDER BY news.[jcr:title]", ((Query)((QueryWrapper)q).getQueries().values().iterator().next()).getStatement());
                query = "SELECT news.* FROM [jnt:news] AS news WHERE ISDESCENDANTNODE(news, ['/sites/jcrQueryModificationTest']) AND (LENGTH(news.desc) > 100 OR news.date > '+2001-01-01T01:02:03.000Z') AND news.[jcr:language] = 'en' ORDER BY news.[jcr:title]";
                q = queryManager.createQuery(query, "JCR-SQL2");
                Assert.assertEquals("SELECT news.* FROM [jnt:news] AS news WHERE (NOT news.[j:isExternalProviderRoot] IS NOT NULL) AND ISDESCENDANTNODE(news, ['/sites/jcrQueryModificationTest']) AND (LENGTH(news.desc) > CAST('100' AS LONG) OR news.date > '+2001-01-01T01:02:03.000Z') AND news.[jcr:language] = 'en' ORDER BY news.[jcr:title]", ((Query)((QueryWrapper)q).getQueries().values().iterator().next()).getStatement());
                query = "SELECT * FROM [jnt:news] as news WHERE ISDESCENDANTNODE(news, ['/sites/jcrQueryModificationTest']) AND (length(news.[j:nodename]) > 100 OR news.[date] > '+2001-01-01T01:02:03.000Z')";
                q = queryManager.createQuery(query, "JCR-SQL2");
                Assert.assertEquals("SELECT news.* FROM [jnt:news] AS news WHERE (NOT news.[j:isExternalProviderRoot] IS NOT NULL) AND ISDESCENDANTNODE(news, ['/sites/jcrQueryModificationTest']) AND (LENGTH(news.[j:nodename]) > CAST('100' AS LONG) OR news.date > '+2001-01-01T01:02:03.000Z') AND (NOT news.[jcr:language] IS NOT NULL OR news.[jcr:language] = 'en')", ((Query)((QueryWrapper)q).getQueries().values().iterator().next()).getStatement());
                query = "SELECT news.* FROM [jnt:news] AS news WHERE ISDESCENDANTNODE(news, ['/sites/jcrQueryModificationTest']) AND (LENGTH(news.[j:nodename]) > 100 OR news.[date] > '+2001-01-01T01:02:03.000Z') AND (NOT news.[jcr:language] IS NOT NULL OR news.[jcr:language] = 'en')";
                q = queryManager.createQuery(query, "JCR-SQL2");
                Assert.assertEquals("SELECT news.* FROM [jnt:news] AS news WHERE (NOT news.[j:isExternalProviderRoot] IS NOT NULL) AND ISDESCENDANTNODE(news, ['/sites/jcrQueryModificationTest']) AND (LENGTH(news.[j:nodename]) > CAST('100' AS LONG) OR news.date > '+2001-01-01T01:02:03.000Z') AND (NOT (news.[jcr:language] IS NOT NULL OR news.[jcr:language] = 'en'))", ((Query)((QueryWrapper)q).getQueries().values().iterator().next()).getStatement());
            }
        }
        finally {
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFulltextSearch() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
        try {
            QueryManagerWrapper queryManager = session.getWorkspace().getQueryManager();
            if (queryManager != null) {
                String query = "SELECT * FROM [jnt:news] as news WHERE contains(news.*, 'ACME') ORDER BY news.[date]";
                Query q = queryManager.createQuery(query, "JCR-SQL2");
                Assert.assertEquals("SELECT news.* FROM [jnt:news] AS news WHERE (NOT news.[j:isExternalProviderRoot] IS NOT NULL) AND CONTAINS(news.*, 'ACME') AND (NOT news.[jcr:language] IS NOT NULL OR news.[jcr:language] = 'en') ORDER BY news.date", ((Query)((QueryWrapper)q).getQueries().values().iterator().next()).getStatement());
                query = "SELECT news.* FROM [jnt:news] AS news WHERE CONTAINS(news.*, 'ACME') AND news.[jcr:language] = 'en' ORDER BY news.date";
                q = queryManager.createQuery(query, "JCR-SQL2");
                Assert.assertEquals("SELECT news.* FROM [jnt:news] AS news WHERE (NOT news.[j:isExternalProviderRoot] IS NOT NULL) AND CONTAINS(news.*, 'ACME') AND news.[jcr:language] = 'en' ORDER BY news.date", ((Query)((QueryWrapper)q).getQueries().values().iterator().next()).getStatement());
                query = "SELECT * FROM [jnt:news] as news WHERE contains(news.[jcr:title], 'ACME') ORDER BY news.[date]";
                q = queryManager.createQuery(query, "JCR-SQL2");
                Assert.assertEquals("SELECT news.* FROM [jnt:news] AS news WHERE (NOT news.[j:isExternalProviderRoot] IS NOT NULL) AND CONTAINS(news.[jcr:title], 'ACME') AND news.[jcr:language] = 'en' ORDER BY news.date", ((Query)((QueryWrapper)q).getQueries().values().iterator().next()).getStatement());
                query = "SELECT news.* FROM [jnt:news] AS news WHERE CONTAINS(news.[jcr:title], 'ACME') AND news.[jcr:language] = 'en' ORDER BY news.date";
                q = queryManager.createQuery(query, "JCR-SQL2");
                Assert.assertEquals("SELECT news.* FROM [jnt:news] AS news WHERE (NOT news.[j:isExternalProviderRoot] IS NOT NULL) AND CONTAINS(news.[jcr:title], 'ACME') AND news.[jcr:language] = 'en' ORDER BY news.date", ((Query)((QueryWrapper)q).getQueries().values().iterator().next()).getStatement());
                query = "SELECT * FROM [jnt:news] as news WHERE contains(news.[jcr:title], 'ACME') OR contains(news.[j:keywords], 'ACME') ORDER BY news.[date]";
                q = queryManager.createQuery(query, "JCR-SQL2");
                Assert.assertEquals("SELECT news.* FROM [jnt:news] AS news WHERE (NOT news.[j:isExternalProviderRoot] IS NOT NULL) AND (CONTAINS(news.[jcr:title], 'ACME') OR CONTAINS(news.[j:keywords], 'ACME')) AND news.[jcr:language] = 'en' ORDER BY news.date", ((Query)((QueryWrapper)q).getQueries().values().iterator().next()).getStatement());
                query = "SELECT news.* FROM [jnt:news] AS news WHERE (CONTAINS(news.[jcr:title], 'ACME') OR CONTAINS(news.[j:keywords], 'ACME')) AND news.[jcr:language] = 'en' ORDER BY news.date";
                q = queryManager.createQuery(query, "JCR-SQL2");
                Assert.assertEquals("SELECT news.* FROM [jnt:news] AS news WHERE (NOT news.[j:isExternalProviderRoot] IS NOT NULL) AND (CONTAINS(news.[jcr:title], 'ACME') OR CONTAINS(news.[j:keywords], 'ACME')) AND news.[jcr:language] = 'en' ORDER BY news.date", ((Query)((QueryWrapper)q).getQueries().values().iterator().next()).getStatement());
                query = "SELECT * FROM [jmix:keywords] as node WHERE contains(node.[j:keywords], 'ACME')";
                q = queryManager.createQuery(query, "JCR-SQL2");
            }
        }
        finally {
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithOtherLanguageSet() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
        try {
            QueryManagerWrapper queryManager = session.getWorkspace().getQueryManager();
            if (queryManager != null) {
                String query = "SELECT * FROM [jnt:news] as news WHERE ISCHILDNODE(news, ['/sites/jcrQueryModificationTest/home/page8/news']) AND news.[jcr:language] = 'fr' ORDER BY news.[jcr:title]";
                Query q = queryManager.createQuery(query, "JCR-SQL2");
                Assert.assertEquals("SELECT news.* FROM [jnt:news] AS news WHERE (NOT news.[j:isExternalProviderRoot] IS NOT NULL) AND ISCHILDNODE(news, ['/sites/jcrQueryModificationTest/home/page8/news']) AND news.[jcr:language] = 'fr' ORDER BY news.[jcr:title]", ((Query)((QueryWrapper)q).getQueries().values().iterator().next()).getStatement());
                query = "SELECT news.* FROM [jnt:news] AS news WHERE ISCHILDNODE(news, ['/sites/jcrQueryModificationTest/home/page8/news']) AND news.[jcr:language] = 'fr' ORDER BY news.[jcr:title]";
                q = queryManager.createQuery(query, "JCR-SQL2");
                Assert.assertEquals("SELECT news.* FROM [jnt:news] AS news WHERE (NOT news.[j:isExternalProviderRoot] IS NOT NULL) AND ISCHILDNODE(news, ['/sites/jcrQueryModificationTest/home/page8/news']) AND news.[jcr:language] = 'fr' ORDER BY news.[jcr:title]", ((Query)((QueryWrapper)q).getQueries().values().iterator().next()).getStatement());
            }
        }
        finally {
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithJoins() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
        try {
            QueryManagerWrapper queryManager = session.getWorkspace().getQueryManager();
            if (queryManager != null) {
                String query = "SELECT * FROM [jnt:news] as news INNER JOIN [jnt:category] AS categories ON news.[j:defaultCategory] = categories.[jcr:uuid] WHERE ISCHILDNODE(news, [/sites/jcrQueryModificationTest]) AND LOCALNAME(categories)='test' ORDER BY news.[jcr:title]";
                Query q = queryManager.createQuery(query, "JCR-SQL2");
                Assert.assertEquals("SELECT news.*, categories.* FROM [jnt:news] AS news INNER JOIN [jnt:category] AS categories ON news.[j:defaultCategory] = categories.[jcr:uuid] WHERE ISCHILDNODE(news, [/sites/jcrQueryModificationTest]) AND LOCALNAME(categories) = 'test' AND news.[jcr:language] = 'en' ORDER BY news.[jcr:title]", ((Query)((QueryWrapper)q).getQueries().values().iterator().next()).getStatement());
                query = "SELECT news.*, categories.* FROM [jnt:news] AS news INNER JOIN [jnt:category] AS categories ON news.[j:defaultCategory] = categories.[jcr:uuid] WHERE ISCHILDNODE(news, [/sites/jcrQueryModificationTest]) AND LOCALNAME(categories) = 'test' AND news.[jcr:language] = 'en' ORDER BY news.[jcr:title]";
                q = queryManager.createQuery(query, "JCR-SQL2");
                Assert.assertEquals("SELECT news.*, categories.* FROM [jnt:news] AS news INNER JOIN [jnt:category] AS categories ON news.[j:defaultCategory] = categories.[jcr:uuid] WHERE ISCHILDNODE(news, [/sites/jcrQueryModificationTest]) AND LOCALNAME(categories) = 'test' AND news.[jcr:language] = 'en' ORDER BY news.[jcr:title]", ((Query)((QueryWrapper)q).getQueries().values().iterator().next()).getStatement());
            }
        }
        finally {
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithReferences() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
        try {
            QueryManagerWrapper queryManager = session.getWorkspace().getQueryManager();
            if (queryManager != null) {
                String query = "select press.* from [jnt:press] as press left outer join [nt:file] as file on press.pdfVersion = file.[jcr:uuid] inner join [nt:resource] as filecontent on ischildnode(filecontent, file) where contains(filecontent.*, 'ACME') or contains(press.*, 'ACME') order by press.[date] desc";
                Query q = queryManager.createQuery(query, "JCR-SQL2");
                Assert.assertEquals("SELECT press.* FROM [jnt:press] AS press LEFT OUTER JOIN [nt:file] AS file ON press.pdfVersion = file.[jcr:uuid] INNER JOIN [nt:resource] AS filecontent ON ISCHILDNODE(filecontent, file) WHERE (CONTAINS(filecontent.*, 'ACME') OR CONTAINS(press.*, 'ACME')) AND press.[jcr:language] = 'en' ORDER BY press.date DESC", ((Query)((QueryWrapper)q).getQueries().values().iterator().next()).getStatement());
                query = "SELECT press.* FROM [jnt:press] AS press LEFT OUTER JOIN [nt:file] AS file ON press.pdfVersion = file.[jcr:uuid] INNER JOIN [nt:resource] AS filecontent ON ISCHILDNODE(filecontent, file) WHERE (CONTAINS(filecontent.*, 'ACME') OR CONTAINS(press.*, 'ACME')) AND press.[jcr:language] = 'en' ORDER BY press.date DESC";
                q = queryManager.createQuery(query, "JCR-SQL2");
                Assert.assertEquals("SELECT press.* FROM [jnt:press] AS press LEFT OUTER JOIN [nt:file] AS file ON press.pdfVersion = file.[jcr:uuid] INNER JOIN [nt:resource] AS filecontent ON ISCHILDNODE(filecontent, file) WHERE (CONTAINS(filecontent.*, 'ACME') OR CONTAINS(press.*, 'ACME')) AND press.[jcr:language] = 'en' ORDER BY press.date DESC", ((Query)((QueryWrapper)q).getQueries().values().iterator().next()).getStatement());
            }
        }
        finally {
            session.save();
        }
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
            if (session.nodeExists(SITECONTENT_ROOT_NODE)) {
                TestHelper.deleteSite(TESTSITE_NAME);
            }
            session.save();
            session.logout();
        }
        catch (Exception ex) {
            logger.warn("Exception during test tearDown", (Throwable)ex);
        }
    }
}

