/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.query;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.util.ISO8601;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.query.QueryResultWrapper;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.sites.JahiaSite;
import org.jahia.test.TestHelper;
import org.jahia.utils.LanguageCodeConverters;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryResultTest {
    private static Logger logger = LoggerFactory.getLogger(QueryResultTest.class);
    private static String DEFAULT_LANGUAGE = "en";
    private static final String TESTSITE_NAME = "jcrQueryTest";
    private static final String SITECONTENT_ROOT_NODE = "/sites/jcrQueryTest";
    private static final String XPATH_SITECONTENT_ROOT_NODE = "/jcr:root/sites/jcrQueryTest";
    private static final String NEWS_NAME_PREFIX = "news_";
    private static final String MEETING = "meeting";
    private static final String CONSUMER_SHOW = "consumerShow";
    private static final String ROAD_SHOW = "roadShow";
    private static final String CONFERENCE = "conference";
    private static final String SHOW = "show";
    private static final String PRESS_CONFERENCE = "pressConference";
    private static final String PARIS = "paris";
    private static final String GENEVA = "geneva";
    private static final int NOT_CHILD_CHECK = 1;
    private static final int NOT_DESCENDANT_CHECK = 2;
    private static final String FIRST_PHONE_SENTENCE = "The horse doesn't eat cucumber salad";
    private static final String FIRST_TELEGRAPH_SENTENCE = "What hath God wrought?";

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        JahiaSite site = TestHelper.createSite(TESTSITE_NAME);
        Assert.assertNotNull(site);
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE));
        QueryResultTest.initContent(session);
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        TestHelper.deleteSite(TESTSITE_NAME);
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @Test
    public void testChildNodeQueries() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE));
        QueryResultWrapper res = this.doQuery(session, "SELECT * FROM [jnt:news] as news WHERE ISCHILDNODE(news, [/sites/jcrQueryTest/contents/news]) ORDER BY news.[jcr:title]", "JCR-SQL2");
        this.checkResultSize(res, 16);
        res = this.doQuery(session, "SELECT * FROM [jmix:editorialContent] as content WHERE ISCHILDNODE(content, [/sites/jcrQueryTest/contents/news]) OR ISCHILDNODE(content, [/sites/jcrQueryTest/contents/events]) ORDER BY content.[jcr:title]", "JCR-SQL2");
        this.checkResultSize(res, 43);
        res = this.doQuery(session, "SELECT * FROM [jmix:editorialContent] as content WHERE NOT ISCHILDNODE(content, [/sites/jcrQueryTest/contents/news]) ORDER BY content.[jcr:title]", "JCR-SQL2");
        int size = this.checkHierarchy(res, 1, "/sites/jcrQueryTest/contents/news");
        res = this.doQuery(session, "SELECT * FROM [jmix:editorialContent] as content WHERE NOT (ISCHILDNODE(content, [/sites/jcrQueryTest/contents/events]) OR ISCHILDNODE(content, [/sites/jcrQueryTest/contents/news])) ORDER BY content.[jcr:title]", "JCR-SQL2");
        int size2 = this.checkHierarchy(res, 1, "/sites/jcrQueryTest/contents/events", "/sites/jcrQueryTest/contents/news");
        Assert.assertEquals("Difference between result sizes is wrong.", 27L, size - size2);
        res = this.doQuery(session, "SELECT * FROM [jmix:editorialContent] as content WHERE ISDESCENDANTNODE(content, [/sites/jcrQueryTest/contents]) AND NOT ISCHILDNODE(content, [/sites/jcrQueryTest/contents/events]) ORDER BY content.[jcr:title]", "JCR-SQL2");
        this.checkResultSize(res, 23);
        res = this.doQuery(session, "SELECT * FROM [jmix:editorialContent] as content WHERE ISCHILDNODE(content, [/sites/jcrQueryTest/contents/news]) AND content.[jcr:title] LIKE 'news_1%'", "JCR-SQL2");
        this.checkResultSize(res, 7);
        res = this.doQuery(session, "SELECT * FROM [jmix:editorialContent] as content WHERE ISCHILDNODE(content, [/sites/jcrQueryTest/contents/news]) AND contains(content.*, 'cucumber')", "JCR-SQL2");
        this.checkResultSize(res, 10);
    }

    @Test
    public void testChildNodeXPathQueries() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE));
        QueryResultWrapper res = this.doQuery(session, "/jcr:root/sites/jcrQueryTest/contents/news/element(*, jnt:news) order by @jcr:title", "xpath");
        this.checkResultSize(res, 16);
        res = this.doQuery(session, "/jcr:root/sites/jcrQueryTest/contents/*[fn:name() = 'news' or fn:name() = 'events']/element(*, jmix:editorialContent) order by @jcr:title", "xpath");
        this.checkResultSize(res, 43);
        res = this.doQuery(session, "/jcr:root/sites/jcrQueryTest/contents/news/element(*, jmix:editorialContent)[@date = '" + ISO8601.format((Calendar)new GregorianCalendar(2000, 0, 1, 12, 0)) + "']", "xpath");
        this.checkResultSize(res, 2);
        res = this.doQuery(session, "/jcr:root/sites/jcrQueryTest/contents/news/element(*, jmix:editorialContent)[jcr:contains(., 'cucumber') or jcr:contains(j:translation_en, 'cucumber')]", "xpath");
        this.checkResultSize(res, 10);
    }

    @Test
    public void testDescendantNodeQueries() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE));
        QueryResultWrapper res = this.doQuery(session, "SELECT * FROM [jnt:news] as news WHERE ISDESCENDANTNODE(news, [/sites/jcrQueryTest/contents/news]) ORDER BY news.[jcr:title]", "JCR-SQL2");
        this.checkResultSize(res, 23);
        res = this.doQuery(session, "SELECT * FROM [jmix:editorialContent] as content WHERE ISDESCENDANTNODE(content, [/sites/jcrQueryTest/contents/news]) OR ISDESCENDANTNODE(content, [/sites/jcrQueryTest/contents/events]) ORDER BY content.[jcr:title]", "JCR-SQL2");
        this.checkResultSize(res, 50);
        res = this.doQuery(session, "SELECT * FROM [jmix:editorialContent] as content WHERE NOT ISDESCENDANTNODE(content, [/sites/jcrQueryTest/contents/news]) ORDER BY content.[jcr:title]", "JCR-SQL2");
        int size = this.checkHierarchy(res, 2, "/sites/jcrQueryTest/contents/news");
        res = this.doQuery(session, "SELECT * FROM [jmix:editorialContent] as content WHERE NOT (ISDESCENDANTNODE(content, [/sites/jcrQueryTest/contents/events]) OR ISDESCENDANTNODE(content, [/sites/jcrQueryTest/contents/news])) ORDER BY content.[jcr:title]", "JCR-SQL2");
        int size2 = this.checkHierarchy(res, 2, "/sites/jcrQueryTest/contents/events", "/sites/jcrQueryTest/contents/news");
        Assert.assertEquals("Difference between result sizes is wrong.", 27L, size - size2);
        res = this.doQuery(session, "SELECT * FROM [jmix:editorialContent] as content WHERE ISDESCENDANTNODE(content, [/sites/jcrQueryTest/contents]) AND NOT ISDESCENDANTNODE(content, [/sites/jcrQueryTest/contents/news]) ORDER BY content.[jcr:title]", "JCR-SQL2");
        this.checkResultSize(res, 27);
        res = this.doQuery(session, "SELECT * FROM [jmix:editorialContent] as content WHERE ISDESCENDANTNODE(content, [/sites/jcrQueryTest/contents/news]) AND content.[jcr:title] LIKE 'news_1%'", "JCR-SQL2");
        this.checkResultSize(res, 11);
        res = this.doQuery(session, "SELECT * FROM [jmix:editorialContent] as content WHERE ISDESCENDANTNODE(content, [/sites/jcrQueryTest/contents/news]) AND contains(content.*, 'cucumber')", "JCR-SQL2");
        this.checkResultSize(res, 13);
        res = this.doQuery(session, "SELECT * FROM [jmix:editorialContent] as content WHERE (ISCHILDNODE(content, [/sites/jcrQueryTest/contents/news]) AND content.[jcr:title] LIKE 'news_1%') OR (ISDESCENDANTNODE(content, [/sites/jcrQueryTest/contents/events]) AND content.[location] = 'geneva')", "JCR-SQL2");
        this.checkResultSize(res, 19);
    }

    @Test
    public void testDescendantNodeXPathQueries() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE));
        QueryResultWrapper res = this.doQuery(session, "/jcr:root/sites/jcrQueryTest/contents/news//element(*, jnt:news) [@jcr:language = 'en'] order by @jcr:title", "xpath");
        this.checkResultSize(res, 23);
        res = this.doQuery(session, "/jcr:root/sites/jcrQueryTest/contents/*[fn:name() = 'news' or fn:name() = 'events']//element(*, jmix:editorialContent) [@jcr:language = 'en'] order by @jcr:title", "xpath");
        this.checkResultSize(res, 50);
        res = this.doQuery(session, "/jcr:root/sites/jcrQueryTest/contents/news//element(*, jmix:editorialContent)[not(@jcr:language) and @date = '" + ISO8601.format((Calendar)new GregorianCalendar(2000, 0, 1, 12, 0)) + "']", "xpath");
        this.checkResultSize(res, 5);
        res = this.doQuery(session, "/jcr:root/sites/jcrQueryTest/contents/news//element(*, jmix:editorialContent) [@jcr:language = 'en' and jcr:contains(., 'cucumber')]", "xpath");
        this.checkResultSize(res, 13);
    }

    private int checkHierarchy(QueryResultWrapper res, int check, String ... pathes) throws RepositoryException {
        int size = 0;
        JCRNodeIteratorWrapper ni = res.getNodes();
        while (ni.hasNext()) {
            JCRNodeWrapper node = (JCRNodeWrapper)ni.next();
            for (String path : pathes) {
                if (check == 1) {
                    Assert.assertFalse("There is a child node in the result, which should not be there: " + node.getParent().getPath(), node.getParent().getPath().equals(path));
                    continue;
                }
                if (check != 2) continue;
                Assert.assertFalse("There is a descendant node in the result, which should not be there: " + node.getPath(), node.getPath().startsWith(path));
            }
            ++size;
        }
        return size;
    }

    private static void initContent(JCRSessionWrapper session) throws RepositoryException {
        int i = 0;
        GregorianCalendar calendar = new GregorianCalendar(2000, 0, 1, 12, 0);
        JCRNodeWrapper cats = session.getNode("/sites/systemsite/categories");
        if (!cats.hasNode("cat1")) {
            cats.addNode("cat1", "jnt:category");
        }
        if (!cats.hasNode("cat2")) {
            cats.addNode("cat2", "jnt:category");
        }
        if (!cats.hasNode("cat3")) {
            cats.addNode("cat3", "jnt:category");
        }
        JCRNodeWrapper cat1 = cats.getNode("cat1");
        JCRNodeWrapper cat2 = cats.getNode("cat2");
        JCRNodeWrapper cat3 = cats.getNode("cat3");
        JCRNodeWrapper contentNode = session.getNode("/sites/jcrQueryTest/contents");
        session.getWorkspace().getVersionManager().checkout(contentNode.getPath());
        JCRNodeWrapper node = QueryResultTest.createList(contentNode, "events");
        QueryResultTest.createEvent(node, MEETING, PARIS, calendar, cat1, i++);
        QueryResultTest.createEvent(node, MEETING, GENEVA, calendar, cat1, i++);
        ((Calendar)calendar).add(5, 5);
        QueryResultTest.createEvent(node, CONSUMER_SHOW, PARIS, calendar, cat1, i++);
        QueryResultTest.createEvent(node, CONSUMER_SHOW, PARIS, calendar, cat1, i++);
        ((Calendar)calendar).add(5, 5);
        QueryResultTest.createEvent(node, CONSUMER_SHOW, GENEVA, calendar, cat1, i++);
        QueryResultTest.createEvent(node, ROAD_SHOW, PARIS, calendar, cat2, i++);
        ((Calendar)calendar).add(5, 5);
        QueryResultTest.createEvent(node, ROAD_SHOW, PARIS, calendar, cat2, i++);
        QueryResultTest.createEvent(node, ROAD_SHOW, GENEVA, calendar, cat2, i++);
        ((Calendar)calendar).add(5, 5);
        QueryResultTest.createEvent(node, ROAD_SHOW, GENEVA, calendar, cat2, i++);
        QueryResultTest.createEvent(node, CONFERENCE, PARIS, calendar, cat2, i++);
        ((Calendar)calendar).add(5, 5);
        QueryResultTest.createEvent(node, CONFERENCE, PARIS, calendar, cat2, i++);
        QueryResultTest.createEvent(node, CONFERENCE, PARIS, calendar, cat3, i++);
        ((Calendar)calendar).add(5, 5);
        QueryResultTest.createEvent(node, CONFERENCE, GENEVA, calendar, cat3, i++);
        QueryResultTest.createEvent(node, CONFERENCE, GENEVA, calendar, cat3, i++);
        ((Calendar)calendar).add(5, 5);
        QueryResultTest.createEvent(node, SHOW, PARIS, calendar, cat3, i++);
        QueryResultTest.createEvent(node, SHOW, PARIS, calendar, cat3, i++);
        ((Calendar)calendar).add(5, 5);
        QueryResultTest.createEvent(node, SHOW, PARIS, calendar, cat3, i++);
        QueryResultTest.createEvent(node, SHOW, GENEVA, calendar, cat3, i++);
        QueryResultTest.createEvent(node, SHOW, GENEVA, calendar, cat3, i++);
        QueryResultTest.createEvent(node, SHOW, GENEVA, calendar, cat3, i++);
        QueryResultTest.createEvent(node, SHOW, GENEVA, calendar, cat3, i++);
        QueryResultTest.createEvent(node, PRESS_CONFERENCE, PARIS, calendar, cat3, i++);
        QueryResultTest.createEvent(node, PRESS_CONFERENCE, PARIS, calendar, cat3, i++);
        QueryResultTest.createEvent(node, PRESS_CONFERENCE, PARIS, calendar, cat3, i++);
        QueryResultTest.createEvent(node, PRESS_CONFERENCE, PARIS, calendar, cat3, i++);
        QueryResultTest.createEvent(node, PRESS_CONFERENCE, GENEVA, calendar, cat3, i++);
        QueryResultTest.createEvent(node, PRESS_CONFERENCE, GENEVA, calendar, cat3, i++);
        JCRNodeWrapper newsListNode = QueryResultTest.createList(contentNode, "news");
        calendar = new GregorianCalendar(2000, 0, 1, 12, 0);
        i = 0;
        QueryResultTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_PHONE_SENTENCE, calendar, cat1);
        QueryResultTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_TELEGRAPH_SENTENCE, calendar, cat1);
        ((Calendar)calendar).add(5, 5);
        QueryResultTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_PHONE_SENTENCE, calendar, cat1);
        QueryResultTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_PHONE_SENTENCE, calendar, cat1);
        ((Calendar)calendar).add(5, 5);
        QueryResultTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_TELEGRAPH_SENTENCE, calendar, cat1);
        QueryResultTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_PHONE_SENTENCE, calendar, cat2);
        ((Calendar)calendar).add(5, 5);
        QueryResultTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_PHONE_SENTENCE, calendar, cat2);
        QueryResultTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_TELEGRAPH_SENTENCE, calendar, cat2);
        ((Calendar)calendar).add(5, 5);
        QueryResultTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_TELEGRAPH_SENTENCE, calendar, cat2);
        QueryResultTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_PHONE_SENTENCE, calendar, cat2);
        ((Calendar)calendar).add(5, 5);
        QueryResultTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_PHONE_SENTENCE, calendar, cat2);
        QueryResultTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_PHONE_SENTENCE, calendar, cat3);
        ((Calendar)calendar).add(5, 5);
        QueryResultTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_TELEGRAPH_SENTENCE, calendar, cat3);
        QueryResultTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_TELEGRAPH_SENTENCE, calendar, cat3);
        ((Calendar)calendar).add(5, 5);
        QueryResultTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_PHONE_SENTENCE, calendar, cat3);
        QueryResultTest.createNews(newsListNode, NEWS_NAME_PREFIX + i++, FIRST_PHONE_SENTENCE, calendar, cat3);
        JCRNodeWrapper newsSubListNode = QueryResultTest.createList(newsListNode, "news");
        ((Calendar)calendar).add(5, 5);
        QueryResultTest.createNews(newsSubListNode, NEWS_NAME_PREFIX + i++, FIRST_PHONE_SENTENCE, calendar, cat3);
        QueryResultTest.createNews(newsSubListNode, NEWS_NAME_PREFIX + i++, FIRST_TELEGRAPH_SENTENCE, calendar, cat3);
        QueryResultTest.createNews(newsSubListNode, NEWS_NAME_PREFIX + i++, FIRST_TELEGRAPH_SENTENCE, calendar, cat3);
        QueryResultTest.createNews(newsSubListNode, NEWS_NAME_PREFIX + i++, FIRST_TELEGRAPH_SENTENCE, calendar, cat3);
        calendar = new GregorianCalendar(2000, 0, 1, 12, 0);
        QueryResultTest.createNews(newsSubListNode, NEWS_NAME_PREFIX + i++, FIRST_TELEGRAPH_SENTENCE, calendar, cat3);
        QueryResultTest.createNews(newsSubListNode, NEWS_NAME_PREFIX + i++, FIRST_PHONE_SENTENCE, calendar, cat3);
        QueryResultTest.createNews(newsSubListNode, NEWS_NAME_PREFIX + i++, FIRST_PHONE_SENTENCE, calendar, cat3);
        session.save();
    }

    private QueryResultWrapper doQuery(JCRSessionWrapper session, String statement, String language) throws RepositoryException {
        if (logger.isDebugEnabled()) {
            logger.debug("Query: " + statement);
        }
        QueryWrapper query = session.getWorkspace().getQueryManager().createQuery(statement, language);
        QueryResultWrapper res = (QueryResultWrapper)query.execute();
        return res;
    }

    private void checkResultSize(QueryResultWrapper res, int expected) throws RepositoryException {
        JCRNodeIteratorWrapper ni = res.getNodes();
        ArrayList<JCRNodeWrapper> results = new ArrayList<JCRNodeWrapper>();
        while (ni.hasNext()) {
            results.add((JCRNodeWrapper)ni.next());
        }
        if (logger.isDebugEnabled()) {
            String newLine = System.getProperty("line.separator");
            StringBuffer debugMessage = new StringBuffer("Results: ").append(newLine);
            for (JCRNodeWrapper result : results) {
                debugMessage.append(result.getPath()).append(newLine);
            }
            logger.debug(debugMessage.toString());
        }
        Assert.assertEquals("", expected, results.size());
    }

    private static JCRNodeWrapper createList(JCRNodeWrapper node, String name) throws RepositoryException {
        JCRNodeWrapper list = node.addNode(name, "jnt:contentList");
        list.setProperty("jcr:title", name);
        return list;
    }

    private static JCRNodeWrapper createEvent(JCRNodeWrapper node, String eventType, String location, Calendar calendar, JCRNodeWrapper category, int i) throws RepositoryException {
        String name = eventType + i;
        JCRNodeWrapper event = node.addNode(name, "jnt:event");
        event.setProperty("jcr:title", name);
        event.setProperty("eventsType", eventType);
        event.setProperty("location", location);
        event.setProperty("startDate", calendar);
        event.addMixin("jmix:categorized");
        event.setProperty("j:defaultCategory", new Value[]{event.getSession().getValueFactory().createValue((Node)category)});
        return event;
    }

    private static JCRNodeWrapper createNews(JCRNodeWrapper node, String name, String desc, Calendar calendar, JCRNodeWrapper category) throws RepositoryException {
        JCRNodeWrapper event = node.addNode(name, "jnt:news");
        event.setProperty("jcr:title", name);
        event.setProperty("desc", desc);
        event.setProperty("date", calendar);
        event.addMixin("jmix:categorized");
        event.setProperty("j:defaultCategory", new Value[]{event.getSession().getValueFactory().createValue((Node)category)});
        return event;
    }
}

