/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.render;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.Jahia;
import org.jahia.settings.SettingsBean;
import org.jahia.test.JahiaTestCase;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSessionIDTest
extends JahiaTestCase {
    private static Logger logger = LoggerFactory.getLogger(JSessionIDTest.class);
    private HttpClient httpClient;
    private String jsessionid;
    private static boolean isJsessionIdActive;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        isJsessionIdActive = SettingsBean.getInstance().isDisableJsessionIdParameter();
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        SettingsBean.getInstance().setDisableJsessionIdParameter(isJsessionIdActive);
    }

    @Before
    public void setUp() {
        this.httpClient = new HttpClient();
        this.httpClient.getParams().setCookiePolicy("ignoreCookies");
        this.jsessionid = "jsessionid";
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testJsessionIdExists() throws Exception {
        this.findJSessionId(false);
    }

    @Test
    public void testJsessionIdRemoved() throws Exception {
        this.findJSessionId(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findJSessionId(boolean removeJsessionId) throws IOException {
        SettingsBean.getInstance().setDisableJsessionIdParameter(removeJsessionId);
        SettingsBean.getInstance().setJsessionIdParameterName(this.jsessionid);
        GetMethod displayLoginMethod = new GetMethod(this.getBaseServerURL() + Jahia.getContextPath() + "/start");
        try {
            int statusCode = this.httpClient.executeMethod((HttpMethod)displayLoginMethod);
            Assert.assertEquals("Method failed: " + displayLoginMethod.getStatusLine(), 401L, statusCode);
            String responseBodyAsString = displayLoginMethod.getResponseBodyAsString();
            Pattern p = Pattern.compile("action=\"([^\"]*)\"");
            Matcher m = p.matcher(responseBodyAsString);
            Assert.assertTrue(m.find());
            String url = m.group(1);
            if (!removeJsessionId) {
                logger.info("Unencoded URL: " + this.getBaseServerURL() + Jahia.getContextPath() + "/start");
                logger.info("Encoded redirect URL: " + JSessionIDTest.getResponse().encodeRedirectURL(this.getBaseServerURL() + Jahia.getContextPath() + "/start"));
                logger.info("Encoded URL: " + JSessionIDTest.getResponse().encodeURL(this.getBaseServerURL() + Jahia.getContextPath() + "/start"));
            }
            Assert.assertEquals("jsession ID is not " + (removeJsessionId ? "removed" : "present") + " in administration login url:" + url, removeJsessionId, !StringUtils.containsIgnoreCase((String)url, (String)this.jsessionid));
        }
        finally {
            displayLoginMethod.releaseConnection();
        }
    }
}

