/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.render;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.Jahia;
import org.jahia.params.valves.CookieAuthConfig;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginPageHttpTest
extends JahiaTestCase {
    private static String aboutUsPageUrl;
    private static Logger logger;
    private static final String PASSWORD = "password";
    private static JCRPublicationService publicationService;
    private static JahiaSite site;
    private static final String SITE_NAME = "loginPageHttpTest";
    private static final String SITE_PATH = "/sites/loginPageHttpTest";
    private static final String USERNAME = "loginPageHttpTestUser";

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        site = TestHelper.createSite(SITE_NAME);
        Assert.assertNotNull(site);
        publicationService = ServicesRegistry.getInstance().getJCRPublicationService();
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
        Properties properties = new Properties();
        properties.setProperty("j:firstName", "John");
        properties.setProperty("j:lastName", "Doe");
        ServicesRegistry.getInstance().getJahiaUserManagerService().createUser(USERNAME, PASSWORD, properties, session);
        session.getNode("/sites/" + site.getSiteKey()).denyRoles("u:guest", Collections.singleton("reader"));
        session.save();
        publicationService.publishByMainId(session.getNode(SITE_PATH).getIdentifier(), "default", "live", null, true, null);
        JCRSessionWrapper enSession = JCRSessionFactory.getInstance().getCurrentUserSession(null, Locale.ENGLISH);
        JCRNodeWrapper page = enSession.getNode("/sites/loginPageHttpTest/home").addNode("about-us", "jnt:page");
        page.setProperty("j:templateName", "simple");
        page.setProperty("jcr:title", "About Us");
        enSession.save();
        publicationService.publishByMainId(enSession.getNode(SITE_PATH).getIdentifier(), "default", "live", null, true, null);
        aboutUsPageUrl = "/cms/render/live/en/sites/loginPageHttpTest/home/about-us.html";
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        try {
            TestHelper.deleteSite(SITE_NAME);
        }
        catch (Exception ex) {
            logger.warn("Exception during test oneTimeTearDown", (Throwable)ex);
        }
        JahiaUserManagerService userManagerService = ServicesRegistry.getInstance().getJahiaUserManagerService();
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
        userManagerService.deleteUser(userManagerService.lookupUser(USERNAME).getPath(), session);
        session.save();
    }

    protected Cookie getCookie(String cookieName) {
        for (Cookie c : this.getHttpClient().getState().getCookies()) {
            if (!cookieName.equals(c.getName())) continue;
            return c;
        }
        return null;
    }

    @After
    public void tearDown() throws Exception {
        this.logout();
    }

    @Test
    public void testInvalidPassword() throws Exception {
        String content = this.getAsText("/cms/login?username=loginPageHttpTestUser&password=password_invalid&redirect=" + Jahia.getContextPath() + aboutUsPageUrl);
        Assert.assertTrue("Should see a login page with invalid password error", content.contains("name=\"loginForm\"") && content.contains("Invalid username/password"));
    }

    @Test
    public void testNoGuestAccess() throws Exception {
        String content = this.getAsText(aboutUsPageUrl, 401);
        Assert.assertTrue("Guest can access the home page, which should not be the case", content.contains("name=\"loginForm\""));
    }

    @Test
    public void testNormalLogin() throws Exception {
        String content = this.getAsText("/cms/login?username=loginPageHttpTestUser&password=password&redirect=" + Jahia.getContextPath() + aboutUsPageUrl);
        Assert.assertTrue("After normal login the user should see the About Us page", content.contains("<title>About Us</title>"));
    }

    @Test
    public void testRememberMe() throws Exception {
        CookieAuthConfig cookieAuthConfig = (CookieAuthConfig)SpringContextSingleton.getBean((String)"cookieAuthConfig");
        HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
        this.getAsText("/cms/login?username=loginPageHttpTestUser&password=password&restMode=true&useCookie=on", null, 200, responseHeaders);
        String cookieName = cookieAuthConfig.getCookieName();
        List setCookie = (List)responseHeaders.get("Set-Cookie");
        Iterator cookieValueIteraror = setCookie != null ? Iterables.filter((Iterable)setCookie, (Predicate)Predicates.containsPattern((String)(cookieName + "="))).iterator() : null;
        Assert.assertTrue("The response header should contain the corresponding remember me cookie " + cookieName, cookieValueIteraror != null && cookieValueIteraror.hasNext());
        String cookieValue = StringUtils.substringBetween((String)((String)cookieValueIteraror.next()), (String)(cookieName + "="), (String)";");
        Cookie authCookie = this.getCookie(cookieName);
        Assert.assertNotNull("Remember me cookie is not present in HTTP client state", authCookie);
        Assert.assertEquals("Remember me cookie has wrong value in HTTP client state", cookieValue, authCookie.getValue());
        String content = this.getAsText(aboutUsPageUrl);
        Assert.assertTrue("After normal login the user should see the About Us page", content.contains("<title>About Us</title>"));
        this.getHttpClient().getState().clearCookies();
        content = this.getAsText(aboutUsPageUrl, 401);
        Assert.assertTrue("Guest can access the home page, which should not be the case", content.contains("name=\"loginForm\""));
        this.getHttpClient().getState().addCookie(authCookie);
        content = this.getAsText(aboutUsPageUrl);
        Assert.assertTrue("With a remember me cookie the login should be done automatically and the user should see the About Us page", content.contains("<title>About Us</title>"));
    }

    @Test
    public void testRootLogin() throws Exception {
        String content = this.getAsText("/cms/login?username=root&password=root1234&redirect=" + Jahia.getContextPath() + "/cms/admin/default/en/settings.aboutJahia.html");
        Assert.assertTrue("After login the root user should see the about page in the administration", content.contains("<title>Edit</title>") && content.contains("template=\"aboutJahia\""));
    }

    @Test
    public void testXssOnRedirect() throws Exception {
        String content = this.getAsText("/cms/login?redirect=%2fsites%2fwhatever%22%3C%2Fscript%3E%3Cscript%3Ealert(%27xss%27)%3C%2Fscript%3E");
        Assert.assertFalse("<script> element should not be in the page output", content.contains("<script>alert('xss')</script>"));
    }

    static {
        logger = LoggerFactory.getLogger(LoginPageHttpTest.class);
    }
}

