/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.render;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.RenderService;
import org.jahia.services.render.Resource;
import org.jahia.services.render.TemplateNotFoundException;
import org.jahia.services.render.scripting.Script;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.ModuleTestHelper;
import org.jahia.test.TestHelper;
import org.jahia.utils.ScriptEngineUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class MultiScriptingTest
extends JahiaTestCase {
    private static final String TESTSITE_NAME = "multiscriptingtest";
    private static final JahiaTemplateManagerService managerService = ServicesRegistry.getInstance().getJahiaTemplateManagerService();
    private static final String JNT_THYMELEAF_NODE = "jnt:thymeleafNode";
    private static final String SCRIPTLANGUAGES_THYMELEAF = "scriptlanguages-thymeleaf";
    private static final String SCRIPTLANGUAGES_THYMELEAF_EXAMPLES = "scriptlanguages-thymeleaf-examples";
    private static JCRNodeWrapper page;
    private static JCRNodeWrapper home;
    private static final Map<String, String> moduleToVersion;

    @BeforeClass
    public static void oneTimeSetup() throws Exception {
        MultiScriptingTest.deployAndWait("templates-web");
        JahiaSite site = TestHelper.createSite(TESTSITE_NAME);
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
        JCRNodeWrapper siteNode = session.getNode("/sites/" + site.getSiteKey());
        home = siteNode.getNode("home");
        MultiScriptingTest.recreateAndPublishTestPage(session);
    }

    private static void recreateAndPublishTestPage(JCRSessionWrapper session) throws RepositoryException {
        String test = "test";
        if (home.hasNode("test")) {
            home.getNode("test").remove();
        }
        page = home.addNode("test", "jnt:page");
        page.setProperty("jcr:title", "test");
        page.setProperty("j:templateName", "simple");
        session.save();
        MultiScriptingTest.publish(home.getIdentifier());
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        TestHelper.deleteSite(TESTSITE_NAME);
        MultiScriptingTest.undeployAndWait("templates-web");
    }

    @Before
    public void setUp() throws RepositoryException {
        MultiScriptingTest.recreateAndPublishTestPage(JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH));
    }

    @After
    public void tearDown() throws RepositoryException {
        MultiScriptingTest.undeployAndWait(SCRIPTLANGUAGES_THYMELEAF);
        MultiScriptingTest.undeployAndWait(SCRIPTLANGUAGES_THYMELEAF_EXAMPLES);
    }

    @Test
    public void deployingNewScriptFactoryModuleShouldMakeItAvailable() throws RepositoryException {
        MultiScriptingTest.deployAndWait(SCRIPTLANGUAGES_THYMELEAF);
        try {
            ScriptEngine thymeleaf = ScriptEngineUtils.getInstance().getEngineByName("thymeleaf");
            Assert.assertNotNull(thymeleaf);
            Assert.assertEquals("thymeleaf", thymeleaf.getFactory().getEngineName().toLowerCase());
        }
        catch (ScriptException e) {
            Assert.fail(e.getLocalizedMessage());
        }
        MultiScriptingTest.undeployAndWait(SCRIPTLANGUAGES_THYMELEAF);
    }

    @Test
    public void deployingViewsWithoutFactoryShouldNotWork() throws TemplateNotFoundException, RepositoryException {
        ModuleAndPath moduleAndPath = this.getModuleAndPath();
        JahiaTemplatesPackage jahiaTemplatesPackage = moduleAndPath.module;
        managerService.undeployModule(jahiaTemplatesPackage);
        Script script = this.resolveScript(moduleAndPath.path);
        Assert.assertEquals("default", script.getView().getModule().getId());
        Assert.assertEquals("base.jsp", script.getView().getDisplayName());
    }

    @Test
    public void deployingShouldMakeNewViewsAvailable() throws RepositoryException, TemplateNotFoundException {
        this.getModuleAndPath();
    }

    private ModuleAndPath getModuleAndPath() throws RepositoryException, TemplateNotFoundException {
        JahiaTemplatesPackage factoryModule = MultiScriptingTest.deployAndWait(SCRIPTLANGUAGES_THYMELEAF);
        JahiaTemplatesPackage viewModule = MultiScriptingTest.deployAndWait(SCRIPTLANGUAGES_THYMELEAF_EXAMPLES);
        try {
            NodeTypeRegistry.getInstance().getNodeType(JNT_THYMELEAF_NODE);
        }
        catch (NoSuchNodeTypeException e) {
            Assert.fail("Definition not registered");
        }
        Assert.assertTrue("Module view is not correctly registered", managerService.getModulesWithViewsForComponent(JNT_THYMELEAF_NODE).contains(viewModule));
        JCRSessionWrapper editSession = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
        JCRNodeWrapper thymeleafNode = page.addNode("thymeleafNode", JNT_THYMELEAF_NODE);
        thymeleafNode.setProperty("jcr:title", "thymeleafNode");
        editSession.save();
        String parentIdentifier = page.getIdentifier();
        MultiScriptingTest.publish(parentIdentifier);
        String path = thymeleafNode.getPath();
        Script script = this.resolveScript(path);
        Assert.assertEquals(SCRIPTLANGUAGES_THYMELEAF_EXAMPLES, script.getView().getModule().getId());
        return new ModuleAndPath(factoryModule, path);
    }

    private Script resolveScript(String path) throws RepositoryException, TemplateNotFoundException {
        JCRSessionWrapper liveSession = JCRSessionFactory.getInstance().getCurrentUserSession("live", Locale.ENGLISH);
        liveSession.refresh(false);
        JahiaUser user = liveSession.getUser();
        JCRNodeWrapper node = liveSession.getNode(path);
        RenderContext context = new RenderContext(MultiScriptingTest.getRequest(), MultiScriptingTest.getResponse(), user);
        context.setSite(node.getResolveSite());
        context.setServletPath("/render");
        Resource resource = new Resource(node, "html", null, "page");
        context.setMainResource(resource);
        context.setWorkspace(liveSession.getWorkspace().getName());
        return RenderService.getInstance().resolveScript(resource, context);
    }

    private static void publish(String nodeId) throws RepositoryException {
        JCRPublicationService.getInstance().publishByMainId(nodeId, "default", "live", new LinkedHashSet<String>(Collections.singletonList(Locale.ENGLISH.toString())), true, Collections.emptyList());
        MultiScriptingTest.waitFor(500);
    }

    private static JahiaTemplatesPackage deployAndWait(String moduleName) throws RepositoryException {
        return MultiScriptingTest.deployAndWait(moduleName, null);
    }

    private static JahiaTemplatesPackage deployAndWait(final String moduleName, final String version) throws RepositoryException {
        JahiaTemplatesPackage module = (JahiaTemplatesPackage)JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<JahiaTemplatesPackage>(){

            public JahiaTemplatesPackage doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JahiaTemplatesPackage module = null;
                try {
                    File moduleFile = ModuleTestHelper.getModuleFromMaven("org.jahia.modules", moduleName, version);
                    module = managerService.deployModule(moduleFile, session);
                    moduleToVersion.put(moduleName, module.getVersion().toString());
                }
                catch (IOException e) {
                    Assert.fail(e.toString());
                }
                return module;
            }
        });
        Assert.assertNotNull(module);
        MultiScriptingTest.waitFor(500);
        return module;
    }

    private static void undeployAndWait(String moduleName) throws RepositoryException {
        managerService.undeployModule(moduleName, moduleToVersion.get(moduleName));
        MultiScriptingTest.waitFor(500);
    }

    private static void waitFor(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Assert.fail(e.getLocalizedMessage());
        }
    }

    static {
        moduleToVersion = new HashMap<String, String>(7);
    }

    private static class ModuleAndPath {
        private final JahiaTemplatesPackage module;
        private final String path;

        public ModuleAndPath(JahiaTemplatesPackage module, String path) {
            this.module = module;
            this.path = path;
        }
    }
}

