/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.render.filter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.channels.ChannelService;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.RenderService;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.BaseAttributesFilter;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.services.render.filter.RenderFilter;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.test.JahiaAdminUser;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConditionalFilterTest
extends JahiaTestCase {
    private JCRNodeWrapper node;
    private JCRSessionWrapper session;
    private JCRSiteNode site;

    @Before
    public void setUp() throws Exception {
        JahiaSite site = TestHelper.createSite("test");
        ConditionalFilterTest.setSessionSite(site);
        this.session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
        this.site = (JCRSiteNode)this.session.getNode("/sites/" + site.getSiteKey());
        JCRNodeWrapper shared = this.session.getNode("/sites/" + site.getSiteKey() + "/contents");
        if (shared.hasNode("testContent")) {
            shared.getNode("testContent").remove();
        }
        this.node = shared.addNode("testContent", "jnt:contentFolder");
        this.node.addNode("testType", "jnt:contentList");
        this.node.addNode("testType2", "jnt:mainContent");
        this.node.addNode("testMixin", "jnt:bigText").addMixin("jmix:tagged");
        this.session.save();
    }

    @After
    public void tearDown() throws Exception {
        TestHelper.deleteSite("test");
        this.session.save();
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @Test
    public void testModules() throws Exception {
        JahiaUser admin = JahiaAdminUser.getAdminUser(null);
        AbstractFilter outFilter = new AbstractFilter(){

            public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
                return "out";
            }
        };
        outFilter.setPriority(20.0f);
        outFilter.setRenderService(RenderService.getInstance());
        RenderContext context = new RenderContext(ConditionalFilterTest.getRequest(), ConditionalFilterTest.getResponse(), admin);
        context.setSite(this.site);
        ChannelService channelService = (ChannelService)SpringContextSingleton.getInstance().getContext().getBean("ChannelService");
        context.setChannel(channelService.getChannel("generic"));
        Resource resource = new Resource(this.node.getNode("testType"), "html", null, "page");
        context.setMainResource(resource);
        context.getRequest().setAttribute("script", (Object)RenderService.getInstance().resolveScript(resource, context));
        BaseAttributesFilter baseAttributesFilter = new BaseAttributesFilter();
        baseAttributesFilter.setPriority(0.0f);
        baseAttributesFilter.setRenderService(RenderService.getInstance());
        baseAttributesFilter.setConfigurationToSkipInResourceRenderedPath(new HashSet<String>(Arrays.asList("include", "wrapper")));
        TestFilter conditionalFilter = new TestFilter();
        conditionalFilter.setRenderService(RenderService.getInstance());
        conditionalFilter.setApplyOnModules("Default Jahia Templates");
        conditionalFilter.setPriority(10.0f);
        RenderChain chain = new RenderChain(new RenderFilter[]{baseAttributesFilter, conditionalFilter, outFilter});
        String result = chain.doFilter(context, resource);
        Assert.assertTrue("TestFilter is not applied for resource from the 'Default Jahia Templates' module", result.contains("TestFilter"));
        resource = new Resource(this.node.getNode("testType"), "html", null, "page");
        context.setMainResource(resource);
        conditionalFilter = new TestFilter();
        conditionalFilter.setRenderService(RenderService.getInstance());
        conditionalFilter.setApplyOnModules("Jahia Test");
        conditionalFilter.setPriority(10.0f);
        chain = new RenderChain(new RenderFilter[]{baseAttributesFilter, conditionalFilter, outFilter});
        result = chain.doFilter(context, resource);
        Assert.assertTrue("TestFilter is applied for resource that does not belong to the 'Jahia Test' module", !result.contains("TestFilter"));
        resource = new Resource(this.node.getNode("testType"), "html", null, "page");
        context.setMainResource(resource);
        conditionalFilter = new TestFilter();
        conditionalFilter.setRenderService(RenderService.getInstance());
        conditionalFilter.setApplyOnModules("Jahia Test, Default Jahia Templates");
        conditionalFilter.setPriority(10.0f);
        chain = new RenderChain(new RenderFilter[]{baseAttributesFilter, conditionalFilter, outFilter});
        result = chain.doFilter(context, resource);
        Assert.assertTrue("TestFilter is not applied for resource from the 'Default Jahia Templates' module", result.contains("TestFilter"));
        conditionalFilter = new TestFilter();
        conditionalFilter.setRenderService(RenderService.getInstance());
        conditionalFilter.setSkipOnModules("Jahia Test, Default Jahia Templates");
        conditionalFilter.setPriority(10.0f);
        chain = new RenderChain(new RenderFilter[]{baseAttributesFilter, conditionalFilter, outFilter});
        result = chain.doFilter(context, resource);
        Assert.assertTrue("TestFilter is applied for resource from the 'Default Jahia Templates' module", !result.contains("TestFilter"));
        conditionalFilter = new TestFilter();
        conditionalFilter.setRenderService(RenderService.getInstance());
        conditionalFilter.setSkipOnModules("Jahia Test, Jahia Rating");
        conditionalFilter.setPriority(10.0f);
        chain = new RenderChain(new RenderFilter[]{baseAttributesFilter, conditionalFilter, outFilter});
        result = chain.doFilter(context, resource);
        Assert.assertTrue("TestFilter is not applied for resource from the 'Default Jahia Templates' module", result.contains("TestFilter"));
    }

    @Test
    public void testNodeTypes() throws Exception {
        JahiaUser admin = JahiaAdminUser.getAdminUser(null);
        AbstractFilter outFilter = new AbstractFilter(){

            public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
                return "out";
            }
        };
        outFilter.setPriority(20.0f);
        outFilter.setRenderService(RenderService.getInstance());
        RenderContext context = new RenderContext(ConditionalFilterTest.getRequest(), ConditionalFilterTest.getResponse(), admin);
        context.setSite(this.site);
        ChannelService channelService = (ChannelService)SpringContextSingleton.getInstance().getContext().getBean("ChannelService");
        context.setChannel(channelService.getChannel("generic"));
        Resource resource = new Resource(this.node.getNode("testType"), "html", null, "page");
        context.setMainResource(resource);
        BaseAttributesFilter baseAttributesFilter = new BaseAttributesFilter();
        baseAttributesFilter.setRenderService(RenderService.getInstance());
        baseAttributesFilter.setPriority(0.0f);
        baseAttributesFilter.setConfigurationToSkipInResourceRenderedPath(new HashSet<String>(Arrays.asList("include", "wrapper")));
        TestFilter conditionalFilter = new TestFilter();
        conditionalFilter.setRenderService(RenderService.getInstance());
        conditionalFilter.setApplyOnNodeTypes("jnt:contentList");
        conditionalFilter.setPriority(10.0f);
        RenderChain chain = new RenderChain(new RenderFilter[]{baseAttributesFilter, conditionalFilter, outFilter});
        String result = chain.doFilter(context, resource);
        Assert.assertTrue("TestFilter is not applied for node, having jnt:tag type", result.contains("TestFilter"));
        resource = new Resource(this.node.getNode("testType2"), "html", null, "page");
        context.setMainResource(resource);
        chain = new RenderChain(new RenderFilter[]{baseAttributesFilter, conditionalFilter, outFilter});
        result = chain.doFilter(context, resource);
        Assert.assertTrue("TestFilter is applied for node that does not have jnt:contentList type", !result.contains("TestFilter"));
        resource = new Resource(this.node.getNode("testType2"), "html", null, "page");
        context.setMainResource(resource);
        conditionalFilter = new TestFilter();
        conditionalFilter.setRenderService(RenderService.getInstance());
        conditionalFilter.setApplyOnNodeTypes("jnt:page, jnt:mainContent");
        conditionalFilter.setPriority(10.0f);
        chain = new RenderChain(new RenderFilter[]{baseAttributesFilter, conditionalFilter, outFilter});
        result = chain.doFilter(context, resource);
        Assert.assertTrue("TestFilter is not applied for node, having jnt:mainContent type", result.contains("TestFilter"));
        resource = new Resource(this.node.getNode("testMixin"), "html", null, "page");
        context.setMainResource(resource);
        conditionalFilter = new TestFilter();
        conditionalFilter.setRenderService(RenderService.getInstance());
        conditionalFilter.setApplyOnNodeTypes("jmix:tagged");
        conditionalFilter.setPriority(10.0f);
        chain = new RenderChain(new RenderFilter[]{baseAttributesFilter, conditionalFilter, outFilter});
        result = chain.doFilter(context, resource);
        Assert.assertTrue("TestFilter is not applied for node, having jmix:tagged mixin type", result.contains("TestFilter"));
        conditionalFilter = new TestFilter();
        conditionalFilter.setRenderService(RenderService.getInstance());
        conditionalFilter.setSkipOnNodeTypes("jmix:tagged, jnt:page");
        conditionalFilter.setPriority(10.0f);
        chain = new RenderChain(new RenderFilter[]{baseAttributesFilter, conditionalFilter, outFilter});
        result = chain.doFilter(context, resource);
        Assert.assertTrue("TestFilter is applied for node, having jmix:tagged mixin type", !result.contains("TestFilter"));
        conditionalFilter = new TestFilter();
        conditionalFilter.setRenderService(RenderService.getInstance());
        conditionalFilter.setSkipOnNodeTypes("jmix:my");
        conditionalFilter.setPriority(10.0f);
        chain = new RenderChain(new RenderFilter[]{baseAttributesFilter, conditionalFilter, outFilter});
        result = chain.doFilter(context, resource);
        Assert.assertTrue("TestFilter is not applied for node, not having jmix:my mixin type", result.contains("TestFilter"));
    }

    @Test
    public void testTemplates() throws Exception {
        JahiaUser admin = JahiaAdminUser.getAdminUser(null);
        AbstractFilter outFilter = new AbstractFilter(){

            public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
                return "out";
            }
        };
        outFilter.setPriority(20.0f);
        outFilter.setRenderService(RenderService.getInstance());
        RenderContext context = new RenderContext(ConditionalFilterTest.getRequest(), ConditionalFilterTest.getResponse(), admin);
        context.setSite(this.site);
        ChannelService channelService = (ChannelService)SpringContextSingleton.getInstance().getContext().getBean("ChannelService");
        context.setChannel(channelService.getChannel("generic"));
        Resource resource = new Resource(this.node.getNode("testType"), "html", "mine", "page");
        context.setMainResource(resource);
        BaseAttributesFilter baseAttributesFilter = new BaseAttributesFilter();
        baseAttributesFilter.setRenderService(RenderService.getInstance());
        baseAttributesFilter.setPriority(0.0f);
        baseAttributesFilter.setConfigurationToSkipInResourceRenderedPath(new HashSet<String>(Arrays.asList("include", "wrapper")));
        TestFilter conditionalFilter = new TestFilter();
        conditionalFilter.setRenderService(RenderService.getInstance());
        conditionalFilter.setApplyOnTemplates("mine");
        conditionalFilter.setPriority(10.0f);
        RenderChain chain = new RenderChain(new RenderFilter[]{baseAttributesFilter, conditionalFilter, outFilter});
        String result = chain.doFilter(context, resource);
        Assert.assertTrue("TestFilter is not applied for resource, having 'mine' template", result.contains("TestFilter"));
        resource = new Resource(this.node.getNode("testType"), "html", "others", "page");
        context.setMainResource(resource);
        chain = new RenderChain(new RenderFilter[]{baseAttributesFilter, conditionalFilter, outFilter});
        result = chain.doFilter(context, resource);
        Assert.assertTrue("TestFilter is applied for resource that does not have 'mine' template", !result.contains("TestFilter"));
        resource = new Resource(this.node.getNode("testType"), "html", "mine", "page");
        context.setMainResource(resource);
        conditionalFilter = new TestFilter();
        conditionalFilter.setRenderService(RenderService.getInstance());
        conditionalFilter.setApplyOnTemplates("others,mine");
        conditionalFilter.setPriority(10.0f);
        chain = new RenderChain(new RenderFilter[]{baseAttributesFilter, conditionalFilter, outFilter});
        result = chain.doFilter(context, resource);
        Assert.assertTrue("TestFilter is not applied for resource, having 'mine' template", result.contains("TestFilter"));
        conditionalFilter = new TestFilter();
        conditionalFilter.setRenderService(RenderService.getInstance());
        conditionalFilter.setSkipOnTemplates("others,mine");
        conditionalFilter.setPriority(10.0f);
        chain = new RenderChain(new RenderFilter[]{baseAttributesFilter, conditionalFilter, outFilter});
        result = chain.doFilter(context, resource);
        Assert.assertTrue("TestFilter is applied for resource, having 'mine' template", !result.contains("TestFilter"));
        conditionalFilter = new TestFilter();
        conditionalFilter.setRenderService(RenderService.getInstance());
        conditionalFilter.setSkipOnTemplates("unknown");
        conditionalFilter.setPriority(10.0f);
        chain = new RenderChain(new RenderFilter[]{baseAttributesFilter, conditionalFilter, outFilter});
        result = chain.doFilter(context, resource);
        Assert.assertTrue("TestFilter is not applied for resource, not having 'unknown' template", result.contains("TestFilter"));
    }

    @Test
    public void testTemplateTypes() throws Exception {
        JahiaUser admin = JahiaAdminUser.getAdminUser(null);
        AbstractFilter outFilter = new AbstractFilter(){

            public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
                return "out";
            }
        };
        outFilter.setPriority(20.0f);
        outFilter.setRenderService(RenderService.getInstance());
        RenderContext context = new RenderContext(ConditionalFilterTest.getRequest(), ConditionalFilterTest.getResponse(), admin);
        context.setSite(this.site);
        ChannelService channelService = (ChannelService)SpringContextSingleton.getInstance().getContext().getBean("ChannelService");
        context.setChannel(channelService.getChannel("generic"));
        Resource resource = new Resource(this.node.getNode("testType"), "html", null, "page");
        context.setMainResource(resource);
        BaseAttributesFilter baseAttributesFilter = new BaseAttributesFilter();
        baseAttributesFilter.setRenderService(RenderService.getInstance());
        baseAttributesFilter.setPriority(0.0f);
        baseAttributesFilter.setConfigurationToSkipInResourceRenderedPath(new HashSet<String>(Arrays.asList("include", "wrapper")));
        TestFilter conditionalFilter = new TestFilter();
        conditionalFilter.setRenderService(RenderService.getInstance());
        conditionalFilter.setApplyOnTemplateTypes("html");
        conditionalFilter.setPriority(10.0f);
        RenderChain chain = new RenderChain(new RenderFilter[]{baseAttributesFilter, conditionalFilter, outFilter});
        String result = chain.doFilter(context, resource);
        Assert.assertTrue("TestFilter is not applied for resource, having 'html' template type", result.contains("TestFilter"));
        resource = new Resource(this.node.getNode("testType"), "html", null, "page");
        context.setMainResource(resource);
        conditionalFilter = new TestFilter();
        conditionalFilter.setRenderService(RenderService.getInstance());
        conditionalFilter.setApplyOnTemplateTypes("rss");
        conditionalFilter.setPriority(10.0f);
        chain = new RenderChain(new RenderFilter[]{baseAttributesFilter, conditionalFilter, outFilter});
        result = chain.doFilter(context, resource);
        Assert.assertTrue("TestFilter is applied for resource that does not have 'rss' template", !result.contains("TestFilter"));
        resource = new Resource(this.node.getNode("testType"), "html", null, "page");
        context.setMainResource(resource);
        conditionalFilter = new TestFilter();
        conditionalFilter.setRenderService(RenderService.getInstance());
        conditionalFilter.setApplyOnTemplateTypes("xml,html");
        conditionalFilter.setPriority(10.0f);
        chain = new RenderChain(new RenderFilter[]{baseAttributesFilter, conditionalFilter, outFilter});
        result = chain.doFilter(context, resource);
        Assert.assertTrue("TestFilter is not applied for resource, having 'html' template type", result.contains("TestFilter"));
        resource = new Resource(this.node.getNode("testType"), "html", null, "page");
        context.setMainResource(resource);
        conditionalFilter = new TestFilter();
        conditionalFilter.setRenderService(RenderService.getInstance());
        conditionalFilter.setSkipOnTemplateTypes("xml,html");
        conditionalFilter.setPriority(10.0f);
        chain = new RenderChain(new RenderFilter[]{baseAttributesFilter, conditionalFilter, outFilter});
        result = chain.doFilter(context, resource);
        Assert.assertTrue("TestFilter is applied for resource, having 'html' template type", !result.contains("TestFilter"));
        conditionalFilter = new TestFilter();
        conditionalFilter.setRenderService(RenderService.getInstance());
        conditionalFilter.setSkipOnTemplateTypes("csv,rss");
        conditionalFilter.setPriority(10.0f);
        chain = new RenderChain(new RenderFilter[]{baseAttributesFilter, conditionalFilter, outFilter});
        result = chain.doFilter(context, resource);
        Assert.assertTrue("TestFilter is not applied for resource, not having 'rss' template type", result.contains("TestFilter"));
    }

    private static class TestFilter
    extends AbstractFilter {
        private TestFilter() {
        }

        public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
            return "TestFilter " + previousOut;
        }
    }
}

