/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.render.filter;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.render.URLResolver;
import org.jahia.services.render.URLResolverFactory;
import org.jahia.services.seo.VanityUrl;
import org.jahia.services.seo.jcr.VanityUrlService;
import org.jahia.services.sites.JahiaSite;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public class URLFilterTest
extends JahiaTestCase {
    private static final String TESTSITE_NAME = "test";
    private static final String SITECONTENT_ROOT_NODE = "/sites/test";

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        JahiaSite site = TestHelper.createSite(TESTSITE_NAME, Sets.newHashSet((Object[])new String[]{"en", "fr"}), null, false);
        URLFilterTest.setSessionSite(site);
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        TestHelper.deleteSite(TESTSITE_NAME);
    }

    @Before
    public void setUp() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession(null, Locale.ENGLISH);
        JCRNodeWrapper siteNode = session.getNode(SITECONTENT_ROOT_NODE);
        if (!siteNode.isCheckedOut()) {
            session.checkout((Node)siteNode);
        }
        if (siteNode.hasNode("testPage")) {
            siteNode.getNode("testPage").remove();
        }
        JCRNodeWrapper pageNode = siteNode.addNode("testPage", "jnt:page");
        pageNode.setProperty("jcr:title", "English test page");
        pageNode.setProperty("j:templateName", "simple");
        pageNode.addNode("testContent", "jnt:mainContent");
        session.save();
        JCRSessionWrapper frenchSession = JCRSessionFactory.getInstance().getCurrentUserSession(null, Locale.FRENCH);
        pageNode = frenchSession.getNode("/sites/test/testPage");
        pageNode.setProperty("jcr:title", "French test page");
        frenchSession.save();
    }

    @After
    public void tearDown() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession(null, Locale.ENGLISH);
        JCRNodeWrapper siteNode = session.getNode(SITECONTENT_ROOT_NODE);
        if (!siteNode.isCheckedOut()) {
            session.checkout((Node)siteNode);
        }
        if (siteNode.hasNode("testPage")) {
            siteNode.getNode("testPage").remove();
        }
        session.save();
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @Test
    public void testAssigningUrlMappings() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession(null, Locale.ENGLISH);
        JCRNodeWrapper pageNode = session.getNode("/sites/test/testPage");
        JCRNodeWrapper contentNode = session.getNode("/sites/test/testPage/testContent");
        VanityUrl vanityUrl = new VanityUrl("/testpage", TESTSITE_NAME, "en");
        vanityUrl.setDefaultMapping(true);
        vanityUrl.setActive(true);
        Assert.assertTrue("URL mapping should not exist yet", this.getVanityUrlService().findExistingVanityUrls(vanityUrl.getUrl(), vanityUrl.getSite(), "default").isEmpty());
        this.getVanityUrlService().saveVanityUrlMapping(pageNode, vanityUrl);
        Assert.assertFalse("URL mapping should exist", this.getVanityUrlService().findExistingVanityUrls(vanityUrl.getUrl(), vanityUrl.getSite(), "default").isEmpty());
        try {
            this.getVanityUrlService().saveVanityUrlMapping(contentNode, vanityUrl);
            Assert.assertTrue("Exception should have been thrown", false);
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        VanityUrl newVanityUrl = new VanityUrl("/testcontent", TESTSITE_NAME, "en");
        newVanityUrl.setDefaultMapping(true);
        newVanityUrl.setActive(true);
        this.getVanityUrlService().saveVanityUrlMapping(contentNode, newVanityUrl);
        Assert.assertFalse("New URL mapping should exist", this.getVanityUrlService().findExistingVanityUrls(vanityUrl.getUrl(), vanityUrl.getSite(), "default").isEmpty());
        VanityUrl savedVanityUrl = this.getVanityUrlService().getVanityUrlForWorkspaceAndLocale(pageNode, session.getWorkspace().getName(), session.getLocale(), TESTSITE_NAME);
        Assert.assertTrue("Wrong page vanity URL returned", vanityUrl.getUrl().equals(savedVanityUrl.getUrl()));
        VanityUrl savedNewVanityUrl = (VanityUrl)this.getVanityUrlService().getVanityUrlsForCurrentLocale(contentNode, session).get(0);
        Assert.assertTrue("Wrong container vanity URL returned", newVanityUrl.getUrl().equals(savedNewVanityUrl.getUrl()));
        this.getVanityUrlService().removeVanityUrlMapping(pageNode, vanityUrl);
        this.getVanityUrlService().removeVanityUrlMapping(contentNode, newVanityUrl);
        Assert.assertTrue("URL mapping should no longer exist", this.getVanityUrlService().findExistingVanityUrls(vanityUrl.getUrl(), vanityUrl.getSite(), "default").isEmpty());
        Assert.assertNull("No page vanity URL should exist", this.getVanityUrlService().getVanityUrlForWorkspaceAndLocale(pageNode, session.getWorkspace().getName(), session.getLocale(), TESTSITE_NAME));
        Assert.assertTrue("No container vanity URL should exist", this.getVanityUrlService().getVanityUrlsForCurrentLocale(contentNode, session).isEmpty());
    }

    @Test
    public void testBulkDiffAssigningUrlMappings() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession(null, Locale.ENGLISH);
        JCRNodeWrapper pageNode = session.getNode("/sites/test/testPage");
        VanityUrl englishVanityUrl = new VanityUrl("/test2page", TESTSITE_NAME, "en");
        englishVanityUrl.setActive(true);
        VanityUrl englishVanityUrl2 = new VanityUrl("/test2page2", TESTSITE_NAME, "en");
        englishVanityUrl2.setActive(false);
        VanityUrl englishVanityUrl3 = new VanityUrl("/test2page/page3", TESTSITE_NAME, "en");
        englishVanityUrl3.setActive(true);
        VanityUrl frenchVanityUrl = new VanityUrl("/test2page/french", TESTSITE_NAME, "fr");
        frenchVanityUrl.setActive(true);
        VanityUrl frenchVanityUrl2 = new VanityUrl("/test2page/french2", TESTSITE_NAME, "fr");
        frenchVanityUrl2.setDefaultMapping(true);
        frenchVanityUrl2.setActive(true);
        ArrayList<VanityUrl> vanityUrls = new ArrayList<VanityUrl>();
        vanityUrls.add(englishVanityUrl);
        vanityUrls.add(englishVanityUrl2);
        vanityUrls.add(englishVanityUrl3);
        vanityUrls.add(frenchVanityUrl);
        vanityUrls.add(frenchVanityUrl2);
        HashSet<String> languages = new HashSet<String>();
        languages.add("en");
        languages.add("fr");
        this.getVanityUrlService().saveVanityUrlMappings(pageNode, vanityUrls, languages);
        Assert.assertFalse("URL mapping should exist", this.getVanityUrlService().findExistingVanityUrls(englishVanityUrl.getUrl(), englishVanityUrl.getSite(), "default").isEmpty());
        Assert.assertFalse("URL mapping should exist", this.getVanityUrlService().findExistingVanityUrls(englishVanityUrl2.getUrl(), englishVanityUrl2.getSite(), "default").isEmpty());
        Assert.assertFalse("URL mapping should exist", this.getVanityUrlService().findExistingVanityUrls(englishVanityUrl3.getUrl(), englishVanityUrl3.getSite(), "default").isEmpty());
        Assert.assertFalse("URL mapping should exist", this.getVanityUrlService().findExistingVanityUrls(frenchVanityUrl.getUrl(), frenchVanityUrl.getSite(), "default").isEmpty());
        Assert.assertFalse("URL mapping should exist", this.getVanityUrlService().findExistingVanityUrls(frenchVanityUrl2.getUrl(), frenchVanityUrl2.getSite(), "default").isEmpty());
        englishVanityUrl.setDefaultMapping(true);
        englishVanityUrl2.setDefaultMapping(true);
        try {
            this.getVanityUrlService().saveVanityUrlMappings(pageNode, vanityUrls, languages);
            Assert.assertTrue("Exception should have been thrown", false);
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        VanityUrl frenchVanityUrl3 = new VanityUrl("/test2page", TESTSITE_NAME, "fr");
        frenchVanityUrl3.setDefaultMapping(true);
        frenchVanityUrl3.setActive(true);
        try {
            this.getVanityUrlService().saveVanityUrlMappings(pageNode, vanityUrls, languages);
            Assert.assertTrue("Exception should have been thrown", false);
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        List vanityUrls_en = this.getVanityUrlService().getVanityUrlsForCurrentLocale(pageNode, session);
        String[] expectedUrls_en = new String[]{"/test2page", "/test2page2", "/test2page/page3"};
        Assert.assertTrue("Number of Urls is not expected " + expectedUrls_en.length + " vs. " + vanityUrls_en.size(), expectedUrls_en.length == vanityUrls_en.size());
        for (VanityUrl vanityUrl_en : vanityUrls_en) {
            boolean found = false;
            for (String expectedUrl_en : expectedUrls_en) {
                if (!vanityUrl_en.getUrl().equals(expectedUrl_en)) continue;
                found = true;
                break;
            }
            Assert.assertTrue("Expected vanity url not found: " + vanityUrl_en, found);
        }
        JCRSessionWrapper frenchSession = JCRSessionFactory.getInstance().getCurrentUserSession(null, Locale.FRENCH);
        List vanityUrls_fr = this.getVanityUrlService().getVanityUrlsForCurrentLocale(pageNode, frenchSession);
        String[] expectedUrls_fr = new String[]{"/test2page/french", "/test2page/french2"};
        Assert.assertTrue("Number of Urls is not expected " + expectedUrls_fr.length + " vs. " + vanityUrls_fr.size(), expectedUrls_fr.length == vanityUrls_fr.size());
        for (VanityUrl vanityUrl_fr : vanityUrls_fr) {
            boolean found = false;
            for (String expectedUrl_fr : expectedUrls_fr) {
                if (!vanityUrl_fr.getUrl().equals(expectedUrl_fr)) continue;
                found = true;
                break;
            }
            Assert.assertTrue("Expected vanity url not found: " + vanityUrl_fr, found);
        }
        this.getVanityUrlService().removeVanityUrlMappings(pageNode, "en");
        this.getVanityUrlService().removeVanityUrlMappings(pageNode, "fr");
        Assert.assertNull("No page vanity URL should exist", this.getVanityUrlService().getVanityUrlForWorkspaceAndLocale(pageNode, session.getWorkspace().getName(), session.getLocale(), TESTSITE_NAME));
    }

    @Test
    public void testURLFilterResolving() throws Exception {
        Object[][] testPathes;
        for (Object[] testPath : testPathes = new Object[][]{{"/", "", Locale.ENGLISH, "/", NoSuchWorkspaceException.class, ""}, {"/render", "", Locale.ENGLISH, "/", NoSuchWorkspaceException.class, ""}, {"/render/default", "default", Locale.ENGLISH, "/", JCRNodeWrapper.class, "/"}, {"/render/live", "live", Locale.ENGLISH, "/", JCRNodeWrapper.class, "/"}, {"/render/live/fr", "live", Locale.FRENCH, "/", JCRNodeWrapper.class, "/"}, {"/render/default/en/sites/test/testPage.html", "default", Locale.ENGLISH, "/sites/test/testPage.html", JCRNodeWrapper.class, "/sites/test/testPage"}, {"/render/default/en/sites/test/testPage/testContent.detail.html", "default", Locale.ENGLISH, "/sites/test/testPage/testContent.detail.html", JCRNodeWrapper.class, "/sites/test/testPage/testContent"}, {"/edit/default", "default", Locale.ENGLISH, "/", JCRNodeWrapper.class, "/"}, {"/edit/default/en", "default", Locale.ENGLISH, "/", JCRNodeWrapper.class, "/"}, {"/edit/default/fr", "default", Locale.FRENCH, "/", JCRNodeWrapper.class, "/"}, {"/edit/default/fr/sites/test/home.html", "default", Locale.FRENCH, "/sites/test/home.html", JCRNodeWrapper.class, "/sites/test/home"}}) {
            URLResolver urlResolver = this.getUrlResolverFactory().createURLResolver((String)testPath[0], "", (HttpServletRequest)new MockHttpServletRequest("GET", (String)testPath[0]));
            urlResolver.setSiteKey(TESTSITE_NAME);
            Assert.assertTrue("Path " + testPath[0] + " not resolved correctly", testPath[1].equals(urlResolver.getWorkspace()) && testPath[2].equals(urlResolver.getLocale()) && testPath[3].equals(urlResolver.getPath()));
            Object nodeObject = null;
            String path = null;
            try {
                nodeObject = urlResolver.getNode();
                path = nodeObject.getPath();
            }
            catch (Exception e) {
                nodeObject = e;
                path = "";
            }
            Assert.assertTrue("Path " + testPath[0] + " not resolved correctly", ((Class)testPath[4]).isAssignableFrom(nodeObject.getClass()) && testPath[5].equals(path));
        }
    }

    @Test
    public void testVanityURLResolving() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession(null, Locale.ENGLISH);
        JahiaSite site = ServicesRegistry.getInstance().getJahiaSitesService().getSiteByKey(TESTSITE_NAME);
        JCRNodeWrapper pageNode = session.getNode("/sites/test/testPage");
        VanityUrl englishVanityUrl = new VanityUrl("/test4page", TESTSITE_NAME, "en");
        englishVanityUrl.setActive(true);
        VanityUrl englishVanityUrl2 = new VanityUrl("/test4page2", TESTSITE_NAME, "en");
        englishVanityUrl2.setActive(false);
        VanityUrl englishVanityUrl3 = new VanityUrl("/test4page/page3", TESTSITE_NAME, "en");
        englishVanityUrl3.setActive(true);
        VanityUrl frenchVanityUrl = new VanityUrl("/test4page/french", TESTSITE_NAME, "fr");
        frenchVanityUrl.setActive(true);
        VanityUrl frenchVanityUrl2 = new VanityUrl("/test4page/french2", TESTSITE_NAME, "fr");
        frenchVanityUrl2.setDefaultMapping(true);
        frenchVanityUrl2.setActive(true);
        ArrayList<VanityUrl> vanityUrls = new ArrayList<VanityUrl>();
        vanityUrls.add(englishVanityUrl);
        vanityUrls.add(englishVanityUrl2);
        vanityUrls.add(englishVanityUrl3);
        vanityUrls.add(frenchVanityUrl);
        vanityUrls.add(frenchVanityUrl2);
        HashSet<String> languages = new HashSet<String>();
        languages.add("en");
        languages.add("fr");
        this.getVanityUrlService().saveVanityUrlMappings(pageNode, vanityUrls, languages);
        Assert.assertTrue("Wrong URL returned", this.getVanityUrlService().getVanityUrlForWorkspaceAndLocale(pageNode, "default", Locale.ENGLISH, TESTSITE_NAME).getUrl().equals("/test4page"));
        Assert.assertTrue("Wrong URL returned", this.getVanityUrlService().getVanityUrlForWorkspaceAndLocale(pageNode, "default", Locale.FRENCH, TESTSITE_NAME).getUrl().equals("/test4page/french2"));
        URLResolver urlResolver = null;
        try {
            urlResolver = this.getUrlResolverFactory().createURLResolver("/edit/default/test4page", site.getServerName(), (HttpServletRequest)new MockHttpServletRequest("GET", "/edit/default/testpage"));
            urlResolver.getNode();
            Assert.fail("Node should not be returned as edit servlet does not resolve vanity URLs");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        try {
            urlResolver = this.getUrlResolverFactory().createURLResolver("/render/live/test4page", site.getServerName(), (HttpServletRequest)new MockHttpServletRequest("GET", "/render/live/testpage"));
            urlResolver.getNode();
            Assert.fail("Node should not be returned as it is not published yet");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        languages.clear();
        languages.add("en");
        ServicesRegistry.getInstance().getJCRPublicationService().publishByMainId(pageNode.getIdentifier(), "default", "live", languages, true, null);
        urlResolver = this.getUrlResolverFactory().createURLResolver("/render/live/test4page", site.getServerName(), (HttpServletRequest)new MockHttpServletRequest("GET", "/render/live/testpage"));
        JCRNodeWrapper resolvedNode = urlResolver.getNode();
        Assert.assertTrue("Wrong node or language returned", pageNode.equals(resolvedNode) && "en".equals(resolvedNode.getLanguage()));
        try {
            urlResolver = this.getUrlResolverFactory().createURLResolver("/render/live/test4page2", site.getServerName(), (HttpServletRequest)new MockHttpServletRequest("GET", "/render/live/testpage2"));
            urlResolver.getNode();
            Assert.fail("Node should not be returned as mapping is not active");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        urlResolver = this.getUrlResolverFactory().createURLResolver("/render/live/test4page/page3", site.getServerName(), (HttpServletRequest)new MockHttpServletRequest("GET", "/render/live/testpage/page3"));
        resolvedNode = urlResolver.getNode();
        Assert.assertTrue("Wrong node or language returned", pageNode.equals(resolvedNode) && "en".equals(resolvedNode.getLanguage()));
        urlResolver = this.getUrlResolverFactory().createURLResolver("/render/live/test4page/french2", site.getServerName(), (HttpServletRequest)new MockHttpServletRequest("GET", "/render/live/testpage/french2"));
        try {
            resolvedNode = urlResolver.getNode();
            Assert.assertTrue("Wrong node or language returned - all vanity urls are published, not just the one of the published language", pageNode.equals(resolvedNode) && "fr".equals(resolvedNode.getLanguage()));
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        languages.clear();
        languages.add("fr");
        ServicesRegistry.getInstance().getJCRPublicationService().publishByMainId(pageNode.getIdentifier(), "default", "live", languages, true, null);
        urlResolver = this.getUrlResolverFactory().createURLResolver("/render/live/test4page/french2", site.getServerName(), (HttpServletRequest)new MockHttpServletRequest("GET", "/render/live/testpage/french2"));
        resolvedNode = urlResolver.getNode();
        Assert.assertTrue("Wrong node or language returned", pageNode.equals(resolvedNode) && "fr".equals(resolvedNode.getLanguage()));
        urlResolver = this.getUrlResolverFactory().createURLResolver("/render/live/test4page/french", site.getServerName(), (HttpServletRequest)new MockHttpServletRequest("GET", "/render/live/testpage/french"));
        resolvedNode = urlResolver.getNode();
        Assert.assertTrue("Wrong node or language returned", pageNode.equals(resolvedNode) && "fr".equals(resolvedNode.getLanguage()));
    }

    private VanityUrlService getVanityUrlService() {
        return (VanityUrlService)SpringContextSingleton.getBean((String)VanityUrlService.class.getName());
    }

    private URLResolverFactory getUrlResolverFactory() {
        return (URLResolverFactory)SpringContextSingleton.getBean((String)"urlResolverFactory");
    }
}

