/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.render.filter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.jcr.Node;
import junit.framework.Assert;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.channels.ChannelService;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.RenderService;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.BaseAttributesFilter;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.services.render.filter.RenderFilter;
import org.jahia.services.render.filter.WrapperFilter;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.test.JahiaAdminUser;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class WrapperFilterTest
extends JahiaTestCase {
    private JCRSiteNode site;
    private JCRSessionWrapper session;
    private JCRNodeWrapper node;

    @Before
    public void setUp() throws Exception {
        this.session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
        JahiaSite site = TestHelper.createSite("test", "localhost" + System.currentTimeMillis(), "templates-web", null, null, new String[]{"jahia-test-module"});
        this.site = (JCRSiteNode)this.session.getNode("/sites/" + site.getSiteKey());
        if (!this.site.isCheckedOut()) {
            this.session.checkout((Node)this.site);
        }
        if (this.site.hasNode("testContent")) {
            this.site.getNode("testContent").remove();
        }
        this.node = this.site.addNode("testContent", "jnt:mainContent");
        this.session.save();
    }

    @After
    public void tearDown() throws Exception {
        TestHelper.deleteSite("test");
        this.session.save();
    }

    @Test
    public void testFullpageWrapper() throws Exception {
        JahiaUser admin = JahiaAdminUser.getAdminUser(null);
        RenderContext context = new RenderContext(WrapperFilterTest.getRequest(), WrapperFilterTest.getResponse(), admin);
        context.setSite(this.site);
        Resource resource = new Resource(this.node, "html", null, "page");
        context.setMainResource(resource);
        ChannelService channelService = (ChannelService)SpringContextSingleton.getInstance().getContext().getBean("ChannelService");
        context.setChannel(channelService.getChannel("generic"));
        context.setServletPath("/cms/render");
        resource.pushWrapper("wrappertest");
        RenderChain chain = new RenderChain();
        BaseAttributesFilter attributesFilter = new BaseAttributesFilter();
        attributesFilter.setRenderService(RenderService.getInstance());
        attributesFilter.setConfigurationToSkipInResourceRenderedPath(new HashSet<String>(Arrays.asList("include", "wrapper")));
        chain.addFilter((RenderFilter)attributesFilter);
        WrapperFilter filter = new WrapperFilter();
        filter.setRenderService(RenderService.getInstance());
        chain.addFilter((RenderFilter)filter);
        chain.addFilter((RenderFilter)new AbstractFilter(){

            public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
                return "test";
            }
        });
        String result = chain.doFilter(context, resource);
        Assert.assertTrue("Cannot find <body> tag", Pattern.compile("body").matcher(result).find());
        Assert.assertTrue("Cannot find test content", Pattern.compile("test").matcher(result).find());
    }
}

