/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.render.filter.aggregate;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.jcr.Node;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.channels.ChannelService;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRReferenceNode;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.RenderService;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.AggregateFilter;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.services.render.filter.RenderFilter;
import org.jahia.services.render.filter.cache.CacheKeyGenerator;
import org.jahia.services.render.filter.cache.ModuleCacheProvider;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.templates.TemplatePackageRegistry;
import org.jahia.test.JahiaAdminUser;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateFilterTest
extends JahiaTestCase {
    private static transient Logger logger = LoggerFactory.getLogger(AggregateFilterTest.class);
    private static final String ESI_TAG_START = "<jahia_esi:include src=\"";
    private static final String ESI_TAG_END = "\"></jahia_esi:include>";
    public static final String TESTSITE_NAME = "test";
    private static List<RenderFilter> renderServiceFilters;
    private static List<RenderFilter> templatePackageRegistryFilters;
    private JCRSessionWrapper session;
    private OutFilter outFilter = new OutFilter();
    private int testNodesLvls = 3;
    private int testNodesChilds = 3;

    @Before
    public void setUp() throws Exception {
        JahiaSite site = TestHelper.createSite(TESTSITE_NAME);
        this.session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
        this.session.getNode("/sites/" + site.getSiteKey());
        JCRNodeWrapper shared = this.session.getNode("/sites/" + site.getSiteKey() + "/home");
        if (shared.hasNode("testPage")) {
            shared.getNode("testPage").remove();
        }
        JCRNodeWrapper page = shared.addNode("testPage", "jnt:page");
        page.setProperty("jcr:title", "English test page");
        page.setProperty("j:templateName", "simple");
        this.createTestNodes(page, this.testNodesLvls, this.testNodesChilds);
        this.session.save();
        RenderService renderService = RenderService.getInstance();
        TemplatePackageRegistry templatePackageRegistry = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageRegistry();
        LinkedList<AbstractFilter> filters = new LinkedList<AbstractFilter>();
        filters.add(new BaseAttributesFilter());
        AggregateFilter aggregateFilter = (AggregateFilter)SpringContextSingleton.getInstance().getContext().getBean("org.jahia.services.render.filter.AggregateFilter");
        aggregateFilter.setDisabled(false);
        filters.add((AbstractFilter)aggregateFilter);
        filters.add(this.outFilter);
        Field field = RenderService.class.getDeclaredField("filters");
        field.setAccessible(true);
        renderServiceFilters = new LinkedList<RenderFilter>((Collection)field.get(renderService));
        field.set(renderService, filters);
        templatePackageRegistryFilters = new LinkedList<RenderFilter>(templatePackageRegistry.getRenderFilters());
        templatePackageRegistry.getRenderFilters().clear();
    }

    @After
    public void tearDown() throws Exception {
        TestHelper.deleteSite(TESTSITE_NAME);
        this.session.save();
        JCRSessionFactory.getInstance().closeAllSessions();
        Field field = RenderService.class.getDeclaredField("filters");
        field.setAccessible(true);
        field.set(RenderService.getInstance(), new LinkedList<RenderFilter>(renderServiceFilters));
        ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageRegistry().getRenderFilters().clear();
        ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageRegistry().getRenderFilters().addAll(new LinkedList<RenderFilter>(templatePackageRegistryFilters));
    }

    @Test
    public void testMainResource() throws Exception {
        ModuleCacheProvider moduleCacheProvider = (ModuleCacheProvider)SpringContextSingleton.getInstance().getContext().getBean("ModuleCacheProvider");
        CacheKeyGenerator generator = moduleCacheProvider.getKeyGenerator();
        AggregateFilter aggregateFilter = (AggregateFilter)SpringContextSingleton.getInstance().getContext().getBean("org.jahia.services.render.filter.AggregateFilter");
        Resource mainResource = new Resource(this.session.getNode("/sites/test/home/testPage"), "html", null, "page");
        RenderContext context = this.mockRenderContext(mainResource, mainResource.getNode().getResolveSite());
        Map moduleMap = new HashMap();
        context.getRequest().setAttribute("moduleMap", moduleMap);
        String result = aggregateFilter.prepare(context, mainResource, null);
        String key = generator.generate(mainResource, context, generator.getAttributesForKey(context, mainResource));
        String finalKey = generator.replacePlaceholdersInCacheKey(context, key);
        Stack stack = (Stack)context.getRequest().getAttribute("aggregateFilter.resourcesStack");
        moduleMap = (Map)context.getRequest().getAttribute("moduleMap");
        Assert.assertNull(result);
        Assert.assertTrue(moduleMap.size() == 4);
        Assert.assertTrue((Boolean)moduleMap.get("aggregateFilter.aggregating") == false);
        Assert.assertEquals(key, moduleMap.get("aggregateFilter.rendering.key"));
        Assert.assertEquals(finalKey, moduleMap.get("aggregateFilter.rendering.final.key"));
        Assert.assertTrue(stack != null && stack.size() == 0);
        result = aggregateFilter.execute("MR render", context, mainResource, null);
        stack = (Stack)context.getRequest().getAttribute("aggregateFilter.resourcesStack");
        moduleMap = (Map)context.getRequest().getAttribute("moduleMap");
        Assert.assertTrue(result != null && result.equals("MR render"));
        Assert.assertTrue(moduleMap.size() == 4);
        Assert.assertTrue((Boolean)moduleMap.get("aggregateFilter.aggregating") == false);
        Assert.assertEquals(key, moduleMap.get("aggregateFilter.rendering.key"));
        Assert.assertEquals(finalKey, moduleMap.get("aggregateFilter.rendering.final.key"));
        Assert.assertTrue(stack.size() == 0);
        aggregateFilter.finalize(context, mainResource, null);
        stack = (Stack)context.getRequest().getAttribute("aggregateFilter.resourcesStack");
        Assert.assertTrue(stack == null);
    }

    @Test
    public void testModuleAlone() throws Exception {
        AggregateFilter aggregateFilter = (AggregateFilter)SpringContextSingleton.getInstance().getContext().getBean("org.jahia.services.render.filter.AggregateFilter");
        Resource mainResource = new Resource(this.session.getNode("/sites/test/home/testPage"), "html", null, "module");
        RenderContext context = this.mockRenderContext(mainResource, mainResource.getNode().getResolveSite());
        Map moduleMap = new HashMap();
        context.getRequest().setAttribute("moduleMap", moduleMap);
        String result = aggregateFilter.prepare(context, mainResource, null);
        Stack stack = (Stack)context.getRequest().getAttribute("aggregateFilter.resourcesStack");
        moduleMap = (Map)context.getRequest().getAttribute("moduleMap");
        Assert.assertNull(result);
        Assert.assertNull(stack);
        Assert.assertTrue(moduleMap.size() == 0);
        result = aggregateFilter.execute("Module render", context, mainResource, null);
        stack = (Stack)context.getRequest().getAttribute("aggregateFilter.resourcesStack");
        moduleMap = (Map)context.getRequest().getAttribute("moduleMap");
        Assert.assertNull(stack);
        Assert.assertTrue(result != null && result.equals("Module render"));
        Assert.assertTrue(moduleMap.size() == 0);
        aggregateFilter.finalize(context, mainResource, null);
        stack = (Stack)context.getRequest().getAttribute("aggregateFilter.resourcesStack");
        moduleMap = (Map)context.getRequest().getAttribute("moduleMap");
        Assert.assertTrue(stack == null);
        Assert.assertTrue(moduleMap.size() == 0);
    }

    @Test
    public void testSubFragmentOfMainResource() throws Exception {
        ModuleCacheProvider moduleCacheProvider = (ModuleCacheProvider)SpringContextSingleton.getInstance().getContext().getBean("ModuleCacheProvider");
        CacheKeyGenerator generator = moduleCacheProvider.getKeyGenerator();
        AggregateFilter aggregateFilter = (AggregateFilter)SpringContextSingleton.getInstance().getContext().getBean("org.jahia.services.render.filter.AggregateFilter");
        Resource mainResource = new Resource(this.session.getNode("/sites/test/home/testPage"), "html", null, "page");
        Resource fragmentResource = new Resource(this.session.getNode("/sites/test/home/testPage/fragment"), "html", null, "module");
        RenderContext context = this.mockRenderContext(mainResource, mainResource.getNode().getResolveSite());
        String key = generator.generate(mainResource, context, generator.getAttributesForKey(context, mainResource));
        String finalKey = generator.replacePlaceholdersInCacheKey(context, key);
        Map moduleMap = new HashMap<String, Object>();
        moduleMap.put("aggregateFilter.rendering.key", key);
        moduleMap.put("aggregateFilter.rendering.final.key", finalKey);
        moduleMap.put("aggregateFilter.aggregating", false);
        context.getRequest().setAttribute("moduleMap", moduleMap);
        context.getRequest().setAttribute("aggregateFilter.resourcesStack", new Stack());
        String fragmentKey = generator.generate(fragmentResource, context, generator.getAttributesForKey(context, fragmentResource));
        String fragmentFinalKey = generator.replacePlaceholdersInCacheKey(context, fragmentKey);
        String result = aggregateFilter.prepare(context, fragmentResource, null);
        Stack stack = (Stack)context.getRequest().getAttribute("aggregateFilter.resourcesStack");
        moduleMap = (Map)context.getRequest().getAttribute("moduleMap");
        String expectedResult = ESI_TAG_START + fragmentKey + ESI_TAG_END;
        Assert.assertTrue(result.equals(expectedResult));
        Assert.assertTrue(moduleMap.size() == 3);
        Assert.assertTrue((Boolean)moduleMap.get("aggregateFilter.aggregating") == false);
        Assert.assertEquals(key, moduleMap.get("aggregateFilter.rendering.key"));
        Assert.assertEquals(finalKey, moduleMap.get("aggregateFilter.rendering.final.key"));
        Assert.assertTrue(stack != null && stack.size() == 0);
        result = aggregateFilter.execute(result, context, fragmentResource, null);
        stack = (Stack)context.getRequest().getAttribute("aggregateFilter.resourcesStack");
        moduleMap = (Map)context.getRequest().getAttribute("moduleMap");
        Assert.assertTrue(result.equals(expectedResult));
        Assert.assertTrue(moduleMap.size() == 3);
        Assert.assertTrue((Boolean)moduleMap.get("aggregateFilter.aggregating") == false);
        Assert.assertEquals(key, moduleMap.get("aggregateFilter.rendering.key"));
        Assert.assertEquals(finalKey, moduleMap.get("aggregateFilter.rendering.final.key"));
        Assert.assertTrue(stack != null && stack.size() == 0);
        aggregateFilter.finalize(context, fragmentResource, null);
        stack = (Stack)context.getRequest().getAttribute("aggregateFilter.resourcesStack");
        moduleMap = (Map)context.getRequest().getAttribute("moduleMap");
        Assert.assertTrue(moduleMap.size() == 3);
        Assert.assertTrue((Boolean)moduleMap.get("aggregateFilter.aggregating") == false);
        Assert.assertEquals(key, moduleMap.get("aggregateFilter.rendering.key"));
        Assert.assertEquals(finalKey, moduleMap.get("aggregateFilter.rendering.final.key"));
        Assert.assertTrue(stack != null && stack.size() == 0);
    }

    @Test
    public void testSimpleAggregation() throws Exception {
        ModuleCacheProvider moduleCacheProvider = (ModuleCacheProvider)SpringContextSingleton.getInstance().getContext().getBean("ModuleCacheProvider");
        CacheKeyGenerator generator = moduleCacheProvider.getKeyGenerator();
        AggregateFilter aggregateFilter = (AggregateFilter)SpringContextSingleton.getInstance().getContext().getBean("org.jahia.services.render.filter.AggregateFilter");
        Resource mainResource = new Resource(this.session.getNode("/sites/test/home/testPage"), "html", null, "page");
        Resource fragmentResource = new Resource(this.session.getNode("/sites/test/home/testPage/fragment"), "html", null, "module");
        Resource subFragmentResource = new Resource(this.session.getNode("/sites/test/home/testPage/fragment/fragment"), "html", null, "module");
        RenderContext context = this.mockRenderContext(mainResource, mainResource.getNode().getResolveSite());
        String fragmentKey = generator.generate(fragmentResource, context, generator.getAttributesForKey(context, fragmentResource));
        String fragmentFinalKey = generator.replacePlaceholdersInCacheKey(context, fragmentKey);
        String subFragmentKey = generator.generate(subFragmentResource, context, generator.getAttributesForKey(context, subFragmentResource));
        fragmentResource.getModuleParams().put("aggregateFilter.aggregating.key", fragmentKey);
        context.getRequest().setAttribute("aggregateFilter.resourcesStack", new Stack());
        Map moduleMap = new HashMap();
        context.getRequest().setAttribute("moduleMap", moduleMap);
        String result = aggregateFilter.prepare(context, fragmentResource, null);
        Stack stack = (Stack)context.getRequest().getAttribute("aggregateFilter.resourcesStack");
        moduleMap = (Map)context.getRequest().getAttribute("moduleMap");
        Assert.assertNull(result);
        Assert.assertTrue(moduleMap.size() == 4);
        Assert.assertTrue((Boolean)moduleMap.get("aggregateFilter.aggregating"));
        Assert.assertEquals(fragmentKey, moduleMap.get("aggregateFilter.rendering.key"));
        Assert.assertEquals(fragmentFinalKey, moduleMap.get("aggregateFilter.rendering.final.key"));
        Assert.assertTrue(stack != null && stack.size() == 1);
        Assert.assertTrue(((Resource)stack.get(0)).equals((Object)fragmentResource));
        Assert.assertTrue(!fragmentResource.getModuleParams().containsKey("aggregateFilter.aggregating.key"));
        String fragmentRender = "Render for fragment: " + fragmentResource.getNode().getPath() + "\n";
        String subfragmentRender = ESI_TAG_START + subFragmentKey + ESI_TAG_END;
        result = aggregateFilter.execute(fragmentRender + subfragmentRender, context, fragmentResource, null);
        moduleMap = (Map)context.getRequest().getAttribute("moduleMap");
        stack = (Stack)context.getRequest().getAttribute("aggregateFilter.resourcesStack");
        Assert.assertTrue(moduleMap.size() == 4);
        Assert.assertTrue(stack != null && stack.size() == 1);
        Assert.assertTrue(((Resource)stack.get(0)).equals((Object)fragmentResource));
        Assert.assertTrue(result.substring(fragmentRender.length()).equals(this.getTestNodesPaths(subFragmentResource.getNode(), new StringBuilder())));
        aggregateFilter.finalize(context, fragmentResource, null);
        moduleMap = (Map)context.getRequest().getAttribute("moduleMap");
        stack = (Stack)context.getRequest().getAttribute("aggregateFilter.resourcesStack");
        Assert.assertTrue(moduleMap.size() == 4);
        Assert.assertTrue((Boolean)moduleMap.get("aggregateFilter.aggregating"));
        Assert.assertEquals(fragmentKey, moduleMap.get("aggregateFilter.rendering.key"));
        Assert.assertEquals(fragmentFinalKey, moduleMap.get("aggregateFilter.rendering.final.key"));
        Assert.assertTrue(stack != null && stack.size() == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInfiteLoopRendering() throws Exception {
        try {
            this.outFilter.infiniteLoopRender = true;
            JCRNodeWrapper rootNode = this.session.getNode("/sites/test/home/testPage");
            Resource resource = new Resource(rootNode, "html", null, "page");
            RenderContext context = this.mockRenderContext(resource, resource.getNode().getResolveSite());
            String result = RenderService.getInstance().render(resource, context);
            Assert.assertTrue(context.getRequest().getAttribute("aggregateFilter.resourcesStack") == null);
            Assert.assertTrue(!result.equals(this.getTestNodesPaths(rootNode, new StringBuilder())));
            Assert.assertTrue(result.contains("Loop detected while rendering resource /sites/test/home/testPage/fragment/fragment.default.html. Please check your content structure and references."));
        }
        finally {
            this.outFilter.infiniteLoopRender = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReferenceLoopRendering() throws Exception {
        try {
            JCRNodeWrapper rootNode = this.session.getNode("/sites/test/home/testPage");
            JCRNodeWrapper refNode = rootNode.addNode("reference", "jnt:nodeLink");
            refNode.setProperty("j:node", (Node)rootNode);
            this.session.save();
            Resource resource = new Resource(rootNode, "html", null, "page");
            RenderContext context = this.mockRenderContext(resource, resource.getNode().getResolveSite());
            String result = RenderService.getInstance().render(resource, context);
            Assert.assertTrue(context.getRequest().getAttribute("aggregateFilter.resourcesStack") == null);
            Assert.assertTrue(!result.equals(this.getTestNodesPaths(rootNode, new StringBuilder())));
            Assert.assertTrue(result.contains("oop detected while rendering resource /sites/test/home/testPage/reference@/testPage/reference.default.html. Please check your content structure and references."));
        }
        finally {
            this.session.getNode("/sites/test/home/testPage/reference").remove();
            this.session.save();
        }
    }

    @Test
    public void testFullAggregation() throws Exception {
        JCRNodeWrapper rootNode = this.session.getNode("/sites/test/home/testPage");
        Resource resource = new Resource(rootNode, "html", null, "page");
        RenderContext context = this.mockRenderContext(resource, resource.getNode().getResolveSite());
        String result = RenderService.getInstance().render(resource, context);
        Assert.assertTrue(context.getRequest().getAttribute("aggregateFilter.resourcesStack") == null);
        Assert.assertTrue(result.equals(this.getTestNodesPaths(rootNode, new StringBuilder())));
    }

    private void createTestNodes(JCRNodeWrapper rootNode, int lvl, int nbofChilds) throws Exception {
        if (lvl > 0) {
            --lvl;
            for (int i = 0; i < nbofChilds; ++i) {
                JCRNodeWrapper fragment = rootNode.addNode(JCRContentUtils.findAvailableNodeName((Node)rootNode, (String)"fragment"), "jnt:contentList");
                this.createTestNodes(fragment, lvl, nbofChilds);
            }
        }
    }

    private String getTestNodesPaths(JCRNodeWrapper rootNode, StringBuilder result) throws Exception {
        result.append("\nRender for fragment: ").append(rootNode.getPath());
        JCRNodeIteratorWrapper iteratorWrapper = rootNode.getNodes();
        if (iteratorWrapper.getSize() > 0L) {
            while (iteratorWrapper.hasNext()) {
                JCRNodeWrapper subNode = (JCRNodeWrapper)iteratorWrapper.nextNode();
                this.getTestNodesPaths(subNode, result);
            }
        }
        return result.toString();
    }

    private HttpSession mockHttpSession() {
        return (HttpSession)Proxy.newProxyInstance(HttpSession.class.getClassLoader(), new Class[]{HttpSession.class}, new InvocationHandler(){
            Map<String, Object> attributes = new HashMap<String, Object>();

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("setAttribute")) {
                    this.attributes.put((String)args[0], args[1]);
                }
                if (method.getName().equals("getAttribute")) {
                    return this.attributes.get(args[0]);
                }
                return null;
            }
        });
    }

    private HttpServletRequest mockNewServletRequest() {
        return (HttpServletRequest)Proxy.newProxyInstance(HttpServletRequest.class.getClassLoader(), new Class[]{HttpServletRequest.class}, new InvocationHandler(){
            Map<String, Object> attributes = new HashMap<String, Object>();
            HttpSession session = AggregateFilterTest.access$000(AggregateFilterTest.this);

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("setAttribute")) {
                    this.attributes.put((String)args[0], args[1]);
                } else {
                    if (method.getName().equals("getAttribute")) {
                        return this.attributes.get(args[0]);
                    }
                    if (method.getName().equals("getParameterMap")) {
                        return new HashMap();
                    }
                    if (method.getName().equals("removeAttribute")) {
                        this.attributes.remove(args[0]);
                    } else {
                        if (method.getName().equals("getSession")) {
                            return this.session;
                        }
                        if (method.getName().equals("getMethod")) {
                            return "GET";
                        }
                    }
                }
                return null;
            }
        });
    }

    private HttpServletResponse mockNewServletResponse() {
        return (HttpServletResponse)Proxy.newProxyInstance(HttpServletResponse.class.getClassLoader(), new Class[]{HttpServletResponse.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return null;
            }
        });
    }

    private RenderContext mockRenderContext(Resource mr, JCRSiteNode site) throws Exception {
        RenderContext context = new RenderContext(this.mockNewServletRequest(), this.mockNewServletResponse(), JahiaAdminUser.getAdminUser(null));
        context.setSite(site);
        context.setServletPath("/render");
        ChannelService channelService = (ChannelService)SpringContextSingleton.getInstance().getContext().getBean("ChannelService");
        context.setChannel(channelService.getChannel("generic"));
        context.setWorkspace(this.session.getWorkspace().getName());
        context.setMainResource(mr);
        return context;
    }

    static /* synthetic */ HttpSession access$000(AggregateFilterTest x0) {
        return x0.mockHttpSession();
    }

    public static class OutFilter
    extends AbstractFilter {
        public boolean infiniteLoopRender = false;

        public String prepare(RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
            JCRNodeIteratorWrapper iteratorWrapper = resource.getNode().getNodes();
            String out = "\nRender for fragment: " + resource.getNode().getPath();
            if (iteratorWrapper.getSize() > 0L) {
                if (this.infiniteLoopRender && resource.getNode().getPath().equals("/sites/test/home/testPage/fragment/fragment")) {
                    Resource sameResource = new Resource(resource.getNode(), "html", null, "module");
                    out = out + RenderService.getInstance().render(sameResource, renderContext);
                }
                while (iteratorWrapper.hasNext()) {
                    JCRNodeWrapper subNode = (JCRNodeWrapper)iteratorWrapper.nextNode();
                    Resource subResource = new Resource(subNode, "html", null, "module");
                    String renderedSubModule = RenderService.getInstance().render(subResource, renderContext);
                    out = out + renderedSubModule;
                }
            } else if (resource.getNode() instanceof JCRReferenceNode) {
                JCRNodeWrapper referencedNode = (JCRNodeWrapper)((JCRReferenceNode)resource.getNode()).getNode();
                JCRNodeWrapper subNode = resource.getNode().getSession().getNode(resource.getNode().getPath() + "@/" + referencedNode.getName());
                Resource subResource = new Resource(subNode, "html", null, "module");
                String renderedSubModule = RenderService.getInstance().render(subResource, renderContext);
                out = out + renderedSubModule;
            }
            return out;
        }

        public String getDescription() {
            return "out filter";
        }

        public float getPriority() {
            return 17.0f;
        }
    }

    public static class BaseAttributesFilter
    extends AbstractFilter {
        public String prepare(RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
            chain.pushAttribute(renderContext.getRequest(), "moduleMap", new HashMap());
            return null;
        }

        public String getDescription() {
            return "Base attribute filter, use to instantiate new moduleMap";
        }

        public float getPriority() {
            return 15.0f;
        }
    }
}

