/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.render.filter.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;

public class CacheFilterCheckFilter
extends AbstractFilter {
    private Map<String, RequestData> data = new HashMap<String, RequestData>();

    public void clear() {
        this.data.clear();
    }

    public RequestData getData(String id) {
        return this.data.get(id);
    }

    public String prepare(RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        String key = renderContext.getRequest().getHeader("request-id");
        if (key != null) {
            RequestData requestData;
            if (!this.data.containsKey(key)) {
                requestData = new RequestData();
                this.data.put(key, requestData);
            }
            requestData = this.data.get(key);
            requestData.getRenderCalled().add(resource.getPath());
            requestData.setCount(requestData.getCount() + 1);
        }
        return super.prepare(renderContext, resource, chain);
    }

    public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        String key = renderContext.getRequest().getHeader("request-id");
        if (key != null && resource.getContextConfiguration().equals("page")) {
            RequestData requestData = this.data.get(key);
            requestData.setServedFromCache((Set)renderContext.getRequest().getAttribute("servedFromCache"));
            requestData.setTime(System.currentTimeMillis() - requestData.getTime());
        }
        return super.execute(previousOut, renderContext, resource, chain);
    }

    public class RequestData {
        private Set<String> renderCalled = new HashSet<String>();
        private Set<String> servedFromCache;
        private int count = 0;
        private long time = System.currentTimeMillis();

        public Set<String> getRenderCalled() {
            return this.renderCalled;
        }

        public void setRenderCalled(Set<String> renderCalled) {
            this.renderCalled = renderCalled;
        }

        public Set<String> getServedFromCache() {
            return this.servedFromCache;
        }

        public void setServedFromCache(Set<String> servedFromCache) {
            this.servedFromCache = servedFromCache;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }
    }
}

