/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.render.filter.cache;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.Element;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.cache.CacheEntry;
import org.jahia.services.channels.ChannelService;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.RenderService;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.services.render.filter.RenderFilter;
import org.jahia.services.render.filter.cache.CacheKeyGenerator;
import org.jahia.services.render.filter.cache.ModuleCacheProvider;
import org.jahia.services.render.filter.cache.ModuleGeneratorQueue;
import org.jahia.test.JahiaAdminUser;
import org.jahia.test.services.render.filter.cache.NewCacheFilterHttpTest;
import org.jahia.test.services.render.filter.cache.base.CacheFilterTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewCacheFilterTest
extends CacheFilterTest {
    private static transient Logger logger = LoggerFactory.getLogger(CacheFilterTest.class);
    private ModuleGeneratorQueue moduleGeneratorQueue = (ModuleGeneratorQueue)SpringContextSingleton.getBean((String)"moduleGeneratorQueue");

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        CacheFilterTest.oneTimeSetUp();
        NewCacheFilterHttpTest.switchCacheImplem();
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        CacheFilterTest.oneTimeTearDown();
    }

    @Test
    public void testCacheFilter() throws Exception {
        ModuleCacheProvider moduleCacheProvider = (ModuleCacheProvider)SpringContextSingleton.getInstance().getContext().getBean("ModuleCacheProvider");
        CacheFilterRenderResult result = this.cacheFilterRender();
        Element element = moduleCacheProvider.getCache().get((Serializable)((Object)result.finalKey));
        Assert.assertNotNull("Html Cache does not contains our html rendering", element);
        Assert.assertTrue("Content Cache and rendering are not equals", ((String)((CacheEntry)element.getValue()).getObject()).contains(result.fragmentHtml));
    }

    @Test
    public void testDependencies() throws Exception {
        ModuleCacheProvider moduleCacheProvider = (ModuleCacheProvider)SpringContextSingleton.getInstance().getContext().getBean("ModuleCacheProvider");
        this.cacheFilterRender();
        Element element1 = moduleCacheProvider.getDependenciesCache().get((Serializable)((Object)"/sites/test/home/testContent"));
        Assert.assertNotNull("Node /shared should have dependencies", element1);
        Assert.assertTrue("Dependencies must not be empty", ((Set)((Object)element1.getValue())).size() > 0);
    }

    @Test
    public void testLatch() throws Exception {
        this.testLatch("/sites/test/home/testContent", false);
    }

    @Test
    public void testLatchOnError() throws Exception {
        this.testLatch("/sites/test/home", true);
    }

    public void testLatch(String path, boolean onError) throws Exception {
        JCRSessionWrapper sessionWrapper = JCRSessionFactory.getInstance().getCurrentUserSession("live", Locale.ENGLISH);
        CacheRenderThread r1 = new CacheRenderThread(sessionWrapper, path, "module", (Integer)3000, onError);
        CacheRenderThread r2 = new CacheRenderThread(sessionWrapper, path, "module", null, false);
        r1.start();
        Thread.sleep(500L);
        r2.start();
        r2.join();
        r1.join();
        Assert.assertNull(r1.error);
        Assert.assertNull(r2.error);
        Assert.assertNotNull(r2.result);
        Assert.assertNotNull(r1.result);
        if (onError) {
            Assert.assertTrue(r1.result.fragmentHtml.contains("<!-- Module error : Error filter triggered in render chain-->"));
            Assert.assertTrue(r2.result.fragmentHtml.contains("<!-- Module error : Error filter triggered in render chain-->"));
        } else {
            Assert.assertTrue(r1.result.fragmentHtml.contains("render for:/sites/test/home/testContent"));
            Assert.assertTrue(r2.result.fragmentHtml.contains("render for:/sites/test/home/testContent"));
        }
        Assert.assertTrue("Long thread don't spent the correct time to generate the fragment", r1.timer >= 3000L);
        Assert.assertTrue("Waiting thread don't spent the correct time to get the fragment", r2.timer >= 2300L);
        CacheRenderThread r3 = new CacheRenderThread(sessionWrapper, path, "module", null, false);
        r3.start();
        r3.join();
        Assert.assertNull(r3.error);
        Assert.assertNotNull(r3.result);
        Assert.assertTrue(r3.result.fragmentHtml.contains("render for:/sites/test/home"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxWait() throws Exception {
        long previousModuleGenerationWaitTime = this.moduleGeneratorQueue.getModuleGenerationWaitTime();
        try {
            this.moduleGeneratorQueue.setModuleGenerationWaitTime(1000L);
            JCRSessionWrapper sessionWrapper = JCRSessionFactory.getInstance().getCurrentUserSession("live", Locale.ENGLISH);
            CacheRenderThread r1 = new CacheRenderThread(sessionWrapper, "/sites/test/home/testContent", "page", (Integer)3000, false);
            CacheRenderThread r2 = new CacheRenderThread(sessionWrapper, "/sites/test/home/testContent", "page", null, false);
            r1.start();
            Thread.sleep(500L);
            r2.start();
            r2.join();
            r1.join();
            Assert.assertNull(r1.error);
            Assert.assertNotNull(r1.result);
            Assert.assertNull(r2.result);
            Assert.assertTrue(r2.error != null && r2.error.getMessage().contains("Module generation takes too long due to module not generated fast enough (>1000 ms)"));
            Assert.assertTrue("Long thread don't spent the correct time to generate the fragment", r1.timer >= 3000L);
            Assert.assertTrue("Waiting thread don't spent the correct time waiting before throw error", r2.timer >= 1000L);
        }
        finally {
            this.moduleGeneratorQueue.setModuleGenerationWaitTime(previousModuleGenerationWaitTime);
        }
    }

    @Test
    public void testMaxConcurrent() throws Exception {
        this.testMaxConcurrent("/sites/test/home/testContent", "/sites/test/home");
        this.testMaxConcurrent("/sites/test/home/testContent/testNotCacheable1", "/sites/test/home/testContent/testNotCacheable2");
        this.testMaxConcurrent("/sites/test/home/testContent", "/sites/test/home/testContent/testNotCacheable1");
        this.testMaxConcurrent("/sites/test/home/testContent/testNotCacheable1", "/sites/test/home/testContent");
    }

    @Test
    public void testRenderError() throws Exception {
        ModuleCacheProvider moduleCacheProvider = (ModuleCacheProvider)SpringContextSingleton.getInstance().getContext().getBean("ModuleCacheProvider");
        JCRSessionWrapper sessionWrapper = JCRSessionFactory.getInstance().getCurrentUserSession("live", Locale.ENGLISH);
        Exception exception = null;
        CacheFilterRenderResult result = null;
        try {
            result = NewCacheFilterTest.cacheFilterRender(sessionWrapper, "/sites/test/home/testContent", "module", null, true);
        }
        catch (Exception e) {
            exception = e;
        }
        Element element = moduleCacheProvider.getCache().get((Serializable)((Object)result.finalKey));
        Assert.assertNull(exception);
        Assert.assertTrue("<!-- Module error : Error filter triggered in render chain-->".equals(result.fragmentHtml));
        Assert.assertNotNull("Html Cache does not contains our error rendering", element);
        Assert.assertTrue("Error Cache and rendering are not equals", ((String)((CacheEntry)element.getValue()).getObject()).contains(result.fragmentHtml));
        exception = null;
        result = null;
        try {
            result = NewCacheFilterTest.cacheFilterRender(sessionWrapper, "/sites/test/home/testContent", "page", null, true);
        }
        catch (Exception e) {
            exception = e;
        }
        Assert.assertNull(result);
        Assert.assertTrue(exception != null && exception.getMessage().contains("Error filter triggered in render chain"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMaxConcurrent(String nodePath1, String nodePath2) throws Exception {
        long previousModuleGenerationWaitTime = this.moduleGeneratorQueue.getModuleGenerationWaitTime();
        int previousModuleGenerateInParallel = this.moduleGeneratorQueue.getMaxModulesToGenerateInParallel();
        try {
            this.moduleGeneratorQueue.setModuleGenerationWaitTime(1000L);
            this.moduleGeneratorQueue.setMaxModulesToGenerateInParallel(1);
            JCRSessionWrapper sessionWrapper = JCRSessionFactory.getInstance().getCurrentUserSession("live", Locale.ENGLISH);
            CacheRenderThread r1 = new CacheRenderThread(sessionWrapper, nodePath1, "page", (Integer)3000, false);
            CacheRenderThread r2 = new CacheRenderThread(sessionWrapper, nodePath2, "page", null, false);
            r1.start();
            Thread.sleep(500L);
            r2.start();
            r2.join();
            r1.join();
            Assert.assertNull(r1.error);
            Assert.assertNotNull(r1.result);
            Assert.assertNull(r2.result);
            Assert.assertTrue(r2.error != null && r2.error.getMessage().contains("Module generation takes too long due to maximum parallel processing reached (1)"));
            Assert.assertTrue("Long thread don't spent the correct time to generate the fragment: " + r1.timer, r1.timer >= 3000L);
            Assert.assertTrue("Waiting thread don't spent the correct time waiting before throw error:" + r2.timer, r2.timer >= 1000L);
        }
        finally {
            this.moduleGeneratorQueue.setModuleGenerationWaitTime(previousModuleGenerationWaitTime);
            this.moduleGeneratorQueue.setMaxModulesToGenerateInParallel(previousModuleGenerateInParallel);
        }
    }

    public CacheFilterRenderResult cacheFilterRender() throws Exception {
        return NewCacheFilterTest.cacheFilterRender(JCRSessionFactory.getInstance().getCurrentUserSession("live", Locale.ENGLISH), "/sites/test/home/testContent", "page", null, false);
    }

    public static HttpServletRequest mockNewServletRequest() {
        return (HttpServletRequest)Proxy.newProxyInstance(HttpServletRequest.class.getClassLoader(), new Class[]{HttpServletRequest.class}, new InvocationHandler(){
            Map<String, Object> attributes = new HashMap<String, Object>();

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("setAttribute")) {
                    this.attributes.put((String)args[0], args[1]);
                }
                if (method.getName().equals("getAttribute")) {
                    return this.attributes.get(args[0]);
                }
                if (method.getName().equals("getParameterMap")) {
                    return new HashMap();
                }
                return null;
            }
        });
    }

    public static HttpServletResponse mockNewServletResponse() {
        return (HttpServletResponse)Proxy.newProxyInstance(HttpServletResponse.class.getClassLoader(), new Class[]{HttpServletResponse.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return null;
            }
        });
    }

    public static CacheFilterRenderResult cacheFilterRender(JCRSessionWrapper sessionWrapper, final String nodePath, String resourceConfig, final Integer waitBeforeGenerate, final boolean renderError) throws Exception {
        AbstractFilter outFilter = new AbstractFilter(){

            public String prepare(RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
                return "render for:" + nodePath;
            }

            public String getDescription() {
                return "out filter";
            }

            public float getPriority() {
                return 19.0f;
            }
        };
        AbstractFilter waitFilter = new AbstractFilter(){

            public String prepare(RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
                if (waitBeforeGenerate != null) {
                    logger.info("wait filter is waiting " + waitBeforeGenerate);
                    Thread.sleep(waitBeforeGenerate.intValue());
                    logger.info("wait is finished !!");
                }
                return null;
            }

            public String getDescription() {
                return "wait filter";
            }

            public float getPriority() {
                return 17.0f;
            }
        };
        AbstractFilter errorFilter = new AbstractFilter(){

            public String prepare(RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
                if (renderError) {
                    throw new ErrorFilterException("Error filter triggered in render chain");
                }
                return null;
            }

            public String getDescription() {
                return "error filter";
            }

            public float getPriority() {
                return 18.0f;
            }

            class ErrorFilterException
            extends Exception {
                public ErrorFilterException(String message) {
                    super(message);
                }
            }
        };
        outFilter.setRenderService(RenderService.getInstance());
        waitFilter.setRenderService(RenderService.getInstance());
        errorFilter.setRenderService(RenderService.getInstance());
        JCRNodeWrapper node = sessionWrapper.getNode(nodePath);
        RenderContext context = new RenderContext(NewCacheFilterTest.mockNewServletRequest(), NewCacheFilterTest.mockNewServletResponse(), JahiaAdminUser.getAdminUser(null));
        context.setSite(node.getResolveSite());
        context.setServletPath("/render");
        ChannelService channelService = (ChannelService)SpringContextSingleton.getInstance().getContext().getBean("ChannelService");
        context.setChannel(channelService.getChannel("generic"));
        Resource resource = new Resource(node, "html", null, resourceConfig);
        context.setMainResource(resource);
        context.setWorkspace(sessionWrapper.getWorkspace().getName());
        context.getRequest().setAttribute("script", (Object)RenderService.getInstance().resolveScript(resource, context));
        RenderFilter cacheFilter = (RenderFilter)SpringContextSingleton.getInstance().getContext().getBean("org.jahia.services.render.filter.cache.CacheFilter");
        ModuleCacheProvider moduleCacheProvider = (ModuleCacheProvider)SpringContextSingleton.getInstance().getContext().getBean("ModuleCacheProvider");
        CacheKeyGenerator generator = moduleCacheProvider.getKeyGenerator();
        Properties properties = new Properties();
        properties.put("cache.requestParameters", "ec,v,cacheinfo,moduleinfo");
        String key = generator.generate(resource, context, properties);
        String finalKey = generator.replacePlaceholdersInCacheKey(context, key);
        moduleCacheProvider.getCache().removeAll();
        RenderChain chain = new RenderChain(new RenderFilter[]{cacheFilter, waitFilter, errorFilter, outFilter});
        HashMap<String, String> moduleMap = new HashMap<String, String>();
        moduleMap.put("aggregateFilter.rendering.key", key);
        moduleMap.put("aggregateFilter.rendering.final.key", finalKey);
        context.getRequest().setAttribute("moduleMap", moduleMap);
        String result = chain.doFilter(context, resource);
        return new CacheFilterRenderResult(key, finalKey, result);
    }

    public static class CacheRenderThread
    extends Thread {
        JCRSessionWrapper sessionWrapper;
        Integer wait;
        boolean renderError;
        String nodePath;
        String resourceConfig;
        public CacheFilterRenderResult result;
        public Exception error;
        public long timer;

        public CacheRenderThread(JCRSessionWrapper sessionWrapper, String nodePath, String resourceConfig, Integer wait, boolean renderError) {
            this.sessionWrapper = sessionWrapper;
            this.resourceConfig = resourceConfig;
            this.wait = wait;
            this.renderError = renderError;
            this.nodePath = nodePath;
        }

        @Override
        public void run() {
            long time = System.currentTimeMillis();
            try {
                this.result = NewCacheFilterTest.cacheFilterRender(this.sessionWrapper, this.nodePath, this.resourceConfig, this.wait, this.renderError);
                this.timer = System.currentTimeMillis() - time;
            }
            catch (Exception e) {
                this.error = e;
                logger.error(e.getMessage(), (Throwable)e);
                this.timer = System.currentTimeMillis() - time;
            }
        }
    }

    private static class CacheFilterRenderResult {
        public String key;
        public String finalKey;
        public String fragmentHtml;

        public CacheFilterRenderResult(String key, String finalKey, String fragmentHtml) {
            this.key = key;
            this.finalKey = finalKey;
            this.fragmentHtml = fragmentHtml;
        }
    }
}

