/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.render.filter.cache;

import java.net.URL;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.cache.AreaResourceCacheKeyPartGenerator;
import org.jahia.services.render.filter.cache.ModuleGeneratorQueue;
import org.jahia.test.services.render.filter.cache.base.CacheFilterHttpTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class OldCacheFilterHttpTest
extends CacheFilterHttpTest {
    protected static void switchCacheImplem() {
        ((AbstractFilter)SpringContextSingleton.getBean((String)"org.jahia.services.render.filter.cache.CacheFilter")).setDisabled(true);
        ((AbstractFilter)SpringContextSingleton.getBean((String)"org.jahia.services.render.filter.AggregateFilter")).setDisabled(true);
        ((AbstractFilter)SpringContextSingleton.getBean((String)"cacheFilter")).setDisabled(false);
        ((AreaResourceCacheKeyPartGenerator)SpringContextSingleton.getBean((String)"areaResourceCacheKeyPartGenerator")).setDisabled(true);
    }

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        CacheFilterHttpTest.oneTimeSetUp();
        OldCacheFilterHttpTest.switchCacheImplem();
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        CacheFilterHttpTest.oneTimeTearDown();
    }

    @Test
    public void testModuleError() throws Exception {
        String s = this.getContent(this.getUrl("/sites/cachetest/home/error"), "root", "root1234", "error1");
        Assert.assertTrue(s.contains("<!-- Module error :"));
        this.getContent(this.getUrl("/sites/cachetest/home/error"), "root", "root1234", "error2");
        Assert.assertEquals(1L, OldCacheFilterHttpTest.getCheckFilter("CacheHttpTestRenderFilter1").getData("error2").getCount());
        Thread.sleep(5000L);
        this.getContent(this.getUrl("/sites/cachetest/home/error"), "root", "root1234", "error3");
        Assert.assertEquals(2L, OldCacheFilterHttpTest.getCheckFilter("CacheHttpTestRenderFilter1").getData("error3").getCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModuleWait() throws Exception {
        long previousModuleGenerationWaitTime = ((ModuleGeneratorQueue)SpringContextSingleton.getBean((String)"moduleGeneratorQueue")).getModuleGenerationWaitTime();
        try {
            ((ModuleGeneratorQueue)SpringContextSingleton.getBean((String)"moduleGeneratorQueue")).setModuleGenerationWaitTime(1000L);
            URL url = this.getUrl("/sites/cachetest/home/long");
            CacheFilterHttpTest.HttpThread t1 = new CacheFilterHttpTest.HttpThread(url, "root", "root1234", "testModuleWait1");
            t1.start();
            Thread.sleep(1000L);
            CacheFilterHttpTest.HttpThread t2 = new CacheFilterHttpTest.HttpThread(url, "root", "root1234", "testModuleWait2");
            t2.start();
            t2.join();
            String content = this.getContent(url, "root", "root1234", "testModuleWait3");
            t1.join();
            String content1 = this.getContent(url, "root", "root1234", "testModuleWait4");
            Assert.assertFalse(t2.getResult().contains("Very long to appear"));
            Assert.assertTrue("Page title <h1>long</h1> not found in result: " + t2.getResult(), t2.getResult().contains("<h1>long</h1>"));
            Assert.assertTrue("Second thread did not spend correct time", OldCacheFilterHttpTest.getCheckFilter("CacheHttpTestRenderFilter1").getData("testModuleWait2").getTime() >= 1000L);
            Assert.assertFalse(content.contains("Very long to appear"));
            Assert.assertTrue("Page title <h1>long</h1> not found in result: " + content, content.contains("<h1>long</h1>"));
            Assert.assertEquals(1L, OldCacheFilterHttpTest.getCheckFilter("CacheHttpTestRenderFilter1").getData("testModuleWait3").getCount());
            Assert.assertTrue(t1.getResult().contains("Very long to appear"));
            Assert.assertTrue("Page title <h1>long</h1> not found in result: " + t1.getResult(), t1.getResult().contains("<h1>long</h1>"));
            Assert.assertTrue("First thread did not spend correct time", OldCacheFilterHttpTest.getCheckFilter("CacheHttpTestRenderFilter1").getData("testModuleWait1").getTime() >= 15000L);
            Assert.assertTrue(content1.contains("Very long to appear"));
            Assert.assertTrue("Page title <h1>long</h1> not found in result: " + content1, content1.contains("<h1>long</h1>"));
            Assert.assertEquals(1L, OldCacheFilterHttpTest.getCheckFilter("CacheHttpTestRenderFilter1").getData("testModuleWait4").getCount());
        }
        finally {
            ((ModuleGeneratorQueue)SpringContextSingleton.getBean((String)"moduleGeneratorQueue")).setModuleGenerationWaitTime(previousModuleGenerationWaitTime);
        }
    }

    @Test
    public void testMaxConcurrent() throws Exception {
        this.testMaxConcurrent(1000);
    }
}

