/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.render.filter.cache.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.NodeIterator;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jahia.bin.Jahia;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.cache.CacheEntry;
import org.jahia.services.cache.CacheHelper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.render.filter.AggregateFilter;
import org.jahia.services.render.filter.cache.AggregateCacheFilter;
import org.jahia.services.render.filter.cache.AreaResourceCacheKeyPartGenerator;
import org.jahia.services.render.filter.cache.CacheFilter;
import org.jahia.services.render.filter.cache.ModuleCacheProvider;
import org.jahia.services.render.filter.cache.ModuleGeneratorQueue;
import org.jahia.services.render.monitoring.DefaultRenderTimeMonitor;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.jahia.test.services.render.filter.cache.CacheFilterCheckFilter;
import org.jahia.test.services.render.filter.cache.base.CacheFilterTest;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheFilterHttpTest
extends JahiaTestCase {
    public static final Logger logger = LoggerFactory.getLogger(CacheFilterTest.class);
    public static final String TESTSITE_NAME = "cachetest";
    public static final String SITECONTENT_ROOT_NODE = "/sites/cachetest";
    public static final String LONG_PAGE_TITLE = "<h1>long</h1>";
    public static final String LONG_CREATED_ELEMENT_TEXT = "Very long to appear";
    private static boolean cacheFilterDisabled;
    private static boolean aggregateFilterDisabled;
    private static boolean aggregateCacheFilterDisabled;
    private static boolean areaResourceCacheKeyPartGeneratorDisabled;
    private String[] texts = new String[]{"visible for root", "visible for users only", "visible for userAB", "visible for userBC", "visible for userAC", "visible for groupA", "visible for groupB", "visible for groupC"};

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        try {
            JahiaSite site = TestHelper.createSite(TESTSITE_NAME, "localhost", "bootstrap-acme-space-templates");
            Assert.assertNotNull(site);
            JCRStoreService jcrService = ServicesRegistry.getInstance().getJCRStoreService();
            JCRSessionWrapper session = jcrService.getSessionFactory().getCurrentUserSession();
            ServicesRegistry.getInstance().getJahiaTemplateManagerService().installModule("jahia-test-module", SITECONTENT_ROOT_NODE, session.getUser().getName());
            JahiaUserManagerService userManagerProvider = JahiaUserManagerService.getInstance();
            JCRUserNode userAB = userManagerProvider.createUser("userAB", "password", new Properties(), session);
            JCRUserNode userAC = userManagerProvider.createUser("userAC", "password", new Properties(), session);
            JCRUserNode userBC = userManagerProvider.createUser("userBC", "password", new Properties(), session);
            userManagerProvider.createUser("user1", "password", new Properties(), session);
            userManagerProvider.createUser("user2", "password", new Properties(), session);
            userManagerProvider.createUser("user3", "password", new Properties(), session);
            JahiaGroupManagerService groupManagerProvider = JahiaGroupManagerService.getInstance();
            JCRGroupNode groupA = groupManagerProvider.createGroup(site.getSiteKey(), "groupA", new Properties(), false, session);
            JCRGroupNode groupB = groupManagerProvider.createGroup(site.getSiteKey(), "groupB", new Properties(), false, session);
            JCRGroupNode groupC = groupManagerProvider.createGroup(site.getSiteKey(), "groupC", new Properties(), false, session);
            groupA.addMember((JCRNodeWrapper)userAB);
            groupA.addMember((JCRNodeWrapper)userAC);
            groupB.addMember((JCRNodeWrapper)userAB);
            groupB.addMember((JCRNodeWrapper)userBC);
            groupC.addMember((JCRNodeWrapper)userAC);
            groupC.addMember((JCRNodeWrapper)userBC);
            InputStream importStream = CacheFilterHttpTest.class.getClassLoader().getResourceAsStream("imports/cachetest-site.xml");
            session.importXML(SITECONTENT_ROOT_NODE, importStream, 1);
            importStream.close();
            session.save();
            JCRNodeWrapper siteNode = session.getNode(SITECONTENT_ROOT_NODE);
            JCRPublicationService.getInstance().publishByMainId(siteNode.getIdentifier(), "default", "live", null, true, null);
            cacheFilterDisabled = ((CacheFilter)SpringContextSingleton.getBean((String)"org.jahia.services.render.filter.cache.CacheFilter")).isDisabled();
            aggregateFilterDisabled = ((AggregateFilter)SpringContextSingleton.getBean((String)"org.jahia.services.render.filter.AggregateFilter")).isDisabled();
            aggregateCacheFilterDisabled = ((AggregateCacheFilter)SpringContextSingleton.getBean((String)"cacheFilter")).isDisabled();
            areaResourceCacheKeyPartGeneratorDisabled = ((AreaResourceCacheKeyPartGenerator)SpringContextSingleton.getBean((String)"areaResourceCacheKeyPartGenerator")).isDisabled();
            CacheFilterHttpTest.getCheckFilter("CacheHttpTestRenderFilter1").setDisabled(false);
            CacheFilterHttpTest.getCheckFilter("CacheHttpTestRenderFilter2").setDisabled(false);
        }
        catch (Exception e) {
            logger.warn("Exception during test setUp", (Throwable)e);
            Assert.fail();
        }
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        try {
            TestHelper.deleteSite(TESTSITE_NAME);
            JahiaUserManagerService userManagerProvider = JahiaUserManagerService.getInstance();
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
            userManagerProvider.deleteUser(userManagerProvider.lookupUser("userAB").getPath(), session);
            userManagerProvider.deleteUser(userManagerProvider.lookupUser("userAC").getPath(), session);
            userManagerProvider.deleteUser(userManagerProvider.lookupUser("userBC").getPath(), session);
            userManagerProvider.deleteUser(userManagerProvider.lookupUser("user1").getPath(), session);
            userManagerProvider.deleteUser(userManagerProvider.lookupUser("user2").getPath(), session);
            userManagerProvider.deleteUser(userManagerProvider.lookupUser("user3").getPath(), session);
            session.save();
            ((CacheFilter)SpringContextSingleton.getBean((String)"org.jahia.services.render.filter.cache.CacheFilter")).setDisabled(cacheFilterDisabled);
            ((AggregateFilter)SpringContextSingleton.getBean((String)"org.jahia.services.render.filter.AggregateFilter")).setDisabled(aggregateFilterDisabled);
            ((AggregateCacheFilter)SpringContextSingleton.getBean((String)"cacheFilter")).setDisabled(aggregateCacheFilterDisabled);
            ((AreaResourceCacheKeyPartGenerator)SpringContextSingleton.getBean((String)"areaResourceCacheKeyPartGenerator")).setDisabled(areaResourceCacheKeyPartGeneratorDisabled);
            CacheFilterHttpTest.getCheckFilter("CacheHttpTestRenderFilter1").setDisabled(true);
            CacheFilterHttpTest.getCheckFilter("CacheHttpTestRenderFilter2").setDisabled(true);
            CacheFilterHttpTest.getCheckFilter("CacheHttpTestRenderFilter1").clear();
            CacheFilterHttpTest.getCheckFilter("CacheHttpTestRenderFilter2").clear();
        }
        catch (Exception e) {
            logger.warn("Exception during test tearDown", (Throwable)e);
        }
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @Before
    public void setUp() {
        this.clearAll();
    }

    private void clearAll() {
        ModuleCacheProvider cacheProvider = ModuleCacheProvider.getInstance();
        Cache cache = cacheProvider.getCache();
        Cache depCache = cacheProvider.getDependenciesCache();
        cache.flush();
        cache.removeAll();
        depCache.flush();
        depCache.removeAll();
        cacheProvider.flushNonCacheableFragments();
        CacheFilterHttpTest.getCheckFilter("CacheHttpTestRenderFilter1").clear();
        CacheFilterHttpTest.getCheckFilter("CacheHttpTestRenderFilter2").clear();
        cache.getCacheConfiguration().setEternal(true);
        depCache.getCacheConfiguration().setEternal(true);
    }

    @After
    public void tearDown() {
        ModuleCacheProvider cacheProvider = ModuleCacheProvider.getInstance();
        Cache cache = cacheProvider.getCache();
        Cache depCache = cacheProvider.getDependenciesCache();
        cache.getCacheConfiguration().setEternal(false);
        depCache.getCacheConfiguration().setEternal(false);
    }

    @Test
    public void testACLs() throws Exception {
        this.testACLs("/sites/cachetest/home/acl1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReferencesFlush() throws Exception {
        URL url = this.getUrl("/sites/cachetest/home/references");
        this.getContent(url, "root", "root1234", null);
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("live", new Locale("en"));
        JCRNodeWrapper n = session.getNode("/sites/cachetest/home/references/main/simple-text");
        try {
            n.setProperty("text", "text content updated");
            session.save();
            String newvalue = this.getContent(url, "root", "root1234", "testReferencesFlush1");
            Matcher m = Pattern.compile("text content updated").matcher(newvalue);
            Assert.assertTrue("Value has not been updated", m.find());
            Assert.assertTrue("References have not been flushed", m.find());
            Assert.assertTrue("References have not been flushed", m.find());
        }
        finally {
            n.setProperty("text", "text content");
            session.save();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRandomFlush() throws Exception {
        void var11_14;
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("live", new Locale("en"));
        QueryWrapper q = session.getWorkspace().getQueryManager().createQuery("select * from [jnt:page] as p where isdescendantnode(p,'/sites/cachetest/home')", "JCR-SQL2");
        ArrayList<String> paths = new ArrayList<String>();
        NodeIterator nodes = q.execute().getNodes();
        HashSet<String> skipped = new HashSet<String>(Arrays.asList("long", "error", "user-per-content-test", "simple-page-A", "simple-page-B", "simple-page-C", "simple-page-AC", "simple-page-BC", "simple-page-AB", "simple-page-root", "simple-page-users"));
        while (nodes.hasNext()) {
            JCRNodeWrapper next = (JCRNodeWrapper)nodes.next();
            if (skipped.contains(next.getName())) continue;
            paths.add(next.getPath());
        }
        List<String> users = Arrays.asList("userAB", "userAC", "userBC");
        HashMap<String, String> m = new HashMap<String, String>();
        for (String user : users) {
            for (String string : paths) {
                m.put(user + string, this.getContent(this.getUrl(string), user, "password", null));
            }
        }
        Cache cache = ModuleCacheProvider.getInstance().getCache();
        List keysBefore = cache.getKeys();
        HashMap<String, Object> cacheCopy = new HashMap<String, Object>();
        for (String s : keysBefore) {
            Element element = cache.get((Serializable)((Object)s));
            if (element == null) continue;
            cacheCopy.put(s, element.getObjectValue());
        }
        boolean bl = false;
        while (var11_14 < 10) {
            System.out.println("flush " + (int)var11_14);
            List<String> toFlush = this.randomizeFlush(keysBefore, 10);
            for (String user : users) {
                for (String path : paths) {
                    System.out.println(user + " - " + path);
                    Assert.assertEquals("Different content for " + user + " , " + path + " when flushing : " + toFlush, m.get(user + path), this.getContent(this.getUrl(path), user, "password", null));
                    this.checkCacheContent(cache, cacheCopy, toFlush);
                }
            }
            List keysAfter = cache.getKeys();
            Collections.sort(keysBefore);
            Collections.sort(keysAfter);
            if (!keysBefore.equals(keysAfter)) {
                ArrayList onlyInBefore = new ArrayList(keysBefore);
                onlyInBefore.removeAll(keysAfter);
                ArrayList onlyInAfter = new ArrayList(keysAfter);
                onlyInAfter.removeAll(keysBefore);
                Assert.fail("Key sets are not the same before and after flushing : " + toFlush + "\n Before flushs :" + onlyInBefore + " ,\n After flush : " + onlyInAfter);
            }
            this.checkCacheContent(cache, cacheCopy, toFlush);
            ++var11_14;
        }
    }

    @Test
    public void testACLsUserPerContent() throws Exception {
        String path = "/sites/cachetest/home/user-per-content-test";
        String contentForUser1 = this.getContent(this.getUrl(path), "user1", "password", "testACLs11");
        Assert.assertTrue("user1 cannot see content, she should see", contentForUser1.contains("content for user1"));
        Assert.assertFalse("user1 sees content, she should not see", contentForUser1.contains("content for user2"));
        Assert.assertFalse("user1 sees content, she should not see", contentForUser1.contains("content for user3"));
        String contentForUser2 = this.getContent(this.getUrl(path), "user2", "password", "testACLs12");
        Assert.assertTrue("user2 cannot see content, she should see", contentForUser2.contains("content for user2"));
        Assert.assertFalse("user2 sees content, she should not see", contentForUser2.contains("content for user1"));
        Assert.assertFalse("user2 sees content, she should not see", contentForUser2.contains("content for user3"));
        String contentForUser3 = this.getContent(this.getUrl(path), "user3", "password", "testACLs13");
        Assert.assertTrue("user3 cannot see content, she should see", contentForUser3.contains("content for user3"));
        Assert.assertFalse("user3 sees content, she should not see", contentForUser3.contains("content for user1"));
        Assert.assertFalse("user3 sees content, she should not see", contentForUser3.contains("content for user2"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMaxConcurrent(int generationTime) throws Exception {
        long previousModuleGenerationWaitTime = ((ModuleGeneratorQueue)SpringContextSingleton.getBean((String)"moduleGeneratorQueue")).getModuleGenerationWaitTime();
        int previousMaxModulesToGenerateInParallel = ((ModuleGeneratorQueue)SpringContextSingleton.getBean((String)"moduleGeneratorQueue")).getMaxModulesToGenerateInParallel();
        try {
            ((ModuleGeneratorQueue)SpringContextSingleton.getBean((String)"moduleGeneratorQueue")).setModuleGenerationWaitTime((long)generationTime);
            ((ModuleGeneratorQueue)SpringContextSingleton.getBean((String)"moduleGeneratorQueue")).setMaxModulesToGenerateInParallel(1);
            HttpThread t1 = new HttpThread(this.getUrl("/sites/cachetest/home/long"), "root", "root1234", "testMaxConcurrent1");
            t1.start();
            Thread.sleep(500L);
            HttpThread t2 = new HttpThread(this.getUrl("/sites/cachetest/home"), "root", "root1234", "testMaxConcurrent2");
            t2.start();
            t2.join();
            t1.join();
            Assert.assertEquals("Incorrect response code for first thread", 200L, t1.resultCode);
            Assert.assertEquals("Incorrect response code for second thread", 503L, t2.resultCode);
            Assert.assertTrue(this.getContent(this.getUrl("/sites/cachetest/home"), "root", "root1234", "testMaxConcurrent3").contains("<title>Home</title>"));
        }
        finally {
            ((ModuleGeneratorQueue)SpringContextSingleton.getBean((String)"moduleGeneratorQueue")).setModuleGenerationWaitTime(previousModuleGenerationWaitTime);
            ((ModuleGeneratorQueue)SpringContextSingleton.getBean((String)"moduleGeneratorQueue")).setMaxModulesToGenerateInParallel(previousMaxModulesToGenerateInParallel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxRequestRenderTime() throws Exception {
        DefaultRenderTimeMonitor renderTimeMonitor = (DefaultRenderTimeMonitor)SpringContextSingleton.getBean((String)"RenderTimeMonitor");
        long previousMaxRequestRenderTime = renderTimeMonitor.getMaxRequestRenderTime();
        try {
            renderTimeMonitor.setMaxRequestRenderTime(-1L);
            long startTime = System.currentTimeMillis();
            Assert.assertTrue(this.getContent(this.getUrl("/sites/cachetest/home/long5"), "root", "root1234", "testMaxConcurrent3").contains(LONG_CREATED_ELEMENT_TEXT));
            Assert.assertTrue("Execution time was too short", System.currentTimeMillis() - startTime >= 5000L);
            CacheHelper.flushOutputCaches();
            renderTimeMonitor.setMaxRequestRenderTime(3000L);
            HttpThread t1 = new HttpThread(this.getUrl("/sites/cachetest/home/long5"), "root", "root1234", "testMaxConcurrent1");
            t1.start();
            Thread.sleep(500L);
            HttpThread t2 = new HttpThread(this.getUrl("/sites/cachetest/home/long5"), "root", "root1234", "testMaxConcurrent2");
            t2.start();
            t2.join();
            t1.join();
            Assert.assertEquals("Incorrect response code for first thread", 503L, t1.resultCode);
            Assert.assertEquals("Incorrect response code for second thread", 503L, t2.resultCode);
            Assert.assertTrue(this.getContent(this.getUrl("/sites/cachetest/home/long5"), "root", "root1234", "testMaxConcurrent3").contains(LONG_CREATED_ELEMENT_TEXT));
        }
        finally {
            renderTimeMonitor.setMaxRequestRenderTime(previousMaxRequestRenderTime);
        }
    }

    static void permute(List<String> arr, int k, List<List<String>> res) {
        for (int i = k; i < arr.size(); ++i) {
            Collections.swap(arr, i, k);
            CacheFilterHttpTest.permute(arr, k + 1, res);
            Collections.swap(arr, k, i);
        }
        if (k == arr.size() - 1) {
            res.add(new ArrayList<String>(arr));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testACLs(String path) throws Exception {
        List<String> users = Arrays.asList(null, "root", "userAB", "userAC");
        ArrayList<List<String>> allPerms = new ArrayList<List<String>>();
        CacheFilterHttpTest.permute(users, 0, allPerms);
        HashMap<String, String> results = new HashMap<String, String>();
        for (List list : allPerms) {
            results.clear();
            this.clearAll();
            for (String user : list) {
                results.put(user, this.getContent(this.getUrl(path), user, this.getPassword(user), null));
            }
            try {
                this.checkAcl(list + ", guest : ", (String)results.get(null), new boolean[]{false, false, false, false, false, false, false, false});
                this.checkAcl(list + ", root : ", (String)results.get("root"), new boolean[]{true, true, true, true, true, true, true, true});
                this.checkAcl(list + ", userAB : ", (String)results.get("userAB"), new boolean[]{false, true, true, false, false, true, true, false});
                this.checkAcl(list + ", userAC : ", (String)results.get("userAC"), new boolean[]{false, true, false, false, true, true, false, true});
            }
            catch (AssertionError e) {
                logger.error(((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
                throw e;
            }
        }
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("live", new Locale("en"));
        JCRNodeWrapper jCRNodeWrapper = session.getNode(path + "/main/simple-text-A");
        JCRNodeWrapper n2 = session.getNode(path + "/simple-page-A");
        try {
            jCRNodeWrapper.revokeRolesForPrincipal("g:groupA");
            jCRNodeWrapper.grantRoles("g:groupB", new HashSet<String>(Arrays.asList("reader")));
            n2.revokeRolesForPrincipal("g:groupA");
            n2.grantRoles("g:groupB", new HashSet<String>(Arrays.asList("reader")));
            session.save();
            HashMap<String, String> results2 = new HashMap<String, String>();
            for (String user : users) {
                results2.put(user, this.getContent(this.getUrl(path), user, this.getPassword(user), null));
            }
            this.checkAcl(users + ", guest : ", (String)results2.get(null), new boolean[]{false, false, false, false, false, false, false, false});
            this.checkAcl(users + ", root : ", (String)results2.get("root"), new boolean[]{true, true, true, true, true, true, true, true});
            this.checkAcl(users + ", userAB : ", (String)results2.get("userAB"), new boolean[]{false, true, true, false, false, true, true, false});
            this.checkAcl(users + ", userAC : ", (String)results2.get("userAC"), new boolean[]{false, true, false, false, true, false, false, true});
        }
        catch (Throwable throwable) {
            jCRNodeWrapper.revokeRolesForPrincipal("g:groupB");
            jCRNodeWrapper.grantRoles("g:groupA", new HashSet<String>(Arrays.asList("reader")));
            n2.revokeRolesForPrincipal("g:groupB");
            n2.grantRoles("g:groupA", new HashSet<String>(Arrays.asList("reader")));
            session.save();
            throw throwable;
        }
        jCRNodeWrapper.revokeRolesForPrincipal("g:groupB");
        jCRNodeWrapper.grantRoles("g:groupA", new HashSet<String>(Arrays.asList("reader")));
        n2.revokeRolesForPrincipal("g:groupB");
        n2.grantRoles("g:groupA", new HashSet<String>(Arrays.asList("reader")));
        session.save();
        for (String user : users) {
            Assert.assertEquals("Content served is not the same for " + user, results.get(user), this.getContent(this.getUrl(path), user, this.getPassword(user), null));
        }
    }

    private String getPassword(String user) {
        return user == null ? null : (user.equals("root") ? "root1234" : "password");
    }

    private void checkAcl(String message, String content, boolean[] b) {
        for (int i = 0; i < this.texts.length; ++i) {
            Assert.assertEquals(message + " , " + this.texts[i], b[i], content.contains(this.texts[i]));
        }
    }

    public static CacheFilterCheckFilter getCheckFilter(String id) {
        return (CacheFilterCheckFilter)((Object)SpringContextSingleton.getBean((String)id));
    }

    public void checkCacheContent(Cache cache, Map<String, Object> cacheCopy, List<String> toFlush) {
        List keysNow = cache.getKeys();
        for (String s : keysNow) {
            CacheEntry c1 = (CacheEntry)cacheCopy.get(s);
            Element element = cache.get((Serializable)((Object)s));
            if (element == null || c1 == null) continue;
            CacheEntry c2 = (CacheEntry)element.getObjectValue();
            Assert.assertEquals("Cache fragment different for : " + s + " after flushing : " + toFlush, c1.getObject(), c2.getObject());
            Assert.assertEquals("Cache properties different for : " + s + " after flushing : " + toFlush, c1.getExtendedProperties(), c2.getExtendedProperties());
        }
    }

    public List<String> randomizeFlush(List<String> l, int number) {
        Random r = new Random();
        ArrayList<String> toFlush = new ArrayList<String>();
        for (int i = 0; i < number; ++i) {
            String s = l.get(r.nextInt(l.size()));
            toFlush.add(s);
            ModuleCacheProvider.getInstance().getCache().remove((Serializable)((Object)s));
        }
        return toFlush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContent(URL url, String user, String password, String requestId) throws Exception {
        String content = null;
        GetMethod method = null;
        try {
            method = this.executeCall(url, user, password, requestId);
            Assert.assertEquals("Bad result code", 200L, method.getStatusCode());
            content = method.getResponseBodyAsString();
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return content;
    }

    public GetMethod executeCall(URL url, String user, String password, String requestId) throws IOException {
        HttpClient client = new HttpClient();
        client.getParams().setAuthenticationPreemptive(true);
        if (user != null && password != null) {
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(user, password);
            client.getState().setCredentials(new AuthScope(url.getHost(), url.getPort(), AuthScope.ANY_REALM), (Credentials)defaultcreds);
        }
        client.getHostConfiguration().setHost(url.getHost(), url.getPort(), url.getProtocol());
        GetMethod method = new GetMethod(url.toExternalForm());
        if (requestId != null) {
            method.setRequestHeader("request-id", requestId);
        }
        client.executeMethod((HttpMethod)method);
        return method;
    }

    public URL getUrl(String path) throws MalformedURLException {
        String baseurl = this.getBaseServerURL() + Jahia.getContextPath() + "/cms";
        return new URL(baseurl + "/render/live/en" + path + ".html");
    }

    public class HttpThread
    extends Thread {
        public String result;
        public int resultCode;
        public URL url;
        public String user;
        public String password;
        public String requestId;

        public HttpThread(URL url, String user, String password, String requestId) {
            this.url = url;
            this.user = user;
            this.password = password;
            this.requestId = requestId;
        }

        public String getResult() {
            return this.result;
        }

        @Override
        public void run() {
            GetMethod method = null;
            try {
                method = CacheFilterHttpTest.this.executeCall(this.url, this.user, this.password, this.requestId);
                this.resultCode = method.getStatusCode();
                this.result = method.getResponseBodyAsString();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
    }
}

