/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.render.filter.channels;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jahia.bin.Jahia;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.sites.JahiaSite;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelResolutionAndExclusionTest
extends JahiaTestCase {
    private static Logger logger = LoggerFactory.getLogger(ChannelResolutionAndExclusionTest.class);
    private static final String TESTSITE_NAME = "channelsTestSite";
    private static final String SITECONTENT_ROOT_NODE = "/sites/channelsTestSite";

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        try {
            JahiaSite site = TestHelper.createSite(TESTSITE_NAME, "localhost", "templates-web-space");
            Assert.assertNotNull(site);
            JCRStoreService jcrService = ServicesRegistry.getInstance().getJCRStoreService();
            JCRSessionWrapper session = jcrService.getSessionFactory().getCurrentUserSession();
            InputStream importStream = ChannelResolutionAndExclusionTest.class.getClassLoader().getResourceAsStream("imports/importChannelsTest.xml");
            session.importXML(SITECONTENT_ROOT_NODE, importStream, 1);
            importStream.close();
            session.save();
            JCRNodeWrapper siteNode = session.getNode(SITECONTENT_ROOT_NODE);
            JCRPublicationService.getInstance().publishByMainId(siteNode.getIdentifier(), "default", "live", null, true, null);
        }
        catch (Exception ex) {
            logger.warn("Exception during test setUp", (Throwable)ex);
            Assert.fail();
        }
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        try {
            TestHelper.deleteSite(TESTSITE_NAME);
        }
        catch (Exception e) {
            logger.warn("Exception during test tearDown", (Throwable)e);
        }
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGenericChannelResolution() throws Exception, IOException {
        HttpClient client = new HttpClient();
        GetMethod nodeGet = new GetMethod(this.getBaseServerURL() + Jahia.getContextPath() + "/cms/render/live/en" + SITECONTENT_ROOT_NODE + "/home.html");
        String response = null;
        try {
            int responseCode = client.executeMethod((HttpMethod)nodeGet);
            Assert.assertEquals("Response code " + responseCode, 200L, responseCode);
            response = nodeGet.getResponseBodyAsString();
            Assert.assertTrue("This text should be displayed on generic channel", response.contains("This banner shouldn&#39;t appear on an iPhone."));
        }
        finally {
            nodeGet.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSupportedChannelResolution() throws Exception, IOException {
        HttpClient client = new HttpClient();
        client.getParams().setParameter("http.useragent", (Object)"Mozilla/5.0 (iPhone; CPU iPhone OS 5_0 like Mac OS X) AppleWebKit/534.46 (KHTML, like Gecko) Version/5.1 Mobile/9A334 Safari/7534.48.3");
        GetMethod nodeGet = new GetMethod(this.getBaseServerURL() + Jahia.getContextPath() + "/cms/render/live/en" + SITECONTENT_ROOT_NODE + "/home.html");
        String response = null;
        try {
            int responseCode = client.executeMethod((HttpMethod)nodeGet);
            Assert.assertEquals("Response code " + responseCode, 200L, responseCode);
            response = nodeGet.getResponseBodyAsString();
            Assert.assertFalse("This text shouldn't be displayed on iPhone channel", response.contains("This banner shouldn&#39;t appear on an iPhone."));
        }
        finally {
            nodeGet.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnsupportedChannelResolution() throws Exception, IOException {
        HttpClient client = new HttpClient();
        client.getParams().setParameter("http.useragent", (Object)"Mozilla/5.0 (SymbianOS/9.4; Series60/5.0 NokiaN97-1/12.0.024; Profile/MIDP-2.1 Configuration/CLDC-1.1; en-us) AppleWebKit/525 (KHTML, like Gecko) BrowserNG/7.1.12344");
        GetMethod nodeGet = new GetMethod(this.getBaseServerURL() + Jahia.getContextPath() + "/cms/render/live/en" + SITECONTENT_ROOT_NODE + "/home.html");
        String response = null;
        try {
            int responseCode = client.executeMethod((HttpMethod)nodeGet);
            Assert.assertEquals("Response code " + responseCode, 200L, responseCode);
            response = nodeGet.getResponseBodyAsString();
            Assert.assertTrue("Non supported channel should fall back on generic", response.contains("This banner shouldn&#39;t appear on an iPhone."));
        }
        finally {
            nodeGet.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonExcludedChannel() throws Exception, IOException {
        HttpClient client = new HttpClient();
        client.getParams().setParameter("http.useragent", (Object)"Mozilla/5.0 (iPhone; CPU iPhone OS 5_0 like Mac OS X) AppleWebKit/534.46 (KHTML, like Gecko) Version/5.1 Mobile/9A334 Safari/7534.48.3");
        GetMethod nodeGet = new GetMethod(this.getBaseServerURL() + Jahia.getContextPath() + "/cms/render/live/en" + SITECONTENT_ROOT_NODE + "/home.html");
        String response = null;
        try {
            int responseCode = client.executeMethod((HttpMethod)nodeGet);
            Assert.assertEquals("Response code " + responseCode, 200L, responseCode);
            response = nodeGet.getResponseBodyAsString();
            Assert.assertTrue("This text should be displayed when channel is not iPad", response.contains("This text shouldn&#39;t appear on an iPad."));
        }
        finally {
            nodeGet.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExcludedChannel() throws Exception, IOException {
        HttpClient client = new HttpClient();
        client.getParams().setParameter("http.useragent", (Object)"Mozilla/5.0 (iPad; CPU OS 5_0 like Mac OS X) AppleWebKit/534.46 (KHTML, like Gecko) Version/5.1 Mobile/9A334 Safari/7534.48.3");
        GetMethod nodeGet = new GetMethod(this.getBaseServerURL() + Jahia.getContextPath() + "/cms/render/live/en" + SITECONTENT_ROOT_NODE + "/home.html");
        String response = null;
        try {
            int responseCode = client.executeMethod((HttpMethod)nodeGet);
            Assert.assertEquals("Response code " + responseCode, 200L, responseCode);
            response = nodeGet.getResponseBodyAsString();
            Assert.assertFalse("This text should be hidden when channel is iPad", response.contains("This text shouldn&#39;t appear on an iPad."));
        }
        finally {
            nodeGet.releaseConnection();
        }
    }
}

