/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.search;

import java.util.List;
import java.util.Locale;
import javax.jcr.RepositoryException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLGenerator;
import org.jahia.services.search.Hit;
import org.jahia.services.search.SearchCriteria;
import org.jahia.services.search.SearchService;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSearchTest
extends JahiaTestCase {
    private static Logger logger = LoggerFactory.getLogger(SimpleSearchTest.class);
    private static final String FIRST_TESTSITE_NAME = "jcrSearchTest";
    private static final String SECOND_TESTSITE_NAME = "jcrSearchTest2";
    private static final String FIRST_SITECONTENT_ROOT_NODE = "/sites/jcrSearchTest";
    private static final String SECOND_SITECONTENT_ROOT_NODE = "/sites/jcrSearchTest2";

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    try {
                        TestHelper.createSite(SimpleSearchTest.FIRST_TESTSITE_NAME, "localhost", "templates-web", "prepackagedSites/acme.zip", "ACME.zip");
                        session.save();
                    }
                    catch (Exception ex) {
                        logger.warn("Exception during site creation", (Throwable)ex);
                        Assert.fail("Exception during site creation");
                    }
                    return null;
                }
            });
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
            session.getUuidMapping().clear();
            session.getPathMapping().clear();
            JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    try {
                        TestHelper.createSite(SimpleSearchTest.SECOND_TESTSITE_NAME, "127.0.0.1", "templates-web", "prepackagedSites/acme.zip", "ACME.zip");
                        session.save();
                    }
                    catch (Exception ex) {
                        logger.warn("Exception during site creation", (Throwable)ex);
                        Assert.fail("Exception during site creation");
                    }
                    return null;
                }
            });
        }
        catch (Exception ex) {
            logger.warn("Exception during test setUp", (Throwable)ex);
            Assert.fail();
        }
    }

    private RenderContext getContext() throws RepositoryException {
        return this.getContext(FIRST_SITECONTENT_ROOT_NODE, Locale.ENGLISH);
    }

    private RenderContext getContext(String siteRootNode, Locale locale) throws RepositoryException {
        RenderContext context = new RenderContext(SimpleSearchTest.getRequest(), SimpleSearchTest.getResponse(), SimpleSearchTest.getUser());
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession(null, locale);
        JCRNodeWrapper homeNode = session.getNode(siteRootNode + "/home");
        Resource resource = new Resource(homeNode, "html", null, "page");
        context.setMainResource(resource);
        context.setSite(homeNode.getResolveSite());
        context.setServletPath("/cms/render");
        new URLGenerator(context, resource);
        return context;
    }

    @Test
    public void testSimpleFulltextSearchOnSingleSite() throws Exception {
        SearchService searchService = ServicesRegistry.getInstance().getSearchService();
        RenderContext context = this.getContext();
        SearchCriteria criteria = new SearchCriteria();
        SearchCriteria.CommaSeparatedMultipleValue oneSite = new SearchCriteria.CommaSeparatedMultipleValue();
        oneSite.setValue(FIRST_TESTSITE_NAME);
        SearchCriteria.CommaSeparatedMultipleValue englishLang = new SearchCriteria.CommaSeparatedMultipleValue();
        englishLang.setValue("en");
        criteria.setSites(oneSite);
        criteria.setLanguages(englishLang);
        ((SearchCriteria.Term)criteria.getTerms().get(0)).setTerm("ACME");
        ((SearchCriteria.Term)criteria.getTerms().get(0)).getFields().setSiteContent(true);
        List hits = searchService.search(criteria, context).getResults();
        int i = 0;
        for (Hit hit : hits) {
            logger.info("[" + ++i + "]: " + hit.getLink());
        }
        Assert.assertEquals("Unexpected number of search results for: " + criteria.toString(), 19L, hits.size());
    }

    @Test
    public void testSimpleFulltextSearchOnSingleSiteInFrench() throws Exception {
        SearchService searchService = ServicesRegistry.getInstance().getSearchService();
        RenderContext context = this.getContext(FIRST_SITECONTENT_ROOT_NODE, Locale.FRENCH);
        SearchCriteria criteria = new SearchCriteria();
        SearchCriteria.CommaSeparatedMultipleValue oneSite = new SearchCriteria.CommaSeparatedMultipleValue();
        oneSite.setValue(FIRST_TESTSITE_NAME);
        SearchCriteria.CommaSeparatedMultipleValue frenchLang = new SearchCriteria.CommaSeparatedMultipleValue();
        frenchLang.setValue("fr");
        criteria.setSites(oneSite);
        criteria.setLanguages(frenchLang);
        ((SearchCriteria.Term)criteria.getTerms().get(0)).setTerm("ACME");
        ((SearchCriteria.Term)criteria.getTerms().get(0)).getFields().setSiteContent(true);
        List hits = searchService.search(criteria, context).getResults();
        Assert.assertEquals("Unexpected number of search results for: " + criteria.toString(), 15L, hits.size());
    }

    @Test
    public void testSimpleFulltextSearchOnSingleSiteInDocsOnly() throws Exception {
        SearchService searchService = ServicesRegistry.getInstance().getSearchService();
        RenderContext context = this.getContext();
        SearchCriteria criteria = new SearchCriteria();
        SearchCriteria.CommaSeparatedMultipleValue oneSite = new SearchCriteria.CommaSeparatedMultipleValue();
        oneSite.setValue(FIRST_TESTSITE_NAME);
        SearchCriteria.CommaSeparatedMultipleValue englishLang = new SearchCriteria.CommaSeparatedMultipleValue();
        englishLang.setValue("en");
        criteria.setSites(oneSite);
        criteria.setLanguages(englishLang);
        ((SearchCriteria.Term)criteria.getTerms().get(0)).setTerm("ACME");
        ((SearchCriteria.Term)criteria.getTerms().get(0)).getFields().setFileContent(true);
        ((SearchCriteria.Term)criteria.getTerms().get(0)).getFields().setTitle(true);
        ((SearchCriteria.Term)criteria.getTerms().get(0)).getFields().setDescription(true);
        ((SearchCriteria.Term)criteria.getTerms().get(0)).getFields().setFilename(true);
        ((SearchCriteria.Term)criteria.getTerms().get(0)).getFields().setKeywords(true);
        List hits = searchService.search(criteria, context).getResults();
        Assert.assertEquals("Unexpected number of search results for: " + criteria.toString(), 15L, hits.size());
        criteria.setFileType("pdf");
        hits = searchService.search(criteria, context).getResults();
        Assert.assertEquals("Unexpected number of search results for: " + criteria.toString(), 10L, hits.size());
    }

    @Test
    public void testFulltextMatchTypeSearchOnSingleSite() throws Exception {
        SearchService searchService = ServicesRegistry.getInstance().getSearchService();
        RenderContext context = this.getContext();
        SearchCriteria criteria = new SearchCriteria();
        SearchCriteria.CommaSeparatedMultipleValue oneSite = new SearchCriteria.CommaSeparatedMultipleValue();
        oneSite.setValue(FIRST_TESTSITE_NAME);
        SearchCriteria.CommaSeparatedMultipleValue englishLang = new SearchCriteria.CommaSeparatedMultipleValue();
        englishLang.setValue("en");
        criteria.setSites(oneSite);
        criteria.setLanguages(englishLang);
        ((SearchCriteria.Term)criteria.getTerms().get(0)).setTerm("civil Polytech");
        ((SearchCriteria.Term)criteria.getTerms().get(0)).setMatch(SearchCriteria.Term.MatchType.ALL_WORDS);
        ((SearchCriteria.Term)criteria.getTerms().get(0)).getFields().setSiteContent(true);
        List hits = searchService.search(criteria, context).getResults();
        Assert.assertEquals("Unexpected number of search results for: " + criteria.toString(), 1L, hits.size());
        ((SearchCriteria.Term)criteria.getTerms().get(0)).setTerm("civil Polytech");
        ((SearchCriteria.Term)criteria.getTerms().get(0)).setMatch(SearchCriteria.Term.MatchType.ANY_WORD);
        hits = searchService.search(criteria, context).getResults();
        Assert.assertEquals("Unexpected number of search results for: " + criteria.toString(), 3L, hits.size());
        ((SearchCriteria.Term)criteria.getTerms().get(0)).setTerm("civil engineering");
        ((SearchCriteria.Term)criteria.getTerms().get(0)).setMatch(SearchCriteria.Term.MatchType.EXACT_PHRASE);
        hits = searchService.search(criteria, context).getResults();
        Assert.assertEquals("Unexpected number of search results for: " + criteria.toString(), 3L, hits.size());
        ((SearchCriteria.Term)criteria.getTerms().get(0)).setTerm("civil -engineering");
        ((SearchCriteria.Term)criteria.getTerms().get(0)).setMatch(SearchCriteria.Term.MatchType.AS_IS);
        hits = searchService.search(criteria, context).getResults();
        Assert.assertEquals("Unexpected number of search results for: " + criteria.toString(), 0L, hits.size());
        ((SearchCriteria.Term)criteria.getTerms().get(0)).setTerm("civil");
        ((SearchCriteria.Term)criteria.getTerms().get(0)).setMatch(SearchCriteria.Term.MatchType.ANY_WORD);
        ((SearchCriteria.Term)criteria.getTerms().get(1)).setTerm("engineering");
        ((SearchCriteria.Term)criteria.getTerms().get(1)).setMatch(SearchCriteria.Term.MatchType.WITHOUT_WORDS);
        hits = searchService.search(criteria, context).getResults();
        Assert.assertEquals("Unexpected number of search results for: " + criteria.toString(), 0L, hits.size());
    }

    @Test
    public void testSimpleFulltextSearchOnTwoSites() throws Exception {
        SearchService searchService = ServicesRegistry.getInstance().getSearchService();
        RenderContext context = this.getContext(SECOND_SITECONTENT_ROOT_NODE, Locale.ENGLISH);
        SearchCriteria criteria = new SearchCriteria();
        SearchCriteria.CommaSeparatedMultipleValue twoSites = new SearchCriteria.CommaSeparatedMultipleValue();
        twoSites.setValue("jcrSearchTest,jcrSearchTest2");
        SearchCriteria.CommaSeparatedMultipleValue englishLang = new SearchCriteria.CommaSeparatedMultipleValue();
        englishLang.setValue("en");
        criteria.setSites(twoSites);
        criteria.setLanguages(englishLang);
        ((SearchCriteria.Term)criteria.getTerms().get(0)).setTerm("ACME");
        ((SearchCriteria.Term)criteria.getTerms().get(0)).getFields().setSiteContent(true);
        List hits = searchService.search(criteria, context).getResults();
        Assert.assertEquals("Unexpected number of search results for: " + criteria.toString(), 38L, hits.size());
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        TestHelper.deleteSite(FIRST_TESTSITE_NAME);
        TestHelper.deleteSite(SECOND_TESTSITE_NAME);
    }
}

