/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.tags;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.tags.TagActionCallback;
import org.jahia.services.tags.TaggingService;
import org.jahia.services.tags.TagsSuggester;
import org.jahia.services.tags.TagsSuggesterImpl;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaggingTest {
    private static Logger logger = LoggerFactory.getLogger(TaggingTest.class);
    private static final String TESTSITE_NAME = "taggingTest";
    private TaggingService service = (TaggingService)SpringContextSingleton.getBean((String)"org.jahia.services.tags.TaggingService");

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        try {
            TestHelper.createSite(TESTSITE_NAME);
            JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JCRNodeWrapper siteNode = session.getNode("/sites/taggingTest");
                    siteNode.addNode("tags-content", "jnt:contentList");
                    session.save();
                    return null;
                }
            });
        }
        catch (Exception e) {
            logger.error("Error setting up TaggingTest environment", (Throwable)e);
            Assert.fail();
        }
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    try {
                        session.getNode("/sites/taggingTest/tags-content").remove();
                    }
                    catch (PathNotFoundException pathNotFoundException) {
                        // empty catch block
                    }
                    session.save();
                    return null;
                }
            });
        }
        catch (Exception e) {
            logger.error("Error tearing down TaggingTest environment", (Throwable)e);
        }
        try {
            TestHelper.deleteSite(TESTSITE_NAME);
        }
        catch (Exception e) {
            logger.error("Error tearing down TaggingTest environment", (Throwable)e);
        }
    }

    @Test
    public void testTagTaggingService() throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Void>(){

            public Void doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRNodeWrapper contentFolder = session.getNode("/sites/taggingTest/tags-content");
                for (int i = 0; i < 5; ++i) {
                    contentFolder.addNode("content-" + i, "jnt:text");
                }
                TaggingTest.this.service.tag(contentFolder.getNode("content-0"), Arrays.asList("cheese", "Chipmunk", "pepperoni", "black Olives", "aircheck"));
                TaggingTest.this.service.tag(contentFolder.getNode("content-1"), Arrays.asList("cheese", "chiPmunk", "black Olives", "aircheck"));
                TaggingTest.this.service.tag(contentFolder.getNode("content-2"), Arrays.asList("cheese"));
                TaggingTest.this.service.tag(contentFolder.getNode("content-3"), Arrays.asList("cheese", "black Olives"));
                TaggingTest.this.service.tag(contentFolder.getNode("content-4"), Arrays.asList("pepperoni", "black Olives"));
                session.save();
                TagsSuggesterImpl tagsSuggester = new TagsSuggesterImpl();
                tagsSuggester.setFaceted(true);
                Map suggested = tagsSuggester.suggest("ch", "/sites/taggingTest/tags-content", Long.valueOf(1L), Long.valueOf(-1L), Long.valueOf(0L), false, session);
                Assert.assertTrue(suggested.size() == 2);
                Assert.assertTrue(suggested.get("cheese") != null);
                Assert.assertTrue((Long)suggested.get("cheese") == 4L);
                Assert.assertTrue(suggested.get("chipmunk") != null);
                Assert.assertTrue((Long)suggested.get("chipmunk") == 2L);
                suggested = tagsSuggester.suggest("ch", "/sites/taggingTest/tags-content", Long.valueOf(1L), Long.valueOf(-1L), Long.valueOf(0L), true, session);
                Assert.assertTrue(suggested.size() == 2);
                Assert.assertTrue(suggested.get("cheese") != null);
                Assert.assertTrue((Long)suggested.get("cheese") == 4L);
                Assert.assertTrue(suggested.get("chipmunk") != null);
                Assert.assertTrue((Long)suggested.get("chipmunk") == 2L);
                Assert.assertTrue(((String)new TreeMap(suggested).firstKey()).equals("cheese"));
                suggested = tagsSuggester.suggest("ch", "/sites/taggingTest/tags-content", Long.valueOf(3L), Long.valueOf(-1L), Long.valueOf(0L), false, session);
                Assert.assertTrue(suggested.size() == 1);
                Assert.assertTrue(suggested.get("cheese") != null);
                Assert.assertTrue((Long)suggested.get("cheese") == 4L);
                suggested = tagsSuggester.suggest("ch", "/sites/taggingTest/tags-content", Long.valueOf(1L), Long.valueOf(1L), Long.valueOf(1L), false, session);
                Assert.assertTrue(suggested.size() == 1);
                suggested = tagsSuggester.suggest("ch", "/sites/taggingTest/tags-content", Long.valueOf(1L), Long.valueOf(1L), Long.valueOf(0L), false, session);
                Assert.assertTrue(suggested.size() == 1);
                suggested = tagsSuggester.suggest("chip", "/sites/taggingTest/tags-content", Long.valueOf(1L), Long.valueOf(-1L), Long.valueOf(0L), false, session);
                Assert.assertTrue(suggested.size() == 1);
                Assert.assertTrue(suggested.get("chipmunk") != null);
                Assert.assertTrue((Long)suggested.get("chipmunk") == 2L);
                tagsSuggester.setFaceted(false);
                suggested = tagsSuggester.suggest("ch", "/sites/taggingTest/tags-content", Long.valueOf(1L), Long.valueOf(-1L), Long.valueOf(0L), false, session);
                Assert.assertTrue(suggested.size() == 2);
                Assert.assertTrue(suggested.containsKey("cheese"));
                Assert.assertTrue(suggested.containsKey("chipmunk"));
                suggested = tagsSuggester.suggest("chip", "/sites/taggingTest/tags-content", Long.valueOf(1L), Long.valueOf(-1L), Long.valueOf(0L), false, session);
                Assert.assertTrue(suggested.size() == 1);
                Assert.assertTrue(suggested.containsKey("chipmunk"));
                suggested = tagsSuggester.suggest("ch", "/sites/taggingTest/tags-content", Long.valueOf(1L), Long.valueOf(1L), Long.valueOf(1L), false, session);
                Assert.assertTrue(suggested.size() == 1);
                suggested = tagsSuggester.suggest("ch", "/sites/taggingTest/tags-content", Long.valueOf(1L), Long.valueOf(1L), Long.valueOf(0L), false, session);
                Assert.assertTrue(suggested.size() == 1);
                TaggingTest.this.service.untag(contentFolder.getNode("content-2"), Arrays.asList("cheese"));
                session.save();
                Assert.assertFalse(contentFolder.getNode("content-2").isNodeType("jmix:tagged"));
                Assert.assertFalse(contentFolder.getNode("content-2").hasProperty("j:tagList"));
                tagsSuggester.setFaceted(true);
                suggested = tagsSuggester.suggest("cheese", "/sites/taggingTest/tags-content", Long.valueOf(1L), Long.valueOf(-1L), Long.valueOf(0L), false, session);
                Assert.assertTrue(suggested.size() == 1);
                Assert.assertTrue(suggested.get("cheese") != null);
                Assert.assertTrue((Long)suggested.get("cheese") == 3L);
                suggested = tagsSuggester.suggest("cheese", "/sites/taggingTest/tags-content", Long.valueOf(1L), Long.valueOf(-1L), Long.valueOf(0L), false, session);
                Assert.assertTrue(suggested.size() == 1);
                Assert.assertTrue(suggested.get("cheese") != null);
                Assert.assertTrue((Long)suggested.get("cheese") == 3L);
                TaggingTest.this.service.renameTag(contentFolder.getNode("content-4"), "pepperoni", "babybel");
                session.save();
                suggested = tagsSuggester.suggest("babybel", "/sites/taggingTest/tags-content", Long.valueOf(1L), Long.valueOf(-1L), Long.valueOf(0L), false, session);
                Assert.assertTrue(suggested.size() == 1);
                Assert.assertTrue(suggested.get("babybel") != null);
                Assert.assertTrue((Long)suggested.get("babybel") == 1L);
                suggested = tagsSuggester.suggest("pepperoni", "/sites/taggingTest/tags-content", Long.valueOf(1L), Long.valueOf(-1L), Long.valueOf(0L), false, session);
                Assert.assertTrue(suggested.size() == 1);
                Assert.assertTrue(suggested.get("pepperoni") != null);
                Assert.assertTrue((Long)suggested.get("pepperoni") == 1L);
                TaggingTest.this.service.deleteTagUnderPath("/sites/taggingTest/tags-content", session, "cheese", (TagActionCallback)new ChesseTagDeleteCallback((TagsSuggester)tagsSuggester, session));
                TaggingTest.this.service.renameTagUnderPath("/sites/taggingTest/tags-content", session, "black olives", "camembert", (TagActionCallback)new BalckOliveTagRenamedCallback((TagsSuggester)tagsSuggester, session));
                return null;
            }
        });
    }

    private class BalckOliveTagRenamedCallback
    implements TagActionCallback<Void> {
        TagsSuggester tagsSuggester;
        JCRSessionWrapper session;

        private BalckOliveTagRenamedCallback(TagsSuggester tagsSuggester, JCRSessionWrapper session) {
            this.tagsSuggester = tagsSuggester;
            this.session = session;
        }

        public void afterTagAction(JCRNodeWrapper node) throws RepositoryException {
            this.session.save();
            Assert.assertFalse(node.getPropertyAsString("j:tagList").contains("black olives"));
            Assert.assertTrue(node.getPropertyAsString("j:tagList").contains("camembert"));
        }

        public void onError(JCRNodeWrapper node, RepositoryException e) throws RepositoryException {
            Assert.fail("Fail on taging action on node: " + node.getPath());
            throw e;
        }

        public Void end() throws RepositoryException {
            Map suggested = this.tagsSuggester.suggest("black olives", "/sites/taggingTest/tags-content", Long.valueOf(1L), Long.valueOf(-1L), Long.valueOf(0L), false, this.session);
            Assert.assertTrue(suggested.size() == 0);
            suggested = this.tagsSuggester.suggest("camembert", "/sites/taggingTest/tags-content", Long.valueOf(1L), Long.valueOf(-1L), Long.valueOf(0L), false, this.session);
            Assert.assertTrue(suggested.size() == 1);
            Assert.assertTrue(suggested.containsKey("camembert"));
            Assert.assertTrue((Long)suggested.get("camembert") == 4L);
            return null;
        }
    }

    private class ChesseTagDeleteCallback
    implements TagActionCallback<Void> {
        TagsSuggester tagsSuggester;
        JCRSessionWrapper session;

        private ChesseTagDeleteCallback(TagsSuggester tagsSuggester, JCRSessionWrapper session) {
            this.tagsSuggester = tagsSuggester;
            this.session = session;
        }

        public void afterTagAction(JCRNodeWrapper node) throws RepositoryException {
            this.session.save();
            Assert.assertFalse(node.getPropertyAsString("j:tagList").contains("cheese"));
        }

        public void onError(JCRNodeWrapper node, RepositoryException e) throws RepositoryException {
            Assert.fail("Fail on taging action on node: " + node.getPath());
            throw e;
        }

        public Void end() throws RepositoryException {
            Map suggested = this.tagsSuggester.suggest("cheese", "/sites/taggingTest/tags-content", Long.valueOf(1L), Long.valueOf(-1L), Long.valueOf(0L), false, this.session);
            Assert.assertTrue(suggested.size() == 0);
            return null;
        }
    }
}

