/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.templates;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.commons.io.FileUtils;
import org.awaitility.Awaitility;
import org.awaitility.Duration;
import org.jahia.bin.Action;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.data.templates.ModuleState;
import org.jahia.osgi.FrameworkService;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.services.templates.ModuleVersion;
import org.jahia.settings.SettingsBean;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleDeploymentTest {
    private static Logger logger = LoggerFactory.getLogger(ModuleDeploymentTest.class);
    private static JahiaTemplateManagerService managerService = ServicesRegistry.getInstance().getJahiaTemplateManagerService();
    private static final String TESTSITE_NAME = "ModuleDeploymentTestSite";

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        try {
            TestHelper.deleteSite(TESTSITE_NAME);
            TestHelper.createSite(TESTSITE_NAME);
        }
        catch (Exception e) {
            logger.error("Cannot create or publish site", (Throwable)e);
            Assert.fail();
        }
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        try {
            TestHelper.deleteSite(TESTSITE_NAME);
        }
        catch (Exception ex) {
            logger.warn("Exception during test tearDown", (Throwable)ex);
        }
    }

    @Before
    @After
    public void clearDeployedModule() throws Exception {
        JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                Bundle[] bundles;
                logger.info("--- clear deployed modules");
                JahiaTemplatesPackage oldpack = managerService.getTemplatePackageRegistry().lookupByIdAndVersion("dummy1", new ModuleVersion("1.0"));
                if (oldpack != null) {
                    managerService.undeployModule(oldpack);
                }
                if ((oldpack = managerService.getTemplatePackageRegistry().lookupByIdAndVersion("dummy1", new ModuleVersion("1.1"))) != null) {
                    managerService.undeployModule(oldpack);
                }
                SettingsBean settingsBean = SettingsBean.getInstance();
                FileUtils.deleteQuietly((File)new File(settingsBean.getJahiaModulesDiskPath(), "dummy1-1.0.jar"));
                FileUtils.deleteQuietly((File)new File(settingsBean.getJahiaModulesDiskPath(), "dummy1-1.1.jar"));
                for (Bundle bundle : bundles = FrameworkService.getBundleContext().getBundles()) {
                    if (!bundle.getSymbolicName().equals("dummy1")) continue;
                    try {
                        bundle.uninstall();
                    }
                    catch (BundleException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                return null;
            }
        });
    }

    @Test
    public void testJarDeploy() throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                try {
                    File tmpFile = File.createTempFile("module", ".jar");
                    InputStream stream = managerService.getTemplatePackageById("jahia-test-module").getResource("dummy1-1.0.jar").getInputStream();
                    FileUtils.copyInputStreamToFile((InputStream)stream, (File)tmpFile);
                    managerService.deployModule(tmpFile, session);
                    tmpFile.delete();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    Assert.fail(e.toString());
                }
                JahiaTemplatesPackage pack = managerService.getTemplatePackageById("dummy1");
                Assert.assertNotNull(pack);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                Assert.assertEquals("Module is not started", ModuleState.State.STARTED, pack.getState().getState());
                Assert.assertNotNull("Spring context is null", pack.getContext());
                Assert.assertTrue("No action defined", !pack.getContext().getBeansOfType(Action.class).isEmpty());
                Assert.assertTrue("Action not registered", managerService.getActions().containsKey("my-post-action"));
                try {
                    NodeTypeRegistry.getInstance().getNodeType("jnt:testComponent1");
                }
                catch (NoSuchNodeTypeException e) {
                    Assert.fail("Definition not registered");
                }
                Assert.assertTrue("Module view is not correctly registered", managerService.getModulesWithViewsForComponent("jnt:testComponent1").contains(pack));
                return null;
            }
        });
    }

    @Test
    public void testNewVersionDeploy() throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                try {
                    File tmpFile = File.createTempFile("module", ".jar");
                    InputStream stream = managerService.getTemplatePackageById("jahia-test-module").getResource("dummy1-1.0.jar").getInputStream();
                    FileUtils.copyInputStreamToFile((InputStream)stream, (File)tmpFile);
                    managerService.deployModule(tmpFile, session);
                    tmpFile.delete();
                    tmpFile = File.createTempFile("module", ".jar");
                    stream = managerService.getTemplatePackageById("jahia-test-module").getResource("dummy1-1.1.jar").getInputStream();
                    FileUtils.copyInputStreamToFile((InputStream)stream, (File)tmpFile);
                    managerService.deployModule(tmpFile, session);
                    tmpFile.delete();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    Assert.fail(e.toString());
                }
                JahiaTemplatesPackage pack = managerService.getTemplatePackageById("dummy1");
                Assert.assertNotNull(pack);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                Assert.assertEquals("Module is not started", ModuleState.State.STARTED, pack.getState().getState());
                Assert.assertEquals("Active module version is incorrect", "1.1", pack.getVersion().toString());
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testJarAutoDeploy() throws RepositoryException {
        SettingsBean settingsBean = SettingsBean.getInstance();
        File f = null;
        try {
            File tmpFile = File.createTempFile("module", ".jar");
            InputStream stream = managerService.getTemplatePackageById("jahia-test-module").getResource("dummy1-1.0.jar").getInputStream();
            FileUtils.copyInputStreamToFile((InputStream)stream, (File)tmpFile);
            FileUtils.copyFileToDirectory((File)tmpFile, (File)new File(settingsBean.getJahiaModulesDiskPath()));
            tmpFile.delete();
            f = new File(settingsBean.getJahiaModulesDiskPath(), tmpFile.getName());
            Awaitility.with().pollInterval(Duration.ONE_SECOND).await().atMost(20L, TimeUnit.SECONDS).until(this.isPackageDeployedAndServiceInstalled("dummy1"));
            JahiaTemplatesPackage pack = managerService.getTemplatePackageById("dummy1");
            Assert.assertNotNull(pack);
            Assert.assertEquals("Module is not started", ModuleState.State.STARTED, pack.getState().getState());
            Assert.assertNotNull("Spring context is null", pack.getContext());
            Assert.assertTrue("No action defined", !pack.getContext().getBeansOfType(Action.class).isEmpty());
            Assert.assertTrue("Action not registered", managerService.getActions().containsKey("my-post-action"));
            try {
                NodeTypeRegistry.getInstance().getNodeType("jnt:testComponent1");
            }
            catch (NoSuchNodeTypeException e) {
                Assert.fail("Definition not registered");
            }
            Assert.assertTrue("Module view is not correctly registered", managerService.getModulesWithViewsForComponent("jnt:testComponent1").contains(pack));
            FileUtils.deleteQuietly((File)f);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            Assert.fail(e.toString());
            return;
        }
        try {
            Thread.sleep(10000L);
            return;
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return;
        }
        finally {
            FileUtils.deleteQuietly(f);
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Test
    public void testJarWithFailingRules() throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                File tmpFile = null;
                try {
                    tmpFile = File.createTempFile("module", ".jar");
                    FileUtils.copyURLToFile((URL)managerService.getTemplatePackageById("jahia-test-module").getResource("dummy1-1.0.jar").getURL(), (File)tmpFile);
                    HashMap<String, String> env = new HashMap<String, String>();
                    env.put("create", "true");
                    FileSystem fs = FileSystems.newFileSystem(URI.create("jar:" + tmpFile.toURI().toURL()), env);
                    File droolsFile = File.createTempFile("rules", ".drl");
                    FileUtils.writeStringToFile((File)droolsFile, (String)"dummy text");
                    Files.copy(droolsFile.toPath(), fs.getPath("/META-INF/rules.drl", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    FileUtils.deleteQuietly((File)droolsFile);
                    fs.close();
                    final JahiaTemplatesPackage pack = managerService.deployModule(tmpFile, session);
                    Awaitility.with().pollInterval(Duration.ONE_SECOND).await().atMost(20L, TimeUnit.SECONDS).until((Callable)new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return pack.getState().getState() == ModuleState.State.ERROR_WITH_RULES && pack.getBundle().getState() == 4;
                        }
                    });
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    Assert.fail(e.toString());
                }
                finally {
                    FileUtils.deleteQuietly((File)tmpFile);
                }
                return null;
            }
        });
    }

    private Callable<Boolean> isPackageDeployedAndServiceInstalled(String packageId) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                JahiaTemplatesPackage pack = managerService.getTemplatePackageById("dummy1");
                return pack != null && pack.getContext() != null && pack.isServiceInitialized();
            }
        };
    }

    @Test
    public void testJarUndeploy() throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                try {
                    File tmpFile = File.createTempFile("module", ".jar");
                    InputStream stream = managerService.getTemplatePackageById("jahia-test-module").getResource("dummy1-1.0.jar").getInputStream();
                    FileUtils.copyInputStreamToFile((InputStream)stream, (File)tmpFile);
                    JahiaTemplatesPackage pack = managerService.deployModule(tmpFile, session);
                    tmpFile.delete();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    managerService.undeployModule(pack);
                    pack = managerService.getTemplatePackageById("dummy1");
                    Assert.assertNull(pack);
                    Assert.assertFalse("Action not unregistered", managerService.getActions().containsKey("my-post-action"));
                    Assert.assertTrue("Module view is not correctly unregistered", managerService.getModulesWithViewsForComponent("jnt:testComponent1").isEmpty());
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    Assert.fail(e.toString());
                }
                return null;
            }
        });
    }

    @Test
    public void testModuleInstall() throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                try {
                    File tmpFile = File.createTempFile("module", ".jar");
                    InputStream stream = managerService.getTemplatePackageById("jahia-test-module").getResource("dummy1-1.0.jar").getInputStream();
                    FileUtils.copyInputStreamToFile((InputStream)stream, (File)tmpFile);
                    managerService.deployModule(tmpFile, session);
                    tmpFile.delete();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    Assert.fail(e.toString());
                }
                JahiaTemplatesPackage pack = managerService.getTemplatePackageById("dummy1");
                JahiaSitesService service = ServicesRegistry.getInstance().getJahiaSitesService();
                JCRSiteNode site = service.getSiteByKey(ModuleDeploymentTest.TESTSITE_NAME, session);
                Assert.assertFalse("Module was installed before test", site.getInstalledModules().contains("dummy1"));
                managerService.installModule(pack, site.getJCRLocalPath(), session);
                session.save();
                Assert.assertTrue("Module has not been installed on site", site.getInstalledModules().contains("dummy1"));
                Assert.assertTrue("Module content has not been copied", session.itemExists("/sites/ModuleDeploymentTestSite/contents/test-contents"));
                managerService.uninstallModule(pack, site.getJCRLocalPath(), session);
                session.save();
                Assert.assertFalse("Module has not been removed from site", site.getInstalledModules().contains("dummy1"));
                return null;
            }
        });
    }
}

