/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.validation;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.beanutils.BeanUtils;
import org.jahia.test.services.validation.FieldMatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldMatchValidator
implements ConstraintValidator<FieldMatch, Object> {
    private static Logger logger = LoggerFactory.getLogger(FieldMatchValidator.class);
    private String firstFieldName;
    private String secondFieldName;

    public void initialize(FieldMatch constraintAnnotation) {
        this.firstFieldName = constraintAnnotation.first();
        this.secondFieldName = constraintAnnotation.second();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        try {
            String firstObj = BeanUtils.getProperty((Object)value, (String)this.firstFieldName);
            String secondObj = BeanUtils.getProperty((Object)value, (String)this.secondFieldName);
            return firstObj == null && secondObj == null || firstObj != null && firstObj.equals(secondObj);
        }
        catch (Exception e) {
            logger.error("Failed to validate field match", (Throwable)e);
            return true;
        }
    }
}

