/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.validation;

import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.validation.constraints.Future;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.Email;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.decorator.validation.JCRNodeValidator;
import org.jahia.test.services.validation.FieldMatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FieldMatch.List(value={@FieldMatch(first="test_email", second="test_confirmEmail", propertyName="test:confirmEmail")})
public class TestValidatedNodeValidator
implements JCRNodeValidator {
    private static Logger logger = LoggerFactory.getLogger(TestValidatedNodeValidator.class);
    private JCRNodeWrapper node;

    public TestValidatedNodeValidator(JCRNodeWrapper node) {
        this.node = node;
    }

    @NotNull
    public String getTest_notNull() {
        return this.node.getPropertyAsString("test:notNull");
    }

    @Size(min=6, max=20)
    public String getTest_sizeBetween6And20() {
        return this.node.getPropertyAsString("test:sizeBetween6And20");
    }

    @Email
    public String getTest_email() {
        return this.node.getPropertyAsString("test:email");
    }

    @Email
    public String getTest_confirmEmail() {
        return this.node.getPropertyAsString("test:confirmEmail");
    }

    @Future
    public Calendar getTest_futureDate() {
        try {
            JCRPropertyWrapper property = this.node.getProperty("test:futureDate");
            if (property != null) {
                return property.getDate();
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage());
        }
        return null;
    }

    @Min(value=3L)
    public Long getTest_greaterThan2() {
        try {
            JCRPropertyWrapper property = this.node.getProperty("test:greaterThan2");
            if (property != null) {
                return property.getLong();
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage());
        }
        return null;
    }
}

