/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.validation;

import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.jcr.nodetype.ConstraintViolationException;
import org.jahia.services.content.CompositeConstraintViolationException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;

public class ValidationTest {
    private static Logger logger = LoggerFactory.getLogger(ValidationTest.class);
    private static final String TEST_SITE_NAME = "validationTest";
    private static final String SITE_CONTENT_ROOT_NODE = "/sites/validationTest";
    private static final String TEST_NODE_TYPE = "test:validatedNode";

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        try {
            TestHelper.createSite(TEST_SITE_NAME);
        }
        catch (Exception e) {
            logger.error("Error setting up ValidationTest environment", (Throwable)e);
            Assert.fail();
        }
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        try {
            TestHelper.deleteSite(TEST_SITE_NAME);
        }
        catch (Exception e) {
            logger.error("Error tearing down ValidationTest environment", (Throwable)e);
        }
    }

    @Test
    public void testNotNullConstraint() throws Exception {
        List errors = null;
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
            session.getNode(SITE_CONTENT_ROOT_NODE).addNode("testNotNull", TEST_NODE_TYPE);
            session.save();
        }
        catch (CompositeConstraintViolationException e) {
            errors = e.getErrors();
        }
        Assert.assertEquals("/sites/validationTest/testNotNull Field not null: may not be null", ((ConstraintViolationException)errors.get(0)).getLocalizedMessage());
    }

    @Test
    public void testSizeBetween6And20Constraint() throws Exception {
        List errors = null;
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
            JCRNodeWrapper testSizeBetween6And20 = session.getNode(SITE_CONTENT_ROOT_NODE).addNode("testSizeBetween6And20", TEST_NODE_TYPE);
            testSizeBetween6And20.setProperty("test:notNull", "something");
            testSizeBetween6And20.setProperty("test:sizeBetween6And20", "abc");
            session.save();
        }
        catch (CompositeConstraintViolationException e) {
            errors = e.getErrors();
        }
        Assert.assertEquals("/sites/validationTest/testSizeBetween6And20 Field with size between 6 and 20: size must be between 6 and 20", ((ConstraintViolationException)errors.get(0)).getLocalizedMessage());
    }

    @Test
    public void testFieldMatchCustomConstraint() throws Exception {
        List errors = null;
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
            JCRNodeWrapper testFieldMatch = session.getNode(SITE_CONTENT_ROOT_NODE).addNode("testFieldMatch", TEST_NODE_TYPE);
            testFieldMatch.setProperty("test:notNull", "something");
            testFieldMatch.setProperty("test:sizeBetween6And20", "abcdefghijklm");
            testFieldMatch.setProperty("test:email", "mail@one.com");
            testFieldMatch.setProperty("test:confirmEmail", "mail@two.com");
            session.save();
        }
        catch (CompositeConstraintViolationException e) {
            errors = e.getErrors();
        }
        Assert.assertEquals("/sites/validationTest/testFieldMatch Confirmation email field: Fields don't match", ((ConstraintViolationException)errors.get(0)).getLocalizedMessage());
    }

    @Test
    public void testEmailConstraint() throws Exception {
        List errors = null;
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
            JCRNodeWrapper testEmail = session.getNode(SITE_CONTENT_ROOT_NODE).addNode("testEmail", TEST_NODE_TYPE);
            testEmail.setProperty("test:notNull", "something");
            testEmail.setProperty("test:sizeBetween6And20", "abcdefghijklm");
            testEmail.setProperty("test:email", "wrongmail");
            testEmail.setProperty("test:confirmEmail", "wrongmail");
            session.save();
        }
        catch (CompositeConstraintViolationException e) {
            errors = e.getErrors();
        }
        Assert.assertEquals(2L, errors.size());
        List<String> messages = Arrays.asList("/sites/validationTest/testEmail Email field: not a well-formed email address", "/sites/validationTest/testEmail Confirmation email field: not a well-formed email address");
        for (ConstraintViolationException error : errors) {
            String localizedMessage = error.getLocalizedMessage();
            Assert.assertTrue(messages.contains(localizedMessage));
        }
    }

    @Test
    public void testFutureDateConstraint() throws Exception {
        List errors = null;
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
            JCRNodeWrapper testFutureDate = session.getNode(SITE_CONTENT_ROOT_NODE).addNode("testFutureDate", TEST_NODE_TYPE);
            testFutureDate.setProperty("test:notNull", "something");
            testFutureDate.setProperty("test:sizeBetween6And20", "abcdefghijklm");
            testFutureDate.setProperty("test:email", "good@mail.com");
            testFutureDate.setProperty("test:confirmEmail", "good@mail.com");
            testFutureDate.setProperty("test:futureDate", Calendar.getInstance());
            session.save();
        }
        catch (CompositeConstraintViolationException e) {
            errors = e.getErrors();
        }
        Assert.assertEquals("/sites/validationTest/testFutureDate Future date field: must be in the future", ((ConstraintViolationException)errors.get(0)).getLocalizedMessage());
    }

    @Test
    public void testGreaterThan2Constraint() throws Exception {
        List errors = null;
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
            JCRNodeWrapper testGreaterThan2 = session.getNode(SITE_CONTENT_ROOT_NODE).addNode("testGreaterThan2", TEST_NODE_TYPE);
            testGreaterThan2.setProperty("test:notNull", "something");
            testGreaterThan2.setProperty("test:sizeBetween6And20", "abcdefghijklm");
            testGreaterThan2.setProperty("test:email", "good@mail.com");
            testGreaterThan2.setProperty("test:confirmEmail", "good@mail.com");
            Calendar date = Calendar.getInstance();
            date.setTimeInMillis(date.getTimeInMillis() + 3600000L);
            testGreaterThan2.setProperty("test:futureDate", date);
            testGreaterThan2.setProperty("test:greaterThan2", 2L);
            session.save();
        }
        catch (CompositeConstraintViolationException e) {
            errors = e.getErrors();
        }
        Assert.assertEquals("/sites/validationTest/testGreaterThan2 Field with value greater than 2: must be greater than or equal to 3", ((ConstraintViolationException)errors.get(0)).getLocalizedMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testMessageTranslation() throws Exception {
        List errors = null;
        LocaleContext localeContext = null;
        try {
            try {
                JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
                JCRNodeWrapper testGreaterThan2 = session.getNode(SITE_CONTENT_ROOT_NODE).addNode("testTranslation", TEST_NODE_TYPE);
                testGreaterThan2.setProperty("test:sizeBetween6And20", "abc");
                testGreaterThan2.setProperty("test:email", "badmail.com");
                testGreaterThan2.setProperty("test:confirmEmail", "badmail2.com");
                testGreaterThan2.setProperty("test:futureDate", Calendar.getInstance());
                testGreaterThan2.setProperty("test:greaterThan2", 2L);
                localeContext = LocaleContextHolder.getLocaleContext();
                LocaleContextHolder.setLocale((Locale)Locale.FRENCH, (boolean)true);
                session.save();
            }
            catch (CompositeConstraintViolationException e) {
                errors = e.getErrors();
            }
            Assert.assertEquals(7L, errors.size());
            List<String> messages = Arrays.asList("/sites/validationTest/testTranslation Champ non nul: ne peut pas \u00eatre nul", "/sites/validationTest/testTranslation Champ dont la taille est comprise entre 6 et 20: la taille doit \u00eatre entre 6 et 20", "/sites/validationTest/testTranslation Champ de confirmation d'e-mail: Les champs ne correspondent pas", "/sites/validationTest/testTranslation Champ d'e-mail: Adresse email mal form\u00e9e", "/sites/validationTest/testTranslation Champ de confirmation d'e-mail: Adresse email mal form\u00e9e", "/sites/validationTest/testTranslation Champ de date dans le futur: doit \u00eatre dans le futur", "/sites/validationTest/testTranslation Champ avec valeur strictement sup\u00e9rieure \u00e0 2: doit \u00eatre plus grand que 3");
            for (ConstraintViolationException error : errors) {
                String localizedMessage = error.getLocalizedMessage();
                Assert.assertTrue(messages.contains(localizedMessage));
            }
            if (localeContext == null) return;
        }
        catch (Throwable throwable) {
            if (localeContext == null) throw throwable;
            LocaleContextHolder.setLocaleContext(localeContext);
            throw throwable;
        }
        LocaleContextHolder.setLocaleContext((LocaleContext)localeContext);
    }

    @Test
    public void testValidNodeCreation() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
        JCRNodeWrapper siteNode = session.getNode(SITE_CONTENT_ROOT_NODE);
        JCRNodeWrapper validNode = siteNode.addNode("validNode", TEST_NODE_TYPE);
        validNode.setProperty("test:notNull", "something");
        validNode.setProperty("test:sizeBetween6And20", "abcdefghijklm");
        validNode.setProperty("test:email", "good@mail.com");
        validNode.setProperty("test:confirmEmail", "good@mail.com");
        Calendar date = Calendar.getInstance();
        date.setTimeInMillis(date.getTimeInMillis() + 3600000L);
        validNode.setProperty("test:futureDate", date);
        validNode.setProperty("test:greaterThan2", 3L);
        session.save();
        Assert.assertTrue(siteNode.hasNode("validNode"));
        validNode.remove();
        session.save();
    }
}

