/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.vanity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.seo.VanityUrl;
import org.jahia.services.seo.jcr.VanityUrlService;
import org.jahia.services.sites.JahiaSite;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanityUrlServiceTest {
    private static Logger logger = LoggerFactory.getLogger(VanityUrlServiceTest.class);
    private static final String SITEA = "siteA";
    private static VanityUrlService vanityUrlService;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        try {
            vanityUrlService = (VanityUrlService)SpringContextSingleton.getBean((String)"org.jahia.services.seo.jcr.VanityUrlService");
            VanityUrlServiceTest.initSite(SITEA);
        }
        catch (Exception e) {
            logger.error("Error setting up ValidationTest environment", (Throwable)e);
            Assert.fail();
        }
    }

    @After
    public void tearDown() throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
            try {
                JCRNodeWrapper page = session.getNode("/sites/siteA/home/page1");
                page.getNode("vanityUrlMapping").remove();
                session.save();
                vanityUrlService.flushCaches();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        });
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        try {
            TestHelper.deleteSite(SITEA);
        }
        catch (Exception e) {
            logger.error("Error tearing down ValidationTest environment", (Throwable)e);
        }
    }

    @Test
    public void shouldAddAndUpdateNewVanity() throws Exception {
        VanityUrl vanityUrl = VanityUrlServiceTest.createVanity(true, true, "/test", SITEA, "en");
        VanityUrlServiceTest.saveVanity(vanityUrl);
        vanityUrl = VanityUrlServiceTest.insureVanityExist(vanityUrl);
        vanityUrl.setActive(false);
        VanityUrlServiceTest.saveVanity(vanityUrl);
        vanityUrl = VanityUrlServiceTest.insureVanityExist(vanityUrl);
        vanityUrl.setUrl("/test2");
        VanityUrlServiceTest.saveVanity(vanityUrl);
        vanityUrl = VanityUrlServiceTest.insureVanityExist(vanityUrl);
        vanityUrl.setLanguage("fr");
        VanityUrlServiceTest.saveVanity(vanityUrl);
        vanityUrl = VanityUrlServiceTest.insureVanityExist(vanityUrl);
        vanityUrl.setDefaultMapping(false);
        VanityUrlServiceTest.saveVanity(vanityUrl);
        VanityUrlServiceTest.insureVanityExist(vanityUrl);
    }

    @Test
    public void shouldDisableDefault() throws Exception {
        VanityUrl defaultVanity = VanityUrlServiceTest.createVanity(true, true, "/default", SITEA, "en");
        VanityUrl vanity = VanityUrlServiceTest.createVanity(true, false, "/normal", SITEA, "en");
        VanityUrlServiceTest.saveVanity(defaultVanity);
        VanityUrlServiceTest.saveVanity(vanity);
        defaultVanity = VanityUrlServiceTest.insureVanityExist(defaultVanity);
        vanity = VanityUrlServiceTest.insureVanityExist(vanity);
        vanity.setDefaultMapping(true);
        VanityUrlServiceTest.saveVanity(vanity);
        defaultVanity.setDefaultMapping(false);
        VanityUrlServiceTest.insureVanityExist(defaultVanity);
        VanityUrlServiceTest.insureVanityExist(vanity);
    }

    @Test
    public void shouldDisableDefaultWhenLanguageSwitch() throws Exception {
        VanityUrl frVanity = VanityUrlServiceTest.createVanity(true, true, "/fr", SITEA, "fr");
        VanityUrl enVanity = VanityUrlServiceTest.createVanity(true, true, "/en", SITEA, "en");
        VanityUrlServiceTest.saveVanity(frVanity);
        VanityUrlServiceTest.saveVanity(enVanity);
        frVanity = VanityUrlServiceTest.insureVanityExist(frVanity);
        enVanity = VanityUrlServiceTest.insureVanityExist(enVanity);
        frVanity.setLanguage("en");
        VanityUrlServiceTest.saveVanity(frVanity);
        enVanity.setDefaultMapping(false);
        VanityUrlServiceTest.insureVanityExist(frVanity);
        VanityUrlServiceTest.insureVanityExist(enVanity);
    }

    private static void initSite(String siteKey) throws Exception {
        JahiaSite site = TestHelper.createSite(siteKey, "localhost", "templates-web");
        JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
            try {
                VanityUrlServiceTest.createPage((JCRSiteNode)session.getNode(site.getJCRLocalPath()), "page1");
                session.save();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }

    private static void insureVanityDoesNotExist(String vanityUrl) throws RepositoryException {
        int foundCount = (Integer)JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
            try {
                return vanityUrlService.findExistingVanityUrls(vanityUrl, SITEA, "default").size();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        Assert.assertEquals(0L, foundCount);
    }

    private static VanityUrl insureVanityExist(VanityUrl vanityUrlToTest) throws RepositoryException {
        return (VanityUrl)JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
            try {
                VanityUrl vanityUrl = (VanityUrl)vanityUrlService.findExistingVanityUrls(vanityUrlToTest.getUrl(), SITEA, "default").get(0);
                Assert.assertTrue(vanityUrl != null);
                Assert.assertEquals(vanityUrlToTest.isActive(), vanityUrl.isActive());
                Assert.assertEquals(vanityUrlToTest.isDefaultMapping(), vanityUrl.isDefaultMapping());
                Assert.assertEquals(vanityUrlToTest.getLanguage(), vanityUrl.getLanguage());
                Assert.assertEquals(vanityUrlToTest.getUrl(), vanityUrl.getUrl());
                return vanityUrl;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static void saveVanity(VanityUrl vanityUrl) throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
            try {
                JCRNodeWrapper page = session.getNode("/sites/siteA/home/page1");
                vanityUrlService.saveVanityUrlMapping(page, vanityUrl);
                session.save();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }

    private static void saveVanities(List<VanityUrl> vanityUrls, Set<String> updatedLocales) throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
            try {
                JCRNodeWrapper page = session.getNode("/sites/siteA/home/page1");
                vanityUrlService.saveVanityUrlMappings(page, vanityUrls, updatedLocales);
                session.save();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }

    private static JCRNodeWrapper createPage(JCRSiteNode site, String pageName) throws Exception {
        JCRNodeWrapper page = site.getNode("home").addNode(pageName, "jnt:page");
        page.setProperty("j:templateName", "simple");
        page.setProperty("jcr:title", pageName);
        return page;
    }

    private static VanityUrl createVanity(boolean isActive, boolean isDefault, String url, String site, String language) {
        VanityUrl vanityUrl = new VanityUrl();
        vanityUrl.setActive(isActive);
        vanityUrl.setDefaultMapping(isDefault);
        vanityUrl.setLanguage(language);
        vanityUrl.setSite(site);
        vanityUrl.setUrl(url);
        return vanityUrl;
    }

    @Test
    public void testDefaultFlag() throws Exception {
        VanityUrl vanityUrl1 = VanityUrlServiceTest.createVanity(true, true, "/test", SITEA, "en");
        VanityUrlServiceTest.saveVanity(vanityUrl1);
        vanityUrl1 = VanityUrlServiceTest.insureVanityExist(vanityUrl1);
        VanityUrl vanityUrl2 = VanityUrlServiceTest.createVanity(true, false, "/test2", SITEA, "en");
        VanityUrlServiceTest.saveVanities(Lists.newArrayList((Object[])new VanityUrl[]{vanityUrl1, vanityUrl2}), Sets.newHashSet((Object[])new String[]{"en"}));
        vanityUrl1 = VanityUrlServiceTest.insureVanityExist(vanityUrl1);
        vanityUrl2 = VanityUrlServiceTest.insureVanityExist(vanityUrl2);
        VanityUrl vanityUrl3 = VanityUrlServiceTest.createVanity(true, true, "/test3", SITEA, "en");
        vanityUrl1.setDefaultMapping(false);
        VanityUrlServiceTest.saveVanities(Lists.newArrayList((Object[])new VanityUrl[]{vanityUrl1, vanityUrl2, vanityUrl3}), Sets.newHashSet((Object[])new String[]{"en"}));
        VanityUrlServiceTest.insureVanityExist(vanityUrl1);
        VanityUrlServiceTest.insureVanityExist(vanityUrl2);
        VanityUrlServiceTest.insureVanityExist(vanityUrl3);
    }

    @Test
    public void testDelete() throws Exception {
        VanityUrl vanityUrl1 = VanityUrlServiceTest.createVanity(true, true, "/test", SITEA, "en");
        VanityUrlServiceTest.saveVanity(vanityUrl1);
        vanityUrl1 = VanityUrlServiceTest.insureVanityExist(vanityUrl1);
        VanityUrl vanityUrl2 = VanityUrlServiceTest.createVanity(true, false, "/test2", SITEA, "en");
        VanityUrlServiceTest.saveVanities(Lists.newArrayList((Object[])new VanityUrl[]{vanityUrl1, vanityUrl2}), Sets.newHashSet((Object[])new String[]{"en"}));
        vanityUrl1 = VanityUrlServiceTest.insureVanityExist(vanityUrl1);
        vanityUrl2 = VanityUrlServiceTest.insureVanityExist(vanityUrl2);
        VanityUrlServiceTest.saveVanities(Lists.newArrayList((Object[])new VanityUrl[]{vanityUrl1}), Sets.newHashSet((Object[])new String[]{"en"}));
        VanityUrlServiceTest.insureVanityExist(vanityUrl1);
        VanityUrlServiceTest.insureVanityDoesNotExist(vanityUrl2.getUrl());
        VanityUrlServiceTest.saveVanities(Lists.newArrayList(), Sets.newHashSet((Object[])new String[]{"en"}));
        VanityUrlServiceTest.insureVanityDoesNotExist(vanityUrl1.getUrl());
        VanityUrlServiceTest.insureVanityDoesNotExist(vanityUrl2.getUrl());
    }
}

