/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.workflow;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.PublicationInfo;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.services.workflow.WorkflowDefinition;
import org.jahia.services.workflow.WorkflowService;
import org.jahia.services.workflow.WorkflowVariable;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class WorkflowPermissionsTest {
    private static final String CONTENTS_NODE;
    private static JahiaUser editor;
    private static final String LIST_NAME = "wf-test-list";
    private static final String LIST_NODE_PATH;
    private static final String PROVIDER = "jBPM";
    private static JCRPublicationService publicationService;
    private static JahiaUser reviewer;
    private static final String SITE_NAME;
    private static final String TEXT_NAME = "text-node";
    private static final String TEXT_NODE_PATH;
    private static final String TEXT_NODE_WITH_PERMISSIONS_REVOKED_PATH;
    private static final String TEXT_WITH_PERMISSIONS_REVOKED_NAME = "text-node-with-permissions-revoked";
    private static JahiaUserManagerService userManagerService;
    private static WorkflowService workflowService;
    protected String processId;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        userManagerService = ServicesRegistry.getInstance().getJahiaUserManagerService();
        workflowService = WorkflowService.getInstance();
        publicationService = JCRPublicationService.getInstance();
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
        JahiaSite site = TestHelper.createSite(SITE_NAME);
        editor = userManagerService.createUser("wf-editor", SITE_NAME, "password", new Properties(), session).getJahiaUser();
        reviewer = userManagerService.createUser("wf-reviewer", SITE_NAME, "password", new Properties(), session).getJahiaUser();
        session.save();
        JCRNodeWrapper siteNode = session.getNode(site.getJCRLocalPath());
        siteNode.grantRoles("u:" + editor.getName(), (Set)ImmutableSet.of((Object)"editor"));
        siteNode.grantRoles("u:" + reviewer.getName(), (Set)ImmutableSet.of((Object)"reviewer"));
        session.save();
        publicationService.publishByMainId(siteNode.getIdentifier(), "default", "live", null, true, null);
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        TestHelper.deleteSite(SITE_NAME);
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    private void deleteTestContent(JCRSessionWrapper session) throws RepositoryException {
        if (session.nodeExists(LIST_NODE_PATH)) {
            session.getNode(LIST_NODE_PATH).remove();
            session.save();
        }
    }

    private WorkflowDefinition getPossiblePublishWorkflow(JCRNodeWrapper targetNode) throws RepositoryException {
        return workflowService.getPossibleWorkflowForType(targetNode, true, "publish", Locale.ENGLISH);
    }

    @Before
    public void setUp() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
        JCRNodeWrapper listNode = session.getNode(CONTENTS_NODE).addNode(LIST_NAME, "jnt:contentList");
        listNode.addNode(TEXT_NAME, "jnt:text");
        JCRNodeWrapper textNodeWithPermissoinsRevoked = listNode.addNode(TEXT_WITH_PERMISSIONS_REVOKED_NAME, "jnt:text");
        textNodeWithPermissoinsRevoked.denyRoles("u:" + editor.getName(), (Set)ImmutableSet.of((Object)"editor"));
        textNodeWithPermissoinsRevoked.grantRoles("u:" + reviewer.getName(), (Set)ImmutableSet.of((Object)"reviewer"));
        session.save();
    }

    private String startProcess(JCRNodeWrapper node, String workflowKey) throws RepositoryException {
        List<String> nodeIds = Arrays.asList(node.getIdentifier());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startDate", new WorkflowVariable());
        map.put("endDate", new WorkflowVariable());
        map.put("publicationInfos", publicationService.getPublicationInfos(nodeIds, (Set)Sets.newHashSet((Object[])new String[]{Locale.ENGLISH.toString()}), true, true, true, "default", "live"));
        return workflowService.startProcess(((PublicationInfo)publicationService.getPublicationInfos(nodeIds, (Set)Sets.newHashSet((Object[])new String[]{Locale.ENGLISH.toString()}), true, true, true, "default", "live").get(0)).getAllUuids(), node.getSession(), workflowKey, PROVIDER, map, null);
    }

    @After
    public void tearDown() throws Exception {
        if (this.processId != null) {
            workflowService.abortProcess(this.processId, PROVIDER);
        }
        this.deleteTestContent(JCRSessionFactory.getInstance().getCurrentUserSession("live", Locale.ENGLISH));
        this.deleteTestContent(JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH));
    }

    @Test
    public void testDirectStartPermissionCheck() throws RepositoryException {
        Assert.assertNotNull("There should be some workflows for type 'publish' deployed", workflowService.getPossibleWorkflowForType(JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH).getNode(LIST_NODE_PATH), false, "publish", Locale.ENGLISH));
        JCRTemplate.getInstance().doExecute(editor, "default", Locale.ENGLISH, (JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                Assert.assertNotNull("Editor should have a permission to start publication of the list node", WorkflowPermissionsTest.this.getPossiblePublishWorkflow(session.getNode(LIST_NODE_PATH)));
                Assert.assertNotNull("Editor should have a permission to start publication of the text node", WorkflowPermissionsTest.this.getPossiblePublishWorkflow(session.getNode(TEXT_NODE_PATH)));
                Assert.assertNull("Editor should NOT have a permission to start publication of the text node with permissions revoked", WorkflowPermissionsTest.this.getPossiblePublishWorkflow(session.getNode(TEXT_NODE_WITH_PERMISSIONS_REVOKED_PATH)));
                return null;
            }
        });
    }

    @Test
    public void testStart() throws RepositoryException {
        JCRTemplate.getInstance().doExecute(editor, "default", Locale.ENGLISH, (JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRNodeWrapper listNode = session.getNode(LIST_NODE_PATH);
                WorkflowDefinition possiblePublishoWorkflow = WorkflowPermissionsTest.this.getPossiblePublishWorkflow(listNode);
                Assert.assertNotNull("Editor should have a permission to start publication of the list node", possiblePublishoWorkflow);
                WorkflowPermissionsTest.this.processId = WorkflowPermissionsTest.this.startProcess(listNode, possiblePublishoWorkflow.getKey());
                Assert.assertNotNull("Workflow process should have been started", WorkflowPermissionsTest.this.processId);
                TestHelper.triggerScheduledJobsAndWait();
                return null;
            }
        });
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
        Assert.assertNotNull("The workflow process should have been started on node " + LIST_NODE_PATH, session.getNode(LIST_NODE_PATH).getPropertyAsString("j:processId"));
        Assert.assertNotNull("The workflow process should have been started on node " + TEXT_NODE_PATH, session.getNode(TEXT_NODE_PATH).getPropertyAsString("j:processId"));
        Assert.assertNull("The workflow process should NOT have been started on node " + TEXT_NODE_WITH_PERMISSIONS_REVOKED_PATH, session.getNode(TEXT_NODE_WITH_PERMISSIONS_REVOKED_PATH).getPropertyAsString("j:processId"));
    }

    static {
        SITE_NAME = WorkflowPermissionsTest.class.getSimpleName();
        CONTENTS_NODE = "/sites/" + SITE_NAME + "/contents";
        LIST_NODE_PATH = CONTENTS_NODE + '/' + LIST_NAME;
        TEXT_NODE_PATH = LIST_NODE_PATH + '/' + TEXT_NAME;
        TEXT_NODE_WITH_PERMISSIONS_REVOKED_PATH = LIST_NODE_PATH + '/' + TEXT_WITH_PERMISSIONS_REVOKED_NAME;
    }
}

