/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.workflow;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.services.workflow.HistoryWorkflow;
import org.jahia.services.workflow.Workflow;
import org.jahia.services.workflow.WorkflowAction;
import org.jahia.services.workflow.WorkflowDefinition;
import org.jahia.services.workflow.WorkflowService;
import org.jahia.services.workflow.WorkflowTask;
import org.jahia.services.workflow.WorkflowVariable;
import org.jahia.settings.readonlymode.ReadOnlyModeException;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowServiceTest {
    private static final String TESTSITE_NAME = "jBPMWorkflowServiceTest";
    private static final String SITECONTENT_ROOT_NODE = "/sites/jBPMWorkflowServiceTest/home";
    private static final String WORKFLOW_TYPE_1_STEP_PUBLICATION = "1-step-publication";
    private static final String WORKFLOW_TYPE_2_STEP_PUBLICATION = "2-step-publication";
    private static JahiaSite site;
    private static JahiaUser johndoe;
    private static JahiaUser johnsmoe;
    private HashMap<String, Object> emptyMap;
    private static final String PROVIDER = "jBPM";
    private static Logger logger;
    private static int nodeCounter;
    private JCRNodeWrapper stageNode;
    private static WorkflowService service;
    private static JCRPublicationService publicationService;
    private String processId;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        site = TestHelper.createSite(TESTSITE_NAME);
        Assert.assertNotNull("Unable to create test site", site);
        WorkflowServiceTest.initUsersGroup();
        JCRSessionFactory.getInstance().getCurrentUserSession().save();
        service = WorkflowService.getInstance();
        publicationService = JCRPublicationService.getInstance();
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        try {
            TestHelper.deleteSite(TESTSITE_NAME);
        }
        catch (Exception ex) {
            logger.warn("Exception during test tearDown", (Throwable)ex);
        }
        JahiaUserManagerService userManagerService = ServicesRegistry.getInstance().getJahiaUserManagerService();
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
        userManagerService.deleteUser(userManagerService.lookupUser("johndoe").getPath(), session);
        userManagerService.deleteUser(userManagerService.lookupUser("johnsmoe").getPath(), session);
        session.save();
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @Before
    public void setUp() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
        JCRNodeWrapper root = session.getNode(SITECONTENT_ROOT_NODE);
        session.checkout((Node)root);
        this.stageNode = root.addNode("child-" + ++nodeCounter, "jnt:text");
        session.save();
        this.emptyMap = new HashMap();
    }

    private void getCleanStageNode() throws Exception {
        JCRSessionFactory.getInstance().closeAllSessions();
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
        this.stageNode = session.getNode("/sites/jBPMWorkflowServiceTest/home/child-" + nodeCounter);
    }

    @Test
    public void testGetPossibleWorkflow() throws Exception {
        this.getPossibleWorkflows();
    }

    @Test
    public void testGetActiveWorkflows() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startDate", new WorkflowVariable());
        map.put("endDate", new WorkflowVariable());
        this.getPossibleWorkflowEnsureExists(null);
        WorkflowDefinition workflow = this.getPossibleWorkflowEnsureExists(WORKFLOW_TYPE_1_STEP_PUBLICATION);
        map.put("publicationInfos", publicationService.getPublicationInfos(Arrays.asList(this.stageNode.getIdentifier()), (Set)Sets.newHashSet((Object[])new String[]{Locale.ENGLISH.toString()}), true, true, false, "default", "live"));
        this.processId = service.startProcess(Arrays.asList(this.stageNode.getIdentifier()), this.stageNode.getSession(), workflow.getKey(), PROVIDER, map, null);
        Assert.assertNotNull("The startup of a process should have return an id", this.processId);
        TestHelper.triggerScheduledJobsAndWait();
        this.getCleanStageNode();
        List activeWorkflows = service.getActiveWorkflows(this.stageNode, Locale.ENGLISH, null);
        Assert.assertTrue("There should be some active workflow in jBPM", activeWorkflows.size() > 0);
        Assert.assertTrue("There should be some active activities for the first workflow in jBPM", ((Workflow)activeWorkflows.get(0)).getAvailableActions().size() > 0);
    }

    @Test
    public void testAssignTask() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startDate", new WorkflowVariable());
        map.put("endDate", new WorkflowVariable());
        WorkflowDefinition workflow = this.getPossibleWorkflowEnsureExists(WORKFLOW_TYPE_1_STEP_PUBLICATION);
        map.put("publicationInfos", publicationService.getPublicationInfos(Arrays.asList(this.stageNode.getIdentifier()), (Set)Sets.newHashSet((Object[])new String[]{Locale.ENGLISH.toString()}), true, true, false, "default", "live"));
        this.processId = service.startProcess(Arrays.asList(this.stageNode.getIdentifier()), this.stageNode.getSession(), workflow.getKey(), PROVIDER, map, null);
        Assert.assertNotNull("The startup of a process should have return an id", this.processId);
        TestHelper.triggerScheduledJobsAndWait();
        this.getCleanStageNode();
        List activeWorkflows = service.getActiveWorkflows(this.stageNode, Locale.ENGLISH, null);
        Assert.assertTrue("There should be some active workflow in jBPM", activeWorkflows.size() > 0);
        Set actionSet = ((Workflow)activeWorkflows.get(0)).getAvailableActions();
        Assert.assertTrue("There should be some active activities for the first workflow in jBPM", actionSet.size() > 0);
        WorkflowAction action = (WorkflowAction)actionSet.iterator().next();
        Assert.assertTrue(action instanceof WorkflowTask);
        WorkflowTask task = (WorkflowTask)action;
        JahiaUser user = ServicesRegistry.getInstance().getJahiaUserManagerService().lookupUser("root").getJahiaUser();
        Assert.assertNotNull(user);
        service.assignTask(task.getId(), PROVIDER, user);
        TestHelper.triggerScheduledJobsAndWait();
        List forUser = service.getTasksForUser(user, Locale.ENGLISH);
        Assert.assertTrue(forUser.size() > 0);
        HashMap emptyMap = new HashMap();
        WorkflowTask workflowTask = (WorkflowTask)forUser.get(0);
        service.completeTask(workflowTask.getId(), user, PROVIDER, "reject", emptyMap);
        TestHelper.triggerScheduledJobsAndWait();
        Assert.assertTrue(service.getTasksForUser(user, Locale.ENGLISH).size() < forUser.size());
        this.getCleanStageNode();
        Assert.assertFalse(service.getActiveWorkflows(this.stageNode, Locale.ENGLISH, null).equals(actionSet));
    }

    @Test
    public void testFullProcess2StepPublication() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startDate", new WorkflowVariable());
        map.put("endDate", new WorkflowVariable());
        WorkflowDefinition workflow = this.getPublishWorkflowEnsureExists(WORKFLOW_TYPE_2_STEP_PUBLICATION);
        map.put("publicationInfos", publicationService.getPublicationInfos(Arrays.asList(this.stageNode.getIdentifier()), (Set)Sets.newHashSet((Object[])new String[]{Locale.ENGLISH.toString()}), true, true, false, "default", "live"));
        this.processId = service.startProcess(Arrays.asList(this.stageNode.getIdentifier()), this.stageNode.getSession(), workflow.getKey(), PROVIDER, map, null);
        Assert.assertNotNull("The startup of a process should have return an id", this.processId);
        TestHelper.triggerScheduledJobsAndWait();
        this.getCleanStageNode();
        List activeWorkflows = service.getActiveWorkflows(this.stageNode, Locale.ENGLISH, null);
        Assert.assertTrue("There should be some active workflow in jBPM", activeWorkflows.size() > 0);
        Set actionSet = ((Workflow)activeWorkflows.get(0)).getAvailableActions();
        Assert.assertTrue("There should be some active activities for the first workflow in jBPM", actionSet.size() > 0);
        WorkflowAction action = (WorkflowAction)actionSet.iterator().next();
        Assert.assertTrue(action instanceof WorkflowTask);
        WorkflowTask task = (WorkflowTask)action;
        service.assignTask(task.getId(), PROVIDER, johndoe);
        TestHelper.triggerScheduledJobsAndWait();
        List forUser = service.getTasksForUser(johndoe, Locale.ENGLISH);
        Assert.assertTrue(forUser.size() > 0);
        WorkflowTask workflowTask = (WorkflowTask)forUser.get(0);
        service.completeTask(workflowTask.getId(), johndoe, PROVIDER, "accept", this.emptyMap);
        TestHelper.triggerScheduledJobsAndWait();
        this.getCleanStageNode();
        Assert.assertFalse(service.getActiveWorkflows(this.stageNode, Locale.ENGLISH, null).equals(actionSet));
        actionSet = service.getAvailableActions(this.processId, PROVIDER, Locale.ENGLISH);
        service.assignTask(((WorkflowTask)actionSet.iterator().next()).getId(), PROVIDER, johnsmoe);
        TestHelper.triggerScheduledJobsAndWait();
        forUser = service.getTasksForUser(johnsmoe, Locale.ENGLISH);
        Assert.assertTrue("John Smoe task list should not be empty", forUser.size() > 0);
        Assert.assertTrue("Current task should be final review", ((WorkflowTask)forUser.get(0)).getName().equals("final review"));
        workflowTask = (WorkflowTask)forUser.get(0);
        Assert.assertTrue("Final review should have 3 outcomes", workflowTask.getOutcomes().size() == 3);
        Assert.assertTrue("Final review should contains correction needed as an outcome", workflowTask.getOutcomes().contains("correction needed"));
        service.completeTask(workflowTask.getId(), johnsmoe, workflowTask.getProvider(), "correction needed", this.emptyMap);
        TestHelper.triggerScheduledJobsAndWait();
        Assert.assertTrue("Current Task should be finish correction as we have asked for corrections", ((WorkflowAction)service.getAvailableActions(this.processId, PROVIDER, Locale.ENGLISH).iterator().next()).getName().equals("finish correction"));
        service.assignTask(((WorkflowTask)service.getAvailableActions(this.processId, PROVIDER, Locale.ENGLISH).iterator().next()).getId(), PROVIDER, johndoe);
        TestHelper.triggerScheduledJobsAndWait();
        service.completeTask(((WorkflowTask)service.getTasksForUser(johndoe, Locale.ENGLISH).get(0)).getId(), johndoe, PROVIDER, "finished", this.emptyMap);
        TestHelper.triggerScheduledJobsAndWait();
        service.assignTask(((WorkflowTask)service.getAvailableActions(this.processId, PROVIDER, Locale.ENGLISH).iterator().next()).getId(), PROVIDER, johnsmoe);
        TestHelper.triggerScheduledJobsAndWait();
        service.completeTask(((WorkflowTask)service.getTasksForUser(johnsmoe, Locale.ENGLISH).get(0)).getId(), johnsmoe, PROVIDER, "accept", this.emptyMap);
        TestHelper.triggerScheduledJobsAndWait();
        Assert.assertTrue("Current Task should be final review as we have accepted the correction", ((WorkflowAction)service.getAvailableActions(this.processId, PROVIDER, Locale.ENGLISH).iterator().next()).getName().equals("final review"));
    }

    @After
    public void tearDown() throws Exception {
        if (this.processId != null) {
            service.deleteProcess(this.processId, PROVIDER);
        }
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    private static void initUsersGroup() throws RepositoryException {
        JahiaUserManagerService userManagerService = ServicesRegistry.getInstance().getJahiaUserManagerService();
        JahiaGroupManagerService groupManagerService = ServicesRegistry.getInstance().getJahiaGroupManagerService();
        johndoe = userManagerService.lookupUser("johndoe") != null ? userManagerService.lookupUser("johndoe").getJahiaUser() : null;
        johnsmoe = userManagerService.lookupUser("johnsmoe") != null ? userManagerService.lookupUser("johndoe").getJahiaUser() : null;
        Properties properties = new Properties();
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
        if (johndoe == null) {
            properties.setProperty("j:firstName", "John");
            properties.setProperty("j:lastName", "Doe");
            johndoe = userManagerService.createUser("johndoe", "johndoe", properties, session).getJahiaUser();
        }
        if (johnsmoe == null) {
            properties = new Properties();
            properties.setProperty("j:firstName", "John");
            properties.setProperty("j:lastName", "Smoe");
            johnsmoe = userManagerService.createUser("johnsmoe", "johnsmoe", properties, session).getJahiaUser();
        }
        JCRGroupNode group = groupManagerService.createGroup(site.getSiteKey(), "taskUsersGroup", new Properties(), true, session);
        group.addMember((Principal)johndoe);
        group.addMember((Principal)johnsmoe);
        session.getNode("/sites/" + site.getSiteKey()).grantRoles("g:" + group.getName(), (Set)ImmutableSet.of((Object)"editor-in-chief"));
        session.save();
    }

    @Test
    public void test2StepPublicationAccept() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startDate", new WorkflowVariable());
        map.put("endDate", new WorkflowVariable());
        WorkflowDefinition workflow = this.getPublishWorkflowEnsureExists(WORKFLOW_TYPE_2_STEP_PUBLICATION);
        map.put("publicationInfos", publicationService.getPublicationInfos(Arrays.asList(this.stageNode.getIdentifier()), (Set)Sets.newHashSet((Object[])new String[]{Locale.ENGLISH.toString()}), true, true, false, "default", "live"));
        this.processId = service.startProcess(Arrays.asList(this.stageNode.getIdentifier()), this.stageNode.getSession(), workflow.getKey(), PROVIDER, map, null);
        Assert.assertNotNull("The startup of a process should have return an id", this.processId);
        TestHelper.triggerScheduledJobsAndWait();
        this.getCleanStageNode();
        List activeWorkflows = service.getActiveWorkflows(this.stageNode, Locale.ENGLISH, null);
        Assert.assertTrue("There should be some active workflow in jBPM", activeWorkflows.size() > 0);
        Set actionSet = ((Workflow)activeWorkflows.get(0)).getAvailableActions();
        Assert.assertTrue("There should be some active activities for the first workflow in jBPM", actionSet.size() > 0);
        WorkflowAction action = (WorkflowAction)actionSet.iterator().next();
        Assert.assertTrue(action instanceof WorkflowTask);
        WorkflowTask task = (WorkflowTask)action;
        service.assignTask(task.getId(), PROVIDER, johndoe);
        TestHelper.triggerScheduledJobsAndWait();
        List forUser = service.getTasksForUser(johndoe, Locale.ENGLISH);
        Assert.assertTrue(forUser.size() > 0);
        WorkflowTask workflowTask = (WorkflowTask)forUser.get(0);
        service.completeTask(workflowTask.getId(), johndoe, PROVIDER, "accept", this.emptyMap);
        TestHelper.triggerScheduledJobsAndWait();
        this.getCleanStageNode();
        activeWorkflows = service.getActiveWorkflows(this.stageNode, Locale.ENGLISH, null);
        actionSet = ((Workflow)activeWorkflows.get(0)).getAvailableActions();
        Assert.assertTrue("There should be some active activities for the first workflow in jBPM", actionSet.size() > 0);
        action = (WorkflowAction)actionSet.iterator().next();
        Assert.assertTrue(action instanceof WorkflowTask);
        task = (WorkflowTask)action;
        service.assignTask(task.getId(), PROVIDER, johndoe);
        TestHelper.triggerScheduledJobsAndWait();
        forUser = service.getTasksForUser(johndoe, Locale.ENGLISH);
        Assert.assertTrue(forUser.size() > 0);
        workflowTask = (WorkflowTask)forUser.get(0);
        service.completeTask(workflowTask.getId(), johndoe, PROVIDER, "reject", this.emptyMap);
        TestHelper.triggerScheduledJobsAndWait();
        Assert.assertTrue(service.getTasksForUser(johndoe, Locale.ENGLISH).size() < forUser.size());
        this.getCleanStageNode();
        Assert.assertTrue("The workflow process is not completed", service.getActiveWorkflows(this.stageNode, Locale.ENGLISH, null).isEmpty());
    }

    @Test
    public void test1StepPublicationAccept() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startDate", new WorkflowVariable());
        map.put("endDate", new WorkflowVariable());
        WorkflowDefinition workflow = this.getPossibleWorkflowEnsureExists(WORKFLOW_TYPE_1_STEP_PUBLICATION);
        map.put("publicationInfos", publicationService.getPublicationInfos(Arrays.asList(this.stageNode.getIdentifier()), (Set)Sets.newHashSet((Object[])new String[]{Locale.ENGLISH.toString()}), true, true, false, "default", "live"));
        this.processId = service.startProcess(Arrays.asList(this.stageNode.getIdentifier()), this.stageNode.getSession(), workflow.getKey(), PROVIDER, map, null);
        Assert.assertNotNull("The startup of a process should have return an id", this.processId);
        TestHelper.triggerScheduledJobsAndWait();
        this.getCleanStageNode();
        List activeWorkflows = service.getActiveWorkflows(this.stageNode, Locale.ENGLISH, null);
        Assert.assertTrue("There should be some active workflow in jBPM", activeWorkflows.size() > 0);
        Set actionSet = ((Workflow)activeWorkflows.get(0)).getAvailableActions();
        Assert.assertTrue("There should be some active activities for the first workflow in jBPM", actionSet.size() > 0);
        WorkflowAction action = (WorkflowAction)actionSet.iterator().next();
        Assert.assertTrue(action instanceof WorkflowTask);
        WorkflowTask task = (WorkflowTask)action;
        service.assignTask(task.getId(), PROVIDER, johndoe);
        TestHelper.triggerScheduledJobsAndWait();
        List forUser = service.getTasksForUser(johndoe, Locale.ENGLISH);
        Assert.assertTrue(forUser.size() > 0);
        WorkflowTask workflowTask = (WorkflowTask)forUser.get(0);
        service.completeTask(workflowTask.getId(), johndoe, PROVIDER, "reject", this.emptyMap);
        TestHelper.triggerScheduledJobsAndWait();
        this.getCleanStageNode();
        Assert.assertTrue(service.getTasksForUser(johndoe, Locale.ENGLISH).size() < forUser.size());
        this.getCleanStageNode();
        Assert.assertTrue("The workflow process is not completed", service.getActiveWorkflows(this.stageNode, Locale.ENGLISH, null).isEmpty());
    }

    @Test
    public void test1StepPublicationReject() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startDate", new WorkflowVariable());
        map.put("endDate", new WorkflowVariable());
        WorkflowDefinition workflow = this.getPossibleWorkflowEnsureExists(WORKFLOW_TYPE_1_STEP_PUBLICATION);
        map.put("publicationInfos", publicationService.getPublicationInfos(Arrays.asList(this.stageNode.getIdentifier()), (Set)Sets.newHashSet((Object[])new String[]{Locale.ENGLISH.toString()}), true, true, false, "default", "live"));
        this.processId = service.startProcess(Arrays.asList(this.stageNode.getIdentifier()), this.stageNode.getSession(), workflow.getKey(), PROVIDER, map, null);
        Assert.assertNotNull("The startup of a process should have return an id", this.processId);
        TestHelper.triggerScheduledJobsAndWait();
        this.getCleanStageNode();
        List activeWorkflows = service.getActiveWorkflows(this.stageNode, Locale.ENGLISH, null);
        Assert.assertTrue("There should be some active workflow in jBPM", activeWorkflows.size() > 0);
        Set actionSet = ((Workflow)activeWorkflows.get(0)).getAvailableActions();
        Assert.assertTrue("There should be some active activities for the first workflow in jBPM", actionSet.size() > 0);
        WorkflowAction action = (WorkflowAction)actionSet.iterator().next();
        Assert.assertTrue(action instanceof WorkflowTask);
        WorkflowTask task = (WorkflowTask)action;
        service.assignTask(task.getId(), PROVIDER, johndoe);
        TestHelper.triggerScheduledJobsAndWait();
        List forUser = service.getTasksForUser(johndoe, Locale.ENGLISH);
        Assert.assertTrue(forUser.size() > 0);
        WorkflowTask workflowTask = (WorkflowTask)forUser.get(0);
        service.completeTask(workflowTask.getId(), johndoe, PROVIDER, "reject", this.emptyMap);
        TestHelper.triggerScheduledJobsAndWait();
        Assert.assertTrue(service.getTasksForUser(johndoe, Locale.ENGLISH).size() < forUser.size());
        this.getCleanStageNode();
        Assert.assertTrue("The workflow process is not completed", service.getActiveWorkflows(this.stageNode, Locale.ENGLISH, null).isEmpty());
    }

    @Test
    public void testHistory() throws Exception {
        this.test1StepPublicationAccept();
        this.test1StepPublicationReject();
        List history = service.getHistoryWorkflows(this.stageNode, Locale.ENGLISH);
        Assert.assertEquals("Node should have two history records", 2L, history.size());
    }

    @Test
    public void testHistoryTasks() throws Exception {
        this.test2StepPublicationAccept();
        List history = service.getHistoryWorkflows(this.stageNode, Locale.ENGLISH);
        Assert.assertEquals("Node should have one history record", 1L, history.size());
        HistoryWorkflow historyItem = (HistoryWorkflow)history.get(0);
        List tasks = service.getHistoryWorkflowTasks(historyItem.getProcessId(), historyItem.getProvider(), null);
        Assert.assertEquals("The workflow process should have two history task records", 2L, tasks.size());
    }

    @Test
    public void abortProcessShouldFailInReadOnlyMode() {
        this.verifyFailureInReadOnlyMode(new Runnable(){

            @Override
            public void run() {
                service.abortProcess(WorkflowServiceTest.this.processId, WorkflowServiceTest.PROVIDER);
            }
        });
    }

    @Test
    public void startProcessShouldFailInReadOnlyMode() {
        this.verifyFailureInReadOnlyMode(new Runnable(){

            @Override
            public void run() {
                try {
                    service.startProcess(null, null, WorkflowServiceTest.this.processId, WorkflowServiceTest.PROVIDER, null, null);
                }
                catch (RepositoryException e) {
                    throw new JahiaRuntimeException((Throwable)e);
                }
            }
        });
    }

    @Test
    public void assignTaskShouldFailInReadOnlyMode() {
        this.verifyFailureInReadOnlyMode(new Runnable(){

            @Override
            public void run() {
                service.assignTask(null, WorkflowServiceTest.PROVIDER, johndoe);
            }
        });
    }

    @Test
    public void completeTaskShouldFailInReadOnlyMode() {
        this.verifyFailureInReadOnlyMode(new Runnable(){

            @Override
            public void run() {
                service.completeTask(null, johndoe, WorkflowServiceTest.PROVIDER, null, null);
            }
        });
    }

    @Test
    public void addCommentShouldFailInReadOnlyMode() {
        this.verifyFailureInReadOnlyMode(new Runnable(){

            @Override
            public void run() {
                service.addComment(WorkflowServiceTest.this.processId, WorkflowServiceTest.PROVIDER, "comment", "johndoe");
            }
        });
    }

    @Test
    public void deleteProcessShouldFailInReadOnlyMode() {
        this.verifyFailureInReadOnlyMode(new Runnable(){

            @Override
            public void run() {
                service.deleteProcess(WorkflowServiceTest.this.processId, WorkflowServiceTest.PROVIDER);
            }
        });
    }

    protected Collection<WorkflowDefinition> getPossibleWorkflows() throws RepositoryException {
        Collection<WorkflowDefinition> workflowList = service.getPossibleWorkflows(this.stageNode, true, Locale.ENGLISH).values();
        Assert.assertTrue("There should be some workflows already deployed", workflowList.size() > 0);
        return workflowList;
    }

    protected WorkflowDefinition getPublishWorkflowEnsureExists(String type) throws RepositoryException {
        List workflowList = service.getWorkflowDefinitionsForType("publish", null, Locale.ENGLISH);
        Assert.assertTrue("There should be some workflows already deployed", workflowList.size() > 0);
        WorkflowDefinition workflow = null;
        for (WorkflowDefinition workflowDefinition : workflowList) {
            if (!type.equals(workflowDefinition.getName())) continue;
            workflow = workflowDefinition;
            break;
        }
        Assert.assertNotNull("Unable to find workflow process of type: " + type, workflow);
        return workflow;
    }

    protected WorkflowDefinition getPossibleWorkflowEnsureExists(String type) throws RepositoryException {
        Collection<WorkflowDefinition> workflowList = this.getPossibleWorkflows();
        if (type == null) {
            return workflowList.iterator().next();
        }
        WorkflowDefinition workflow = null;
        for (WorkflowDefinition workflowDefinition : workflowList) {
            if (!type.equals(workflowDefinition.getName())) continue;
            workflow = workflowDefinition;
            break;
        }
        Assert.assertNotNull("Unable to find workflow process of type: " + type, workflow);
        return workflow;
    }

    private void verifyFailureInReadOnlyMode(Runnable action) {
        service.switchReadOnlyMode(true);
        try {
            action.run();
            Assert.fail("The action should have failed due to read only mode");
        }
        catch (ReadOnlyModeException readOnlyModeException) {
        }
        finally {
            service.switchReadOnlyMode(false);
        }
    }

    static {
        logger = LoggerFactory.getLogger(WorkflowServiceTest.class);
    }
}

