/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.JanusGraphManagerUtility;
import org.janusgraph.diskstorage.configuration.backend.CommonsConfiguration;
import org.janusgraph.graphdb.configuration.builder.GraphDatabaseConfigurationBuilder;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.janusgraph.graphdb.management.ConfigurationManagementGraph;
import org.janusgraph.graphdb.management.JanusGraphManager;
import org.janusgraph.graphdb.management.utils.ConfigurationManagementGraphNotEnabledException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfiguredGraphFactory {
    private static final Logger log = LoggerFactory.getLogger(ConfiguredGraphFactory.class);

    public static synchronized JanusGraph create(String graphName) {
        ConfigurationManagementGraph configManagementGraph = ConfiguredGraphFactory.getConfigGraphManagementInstance();
        Map<String, Object> graphConfigMap = configManagementGraph.getConfiguration(graphName);
        Preconditions.checkState((null == graphConfigMap ? 1 : 0) != 0, (Object)String.format("Configuration for graph %s already exists.", graphName));
        Map<String, Object> templateConfigMap = configManagementGraph.getTemplateConfiguration();
        Preconditions.checkNotNull(templateConfigMap, (Object)"Please create a template Configuration using the ConfigurationManagementGraph#createTemplateConfiguration API.");
        templateConfigMap.put(ConfigurationManagementGraph.PROPERTY_GRAPH_NAME, graphName);
        templateConfigMap.put("Created_Using_Template", true);
        JanusGraphManager jgm = JanusGraphManagerUtility.getInstance();
        Preconditions.checkNotNull((Object)jgm, (Object)"Gremlin Server must be configured to use the JanusGraphManager.");
        CommonsConfiguration config = new CommonsConfiguration((Configuration)new MapConfiguration(templateConfigMap));
        JanusGraph g = (JanusGraph)jgm.openGraph(graphName, gName -> new StandardJanusGraph(new GraphDatabaseConfigurationBuilder().build(config)));
        configManagementGraph.createConfiguration((Configuration)new MapConfiguration(templateConfigMap));
        return g;
    }

    public static JanusGraph open(String graphName) {
        ConfigurationManagementGraph configManagementGraph = ConfiguredGraphFactory.getConfigGraphManagementInstance();
        Map<String, Object> graphConfigMap = configManagementGraph.getConfiguration(graphName);
        Preconditions.checkNotNull(graphConfigMap, (Object)"Please create configuration for this graph using the ConfigurationManagementGraph#createConfiguration API.");
        JanusGraphManager jgm = JanusGraphManagerUtility.getInstance();
        Preconditions.checkNotNull((Object)jgm, (Object)"Gremlin Server must be configured to use the JanusGraphManager.");
        CommonsConfiguration config = new CommonsConfiguration((Configuration)new MapConfiguration(graphConfigMap));
        return (JanusGraph)jgm.openGraph(graphName, gName -> new StandardJanusGraph(new GraphDatabaseConfigurationBuilder().build(config)));
    }

    public static Set<String> getGraphNames() {
        ConfigurationManagementGraph configManagementGraph = ConfiguredGraphFactory.getConfigGraphManagementInstance();
        List<Map<String, Object>> configurations = configManagementGraph.getConfigurations();
        return configurations.stream().map(elem -> elem.getOrDefault(ConfigurationManagementGraph.PROPERTY_GRAPH_NAME, null)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static JanusGraph close(String graphName) throws Exception {
        JanusGraphManager jgm = JanusGraphManagerUtility.getInstance();
        Preconditions.checkNotNull((Object)jgm, (Object)"Gremlin Server must be configured to use the JanusGraphManager.");
        Graph graph = jgm.removeGraph(graphName);
        if (null != graph) {
            graph.close();
        }
        return (JanusGraph)graph;
    }

    public static void drop(String graphName) throws Exception {
        StandardJanusGraph graph = (StandardJanusGraph)ConfiguredGraphFactory.close(graphName);
        JanusGraphFactory.drop(graph);
        ConfiguredGraphFactory.removeConfiguration(graphName);
    }

    private static ConfigurationManagementGraph getConfigGraphManagementInstance() {
        ConfigurationManagementGraph configManagementGraph;
        try {
            configManagementGraph = ConfigurationManagementGraph.getInstance();
        }
        catch (ConfigurationManagementGraphNotEnabledException e) {
            throw new RuntimeException(e);
        }
        return configManagementGraph;
    }

    public static void createConfiguration(Configuration config) {
        ConfigurationManagementGraph configManagementGraph = ConfiguredGraphFactory.getConfigGraphManagementInstance();
        configManagementGraph.createConfiguration(config);
    }

    public static void createTemplateConfiguration(Configuration config) {
        ConfigurationManagementGraph configManagementGraph = ConfiguredGraphFactory.getConfigGraphManagementInstance();
        configManagementGraph.createTemplateConfiguration(config);
    }

    public static void updateConfiguration(String graphName, Configuration config) {
        ConfigurationManagementGraph configManagementGraph = ConfiguredGraphFactory.getConfigGraphManagementInstance();
        ConfiguredGraphFactory.removeGraphFromCache(graphName);
        configManagementGraph.updateConfiguration(graphName, config);
    }

    public static void updateTemplateConfiguration(Configuration config) {
        ConfigurationManagementGraph configManagementGraph = ConfiguredGraphFactory.getConfigGraphManagementInstance();
        configManagementGraph.updateTemplateConfiguration(config);
    }

    public static void removeConfiguration(String graphName) {
        ConfigurationManagementGraph configManagementGraph = ConfiguredGraphFactory.getConfigGraphManagementInstance();
        ConfiguredGraphFactory.removeGraphFromCache(graphName);
        configManagementGraph.removeConfiguration(graphName);
    }

    private static void removeGraphFromCache(String graphName) {
        try {
            JanusGraph graph = ConfiguredGraphFactory.open(graphName);
            ConfiguredGraphFactory.removeGraphFromCache(graph);
        }
        catch (Exception e) {
            log.error(String.format("Failed to open graph %s with the following error:\n %s.\nThus, it and its traversal will not be bound on this server.", graphName, e.toString()));
        }
    }

    private static void removeGraphFromCache(JanusGraph graph) {
        JanusGraphManager jgm = JanusGraphManagerUtility.getInstance();
        Preconditions.checkNotNull((Object)jgm, (Object)"Gremlin Server must be configured to use the JanusGraphManager.");
        jgm.removeGraph(((StandardJanusGraph)graph).getGraphName());
        ManagementSystem mgmt = (ManagementSystem)graph.openManagement();
        mgmt.evictGraphFromCache();
        mgmt.commit();
    }

    public static void removeTemplateConfiguration() {
        ConfigurationManagementGraph configManagementGraph = ConfiguredGraphFactory.getConfigGraphManagementInstance();
        configManagementGraph.removeTemplateConfiguration();
    }

    public static Map<String, Object> getConfiguration(String configName) {
        ConfigurationManagementGraph configManagementGraph = ConfiguredGraphFactory.getConfigGraphManagementInstance();
        return configManagementGraph.getConfiguration(configName);
    }

    public static List<Map<String, Object>> getConfigurations() {
        ConfigurationManagementGraph configManagementGraph = ConfiguredGraphFactory.getConfigGraphManagementInstance();
        return configManagementGraph.getConfigurations();
    }

    public static Map<String, Object> getTemplateConfiguration() {
        ConfigurationManagementGraph configManagementGraph = ConfiguredGraphFactory.getConfigGraphManagementInstance();
        return configManagementGraph.getTemplateConfiguration();
    }
}

