/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.util.time;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.janusgraph.diskstorage.util.time.TimestampProvider;

public class Timer {
    private final TimestampProvider times;
    private Instant start;
    private Instant stop;

    public Timer(TimestampProvider times) {
        this.times = times;
    }

    public Timer start() {
        Preconditions.checkState((null == this.start ? 1 : 0) != 0, (Object)"Timer can only be started once");
        this.start = this.times.getTime();
        return this;
    }

    public Instant getStartTime() {
        Preconditions.checkNotNull((Object)this.start, (Object)"Timer never started");
        return this.start;
    }

    public Timer stop() {
        Preconditions.checkNotNull((Object)this.start, (Object)"Timer stopped before it was started");
        this.stop = this.times.getTime();
        return this;
    }

    public Duration elapsed() {
        if (null == this.start) {
            return Duration.ZERO;
        }
        Instant stopTime = null == this.stop ? this.times.getTime() : this.stop;
        return Duration.between(this.start, stopTime);
    }

    public String toString() {
        ChronoUnit u = this.times.getUnit();
        if (this.start == null) {
            return "Initialized";
        }
        if (this.stop == null) {
            return String.format("Started at %d %s", this.times.getTime(this.start), u);
        }
        return String.format("%d %s", this.times.getTime(this.stop) - this.times.getTime(this.start), u);
    }
}

