/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.configuration;

import com.google.common.base.Preconditions;
import org.janusgraph.core.attribute.AttributeSerializer;
import org.janusgraph.graphdb.database.serialize.Serializer;

public class RegisteredAttributeClass<T> {
    private final int position;
    private final Class<T> type;
    private final AttributeSerializer<T> serializer;

    public RegisteredAttributeClass(int position, Class<T> type, AttributeSerializer<T> serializer) {
        Preconditions.checkArgument((position >= 0 ? 1 : 0) != 0, (String)"Position must be a positive integer, given: %s", (Object[])new Object[]{position});
        this.position = position;
        this.type = (Class)Preconditions.checkNotNull(type);
        this.serializer = (AttributeSerializer)Preconditions.checkNotNull(serializer);
    }

    void registerWith(Serializer s) {
        s.registerClass(this.position, this.type, this.serializer);
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null || !this.getClass().isInstance(oth)) {
            return false;
        }
        return this.type.equals(((RegisteredAttributeClass)oth).type);
    }

    public int hashCode() {
        return this.type.hashCode() + 110432;
    }

    public String toString() {
        return this.type.toString();
    }
}

