/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.serialize.attribute;

import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.graphdb.database.serialize.OrderPreservingSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.ShortSerializer;

public class CharacterSerializer
implements OrderPreservingSerializer<Character> {
    private final ShortSerializer ss = new ShortSerializer();

    @Override
    public Character read(ScanBuffer buffer) {
        short s = this.ss.read(buffer);
        return Character.valueOf(CharacterSerializer.short2char(s));
    }

    @Override
    public void write(WriteBuffer out, Character attribute) {
        this.ss.write(out, CharacterSerializer.char2short(attribute.charValue()));
    }

    @Override
    public Character readByteOrder(ScanBuffer buffer) {
        return this.read(buffer);
    }

    @Override
    public void writeByteOrder(WriteBuffer buffer, Character attribute) {
        this.write(buffer, attribute);
    }

    public static short char2short(char c) {
        return (short)(c + Short.MIN_VALUE);
    }

    public static char short2char(short s) {
        return (char)(s - Short.MIN_VALUE);
    }

    @Override
    public Character convert(Object value) {
        if (value instanceof String && ((String)value).length() == 1) {
            return Character.valueOf(((String)value).charAt(0));
        }
        return null;
    }
}

