/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.serialize.attribute;

import java.time.Instant;
import org.janusgraph.core.attribute.AttributeSerializer;
import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.graphdb.database.serialize.attribute.IntegerSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.LongSerializer;

public class InstantSerializer
implements AttributeSerializer<Instant> {
    private final LongSerializer secondsSerializer = new LongSerializer();
    private final IntegerSerializer nanosSerializer = new IntegerSerializer();

    @Override
    public Instant read(ScanBuffer buffer) {
        long seconds = this.secondsSerializer.read(buffer);
        long nanos = this.nanosSerializer.read(buffer).intValue();
        return Instant.ofEpochSecond(seconds, nanos);
    }

    @Override
    public void write(WriteBuffer buffer, Instant attribute) {
        this.secondsSerializer.write(buffer, attribute.getEpochSecond());
        this.nanosSerializer.write(buffer, attribute.getNano());
    }
}

