/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.relations;

import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.query.vertex.VertexCentricQueryBuilder;
import org.janusgraph.graphdb.relations.RelationIdentifier;
import org.janusgraph.graphdb.relations.StandardRelation;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;

public class RelationIdentifierUtils {
    public static RelationIdentifier get(InternalRelation r) {
        if (r.hasId()) {
            return new RelationIdentifier(r.getVertex(0).longId(), r.getType().longId(), r.longId(), r.isEdge() ? r.getVertex(1).longId() : 0L);
        }
        return null;
    }

    protected static JanusGraphRelation findRelation(RelationIdentifier rId, JanusGraphTransaction tx) {
        InternalVertex v = ((StandardJanusGraphTx)tx).getInternalVertex(rId.getOutVertexId());
        if (v == null || v.isRemoved()) {
            return null;
        }
        JanusGraphVertex typeVertex = tx.getVertex(rId.getTypeId());
        if (typeVertex == null) {
            return null;
        }
        if (!(typeVertex instanceof RelationType)) {
            throw new IllegalArgumentException("Invalid RelationIdentifier: typeID does not reference a type");
        }
        Iterable<? extends JanusGraphRelation> relations = RelationIdentifierUtils.getJanusGraphRelations(rId, tx, v, (RelationType)typeVertex);
        for (JanusGraphRelation janusGraphRelation : relations) {
            if (janusGraphRelation.longId() != rId.getRelationId() && (!(janusGraphRelation instanceof StandardRelation) || ((StandardRelation)janusGraphRelation).getPreviousID() != rId.getRelationId())) continue;
            return janusGraphRelation;
        }
        return null;
    }

    private static Iterable<? extends JanusGraphRelation> getJanusGraphRelations(RelationIdentifier rId, JanusGraphTransaction tx, JanusGraphVertex v, RelationType typeVertex) {
        if (typeVertex.isEdgeLabel()) {
            return RelationIdentifierUtils.findEdgeRelations(v, typeVertex, rId, tx);
        }
        return ((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)v.query()).noPartitionRestriction()).types((PropertyKey)typeVertex)).properties();
    }

    public static Iterable<? extends JanusGraphRelation> findEdgeRelations(JanusGraphVertex v, RelationType type, RelationIdentifier rId, JanusGraphTransaction tx) {
        Direction dir = Direction.OUT;
        JanusGraphVertex other = ((StandardJanusGraphTx)tx).getInternalVertex(rId.getInVertexId());
        if (other == null || other.isRemoved()) {
            return null;
        }
        if (((StandardJanusGraphTx)tx).isPartitionedVertex(v) && !((StandardJanusGraphTx)tx).isPartitionedVertex(other)) {
            InternalVertex tmp = other;
            other = v;
            v = tmp;
            dir = Direction.IN;
        }
        return ((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)v.query()).noPartitionRestriction()).types((EdgeLabel)type)).direction(dir)).adjacent(other)).edges();
    }

    public static JanusGraphEdge findEdge(RelationIdentifier rId, JanusGraphTransaction tx) {
        JanusGraphRelation r = RelationIdentifierUtils.findRelation(rId, tx);
        if (r == null) {
            return null;
        }
        if (r instanceof JanusGraphEdge) {
            return (JanusGraphEdge)r;
        }
        throw new UnsupportedOperationException("Referenced relation is a property not an edge");
    }

    public static JanusGraphVertexProperty findProperty(RelationIdentifier rId, JanusGraphTransaction tx) {
        JanusGraphRelation r = RelationIdentifierUtils.findRelation(rId, tx);
        if (r == null) {
            return null;
        }
        if (r instanceof JanusGraphVertexProperty) {
            return (JanusGraphVertexProperty)r;
        }
        throw new UnsupportedOperationException("Referenced relation is a edge not a property");
    }
}

