/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.Profiling;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphQuery;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.query.JanusGraphPredicateUtils;
import org.janusgraph.graphdb.query.graph.GraphCentricQuery;
import org.janusgraph.graphdb.query.graph.GraphCentricQueryBuilder;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.tinkerpop.optimize.HasStepFolder;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.QueryInfo;
import org.janusgraph.graphdb.tinkerpop.profile.TP3ProfileWrapper;
import org.janusgraph.graphdb.util.MultiDistinctOrderedIterator;

public class JanusGraphStep<S, E extends Element>
extends GraphStep<S, E>
implements HasStepFolder<S, E>,
Profiling,
HasContainerHolder {
    private final List<HasContainer> hasContainers = new ArrayList<HasContainer>();
    private final Map<List<HasContainer>, QueryInfo> hasLocalContainers = new LinkedHashMap<List<HasContainer>, QueryInfo>();
    private int lowLimit = 0;
    private int highLimit = Integer.MAX_VALUE;
    private final List<HasStepFolder.OrderEntry> orders = new ArrayList<HasStepFolder.OrderEntry>();
    private QueryProfiler queryProfiler = QueryProfiler.NO_OP;

    public JanusGraphStep(GraphStep<S, E> originalStep) {
        super(originalStep.getTraversal(), originalStep.getReturnClass(), originalStep.isStartStep(), originalStep.getIds());
        originalStep.getLabels().forEach(arg_0 -> ((JanusGraphStep)this).addLabel(arg_0));
        this.setIteratorSupplier(() -> {
            if (this.ids == null) {
                return Collections.emptyIterator();
            }
            if (this.ids.length > 0) {
                Graph graph = (Graph)this.traversal.asAdmin().getGraph().get();
                return this.iteratorList(graph.vertices(this.ids));
            }
            if (this.hasLocalContainers.isEmpty()) {
                this.hasLocalContainers.put(new ArrayList(), new QueryInfo(new ArrayList<HasStepFolder.OrderEntry>(), 0, Integer.MAX_VALUE));
            }
            JanusGraphTransaction tx = JanusGraphTraversalUtil.getTx(this.traversal);
            GraphCentricQuery globalQuery = this.buildGlobalGraphCentricQuery(tx);
            ArrayListMultimap queries = ArrayListMultimap.create();
            if (globalQuery != null && !globalQuery.getSubQuery(0).getBackendQuery().isEmpty()) {
                queries.put((Object)0, (Object)globalQuery);
            } else {
                this.hasLocalContainers.entrySet().forEach(arg_0 -> this.lambda$null$0((Multimap)queries, tx, arg_0));
            }
            GraphCentricQueryBuilder builder = (GraphCentricQueryBuilder)tx.query();
            ArrayList responses = new ArrayList();
            queries.entries().forEach(q -> this.executeGraphCentricQuery(builder, responses, (Map.Entry<Integer, GraphCentricQuery>)q));
            return new MultiDistinctOrderedIterator(this.lowLimit, this.highLimit, responses, this.orders);
        });
    }

    private GraphCentricQuery buildGlobalGraphCentricQuery(JanusGraphTransaction tx) {
        Iterator<QueryInfo> itQueryInfo = this.hasLocalContainers.values().iterator();
        QueryInfo queryInfo = itQueryInfo.next();
        if (queryInfo.getLowLimit() > 0 || this.orders.isEmpty() && !queryInfo.getOrders().isEmpty()) {
            return null;
        }
        Integer limit = queryInfo.getHighLimit();
        while (itQueryInfo.hasNext()) {
            queryInfo = itQueryInfo.next();
            if (queryInfo.getLowLimit() <= 0 && (!this.orders.isEmpty() || queryInfo.getOrders().isEmpty()) && (queryInfo.getHighLimit() >= this.highLimit || limit.equals(queryInfo.getHighLimit()))) continue;
            return null;
        }
        JanusGraphQuery<? extends JanusGraphQuery> query = tx.query();
        for (List<HasContainer> localContainers : this.hasLocalContainers.keySet()) {
            JanusGraphQuery<? extends JanusGraphQuery> localQuery = tx.query();
            this.addConstraint(localQuery, localContainers);
            query.or(localQuery);
        }
        for (HasStepFolder.OrderEntry order : this.orders) {
            query.orderBy(order.key, order.order);
        }
        if (this.highLimit != Integer.MAX_VALUE || limit != Integer.MAX_VALUE) {
            query.limit(Math.min(limit, this.highLimit));
        }
        Preconditions.checkArgument((boolean)(query instanceof GraphCentricQueryBuilder));
        GraphCentricQueryBuilder centricQueryBuilder = (GraphCentricQueryBuilder)query;
        centricQueryBuilder.profiler(this.queryProfiler);
        GraphCentricQuery graphCentricQuery = centricQueryBuilder.constructQuery(Vertex.class.isAssignableFrom(this.returnClass) ? ElementCategory.VERTEX : ElementCategory.EDGE);
        return graphCentricQuery;
    }

    private void addConstraint(JanusGraphQuery query, List<HasContainer> localContainers) {
        for (HasContainer condition : this.hasContainers) {
            query.has(condition.getKey(), JanusGraphPredicateUtils.convert(condition.getBiPredicate()), condition.getValue());
        }
        for (HasContainer condition : localContainers) {
            query.has(condition.getKey(), JanusGraphPredicateUtils.convert(condition.getBiPredicate()), condition.getValue());
        }
    }

    private GraphCentricQuery buildGraphCentricQuery(JanusGraphTransaction tx, Map.Entry<List<HasContainer>, QueryInfo> containers) {
        JanusGraphQuery<? extends JanusGraphQuery> query = tx.query();
        this.addConstraint(query, containers.getKey());
        List<HasStepFolder.OrderEntry> realOrders = this.orders.isEmpty() ? containers.getValue().getOrders() : this.orders;
        for (HasStepFolder.OrderEntry order : realOrders) {
            query.orderBy(order.key, order.order);
        }
        if (this.highLimit != Integer.MAX_VALUE || containers.getValue().getHighLimit() != Integer.MAX_VALUE) {
            query.limit(Math.min(containers.getValue().getHighLimit(), this.highLimit));
        }
        Preconditions.checkArgument((boolean)(query instanceof GraphCentricQueryBuilder));
        GraphCentricQueryBuilder centricQueryBuilder = (GraphCentricQueryBuilder)query;
        centricQueryBuilder.profiler(this.queryProfiler);
        GraphCentricQuery graphCentricQuery = centricQueryBuilder.constructQuery(Vertex.class.isAssignableFrom(this.returnClass) ? ElementCategory.VERTEX : ElementCategory.EDGE);
        return graphCentricQuery;
    }

    private void executeGraphCentricQuery(GraphCentricQueryBuilder builder, List<Iterator<E>> responses, Map.Entry<Integer, GraphCentricQuery> query) {
        Class graphClass = Vertex.class.isAssignableFrom(this.returnClass) ? JanusGraphVertex.class : JanusGraphEdge.class;
        Iterator<JanusGraphVertex> response = builder.iterables(query.getValue(), graphClass).iterator();
        for (long i = 0L; i < (long)query.getKey().intValue() && response.hasNext(); ++i) {
            response.next();
        }
        responses.add(response);
    }

    public String toString() {
        if (this.hasLocalContainers.isEmpty() && this.hasContainers.isEmpty()) {
            return super.toString();
        }
        if (this.hasLocalContainers.isEmpty()) {
            return StringFactory.stepString((Step)this, (Object[])new Object[]{Arrays.toString(this.ids), this.hasContainers});
        }
        if (this.hasLocalContainers.size() == 1) {
            ArrayList<HasContainer> containers = new ArrayList<HasContainer>(this.hasContainers);
            containers.addAll((Collection<HasContainer>)this.hasLocalContainers.keySet().iterator().next());
            return StringFactory.stepString((Step)this, (Object[])new Object[]{Arrays.toString(this.ids), containers});
        }
        StringBuilder sb = new StringBuilder();
        if (!this.hasContainers.isEmpty()) {
            sb.append(StringFactory.stepString((Step)this, (Object[])new Object[]{Arrays.toString(this.ids), this.hasContainers})).append(".");
        }
        sb.append("Or(");
        Iterator<List<HasContainer>> itContainers = this.hasLocalContainers.keySet().iterator();
        sb.append(StringFactory.stepString((Step)this, (Object[])new Object[]{Arrays.toString(this.ids), itContainers.next()}));
        while (itContainers.hasNext()) {
            sb.append(",").append(StringFactory.stepString((Step)this, (Object[])new Object[]{Arrays.toString(this.ids), itContainers.next()}));
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void addAll(Iterable<HasContainer> has) {
        HasStepFolder.splitAndP(this.hasContainers, has);
    }

    @Override
    public List<HasContainer> addLocalAll(Iterable<HasContainer> has) {
        List<HasContainer> containers = HasStepFolder.splitAndP(new ArrayList<HasContainer>(), has);
        this.hasLocalContainers.put(containers, new QueryInfo(new ArrayList<HasStepFolder.OrderEntry>(), 0, Integer.MAX_VALUE));
        return containers;
    }

    @Override
    public void orderBy(String key, Order order) {
        this.orders.add(new HasStepFolder.OrderEntry(key, order));
    }

    @Override
    public void localOrderBy(List<HasContainer> containers, String key, Order order) {
        this.hasLocalContainers.get(containers).getOrders().add(new HasStepFolder.OrderEntry(key, order));
    }

    @Override
    public void setLimit(int low, int high) {
        this.lowLimit = low;
        this.highLimit = high;
    }

    @Override
    public void setLocalLimit(List<HasContainer> containers, int low, int high) {
        this.hasLocalContainers.replace(containers, this.hasLocalContainers.get(containers).setLowLimit(low).setHighLimit(high));
    }

    @Override
    public int getLowLimit() {
        return this.lowLimit;
    }

    @Override
    public int getLocalLowLimit(List<HasContainer> containers) {
        return this.hasLocalContainers.get(containers).getLowLimit();
    }

    @Override
    public int getHighLimit() {
        return this.highLimit;
    }

    @Override
    public int getLocalHighLimit(List<HasContainer> containers) {
        return this.hasLocalContainers.get(containers).getHighLimit();
    }

    public void setMetrics(MutableMetrics metrics) {
        this.queryProfiler = new TP3ProfileWrapper(metrics);
    }

    public List<HasContainer> getHasContainers() {
        ArrayList<HasContainer> toReturn = new ArrayList<HasContainer>(this.hasContainers);
        this.hasLocalContainers.keySet().forEach(toReturn::addAll);
        return toReturn;
    }

    public void addHasContainer(HasContainer hasContainer) {
        this.addAll(Collections.singleton(hasContainer));
    }

    public List<HasStepFolder.OrderEntry> getOrders() {
        return this.orders;
    }

    private <A extends Element> Iterator<A> iteratorList(Iterator<A> iterator) {
        ArrayList<Element> list = new ArrayList<Element>();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            if (!HasContainer.testAll((Object)e, this.getHasContainers())) continue;
            list.add(e);
        }
        return list.iterator();
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.hasContainers != null ? this.hasContainers.hashCode() : 0);
        result = 31 * result + (this.hasLocalContainers != null ? this.hasLocalContainers.hashCode() : 0);
        result = 31 * result + this.lowLimit;
        result = 31 * result + this.highLimit;
        result = 31 * result + (this.orders != null ? this.orders.hashCode() : 0);
        return result;
    }

    private /* synthetic */ void lambda$null$0(Multimap queries, JanusGraphTransaction tx, Map.Entry c) {
        queries.put((Object)((QueryInfo)c.getValue()).getLowLimit(), (Object)this.buildGraphCentricQuery(tx, c));
    }
}

